import json
import re

def read_jsonl_file(file_path):
    data = []
    with open(file_path, 'r', encoding='utf-8') as f:
        for line in f:
            data.append(json.loads(line))
    return data

def compare_output_and_beam(data,top_k,tag,trap_result_file):
    total_lines = len(data)
    correct_count = 0
    compare_result = []
    line = 0
    for entry in data:
        output = entry['output']
        beam_output = entry['beam_output']
        i = 1
        for beam_item in beam_output:
            if beam_item == output:
                correct_count += 1
                compare_result.append(line)
                # corredt_line.append(entry['output'])
                break
            if i == top_k:
                break
            i += 1
        line +=1
    if tag:
        with open(trap_result_file, 'w', encoding='utf-8') as f:
            for item in compare_result:
                f.write(str(item) + '\n')
    return correct_count / total_lines

def compare_with_trap_correct(trap_data,repair_data,top_k,tag,repair_result_file):
    total_lines = len(trap_data)
    correct_count = 0
    compare_result = []
    line =0
    for correct,entry in zip(trap_data,repair_data):
        answer = correct['output']
        
        output = entry['output']
        beam_output = entry['beam_output']
        i = 1
        for beam_item in beam_output:
            if beam_item == answer:
                correct_count += 1
                compare_result.append(line)
                break
            if i == top_k:
                break
            i += 1
        line +=1
    if tag:
        with open(repair_result_file, 'w', encoding='utf-8') as f:
            for item in compare_result:
                f.write(str(item) + '\n')
    return correct_count / total_lines