# Two- and Three-Colour Single-Molecule FRET Trace Analaysis

General purpose repository for the analysis of two- and three-colour single-molecule FRET data, generated by Dr Nicholas Marzano. This repository has predominanly been used to investigate how molecular chaperone proteins affect the conformation of their clients during productive folding and for interrogating how RNA-binding proteins bind to specific RNA sequences; however, this is a very general workflow that performs many different kinds of analysis that could be of use to any biological system.

Generally, the code imports the raw FRET data, removes outliers and analyses the kinetic details originating from Hidden Markov Model (HMM) fitting of the data using the vbFRET MATLAB program. Furthermore, the data can be analysed and processed to extract useful kinetic information (e.g., residence time of states, determining the occurence and rates of specific FRET transitions, analysis of live-flow data) and then plotted in simple and effective plots for visualization (e.g., FRET histograms, transition density plots [TDPs], FRET-intensity traces, cumulative residence time analysis) for easy data visualization.

Prerequisites: 

Two kinds of data are required for this analysis. 

    (1)	The idealized FRET data for individual molecules following HMM analysis using vbFRET. These are generated following fitting and saving the data as ‘Idealized Traces’ with ‘Individual Text Files’ (in .dat format). Data for individual molecules is exported from vbFRET and stored within a folder.
    (2) For three-colour experiments, data required is exported as .txt files from the MASH-FRET GUI program (v 1.2.2). 

# Installation
This module is a work in progress, designed to capture common functionality which recurs in analysis of single-molecule FRET data. It contains two main components: the `src` folder which contains general purpose functions.

```
git submodule add https://github.com/nmarzano/smFRET_module smfret
```
## General usage notes

For best use, this module can be combined with a general purpose experiment template that can be found here (https://github.com/nmarzano/smFRET-experiment-template). Here, the scripts are seperated into those used for two-colour and three-colour FRET, where each script within these folders should be run in order to ensure any source data is generated as needed (although in some cases this is not essential). 

The analysis scripts are seperated to do the following functions:

    (0-import_data) - Will import raw data from a list of directories that has been copied into the raw_data.txt file (located in the raw_data folder). The directories provided should be links to a folder that contains a .dat file for each molecule to be analysed within that treatment, generated by saving as 'idealized traces' and 'individual molecules' from vbFRET.
    
    (1-histogram_timelapse_traces_synchtrans_heatmap) - Will do several functions, not all of which are essential to do. The first is essential, whereby all the directories provided in (0-import_data) are concatenated into a single dataframe for downstream processing. From here, outliers are excluded and histograms, traces, synchronised transitions and gaussian fits of the histograms can be plotted. Some of the functions called will rely on additional data input (e.g., liveflow and heatmap data), since these do not rely on the concatenated dataframe, meaning specific datasets must be provided within the appropiate dictionaries. 

    (2-transition-and-residence-time-analysis) - This script is primarily for the analysis of kinetic information derived from the HMM fits of each trace. From these analyses, the visualization of transitions within a dataset can be performed (as transition density plots [TDPs]) or interrogations of certain transitions of interest, easily accessed by user FRET thresholding, to determine rates of FRET transitions, residence times of certain states and the occurence of certain transitions.
 
    (3-three-colour-smFRET-import) - Will import raw data from a list of directories that has been copied into the rscript. The directories provided should be links to a folder that contains a .txt file for each molecule to be analysed within that treatment, generated by exporting ASCII from the MASH-FRET GUI program (v 1.2.2).

    (4-three-colour-smFRET-analysis) - Will take the raw data from multiple treatments and concatenate into a single dataframe. From here, the traces will be fit to a HMM model, which requires importing the 'deepfret_nm' module (https://github.com/nmarzano/deepfret_nm, forked from the hatzakis lab), and then the fitted traces can be plotted, the FRET calculated (plotted as histograms) and the synchronised transitions determined and visualized (allowing the analysis of certain FRET transitions and observation of a third fluorophore).
    

### Data source

To generate data used for analysis using these scripts, all that is required is a single movie where there is direct excitation of the donor fluorophore (for two-colour experiments) or alternate excitation of the two donor fluorophores (for three-colour experiments, e.g., excitation of AF488 dye, then excitation of AF555 dye that can FRET to AF647 dye). The exported images can then be directly imported and processed into the MASH-FRET GUI program (v 1.2.2) for intitial molecule selection and processing. 

