import pennylane as qml
import qiskit.providers.aer.noise as noise
from qiskit.providers.fake_provider import FakeCairoV2, FakeHanoiV2, FakeKolkataV2, FakeMumbaiV2, FakeTorontoV2
from qiskit_aer.noise import NoiseModel
IBM_TOKEN = 'XXX'
def route_device(args, n_qubits):
    if 'real' in args.machine:
        machine_name = args.machine[5:]
        return qml.device(name = 'qiskit.ibmq',
                    backend = f'ibm_{machine_name}',
                    ibmqx_token = IBM_TOKEN,    # Set the IBMQ account token
                    wires = n_qubits,
                    overwrite=True)
    if args.machine =='local':
        return qml.device("default.qubit", args.num_trash * 2 + args.num_latent + 1)
    elif 'sim' in args.machine:
        if args.machine =='sim_cairo':
            backend = FakeCairoV2()
        elif args.machine =='sim_hanoi':
            backend = FakeHanoiV2()
        elif args.machine =='sim_kolkata':
            backend = FakeKolkataV2()
        elif args.machine =='sim_mumbai':
            backend = FakeMumbaiV2()
        elif args.machine =='sim_toronto':
            backend = FakeTorontoV2()
        noise_model = NoiseModel.from_backend(backend)
        return qml.device('qiskit.aer', wires=n_qubits, noise_model = noise_model, optimization_level=3)
