"""
Last updated on 2023 August 31

@author: Shunya Kaneki (AIST)
"""

import glob
import os
import time

import utilmod as util
import fitting as fit
import specmanager as spmn

# INPUT.
dtype = 'CSV' # Type of data file. ONLY 'txt' or 'csv' or 'CSV' is acceptable.
datadir = './raw/' # Directory of raw Raman data.
figurePDF = False # If True, all figures will be saved in PDF format.
figurePNG = False # If True, all figures will be saved in PNG format.
specdat = False # If True, all treated spectral data will be saved.
# INPUT DONE.

mkdir = util.mkdir()
stime = time.time()
files = sorted(glob.glob(os.path.join(datadir,'*.'+dtype)),key=util.numericalSort)
for file in files:
    print(file)
    dat = util.dload(file,dtype).dat
    sft, rint = dat[:,0], dat[:,1]
    tdat = spmn.treat(file,dtype,datadir,mkdir,sft,rint,specdat=specdat)
    spmn.savefig(file,dtype,datadir,mkdir,tdat,figurePDF=figurePDF,figurePNG=figurePNG)
    fitting = fit.fit(sft,tdat.nbint)
    fit.savefig(file,dtype,datadir,mkdir,fitting,figurePDF=figurePDF,figurePNG=figurePNG)
    fit.savespec(file,dtype,datadir,mkdir,fitting,specdat=specdat)
    fit.saveprm(file,dtype,datadir,mkdir,fitting)

util.analysis(mkdir)

print('\nTotal time: {} sec'.format(time.time()-stime))
print('Average time: {} sec'.format((time.time()-stime)/len(files)))