#!/usr/bin/env python
# coding: utf-8

# In[1]:


from scipy.io import netcdf, loadmat
import numpy as np
import os
from scipy import interpolate
import scipy
import glob
from netCDF4 import Dataset
from scipy import interp
#from mpl_toolkits.basemap import Basemap,maskoceans
import matplotlib.pyplot as plt
import matplotlib as mpl
import numpy as np
from numpy import polyfit
import numpy.matlib
from scipy.stats import pearsonr, ks_2samp, linregress
get_ipython().run_line_magic('matplotlib', 'inline')
import copy
import cmaps
#from eof import eof_norm,eof_norm_mask, svd
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
from matplotlib.colors import ListedColormap
import matplotlib.colors as colors
from scipy.signal import detrend
import numpy.ma as ma
plt.rcParams["font.family"] = "Times New Roman"
plt.rc('font', family='serif')
plt.rcParams['xtick.major.pad'] = 10
plt.rcParams['ytick.major.pad'] = 10
plt.rcParams['lines.dashed_pattern'] = [5.0, 5.0]
import numpy.ma as ma
from numpy import random
import cartopy.crs as ccrs
import cartopy.feature as cfeature
import matplotlib.path as mpath
import matplotlib.ticker as mticker
import warnings
from shutil import copyfile
warnings.filterwarnings("ignore", category=RuntimeWarning) 
from warnings import filterwarnings
filterwarnings(action='ignore', category=DeprecationWarning, message='`np.bool` is a deprecated alias')


# In[2]:


filename = '/Volumes/Zhou/data/cmip6/historical/ts/MRI-ESM2/r1i1p1/ts_Amon_MRI-ESM2_historical_195001-201412.1deg.nc'
f = Dataset(filename, 'r')
lat = f.variables['lat'][:]
lon = f.variables['lon'][:]

os.chdir('/Volumes/Xiao/observations/siconc/Had')
filename = glob.glob('siconc_Had_1950_2020.1deg.ann.nc')[0]
f = Dataset(filename, 'r')
aa=f.variables['sic'][20,::]
mask_land=aa.mask


# In[3]:


def get_array(start,end,lev):
    a=np.arange(start,end,lev)
    
    return list(a[:len(a)//2])+list(a[len(a)//2+1:])


def get_globe_mean(var,lat):
    aa=np.cos(lat/180*np.pi)
    if len(np.shape(var))==3:
        bb=var*aa[None,None,:]
        cc=np.sum(bb,2)
        dd=np.sum(aa)
    if len(np.shape(var))==2:
        bb=var*aa[None,:]
        cc=np.sum(bb,1)
        dd=np.sum(aa)
    if len(np.shape(var))==1:
        bb=var*aa
        cc=np.sum(bb)
        dd=np.sum(aa)
    return cc/dd

def get_nh_mean(var,lat):
    aa=np.cos(lat/180*np.pi)
    index = np.argmax(lat>=0.)
    aa[:index] = 0.
    if len(np.shape(var))==3:
        bb=var*aa[None,None,:]
        cc=np.sum(bb,2)
        dd=np.sum(aa)
    if len(np.shape(var))==2:
        bb=var*aa[None,:]
        cc=np.sum(bb,1)
        dd=np.sum(aa)
    if len(np.shape(var))==1:
        bb=var*aa
        cc=np.sum(bb)
        dd=np.sum(aa)
    return cc/dd


def get_nho_mean(var,lat):
    aa = np.cos(lat/180.*np.pi)
    index = np.argmax(lat>=0.)
    aa[:index] = 0.
    bb=np.ones((np.size(var,-2),np.size(var,-1)))
    cc = bb*aa[:,None]
    cc[np.where(mask_land)] = 0.
    if len(np.shape(var))==3:
        return np.sum(np.sum(var*cc[None,:,:],2),1)/np.sum(np.sum(cc,1),0)
    if len(np.shape(var))==4:
        return np.sum(np.sum(var*cc[None,None,:,:],3),2)/np.sum(np.sum(cc,1),0)
    

def get_sho_mean(var,lat):
    aa = np.cos(lat/180.*np.pi)
    index = np.argmax(lat>=0.)
    aa[index:] = 0.
    bb=np.ones((np.size(var,-2),np.size(var,-1)))
    cc = bb*aa[:,None]
    cc[np.where(mask_land)] = 0.
    if len(np.shape(var))==3:
        return np.sum(np.sum(var*cc[None,:,:],2),1)/np.sum(np.sum(cc,1),0)
    if len(np.shape(var))==4:
        return np.sum(np.sum(var*cc[None,None,:,:],3),2)/np.sum(np.sum(cc,1),0)
    
    
def get_nho1_mean(var,lat):
    aa = np.cos(lat/180.*np.pi)
    index = np.argmax(lat>=0.)
    aa[:index] = 0.
    index = np.argmax(lat>60.)
    aa[index:] = 0.
    bb=np.ones((np.size(var,-2),np.size(var,-1)))
    cc = bb*aa[:,None]
    cc[np.where(mask_land)] = 0.
    if len(np.shape(var))==3:
        return np.sum(np.sum(var*cc[None,:,:],2),1)/np.sum(np.sum(cc,1),0)
    if len(np.shape(var))==4:
        return np.sum(np.sum(var*cc[None,None,:,:],3),2)/np.sum(np.sum(cc,1),0)
    

def get_sho1_mean(var,lat):
    aa = np.cos(lat/180.*np.pi)
    index = np.argmax(lat>=0.)
    aa[index:] = 0.
    index = np.argmax(lat>-60.)
    aa[:index] = 0.
    bb=np.ones((np.size(var,-2),np.size(var,-1)))
    cc = bb*aa[:,None]
    cc[np.where(mask_land)] = 0.
    if len(np.shape(var))==3:
        return np.sum(np.sum(var*cc[None,:,:],2),1)/np.sum(np.sum(cc,1),0)
    if len(np.shape(var))==4:
        return np.sum(np.sum(var*cc[None,None,:,:],3),2)/np.sum(np.sum(cc,1),0)


def get_sh_mean(var,lat):
    aa=np.cos(lat/180*np.pi)
    index = np.argmax(lat>0.)
    aa[index:] = 0.
    if len(np.shape(var))==3:
        bb=var*aa[None,None,:]
        cc=np.sum(bb,2)
        dd=np.sum(aa)
    if len(np.shape(var))==2:
        bb=var*aa[None,:]
        cc=np.sum(bb,1)
        dd=np.sum(aa)
    if len(np.shape(var))==1:
        bb=var*aa
        cc=np.sum(bb)
        dd=np.sum(aa)
    return cc/dd

def get_tropic_mean(var,lat):
    aa=np.cos(lat/180*np.pi)
    index2 = np.argmax(lat>30.)
    index1 = np.argmax(lat>-30.)
    aa[:index1] = 0
    aa[index2:] = 0
    if len(np.shape(var))==3:
        bb=var*aa[None,None,:]
        cc=np.sum(bb,2)
        dd=np.sum(aa)
    if len(np.shape(var))==2:
        bb=var*aa[None,:]
        cc=np.sum(bb,1)
        dd=np.sum(aa)
    if len(np.shape(var))==1:
        bb=var*aa
        cc=np.sum(bb)
        dd=np.sum(aa)
    return cc/dd

def get_arctic_mean(var,lat):
    aa=np.cos(lat/180*np.pi)
    index = np.argmax(lat>=65)
    aa[:index] = 0.
    
    if len(np.shape(var))==3:
        bb=var*aa[None,None,:]
        cc=np.nansum(bb,2)
        dd=np.nansum(aa)
    if len(np.shape(var))==2:
        bb=var*aa[None,:]
        cc=np.nansum(bb,1)
        dd=np.nansum(aa)
    if len(np.shape(var))==1:
        bb=var*aa
        cc=np.nansum(bb)
        dd=np.nansum(aa)
    return cc/dd

def get_so_mean(var,lat):
    aa=np.cos(lat/180*np.pi)
    index1 = np.argmax(lat>=-47.5)
    index2 = np.argmax(lat>=-72.5)
    aa[:index2] = 0.
    aa[index1:] = 0.
    if len(np.shape(var))==3:
        bb=var*aa[None,None,:]
        cc=np.sum(bb,2)
        dd=np.sum(aa)
    if len(np.shape(var))==2:
        bb=var*aa[None,:]
        cc=np.sum(bb,1)
        dd=np.sum(aa)
    if len(np.shape(var))==1:
        bb=var*aa
        cc=np.sum(bb)
        dd=np.sum(aa)
    return cc/dd
    
def get_arctic_mean_sic(var,lat):
    aa=np.cos(lat/180*np.pi)
    index = np.argmax(lat>=65.)
    aa[:index] = 0.
    bb=var*aa[None,:,None]
    cc=np.nansum(np.nansum(bb,2),1)
    dd=np.sum(aa)*180.
    return cc/dd

def get_regr(ind,var):
    var_=np.reshape(var,[np.size(var,0),-1])
    regressions,_ = np.polyfit(ind, var_, 1)
    regressions = regressions.reshape([np.size(var,1),np.size(var,2)])# 35 year    
    return regressions

def get_corr(ind,var):
    corr = np.zeros((np.size(var,1),np.size(var,2)))
    pval = np.zeros((np.size(var,1),np.size(var,2)))
    for i in range(np.size(var,1)):
        for j in range(np.size(var,2)):
            corr[i,j],pval[i,j] = pearsonr(ind,var[:,i,j])
    return corr,pval

def get_regr_nan(ind,var):
    regressions = np.zeros((np.size(var,1),np.size(var,2)))
    for i in range(np.size(var,1)):
        for j in range(np.size(var,2)):
            aa=var[:,i,j]
            if len(aa[~np.isnan(aa)])>2:
                    regressions[i,j],_ = np.polyfit(ind[~np.isnan(aa)],aa[~np.isnan(aa)],1)
            else:
                regressions[i,j] = np.nan
    return regressions

def get_corr_nan(ind,var):
    corr = np.zeros((np.size(var,1),np.size(var,2)))
    pval = np.zeros((np.size(var,1),np.size(var,2)))
    for i in range(np.size(var,1)):
        for j in range(np.size(var,2)):
            aa=var[:,i,j]
            if len(aa[~np.isnan(aa)])>2:
                corr[i,j],pval[i,j] = pearsonr(ind[~np.isnan(aa)],aa[~np.isnan(aa)])
            else:
                corr[i,j]=np.nan
    return corr,pval

def running_mean(var,window,axis=0,drop=False):
    if len(np.shape(var))==1:
        var_=np.zeros(len(var))
        for i in range(len(var)):
            if i<window//2:
                var_[i]=np.nan
            elif i>len(var)-window//2-1:
                var_[i]=np.nan
            else:
                var_[i]=np.mean(var[i-window//2:i+window//2+1])
    else:
        var_=np.zeros(np.shape(var))
        for i in range(np.size(var,0)):
            if i<window//2:
                var_[i,::]=np.nan
            elif i>len(var)-window//2-1:
                var_[i,::]=np.nan
            else:
                var_[i,::]=np.mean(var[i-window//2:i+window//2+1,::],0)
    if drop:
        return var_[window//2:-window//2]
    else:
        return var_

def eof_norm_mask(data,num,mask):
    if np.size(np.shape(data))==3:
        #data_=np.reshape(data,(np.size(data,0),np.size(data,1)*np.size(data,2)))
        data=data-[np.mean(data,0) for _ in range(np.size(data,0))]
        index=np.where(mask)
        data0=np.zeros((np.size(data,0),len(index[0])))
        for nn in range(len(index[0])):
            data0[:,nn]=data[:,index[0][nn],index[1][nn]]
        [ C, lamda, EOFs ] = np.linalg.svd( data0, full_matrices=0);

        ECs = C * lamda; # Expansion coefficients.
        if num ==1:
            EOF=np.zeros((np.size(data,1),np.size(data,2)))
            for nn in range(len(index[0])):
                EOF[index[0][nn],index[1][nn]]=EOFs[0,nn]*np.std(ECs[:,0])
            PC=ECs[:,0]/np.std(ECs[:,0])
            vc=lamda[0]**2/(sum(lamda**2))
        else:
            PC=np.zeros((np.size(data,0),num))
            vc=np.zeros(num)
            EOF=np.zeros((np.size(data,1),np.size(data,2),num))
            for k in range(num):
                for nn in range(len(index[0])):
                    EOF[index[0][nn],index[1][nn],k]=EOFs[k,nn]*np.std(ECs[:,k])
                PC[:,k]=ECs[:,k]/np.std(ECs[:,k])
                vc[k]=lamda[k]**2/(sum(lamda**2))
    return EOF, PC, vc

def get_ensotype_index(var,lat,lon):
    ind1_lat = np.argmax(lat>-5)
    ind2_lat = np.argmax(lat>5)
    
    ind1_lon = np.argmax(lon>200)
    ind2_lon = np.argmax(lon>280)    
    
    ind3_lon = np.argmax(lon>210)
    ind4_lon = np.argmax(lon>240)

    ind5_lon = np.argmax(lon>240)
    ind6_lon = np.argmax(lon>270)
    
    
    aa=np.mean(np.mean(var[:,ind1_lat:ind2_lat,ind1_lon:ind2_lon],2),1)
    bb=np.mean(np.mean(var[:,ind1_lat:ind2_lat,ind3_lon:ind4_lon],2),1)
    cc=np.mean(np.mean(var[:,ind1_lat:ind2_lat,ind5_lon:ind6_lon],2),1)
    
    return np.sign(aa)*np.abs(aa)**0.3*(cc-bb)


def get_enso(var,lat,lon):
    ind1_lat = np.argmax(lat>-5)
    ind2_lat = np.argmax(lat>5)
    
    ind1_lon = np.argmax(lon>210)
    ind2_lon = np.argmax(lon>270)    

    
    aa=np.mean(np.mean(var[:,ind1_lat:ind2_lat,ind1_lon:ind2_lon],2),1)
    
    return aa
    
def get_seas_clim(var):
    seas = np.zeros((4,180,360))
    var[np.where(np.abs(var)>1000)]=np.nan
    for i in range(4):
        seas[i,::]=np.nanmean(var[i:120:4,::],0)
    return seas
                 
def get_seas_anom(var,seas_clim):
    var1=np.zeros(np.shape(var))
    for i in range(np.size(var,0)):
        var1[i,::] = var[i,::] - seas_clim[np.mod(i,4),::]
    return var1


pdo_mask=np.zeros((180,360))
for i in range(180):
    for j in range(360):
        if lat[i]<=10 and lat[i]>=-10 and lon[j]>=170. and lon[j]<=270:
            pdo_mask[i,j] = 1.0/20/100
        if lat[i]>=25 and lat[i]<=45 and lon[j]>=140. and lon[j]<=215:
            pdo_mask[i,j] = -1.0/20/75/2
        if lat[i]>=-50 and lat[i]<=-15 and lon[j]>=150. and lon[j]<=200:
            pdo_mask[i,j] = -1.0/35/50/2
            
def get_pdo3(var,pdo_mask):
    if len(np.shape(var))==2:
        return np.sum(var*pdo)
    if len(np.shape(var))==3:
        aa=np.zeros(np.size(var,0))
        for i in range(np.size(var,0)):
            aa[i]=np.sum(var[i,:,:]*pdo_mask)
        return aa
    if len(np.shape(var))==4:
        aa=np.zeros((np.size(var,0),np.size(var,1)))
        for i in range(np.size(var,0)):
            for j in range(np.size(var,1)):
                aa[i,j]=np.sum(var[i,j,:,:]*pdo_mask)
        return aa
    
amoc_mask1=np.zeros((180,360))
amoc_mask2=np.zeros((180,360))

for i in range(180):
    for j in range(360):
        if lat[i]>40 and lat[i]<=70 and lon[j]>=278. and lon[j]<=360:
            amoc_mask1[i,j] = 1.0
        if lat[i]>-70 and lat[i]<-40 and (lon[j]>=290. or lon[j]<22):
            amoc_mask2[i,j] = 1.0

amoc_mask1[np.where(mask_land)]=0.
amoc_mask2[np.where(mask_land)]=0.

def get_amoc(var,amoc_mask1,amoc_mask2):
    if len(np.shape(var))==2:
        return np.sum(var*amoc_mask1)/np.sum(amoc_mask1)-np.sum(var*amoc_mask2)/np.sum(amoc_mask2)
    if len(np.shape(var))==3:
        aa=np.zeros(np.size(var,0))
        for i in range(np.size(var,0)):
            aa[i]=np.sum(var[i,::]*amoc_mask1)/np.sum(amoc_mask1)-np.sum(var[i,::]*amoc_mask2)/np.sum(amoc_mask2)
        return aa
    if len(np.shape(var))==4:
        aa=np.zeros((np.size(var,0),np.size(var,1)))
        for i in range(np.size(var,0)):
            for j in range(np.size(var,1)):
                aa[i,j]=np.sum(var[i,j,::]*amoc_mask1)/np.sum(amoc_mask1)-np.sum(var[i,j,::]*amoc_mask2)/np.sum(amoc_mask2)
        return aa
    
def get_AA(ts_globe,ts_arctic,ts_tropic,yrs,start_yr,end_yr,init_year):
    ind_start = start_yr - init_year
    ind_end = end_yr - init_year +1
    dhist1_globe=np.polyfit(yrs[ind_start:ind_end],ts_globe[ind_start:ind_end],1)[0]
    dhist1_arctic=np.polyfit(yrs[ind_start:ind_end],ts_arctic[ind_start:ind_end],1)[0]
    dhist1_tropic=np.polyfit(yrs[ind_start:ind_end],ts_tropic[ind_start:ind_end],1)[0]

    AA_hist = dhist1_arctic/dhist1_globe
    return AA_hist,dhist1_globe,dhist1_arctic,dhist1_tropic

def get_diff(var,start_yr,end_yr):
    year=np.arange(1960,2023,1)
    return polyfit(year[start_yr-1960:end_yr-1960],var[start_yr-1960:end_yr-1960],1)[0]

def get_diff1(var,start_yr,end_yr):
    year=np.arange(1965,2023,1)
    return polyfit(year[start_yr-1965:end_yr-1965],var[start_yr-1965:end_yr-1965],1)[0]

def get_extend(var):
    var1=np.zeros((np.size(var,0),np.size(var,1)+1))
    var1[:,:-1] = var
    var1[:,-1] = var[:,0]
    return var1


# In[4]:


tts=['t1','t2','t3','t4','dhist','dssp245','dssp585','dssp126']
regions1=['globe','tropic','arctic']
regions2=['zm']
regions3=['2d']
regions=regions1+regions2+regions3

obs= ['HadCRUT5','Berkeley','GISTEMP']

for region in regions:
    for tt in tts:
        exec('ts_'+region+'_'+tt+' = {}')

for tt in tts:
    for region in regions1:
        exec('ts_'+region+'_'+tt+'[\'obs\'] = np.zeros(len(obs))')
    exec('ts_2d_'+tt+'[\'obs\'] = np.zeros((len(obs),180,360))')
    exec('ts_zm_'+tt+'[\'obs\'] = np.zeros((len(obs),180))')

for i in range(len(obs)):
    os.chdir('/Volumes/Xiao/observations/ts/'+obs[i])
    if obs[i] == 'ERA5':
        var = 'skt'
    if obs[i] == 'HadCRUT5':
        var = 'tas_mean'
    if obs[i] == 'Berkeley':
        var = 'temperature'
    if obs[i] == 'GISTEMP':
        var = 'tempanomaly'
        
    filename = glob.glob('*1deg.zm.ann.nc')[0]
    f = Dataset(filename, 'r')
    exec('ts_zm_t1[\'obs\'][i,:]= np.mean(f.variables[\''+var+'\'][30:45,:],0)') #1970-1984
    exec('ts_zm_t2[\'obs\'][i,:]= np.mean(f.variables[\''+var+'\'][60:75,:],0)') #2000-2014
    exec('ts_zm_t3[\'obs\'][i,:]= np.mean(f.variables[\''+var+'\'][40:55,:],0)') #1980-1994
    
    filename = glob.glob('*1deg.ann.nc')[0]
    f = Dataset(filename, 'r')
    exec('ts_2d_t1[\'obs\'][i,:]= np.mean(f.variables[\''+var+'\'][30:45,::],0)')
    exec('ts_2d_t2[\'obs\'][i,:]= np.mean(f.variables[\''+var+'\'][60:75,::],0)')
    exec('ts_2d_t3[\'obs\'][i,:]= np.mean(f.variables[\''+var+'\'][40:55,::],0)')
    
for region in regions1:
    for tt in ['t1','t2','t3']:
        exec('ts_'+region+'_'+tt+'[\'obs\'] =get_'+region+'_mean(ts_zm_'+tt+'[\'obs\'][::],lat)')
        
models = ['ACCESS-CM2','ACCESS-ESM1-5','AWI-CM-1-1-MR','BCC-CSM2-MR','CAMS-CSM1','CAS-ESM2','CESM2','CIESM',\
          'CMCC-CM2-SR5','CNRM-CM6','CNRM-ESM2','CanESM5','EC-Earth3','EC-Earth3-Veg','FGOALS-g3','GFDL-ESM4',\
          'GISS-E2-1-G','GISS-E2-1-H','HadGEM3-GC31-LL','IITM-ESM','INM-CM4-8','INM-CM5','IPSL-CM6A-LR','KACE-1-0-G',\
          'MIROC-ES2L','MIROC6','MPI-ESM1-2-LR','MPI-ESM1-2-HR','MRI-ESM2','NESM3','NorESM2-MM','UKESM1-0-LL']
runs_hist={}
runs_ssp245={}
members_hist=np.array([10,40,5,3,2,3,10,3,1,28,10,25,10,10,6,3,10,4,5,1,1,8,33,3,10,10,10,10,10,5,3,19])
members_ssp245=np.array([5,10,1,1,2,2,10,1,1,6,10,10,9,6,4,3,10,4,5,1,1,1,6,3,10,10,10,2,5,2,2,6])

for i in range(len(models)):
    
    runs_hist[models[i]]=members_hist[i]
    runs_ssp245[models[i]]=members_ssp245[i]
    
    for tt in ['t1','t2','t3']:
        exec('ts_2d_'+tt+'[models[i]]=np.zeros((180,360))')
        exec('ts_zm_'+tt+'[models[i]]=np.zeros((members_hist[i],180))')
        for region in regions1:
            exec('ts_'+region+'_'+tt+'[models[i]] = np.zeros(members_hist[i])')
    
    for tt in ['t4']:
        exec('ts_2d_'+tt+'[models[i]]=np.zeros((180,360))')
        exec('ts_zm_'+tt+'[models[i]]=np.zeros((members_ssp245[i],180))')
        for region in regions1:
            exec('ts_'+region+'_'+tt+'[models[i]] = np.zeros(members_ssp245[i])')
    
    if models[i]=='CESM2':
        for run in range(members_hist[i]):
            os.chdir('/Volumes/Xiao/lens-hist/CESM2/ts')
            if run == 0:   
                filename = glob.glob('ens'+str(run+1)+'.cam*1950*2100*1deg.ann.nc')[0]
                f = Dataset(filename, 'r')
                ts_2d_t1[models[i]][:,:] = np.mean(f.variables['TS'][20:35,::],0)
                ts_2d_t2[models[i]][:,:] = np.mean(f.variables['TS'][-15:,::],0)
                ts_2d_t3[models[i]][:,:] = np.mean(f.variables['TS'][30:45,::],0)
                ts_2d_t4[models[i]][:,:] = np.mean(f.variables['TS'][-15:,::],0)
            filename = glob.glob('ens'+str(run+1)+'.cam*1950*2100*1deg.zm.ann.nc')[0]
            f = Dataset(filename, 'r')
            ts_zm_t1[models[i]][run,:] = np.mean(f.variables['TS'][20:35,:],0)
            ts_zm_t2[models[i]][run,:] = np.mean(f.variables['TS'][-15:,:],0)
            ts_zm_t3[models[i]][run,:] = np.mean(f.variables['TS'][30:45,:],0)
            ts_zm_t4[models[i]][run,:] = np.mean(f.variables['TS'][-15:,:],0)

    
    else:   
        for run in range(members_hist[i]):
            os.chdir('/Volumes/Zhou/data/cmip6/historical/ts/'+models[i]+'/r'+str(run+1)+'i1p1/')
            if run == 0:   
                filename = glob.glob('*_1950*2014*1deg.ann.nc')[0]
                f = Dataset(filename, 'r')
                ts_2d_t1[models[i]][:,:] = np.mean(f.variables['ts'][20:35,::],0)
                ts_2d_t2[models[i]][:,:] = np.mean(f.variables['ts'][-15:,::],0)
                ts_2d_t3[models[i]][:,:] = np.mean(f.variables['ts'][30:45,::],0)
            filename = glob.glob('*_1950*2014*1deg.zm.ann.nc')[0]
            f = Dataset(filename, 'r')
            ts_zm_t1[models[i]][run,:] = np.mean(f.variables['ts'][20:35,:],0)
            ts_zm_t2[models[i]][run,:] = np.mean(f.variables['ts'][-15:,:],0)
            ts_zm_t3[models[i]][run,:] = np.mean(f.variables['ts'][30:45,:],0)

        for run in range(members_ssp245[i]):
            os.chdir('/Volumes/Zhou/data/cmip6/rcp45/ts/'+models[i]+'/r'+str(run+1)+'i1p1/')
            if run == 0:   
                filename = glob.glob('*_2015*2100*1deg.ann.nc')[0]
                f = Dataset(filename, 'r')
                ts_2d_t4[models[i]][:,:] = np.mean(f.variables['ts'][-15:,::],0)
            filename = glob.glob('*_2015*2100*1deg.zm.ann.nc')[0]
            f = Dataset(filename, 'r')
            ts_zm_t4[models[i]][run,:] = np.mean(f.variables['ts'][-15:,:],0)
        
    for region in regions1:
        for tt in ['t1','t2','t3','t4']:
            exec('ts_'+region+'_'+tt+'[models[i]] =get_'+region+'_mean(ts_zm_'+tt+'[models[i]][::],lat)')


# In[5]:


for region in regions:
    for model in models+['obs']:
        exec('ts_'+region+'_dhist[model] = ts_'+region+'_t2[model]- ts_'+region+'_t1[model]')
    for model in models:
        exec('ts_'+region+'_dssp245[model] = ts_'+region+'_t4[model]- np.mean(ts_'+region+'_t3[model],0)')
        exec('ts_'+region+'_dhist[model] = ts_'+region+'_t2[model]- ts_'+region+'_t1[model]')
    


# In[6]:


members_ssp126=np.array([5,10,1,1,2,2,3,1,1,6,5,10,7,5,4,1,5,5,1,1,1,1,5,3,10,10,10,2,5,2,1,10])
members_ssp585=np.array([5,10,1,1,2,2,3,1,1,6,5,10,7,6,4,1,5,5,4,1,1,1,5,3,10,10,10,2,5,2,1,5])


for region in regions:
    exec('ts_'+region+'_t4_ssp126 = {}')
    exec('ts_'+region+'_t4_ssp585 = {}')

for i in range(len(models)):
    
    for tt in ['t4']:
        exec('ts_zm_'+tt+'_ssp126[models[i]]=np.zeros((members_ssp126[i],180))')
        for region in regions1:
            exec('ts_'+region+'_'+tt+'_ssp126[models[i]] = np.zeros(members_ssp126[i])')
        exec('ts_zm_'+tt+'_ssp585[models[i]]=np.zeros((members_ssp585[i],180))')
        for region in regions1:
            exec('ts_'+region+'_'+tt+'_ssp585[models[i]] = np.zeros(members_ssp585[i])')
            
    for run in range(members_ssp126[i]):
        os.chdir('/Volumes/Zhou/data/cmip6/rcp26/ts/'+models[i]+'/r'+str(run+1)+'i1p1/')
        filename = glob.glob('*_2015*2100*1deg.zm.ann.nc')[0]
        f = Dataset(filename, 'r')
        ts_zm_t4_ssp126[models[i]][run,:] = np.mean(f.variables['ts'][-15:,:],0)   
    for run in range(members_ssp585[i]):
        os.chdir('/Volumes/Zhou/data/cmip6/rcp85/ts/'+models[i]+'/r'+str(run+1)+'i1p1/')
        filename = glob.glob('*_2015*2100*1deg.zm.ann.nc')[0]
        f = Dataset(filename, 'r')
        ts_zm_t4_ssp585[models[i]][run,:] = np.mean(f.variables['ts'][-15:,:],0)
        
    for region in regions1:
        for tt in ['t4']:
            exec('ts_'+region+'_'+tt+'_ssp126[models[i]] =get_'+region+'_mean(ts_zm_'+tt+'_ssp126[models[i]][::],lat)')
    
    for region in regions1:
        for tt in ['t4']:
            exec('ts_'+region+'_'+tt+'_ssp585[models[i]] =get_'+region+'_mean(ts_zm_'+tt+'_ssp585[models[i]][::],lat)')
    
  


# In[7]:


for region in ['arctic','globe','zm']:
    for model in models:
        exec('ts_'+region+'_dssp126[model] = ts_'+region+'_t4_ssp126[model]- np.mean(ts_'+region+'_t3[model],0)')
        exec('ts_'+region+'_dssp585[model] = ts_'+region+'_t4_ssp585[model]- np.mean(ts_'+region+'_t3[model],0)')


# In[8]:


regions=['arctic','globe','tropic']


# In[9]:


exps=['hist','ssp245','ssp126','ssp585']


# In[10]:


members_kernal_hist=  [5,5,5,3,2,3,3,3,1,5,5,5,5,5,5,1,5,5,5,1,1,5,5,3,5,5,5,5,5,5,3,4]
members_kernal_ssp126=[5,5,1,1,2,3,3,1,1,5,5,5,4,4,4,1,5,5,1,1,1,1,5,3,5,5,5,2,5,2,1,4]
members_kernal_ssp245=[5,5,1,1,2,2,3,1,1,5,5,5,5,5,4,1,5,5,5,1,1,1,5,3,5,5,5,2,5,2,2,4]
members_kernal_ssp585=[5,5,1,1,2,3,3,1,1,5,5,5,4,4,4,1,5,5,3,1,1,1,5,3,5,5,5,2,5,2,1,4]
    

#EC ssp126 ssp585 r5->r9

regions = ['globe','tropic','arctic']
factors = ['Plank','Albedo','Lapse','WV','cldmask']
exps=['hist','ssp245','ssp126','ssp585']
vars_r = ['dr_tcld','dr_tclr','dr_tscld','dr_tsclr','dr_albcld','dr_albclr','drsw_qcld','drsw_qclr',\
          'drlw_qcld','drlw_qclr','dr_tsacld','dr_tsaclr','dts']
vars_t=vars_r+['dr_plankcld','dr_plankclr','dr_qcld','dr_qclr','dr_lapsecld','dr_lapseclr','dr_cldmask']
for exp in exps:
    for region in regions:
        for factor in factors:
            exec('lamda_'+factor+'_'+region+'_'+exp+'1={}')
            exec('lamda_'+factor+'_'+region+'_'+exp+'2={}')
        exec('dtsm_'+region+'_'+exp+'1={}')
        exec('dtsm_'+region+'_'+exp+'2={}')
    exec('dr_albedo_dt_'+exp+' = {}')
f = Dataset('/Volumes/Xiao/AA/kernal/v2/r1/kernal_historical_r1_GISS-E2-1-H.nc', 'r')
lat_kernal = f.variables['lat'][::]
lon_kernal = f.variables['lon'][::]

for exp in exps:
    exec('dr_cldmask_'+exp+'=np.zeros((len(models),len(lat_kernal),len(lon_kernal)))')
    exec('dr_albedo_'+exp+'=np.zeros((len(models),len(lat_kernal),len(lon_kernal)))')
    exec('dr_WV_'+exp+'=np.zeros((len(models),len(lat_kernal),len(lon_kernal)))')
    exec('dr_Lapse_'+exp+'=np.zeros((len(models),len(lat_kernal),len(lon_kernal)))')
    exec('dts_'+exp+'=np.zeros((len(models),len(lat_kernal),len(lon_kernal)))')
    for i in range(len(models)):
        model = models[i]
        for region in regions:
            for var in vars_t:
                exec(var+'_'+region+'_'+exp+'= np.zeros(members_kernal_'+exp+'[i])')
        exec('members = members_kernal_'+exp+'[i]')
        dr_albedo_a=np.zeros((members,len(lat_kernal),len(lon_kernal)))
        tmp_cldmask = np.zeros((members,len(lat_kernal),len(lon_kernal)))
        tmp_dr_albedo = np.zeros((members,len(lat_kernal),len(lon_kernal)))
        tmp_dts = np.zeros((members,len(lat_kernal),len(lon_kernal)))
        tmp_dr_WV = np.zeros((members,len(lat_kernal),len(lon_kernal)))
        tmp_dr_Lapse = np.zeros((members,len(lat_kernal),len(lon_kernal)))
        for run in range(members):
            os.chdir('/Volumes/Xiao/AA/kernal/v2/r'+str(run+1)+'/')
            if model == 'EC-Earth3':
                filename = glob.glob('kernal_'+exp+'*_r*_'+model+'.nc')[0]
            else:
                filename = glob.glob('kernal_'+exp+'*_r*_'+model+'*.nc')[0]
            f = Dataset(filename, 'r')
            for var in vars_r:
                exec(var +'=f.variables[var][::]')
            dr_qcld = drsw_qcld + drlw_qcld;dr_qclr = drsw_qclr + drlw_qclr
            dr_lapsecld = dr_tcld - dr_tsacld;dr_lapseclr = dr_tclr - dr_tsaclr;
            dr_plankcld = dr_tscld + dr_tsacld;dr_plankclr = dr_tsclr + dr_tsaclr;
            dr_cldmask = (dr_tscld-dr_tsclr)+(dr_tcld-dr_tclr)+(dr_qcld-dr_qclr)+(dr_albcld-dr_albclr)
            for region in regions:
                for var in vars_t:
                    exec(var+'_'+region+'_'+exp+'[run] = get_'+region+'_mean(np.mean('+var+',1)[::-1],lat_kernal[::-1])')
            tmp_dts[run,::] = dts
            tmp_dr_albedo[run,::] = dr_albcld
            dr_albedo_a[run,::]=dr_albcld
            tmp_cldmask[run,::] = dr_cldmask
            tmp_dr_WV[run,::] = dr_qcld
            tmp_dr_Lapse[run,::] = dr_lapsecld
        exec('dr_cldmask_'+exp+'[i,::]=np.mean(tmp_cldmask,0)')
        exec('dr_albedo_'+exp+'[i,::]=np.mean(tmp_dr_albedo,0)')
        exec('dr_WV_'+exp+'[i,::]=np.mean(tmp_dr_WV,0)')
        exec('dr_Lapse_'+exp+'[i,::]=np.mean(tmp_dr_Lapse,0)')
        exec('dts_'+exp+'[i,::]=np.mean(tmp_dts,0)')
        exec('dr_albedo_dt_'+exp+'[model] = np.nanmean(dr_albedo_a,0)/np.mean(dts_arctic_'+exp+')')
        for region in regions:      
            exec('dtsm_'+region+'_'+exp+'1[model]=dts_'+region+'_'+exp)
            exec('lamda_Plank_'+region+'_'+exp+'1[model]= dr_plankcld_'+region+'_'+exp+'/dts_'+region+'_'+exp)
            exec('lamda_Albedo_'+region+'_'+exp+'1[model]= dr_albcld_'+region+'_'+exp+'/dts_'+region+'_'+exp)
            exec('lamda_WV_'+region+'_'+exp+'1[model]= dr_qcld_'+region+'_'+exp+'/dts_'+region+'_'+exp)
            exec('lamda_Lapse_'+region+'_'+exp+'1[model]= dr_lapsecld_'+region+'_'+exp+'/dts_'+region+'_'+exp)
            exec('lamda_cldmask_'+region+'_'+exp+'1[model]= dr_cldmask_'+region+'_'+exp+'/dts_'+region+'_'+exp)
            exec('dtsm_'+region+'_'+exp+'2[model]=np.mean(dts_'+region+'_'+exp+')')
            exec('lamda_Plank_'+region+'_'+exp+'2[model]= np.mean(dr_plankcld_'+region+'_'+exp+')/np.mean(dts_'+region+'_'+exp+')')
            exec('lamda_Albedo_'+region+'_'+exp+'2[model]= np.mean(dr_albcld_'+region+'_'+exp+')/np.mean(dts_'+region+'_'+exp+')')
            exec('lamda_WV_'+region+'_'+exp+'2[model]= np.mean(dr_qcld_'+region+'_'+exp+')/np.mean(dts_'+region+'_'+exp+')')
            exec('lamda_Lapse_'+region+'_'+exp+'2[model]= np.mean(dr_lapsecld_'+region+'_'+exp+')/np.mean(dts_'+region+'_'+exp+')')
            exec('lamda_cldmask_'+region+'_'+exp+'2[model]= np.mean(dr_cldmask_'+region+'_'+exp+')/np.mean(dts_'+region+'_'+exp+')')


# In[12]:


for exp in exps:
    for region in regions:
        exec('lamda_ohf_'+region+'_'+exp+'1={}')
        exec('lamda_ohf_'+region+'_'+exp+'2={}')
        exec('ohf_'+region+'_'+exp+'1={}')
        exec('ohf_'+region+'_'+exp+'2={}')

f = Dataset('/Volumes/Xiao/AA/ohf/r1/ohf_Amon_MPI-ESM1-2-LR_historical.anom.ymon.regrid.nc', 'r')
lat_regrid = f.variables['lat'][::]
lon_regrid = f.variables['lon'][::]


for exp in exps:
    exec('ohf_'+exp+'=np.zeros((len(models),len(lat_regrid),len(lon_regrid)))')
    for i in range(len(models)):
        model = models[i]
#         if exp == 'hist':
#             tend = 0.133*60/30
#         else:
#             tend = 0.133*60/105
        tend=0
        for region in regions:
            exec('ohf_'+region+'_'+exp+'= np.zeros(members_kernal_'+exp+'[i])')
        exec('members = members_kernal_'+exp+'[i]')
         
        tmp = np.zeros((members,len(lat_regrid),len(lon_regrid)))
        for run in range(members):
            os.chdir('/Volumes/Xiao/AA/ohf/r'+str(run+1)+'/')
            if model == 'EC-Earth3':
                filename = glob.glob('ohf_Amon_'+model+'_'+exp+'*.anom.ymon.regrid.nc')[0]
            else:
                filename = glob.glob('ohf_Amon_'+model+'*_'+exp+'*.anom.ymon.regrid.nc')[0]
            f = Dataset(filename, 'r')
            ohf=np.mean(f.variables['ohf'][::],0)
            for region in regions:
                exec('ohf_'+region+'_'+exp+'[run] = get_'+region+'_mean(np.mean(ohf,1),lat_regrid)')
            tmp[run,:,:] = ohf
        exec('ohf_'+exp+'[i,::]=np.mean(tmp,0)')
        if members > 0:       
            for region in regions:       
                exec('ohf_'+region+'_'+exp+'1[model]= ohf_'+region+'_'+exp)
                exec('lamda_ohf_'+region+'_'+exp+'1[model]= ohf_'+region+'_'+exp+'/dtsm_'+region+'_'+exp+'1[model]+tend')

                exec('ohf_'+region+'_'+exp+'2[model]=np.mean(ohf_'+region+'_'+exp+')')
                exec('lamda_ohf_'+region+'_'+exp+'2[model]= np.mean(ohf_'+region+'_'+exp+')/dtsm_'+region+'_'+exp+'2[model]+tend')
        else:
            for region in regions:       
                exec('ohf_'+region+'_'+exp+'1[model]= np.zeros(0)')
                exec('lamda_ohf_'+region+'_'+exp+'1[model]=np.zeros(0)')

                exec('ohf_'+region+'_'+exp+'2[model]=np.nan')
                exec('lamda_ohf_'+region+'_'+exp+'2[model]= np.nan')
  


# In[13]:


for exp in exps:
    for region in regions:
        exec('lamda_ahf_'+region+'_'+exp+'1={}')
        exec('lamda_ahf_'+region+'_'+exp+'2={}')
        exec('ahf_'+region+'_'+exp+'1={}')
        exec('ahf_'+region+'_'+exp+'2={}')

f = Dataset('/Volumes/Xiao/AA/ahf/r1/ahf_Amon_MPI-ESM1-2-LR_historical.anom.ymon.regrid.nc', 'r')
lat_regrid = f.variables['lat'][::]
lon_regrid = f.variables['lon'][::]

for i in range(len(models)):
    model = models[i]
    for exp in exps:
        for region in regions:
            exec('ahf_'+region+'_'+exp+'= np.zeros(members_kernal_'+exp+'[i])')
        exec('members = members_kernal_'+exp+'[i]')
        for run in range(members):
            os.chdir('/Volumes/Xiao/AA/ahf/r'+str(run+1)+'/')
            if model == 'EC-Earth3':
                filename = glob.glob('ahf_Amon_'+model+'_'+exp+'*.anom.ymon.regrid.nc')[0]
            else:
                filename = glob.glob('ahf_Amon_'+model+'*_'+exp+'*.anom.ymon.regrid.nc')[0]
            f = Dataset(filename, 'r')
            ahf=np.mean(f.variables['ahf'][::],0)
            for region in regions:
                exec('ahf_'+region+'_'+exp+'[run] = get_'+region+'_mean(np.mean(ahf,1),lat_regrid)')
        if members > 0:           
            exec('ahf_globe_'+exp+'1[model]= ahf_globe_'+exp)
            exec('lamda_ahf_globe_'+exp+'1[model]= ahf_globe_'+exp+'/dtsm_globe_'+exp+'1[model]')

            exec('ahf_globe_'+exp+'2[model]=np.mean(ahf_globe_'+exp+')')
            exec('lamda_ahf_globe_'+exp+'2[model]= np.mean(ahf_globe_'+exp+')/dtsm_globe_'+exp+'2[model]')

            exec('ahf_arctic_'+exp+'1[model]= ahf_arctic_'+exp+'-ahf_globe_'+exp)
            exec('lamda_ahf_arctic_'+exp+'1[model]= ahf_arctic_'+exp+'/dtsm_arctic_'+exp+'1[model]')

            exec('ahf_arctic_'+exp+'2[model]=np.mean(ahf_arctic_'+exp+'-ahf_globe_'+exp+')')
            exec('lamda_ahf_arctic_'+exp+'2[model]= np.mean(ahf_arctic_'+exp+')/dtsm_arctic_'+exp+'2[model]')
        else:
            for region in regions:       
                exec('ahf_'+region+'_'+exp+'1[model]= np.zeros(0)')
                exec('lamda_ahf_'+region+'_'+exp+'1[model]=np.zeros(0)')

                exec('ahf_'+region+'_'+exp+'2[model]=np.nan')
                exec('lamda_ahf_'+region+'_'+exp+'2[model]= np.nan')
  


# In[14]:


for exp in exps:
    for region in regions:
        exec('lamda_rcld_'+region+'_'+exp+'1={}')
        exec('lamda_rcld_'+region+'_'+exp+'2={}')
        exec('lamda_cld_'+region+'_'+exp+'1={}')
        exec('lamda_cld_'+region+'_'+exp+'2={}')
        exec('rcld_'+region+'_'+exp+'1={}')
        exec('rcld_'+region+'_'+exp+'2={}')

f = Dataset('/Volumes/Xiao/AA/rcld/r1/rcld_Amon_MPI-ESM1-2-LR_historical.anom.ymon.regrid.nc', 'r')
lat_regrid = f.variables['lat'][::]
lon_regrid = f.variables['lon'][::]
for exp in exps:
    exec('rcld_'+exp+'=np.zeros((len(models),len(lat_kernal),len(lon_kernal)))')
    for i in range(len(models)):
        model = models[i]
        for region in regions:
            exec('rcld_'+region+'_'+exp+'= np.zeros(members_kernal_'+exp+'[i])')
        exec('members = members_kernal_'+exp+'[i]')
        tmp = np.zeros((members,len(lat_kernal),len(lon_kernal)))
        for run in range(members):
            os.chdir('/Volumes/Xiao/AA/rcld/r'+str(run+1)+'/')
            if model == 'EC-Earth3':
                filename = glob.glob('rcld_Amon_'+model+'_'+exp+'*.anom.ymon.regrid.nc')[0]
            else:
                filename = glob.glob('rcld_Amon_'+model+'*_'+exp+'*.anom.ymon.regrid.nc')[0]
            f = Dataset(filename, 'r')
            rcld=np.mean(f.variables['rcld'][::],0)
            tmp[run,::] = rcld
            for region in regions:
                exec('rcld_'+region+'_'+exp+'[run] = get_'+region+'_mean(np.mean(rcld,1),lat_regrid)')
        exec('rcld_'+exp+'[i,::]=np.mean(tmp,0)-dr_cldmask_'+exp+'[i,::]')
        if members>0:
            for region in regions:       
                exec('rcld_'+region+'_'+exp+'1[model]= rcld_'+region+'_'+exp)
                exec('lamda_rcld_'+region+'_'+exp+'1[model]= rcld_'+region+'_'+exp+'/dtsm_'+region+'_'+exp+'1[model]')
                exec('lamda_cld_'+region+'_'+exp+'1[model]= lamda_rcld_'+region+'_'+exp+'1[model]-lamda_cldmask_'+region+'_'+exp+'1[model]')

                exec('rcld_'+region+'_'+exp+'2[model]=np.mean(rcld_'+region+'_'+exp+')')
                exec('lamda_rcld_'+region+'_'+exp+'2[model]= np.mean(rcld_'+region+'_'+exp+')/dtsm_'+region+'_'+exp+'2[model]')
                exec('lamda_cld_'+region+'_'+exp+'2[model]= lamda_rcld_'+region+'_'+exp+'2[model]-lamda_cldmask_'+region+'_'+exp+'2[model]')
        else:
            for region in regions:       
                exec('rcld_'+region+'_'+exp+'1[model]= np.zeros(0)')
                exec('lamda_rcld_'+region+'_'+exp+'1[model]= np.zeros(0)')
                exec('lamda_cld_'+region+'_'+exp+'1[model]= np.zeros(0)')

                exec('rcld_'+region+'_'+exp+'2[model]=np.nan')
                exec('lamda_rcld_'+region+'_'+exp+'2[model]= np.nan')
                exec('lamda_cld_'+region+'_'+exp+'2[model]= np.nan')
  
            


# In[15]:


for region in ['globe','arctic','tropic']:
    for exp in exps:
        exec('lamda_All_'+region+'_'+exp+'2={}')
        for model in models:
            exec('lamda_All_'+region+'_'+exp+'2[model]=0')
            for factor in ['Plank','Albedo','Lapse','WV','ohf','cld']:
                exec('lamda_All_'+region+'_'+exp+'2[model]+=lamda_'+factor+'_'+region+'_'+exp+'2[model]')
        exec('lamda_WL_'+region+'_'+exp+'2={}')
        for model in models:
            exec('lamda_WL_'+region+'_'+exp+'2[model]=0')
            for factor in ['WV','Lapse']:
                exec('lamda_WL_'+region+'_'+exp+'2[model]+=lamda_'+factor+'_'+region+'_'+exp+'2[model]')


# In[16]:


regions = ['globe','tropic','arctic']
factors = ['Plank','Albedo','Lapse','WV','cldmask']
vars_r = ['dr_tcld','dr_tclr','dr_tscld','dr_tsclr','dr_albcld','dr_albclr','drsw_qcld','drsw_qclr',\
          'drlw_qcld','drlw_qclr','dr_tsacld','dr_tsaclr','dts']
vars_t=vars_r+['dr_plankcld','dr_plankclr','dr_qcld','dr_qclr','dr_lapsecld','dr_lapseclr','dr_cldmask']

exp='hist'
model='ERA5'


os.chdir('/Volumes/Xiao/AA/kernal/v2/')
f = Dataset('kernal_historical_ERA5.nc', 'r')
for var in vars_r:
    exec(var +'=f.variables[var][::]')
dr_qcld = drsw_qcld + drlw_qcld;dr_qclr = drsw_qclr + drlw_qclr
dr_lapsecld = dr_tcld - dr_tsacld;dr_lapseclr = dr_tclr - dr_tsaclr;
dr_plankcld = dr_tscld + dr_tsacld;dr_plankclr = dr_tsclr + dr_tsaclr;
dr_cldmask = (dr_tscld-dr_tsclr)+(dr_tcld-dr_tclr)+(dr_qcld-dr_qclr)+(dr_albcld-dr_albclr)
for region in regions:
    for var in vars_t:
        exec(var+'_'+region+'_'+exp+' = get_'+region+'_mean(np.mean('+var+',1)[::-1],lat_kernal[::-1])')
dr_albedo_dt_hist_ERA5 = dr_albcld/dts_arctic_hist
for region in regions:       
    exec('dtsm_'+region+'_'+exp+'_ERA5=dts_'+region+'_'+exp)
    exec('lamda_Plank_'+region+'_'+exp+'_ERA5= dr_plankcld_'+region+'_'+exp+'/dts_'+region+'_'+exp)
    exec('lamda_Albedo_'+region+'_'+exp+'_ERA5= dr_albcld_'+region+'_'+exp+'/dts_'+region+'_'+exp)
    exec('lamda_WV_'+region+'_'+exp+'_ERA5= dr_qcld_'+region+'_'+exp+'/dts_'+region+'_'+exp)
    exec('lamda_Lapse_'+region+'_'+exp+'_ERA5= dr_lapsecld_'+region+'_'+exp+'/dts_'+region+'_'+exp)
    exec('lamda_cldmask_'+region+'_'+exp+'_ERA5= dr_cldmask_'+region+'_'+exp+'/dts_'+region+'_'+exp)
    





plt.figure(figsize=(4.5,4.5))
ax1=plt.subplot(111)  
aa=np.zeros(len(models))
bb=np.zeros(len(models))
cc=np.zeros(len(models))
j=0
for i in range(len(models)):
    aa[i]=dtsm_arctic_ssp2452[models[i]]/dtsm_globe_ssp2452[models[i]]
    bb[i]=-ahf_arctic_ssp2452[models[i]]/dtsm_globe_ssp2452[models[i]]
    if ~np.isnan(bb[i]):
        plt.text(aa[i],bb[i],str(i+1),fontsize=6)
        j=j+1
aa=aa[~np.isnan(bb)]
bb=bb[~np.isnan(bb)]
plt.plot(aa,bb,'ko')
coef1,coef2=np.polyfit(aa,bb,1)
coef_a = {}
coef_b = {}
coefz1_a = {}
coefz1_b = {}
coefz2_a = {}
coefz2_b = {}
aa=np.zeros(len(models))
bb=np.zeros(len(models))
cc=np.zeros(len(models))
for i in range(len(models)):
    model=models[i]
    aa[i]=dtsm_arctic_ssp2452[models[i]]/dtsm_globe_ssp2452[models[i]]
    bb[i]=-ahf_arctic_ssp2452[models[i]]/dtsm_globe_ssp2452[models[i]]
    cc[i]=bb[i]-aa[i]*coef1-coef2
    if np.isnan(bb[i]):
        coef_a[model] = np.nan
        coef_b[model] = np.nan
    else:
        coef_a[model] = coef1+coef2+cc[i]/2
        coef_b[model] = -coef1+cc[i]/2/(1-aa[i])
        coefz1_a[model] = coef1+coef2
        coefz1_b[model] = -coef1+cc[i]/(1-aa[i])
        coefz2_a[model] = coef1+coef2+cc[i]
        coefz2_b[model] = -coef1
xx=aa
plt.plot(xx,xx*coef1+coef2)


for i in range(len(models)):
    if ~np.isnan(bb[i]):
        plt.plot(aa[i],-aa[i]*coef_b[models[i]]+coef_a[models[i]]+coef_b[models[i]],'rx')
daht=cc
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2.5)










gammafactor=0.6
ratio_lamda_ssp245_basic0=np.zeros(len(models))
ratio_lamda_ssp245_basic1=np.zeros(len(models))
ratio_lamda_ssp245_basic1_=np.zeros(len(models))
ratio_lamda_ssp245_basic2=np.zeros(len(models))
ratio_lamda_ssp245=np.zeros(len(models))
ratio_lamda_ssp245_ocean=np.zeros(len(models))
ratio_lamda_ssp245_albedo=np.zeros(len(models))
ratio_lamda_ssp245_lapsewv=np.zeros(len(models))
ratio_lamda_ssp245_planck=np.zeros(len(models))
ratio_lamda_ssp245_cloud=np.zeros(len(models))
ratio_lamda_ssp245_basic3=np.zeros(len(models))
con_gamma = np.zeros(len(models))
con_gamma1 = np.zeros(len(models))
conm_ohf=np.zeros(len(models))
conm_albedo=np.zeros(len(models))
conm_lapsewv=np.zeros(len(models))
conm_planck=np.zeros(len(models))
conm_lapse=np.zeros(len(models))
conm_wv=np.zeros(len(models))
conm_cloud=np.zeros(len(models))
conm_feedbacks=np.zeros(len(models))

aa_mean=np.nanmedian(list(lamda_All_arctic_ssp2452.values()))
cc_mean=np.nanmedian(list(lamda_All_globe_ssp2452.values()))
coef_a_mean=np.nanmedian(np.array(list(coef_a.values()))[~np.isnan(ratio_lamda_ssp245)])
coef_b_mean=np.nanmedian(np.array(list(coef_b.values()))[~np.isnan(ratio_lamda_ssp245)])
ratio_lamda_ssp245_basic1_mean = (coef_a_mean+coef_b_mean-cc_mean)/(coef_b_mean-cc_mean)
ratio_lamda_ssp245_basic2_mean = (coef_a_mean+coef_b_mean-gammafactor*cc_mean)/(coef_b_mean-aa_mean)
ratio_lamda_ssp245_mean = (coef_a_mean+coef_b_mean-gammafactor*cc_mean)/(coef_b_mean-aa_mean)

for i in range(len(models)):
    aa=lamda_All_arctic_ssp2452[models[i]]
    cc=lamda_All_globe_ssp2452[models[i]]
    ratio_lamda_ssp245_basic0[i] = (coef_a[models[i]]+coef_b[models[i]])/(coef_b[models[i]])
    ratio_lamda_ssp245_basic1[i] = (coef_a[models[i]]+coef_b[models[i]]-cc)/(coef_b[models[i]]-cc)
    ratio_lamda_ssp245_basic1_[i] = (coef_a[models[i]]+coef_b[models[i]]-lamda_All_globe_ssp2452[models[i]])/(coef_b[models[i]]-lamda_All_globe_ssp2452[models[i]])
    ratio_lamda_ssp245_basic2[i] = (coef_a[models[i]]+coef_b[models[i]]-gammafactor*cc)/(coef_b[models[i]]-cc)
    
    
    ratio_lamda_ssp245_basic3[i] = (coef_a[models[i]]+coef_b[models[i]]-cc)/(coef_b[models[i]]-aa)
    
    ratio_lamda_ssp245[i] = (coef_a[models[i]]+coef_b[models[i]]-gammafactor*cc)/(coef_b[models[i]]-aa)
    
    
    aa=lamda_ohf_globe_ssp2452[models[i]]+lamda_Albedo_arctic_ssp2452[models[i]]+lamda_Lapse_arctic_ssp2452[models[i]]+lamda_Plank_arctic_ssp2452[models[i]]+lamda_cld_arctic_ssp2452[models[i]]+lamda_WV_arctic_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    cc=lamda_ohf_globe_ssp2452[models[i]]+lamda_Albedo_globe_ssp2452[models[i]]+lamda_Lapse_globe_ssp2452[models[i]]+lamda_Plank_globe_ssp2452[models[i]]+lamda_cld_globe_ssp2452[models[i]]+lamda_WV_globe_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    ratio_lamda_ssp245_ocean[i] = (coef_a[models[i]]+coef_b[models[i]]-gammafactor*cc)/(coef_b[models[i]]-aa)

    aa=lamda_ohf_arctic_ssp2452[models[i]]+lamda_Albedo_globe_ssp2452[models[i]]+lamda_Lapse_arctic_ssp2452[models[i]]+lamda_Plank_arctic_ssp2452[models[i]]+lamda_cld_arctic_ssp2452[models[i]]+lamda_WV_arctic_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    cc=lamda_ohf_globe_ssp2452[models[i]]+lamda_Albedo_globe_ssp2452[models[i]]+lamda_Lapse_globe_ssp2452[models[i]]+lamda_Plank_globe_ssp2452[models[i]]+lamda_cld_globe_ssp2452[models[i]]+lamda_WV_globe_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    ratio_lamda_ssp245_albedo[i] = (coef_a[models[i]]+coef_b[models[i]]-gammafactor*cc)/(coef_b[models[i]]-aa)

    aa=lamda_ohf_arctic_ssp2452[models[i]]+lamda_Albedo_arctic_ssp2452[models[i]]+lamda_Lapse_globe_ssp2452[models[i]]+lamda_Plank_arctic_ssp2452[models[i]]+lamda_cld_arctic_ssp2452[models[i]]+lamda_WV_globe_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    cc=lamda_ohf_globe_ssp2452[models[i]]+lamda_Albedo_globe_ssp2452[models[i]]+lamda_Lapse_globe_ssp2452[models[i]]+lamda_Plank_globe_ssp2452[models[i]]+lamda_cld_globe_ssp2452[models[i]]+lamda_WV_globe_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    ratio_lamda_ssp245_lapsewv[i] = (coef_a[models[i]]+coef_b[models[i]]-gammafactor*cc)/(coef_b[models[i]]-aa)

    aa=lamda_ohf_arctic_ssp2452[models[i]]+lamda_Albedo_arctic_ssp2452[models[i]]+lamda_Lapse_arctic_ssp2452[models[i]]+lamda_Plank_globe_ssp2452[models[i]]+lamda_cld_arctic_ssp2452[models[i]]+lamda_WV_arctic_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    cc=lamda_ohf_globe_ssp2452[models[i]]+lamda_Albedo_globe_ssp2452[models[i]]+lamda_Lapse_globe_ssp2452[models[i]]+lamda_Plank_globe_ssp2452[models[i]]+lamda_cld_globe_ssp2452[models[i]]+lamda_WV_globe_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    ratio_lamda_ssp245_planck[i] = (coef_a[models[i]]+coef_b[models[i]]-gammafactor*cc)/(coef_b[models[i]]-aa)
    
    aa=lamda_ohf_arctic_ssp2452[models[i]]+lamda_Albedo_arctic_ssp2452[models[i]]+lamda_Lapse_arctic_ssp2452[models[i]]+lamda_Plank_arctic_ssp2452[models[i]]+lamda_cld_globe_ssp2452[models[i]]+lamda_WV_arctic_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    cc=lamda_ohf_globe_ssp2452[models[i]]+lamda_Albedo_globe_ssp2452[models[i]]+lamda_Lapse_globe_ssp2452[models[i]]+lamda_Plank_globe_ssp2452[models[i]]+lamda_cld_globe_ssp2452[models[i]]+lamda_WV_globe_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    ratio_lamda_ssp245_cloud[i] = (coef_a[models[i]]+coef_b[models[i]]-gammafactor*cc)/(coef_b[models[i]]-aa)
    

    aa1=lamda_Lapse_arctic_ssp2452[models[i]]
    cc1=lamda_Lapse_globe_ssp2452[models[i]]
    aa1_mean=np.nanmean(list(lamda_Lapse_arctic_ssp2452.values()))
    cc1_mean=np.nanmean(list(lamda_Lapse_globe_ssp2452.values()))
    conm_lapse[i] = (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-aa1)-\
    (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-cc1)
    
    
    aa1=lamda_WV_arctic_ssp2452[models[i]]
    cc1=lamda_WV_globe_ssp2452[models[i]]
    aa1_mean=np.nanmean(list(lamda_WV_arctic_ssp2452.values()))
    cc1_mean=np.nanmean(list(lamda_WV_globe_ssp2452.values()))
    conm_wv[i] = (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-aa1)-\
    (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-cc1)

    
    aa=lamda_All_arctic_ssp2452[models[i]]
    cc=lamda_All_globe_ssp2452[models[i]]
    conm_feedbacks[i] =  -(coef_a_mean+coef_b_mean-gammafactor*cc)/(coef_b_mean-aa)+ratio_lamda_ssp245_basic2_mean
    
    
    aa1=lamda_Plank_arctic_ssp2452[models[i]]
    cc1=lamda_Plank_globe_ssp2452[models[i]]
    aa1_mean=np.nanmean(list(lamda_Plank_arctic_ssp2452.values()))
    cc1_mean=np.nanmean(list(lamda_Plank_globe_ssp2452.values()))
    conm_planck[i] = (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-aa1)-\
    (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-cc1)
    
    
    aa1=lamda_Albedo_arctic_ssp2452[models[i]]
    cc1=lamda_Albedo_globe_ssp2452[models[i]]
    aa1_mean=np.nanmean(list(lamda_Albedo_arctic_ssp2452.values()))
    cc1_mean=np.nanmean(list(lamda_Albedo_globe_ssp2452.values()))
    conm_albedo[i] = (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-aa1)-\
    (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-cc1)
    
    aa1=lamda_cld_arctic_ssp2452[models[i]]
    cc1=lamda_cld_globe_ssp2452[models[i]]
    aa1_mean=np.nanmean(list(lamda_cld_arctic_ssp2452.values()))
    cc1_mean=np.nanmean(list(lamda_cld_globe_ssp2452.values()))
    conm_cloud[i] = (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-aa1)-\
    (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-cc1)

    
    
    aa1=lamda_ohf_arctic_ssp2452[models[i]]
    cc1=lamda_ohf_globe_ssp2452[models[i]]
    aa1_mean=np.nanmean(list(lamda_ohf_arctic_ssp2452.values()))
    cc1_mean=np.nanmean(list(lamda_ohf_globe_ssp2452.values()))
    conm_ohf[i] = (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-aa1)-\
    (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-cc1)
    
    aa1=lamda_WV_arctic_ssp2452[models[i]]+lamda_Lapse_arctic_ssp2452[models[i]]
    cc1=lamda_WV_globe_ssp2452[models[i]]+lamda_Lapse_globe_ssp2452[models[i]]
    aa1_mean=np.nanmean(list(lamda_Lapse_arctic_ssp2452.values()))+np.nanmean(list(lamda_WV_arctic_ssp2452.values()))
    cc1_mean=np.nanmean(list(lamda_Lapse_globe_ssp2452.values()))+np.nanmean(list(lamda_WV_globe_ssp2452.values()))
    conm_lapsewv[i] = (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-aa1)-\
    (coef_a_mean+coef_b_mean-0.6*(cc_mean-cc1_mean+cc1))/(coef_b_mean-aa_mean+aa1_mean-cc1)
    
con_cloud=(ratio_lamda_ssp245-ratio_lamda_ssp245_cloud)
con_cloud=con_cloud[~np.isnan(ratio_lamda_ssp245)]
con_albedo=(ratio_lamda_ssp245-ratio_lamda_ssp245_albedo)
con_albedo=con_albedo[~np.isnan(ratio_lamda_ssp245)]
con_ohf=(ratio_lamda_ssp245-ratio_lamda_ssp245_ocean)
con_ohf=con_ohf[~np.isnan(ratio_lamda_ssp245)]
con_planck=(ratio_lamda_ssp245-ratio_lamda_ssp245_planck)
con_planck=con_planck[~np.isnan(ratio_lamda_ssp245)]
con_lapsewv=(ratio_lamda_ssp245-ratio_lamda_ssp245_lapsewv)
con_lapsewv=con_lapsewv[~np.isnan(ratio_lamda_ssp245)]
con_feedbacks=(ratio_lamda_ssp245-ratio_lamda_ssp245_basic2)
con_feedbacks=con_feedbacks[~np.isnan(ratio_lamda_ssp245)]
con_gamma=(ratio_lamda_ssp245_basic2-ratio_lamda_ssp245_basic1)
con_gamma=con_gamma[~np.isnan(ratio_lamda_ssp245)]
con_gamma1=(ratio_lamda_ssp245-ratio_lamda_ssp245_basic3)
con_gamma1=con_gamma1[~np.isnan(ratio_lamda_ssp245)]
con_basic=ratio_lamda_ssp245_basic1[~np.isnan(ratio_lamda_ssp245)]
con_basic_=ratio_lamda_ssp245_basic1_[~np.isnan(ratio_lamda_ssp245)]

conm_cloud=conm_cloud[~np.isnan(ratio_lamda_ssp245)]
conm_albedo=conm_albedo[~np.isnan(ratio_lamda_ssp245)]
conm_ohf=conm_ohf[~np.isnan(ratio_lamda_ssp245)]
conm_planck=conm_planck[~np.isnan(ratio_lamda_ssp245)]
conm_lapsewv=conm_lapsewv[~np.isnan(ratio_lamda_ssp245)]
conm_feedbacks=conm_feedbacks[~np.isnan(ratio_lamda_ssp245)]





flierprops = dict(marker='o', markerfacecolor='None', markersize=4,linestyle='none')
medianprops = dict(linestyle='none')
meanprops = dict(color='w',linewidth=1.3,linestyle='-')

flierprops1 = dict(marker='o', markerfacecolor='None', markersize=4,linestyle='none')
medianprops1 = dict(linestyle='none')
meanprops1 = dict(color='w',linewidth=1.3,linestyle='-')





low=10
high=90
plt.figure(figsize=(8.3,12))

ax1=plt.subplot(321)
aa=np.zeros(len(models))
bb=np.zeros(len(models))
j=0
for i in range(len(models)):
    aa[i]=dtsm_arctic_ssp2452[models[i]]/dtsm_globe_ssp2452[models[i]]-1
    bb[i]=-ahf_arctic_ssp2452[models[i]]/dtsm_globe_ssp2452[models[i]]
    if ~np.isnan(bb[i]):
        plt.text(aa[i],bb[i],str(j+1),color='r',fontsize=6)
        j=j+1
aa=aa[~np.isnan(bb)]
bb=bb[~np.isnan(bb)]
plt.plot(aa,bb,'kd',markersize=4)
coef1,coef2=np.polyfit(aa,bb,1)
print(pearsonr(aa,bb)[0])
xx=np.arange(0,2.9,0.1)
plt.plot(xx,xx*coef1+coef2,color='c')
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2.5)
plt.xlim([0.3,2.7])
plt.ylim([-2.5,2.5])
plt.xlabel('AA$-$1',labelpad=2,fontsize=9)
plt.ylabel('$\Delta AHT/\Delta T^G$ [W m$^{-2}$ K$^{-1}$]',labelpad=2,fontsize=9)
_=plt.text(0.15,0.1,'$r=-0.70$',fontsize=9,transform=ax1.transAxes,horizontalalignment='center',color='k')
plt.text(0.1,0.92,r'$\frac{\Delta AHT}{\Delta T^G}=a-b(AA-1)$',fontsize=9,transform=ax1.transAxes,color='k')
plt.text(0.15,0.83,'$\hat{a}=2.1; \hat{b}=1.7$',fontsize=9,transform=ax1.transAxes,color='k')
plt.text(-0.15,0.99,'a',fontsize=12,transform=ax1.transAxes)

ax2=plt.subplot(322)
hh=[]
for factor in ['Plank','Albedo','ohf','cld','Lapse','WV','All','WL']:
    exec('aa=np.array(list(lamda_'+factor+'_globe_ssp2452.values()))');aa=aa[~np.isnan(aa)]
    exec('bb=np.array(list(lamda_'+factor+'_arctic_ssp2452.values()))');bb=bb[~np.isnan(bb)]
#     if factor=='cld':
#         aa=aa+0.1
    #h=plt.plot(np.mean(aa),np.mean(bb),'o',markersize=5,markerfacecolor='None')
    if factor=='All':
        hh+=[plt.plot(aa,bb,'.',alpha=0.75,markersize=4,color='k')]
        
    else:
        hh+=[plt.plot(aa,bb,'.',alpha=0.75,markersize=2.5)]
    #plt.plot([np.percentile(aa,low),np.percentile(aa,high)],[np.mean(bb),np.mean(bb)],'-',linewidth=1.25,color=hh[-1][0].get_color())
    #plt.plot([np.mean(aa),np.mean(aa)],[np.percentile(bb,low),np.percentile(bb,high)],'-',linewidth=1.25,color=hh[-1][0].get_color())
    plt.plot([np.nanmean(aa)-np.nanstd(aa),np.nanmean(aa)+np.nanstd(aa)],[np.nanmean(bb),np.nanmean(bb)],'-',linewidth=1.25,color=hh[-1][0].get_color())
    plt.plot([np.nanmean(aa),np.nanmean(aa)],[np.nanmean(bb)-np.nanstd(bb),np.nanmean(bb)+np.nanstd(bb)],'-',linewidth=1.25,color=hh[-1][0].get_color())
    
    if factor == 'Plank':
        factor1 ='Planck'
    elif factor == 'ohf':
        factor1 = 'Ocean'
    elif factor == 'cld':
        factor1 = 'Cloud'
    elif factor == 'Lapse':
        factor1 = 'LR'
    elif factor == 'WL':
        factor1 = 'LR+WV'
    else:
        factor1 = factor
    plt.text(np.mean(aa)+0.04,np.mean(bb)+0.12,factor1,fontsize=7,color=hh[-1][0].get_color())

_=plt.text(0.83,0.37,'$r(\lambda_i^G,\lambda_i^A)$',fontsize=8.5,transform=ax2.transAxes,horizontalalignment='center',color='k')
_=plt.text(0.82,0.3,'$All:0.60$',fontsize=8,transform=ax2.transAxes,horizontalalignment='center',color='k')
_=plt.text(0.82,0.24,'$Albedo:0.64$',fontsize=8,transform=ax2.transAxes,horizontalalignment='center',color=hh[1][0].get_color())
_=plt.text(0.82,0.12,'$Ocean:0.65$',fontsize=8,transform=ax2.transAxes,horizontalalignment='center',color=hh[2][0].get_color())
_=plt.text(0.82,0.06,'$Cloud:0.83$',fontsize=8,transform=ax2.transAxes,horizontalalignment='center',color=hh[3][0].get_color())
_=plt.text(0.67,0.18,'$LR$',fontsize=8,transform=ax2.transAxes,horizontalalignment='left',color=hh[4][0].get_color())
_=plt.text(0.78,0.18,'$+WV$',fontsize=8,transform=ax2.transAxes,horizontalalignment='center',color=hh[5][0].get_color())
_=plt.text(0.888,0.18,'$:0.50$',fontsize=8,transform=ax2.transAxes,horizontalalignment='center',color='m')
#plt.plot([np.percentile(aa*0.61,low),np.percentile(aa*0.61,high)],[np.mean(bb),np.mean(bb)],'-',linewidth=1.75,color='grey')
#plt.plot([np.mean(aa*0.61),np.mean(aa*0.61)],[np.percentile(bb,low),np.percentile(bb,high)],'-',linewidth=1.75,color='grey')
plt.plot([-4,4],[0,0],'--',color='grey',linewidth=1)
plt.plot([0,0],[-4,4],'--',color='grey',linewidth=1)
plt.xlim([-3.45,2.45])
plt.ylim([-3.45,2.45])
plt.plot([-4,4],[-4,4],'-',color='c',linewidth=1.2)
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2.5)
plt.text(-0.15,0.99,'b',fontsize=12,transform=ax2.transAxes)
plt.xlabel(r'$\lambda^{G}_i$ [W m$^{-2}$ K$^{-1}$]',labelpad=2,fontsize=9)
plt.ylabel(r'$\lambda^{A}_i$ [W m$^{-2}$ K$^{-1}$]',labelpad=2,fontsize=9)

colors=['b','g','m','r','orange','gold']
markers=['d','o','s','^','v','h']

ax4=plt.subplot(323)
ratio_lamda_ssp245=np.zeros(len(models))
j=0
for i in range(len(models)):
    aa=lamda_ohf_arctic_ssp2452[models[i]]+lamda_Albedo_arctic_ssp2452[models[i]]+lamda_Lapse_arctic_ssp2452[models[i]]+lamda_Plank_arctic_ssp2452[models[i]]+lamda_cld_arctic_ssp2452[models[i]]+lamda_WV_arctic_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    cc=lamda_ohf_globe_ssp2452[models[i]]+lamda_Albedo_globe_ssp2452[models[i]]+lamda_Lapse_globe_ssp2452[models[i]]+lamda_Plank_globe_ssp2452[models[i]]+lamda_cld_globe_ssp2452[models[i]]+lamda_WV_globe_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    ratio_lamda_ssp245[i] = (3.81-0.6*cc)/(1.68-aa)
print('1: '+str(np.std(ratio_lamda_ssp245)))
plt.plot(ratio_lamda_ssp245[~np.isnan(ratio_lamda_ssp245)],AA_ssp245[~np.isnan(ratio_lamda_ssp245)],'kd',markersize=4)
for i in range(len(models)):
    if ~np.isnan(ratio_lamda_ssp245[i]):
        plt.text(ratio_lamda_ssp245[i],AA_ssp245[i],str(j+1),fontsize=6,color='r')
        j=j+1
print(np.mean(ratio_lamda_ssp245[~np.isnan(ratio_lamda_ssp245)]))
print(pearsonr(ratio_lamda_ssp245[~np.isnan(ratio_lamda_ssp245)],AA_ssp245[~np.isnan(ratio_lamda_ssp245)])[0])
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2.5)
plt.text(-0.15,0.99,'c',fontsize=12,transform=ax4.transAxes)
plt.xlabel(r'$I^{AA}=1+(\hat{a}+\lambda^A-\hat{\gamma}\lambda^G)/(\hat{b}-\lambda^A)$',labelpad=2,fontsize=9)
plt.ylabel('AA',labelpad=2,fontsize=9)
plt.ylim([1.25,4.24])
plt.xlim([1.25,4.24])
plt.plot([-4,4.4],[-4,4.4],'-',color='c',linewidth=1.2)
_=plt.text(0.86,0.1,'$r=0.71$',fontsize=9,transform=ax4.transAxes,horizontalalignment='center',color='k')

ax4=plt.subplot(324)
ratio_lamda_ssp245=np.zeros(len(models))
j=0
for i in range(len(models)):
    aa=lamda_ohf_arctic_ssp2452[models[i]]+lamda_Albedo_arctic_ssp2452[models[i]]+lamda_Lapse_arctic_ssp2452[models[i]]+lamda_Plank_arctic_ssp2452[models[i]]+lamda_cld_arctic_ssp2452[models[i]]+lamda_WV_arctic_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    cc=lamda_ohf_globe_ssp2452[models[i]]+lamda_Albedo_globe_ssp2452[models[i]]+lamda_Lapse_globe_ssp2452[models[i]]+lamda_Plank_globe_ssp2452[models[i]]+lamda_cld_globe_ssp2452[models[i]]+lamda_WV_globe_ssp2452[models[i]]#/lamda_Plank_globe_ssp2452[models[i]]
    ratio_lamda_ssp245[i] = (coef_a[models[i]]+coef_b[models[i]]-0.6*cc)/(coef_b[models[i]]-aa)
plt.plot(ratio_lamda_ssp245[~np.isnan(ratio_lamda_ssp245)],AA_ssp245[~np.isnan(ratio_lamda_ssp245)],'kd',markersize=4)
print('2: '+str(np.std(ratio_lamda_ssp245)))
for i in range(len(models)):
    if ~np.isnan(ratio_lamda_ssp245[i]):
        plt.text(ratio_lamda_ssp245[i],AA_ssp245[i],str(j+1),fontsize=6,color='r')
        j=j+1
aa=ratio_lamda_ssp245[~np.isnan(ratio_lamda_ssp245)];
bb=AA_ssp245[~np.isnan(ratio_lamda_ssp245)]
a,b = polyfit(aa,bb,1)
ll=(np.max(aa)-np.min(aa))*0.1
xx = np.arange(np.min(aa)+ll,np.max(aa)-ll,0.01)
print(pearsonr(ratio_lamda_ssp245[~np.isnan(ratio_lamda_ssp245)],AA_ssp245[~np.isnan(ratio_lamda_ssp245)])[0])
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2.5)
plt.text(-0.15,0.99,'d',fontsize=12,transform=ax4.transAxes)
plt.xlabel(r'$I^{AA}=1+(a+\lambda^A-\hat{\gamma}\lambda^G)/(b-\lambda^A)$',labelpad=2,fontsize=9)
plt.ylabel('AA',labelpad=2,fontsize=9)
plt.ylim([1.25,4.25])
plt.xlim([1.25,4.25])
plt.plot([-4,4.4],[-4,4.4],'-',color='c',linewidth=1.2)
_=plt.text(0.86,0.1,'$r=0.92$',fontsize=9,transform=ax4.transAxes,horizontalalignment='center',color='k')

ax4=plt.subplot(325)
plt.barh(9,np.nanmean(AA_ssp245[~np.isnan(ratio_lamda_ssp245)]),xerr =np.nanstd(AA_ssp245[~np.isnan(ratio_lamda_ssp245)]),color='grey',hatch=['....'], capsize=3,height=0.7,linewidth=1,edgecolor='k')
plt.barh(8,np.nanmean(ratio_lamda_ssp245),xerr =np.nanstd(ratio_lamda_ssp245),color='k', alpha=0.8,capsize=3,height=0.7,linewidth=1,edgecolor='k')
plt.barh(7,np.mean(con_basic),xerr =np.std(con_basic),color='grey', alpha=0.7,capsize=3,height=0.7,linewidth=1,edgecolor='k')
plt.barh(6,np.mean(con_gamma1),xerr =np.std(con_gamma1)/1.1, color='cyan',alpha=0.8,capsize=3,height=0.7,linewidth=1,edgecolor='k')
plt.barh(5,np.mean(con_feedbacks),xerr =np.std(con_feedbacks), color='goldenrod',alpha=0.8,capsize=3,height=0.7,linewidth=1,edgecolor='k')
plt.barh(4,np.mean(conm_planck),xerr =np.std(conm_planck), capsize=3,height=0.7,linewidth=1,edgecolor='k')
plt.barh(3,np.mean(conm_albedo),xerr =np.std(conm_albedo), capsize=3,height=0.7,linewidth=1,edgecolor='k')
plt.barh(2,np.mean(conm_ohf),xerr =np.std(conm_ohf), capsize=3,height=0.7,linewidth=1,edgecolor='k')
plt.barh(1,np.mean(conm_cloud),xerr =np.std(conm_cloud), capsize=3,height=0.7,linewidth=1,edgecolor='k')
plt.barh(0,np.mean(conm_lapsewv),xerr =np.std(conm_lapsewv), capsize=3,height=0.7,linewidth=1,edgecolor='k')
plt.barh(-5,np.mean(conm_lapsewv),xerr =np.std(conm_lapsewv), capsize=3,height=0.7,linewidth=1,edgecolor='k')

plt.plot([0,0],[-2,10],color='k',linewidth=1)
plt.xlim(-2.3,3.6)
plt.ylim(-0.65,9.65)
plt.yticks([9,8,7,6,5,4,3,2,1,0],['$GCM$','$I^{AA}$','$I^{AA}_{B}$','$F_A/F_G$','$Feedbacks$','$Planck$','$Albedo$','$Ocean$','$Cloud$','$LR+WV$'],fontsize=6)
plt.xticks([-2,-1,0,1,2,3])
plt.xlabel('AA',fontsize=9)
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2.5)
plt.text(-0.15,0.99,'e',fontsize=12,transform=ax4.transAxes)
j=0
j1=0
k=1
for i in range(len(models)):
    if ~np.isnan(ratio_lamda_ssp245[i]):
        plt.text(2.5+k*3,9-j1*0.6,str(j+1)+': '+models[i],fontsize=7.5,color='r')
        j=j+1
        j1=j1+1
        if j1==16:
            k=k+1
            j1=0
        
plt.subplots_adjust(wspace=0.33,hspace=0.3)
plt.savefig('/Users/zhou272/Desktop/Projects/AA3/Fig2.pdf',bbox_inches='tight', format='pdf', dpi=600)


# In[29]:


lamda_lapsewv_arctic_hist2={}
lamda_lapsewv_globe_hist2={}
lamda_lapsewv_arctic_ssp2452={}
lamda_lapsewv_globe_ssp2452={}

for model in models:
    for region in ['arctic','globe']:
        exec('lamda_lapsewv_'+region+'_hist2[model] = lamda_Lapse_'+region+'_hist2[model] + lamda_WV_'+region+'_hist2[model]')
        exec('lamda_lapsewv_'+region+'_ssp2452[model] = lamda_Lapse_'+region+'_ssp2452[model] + lamda_WV_'+region+'_ssp2452[model]')



# In[31]:


models_ss=['INM-CM4-8','HadGEM3-GC31-LL','CIESM','CanESM5','CESM2','UKESM1-0-LL']


# In[32]:


lamda_All_globe_ssp245=np.array(list(lamda_All_globe_ssp2452.values()))
lamda_All_arctic_ssp245=np.array(list(lamda_All_arctic_ssp2452.values()))





colorss=['c','orange','b','m','g','red']
models_ss=['INM-CM4-8','HadGEM3-GC31-LL','CIESM','CanESM5','CESM2','UKESM1-0-LL']
cmap = plt.cm.get_cmap('jet')
fig = plt.figure(figsize=(9,8.5))
ax1=plt.subplot2grid((2,2),(0,0))
cc=ratio_lamda_ssp245
cc=cc[~np.isnan(cc)]
dd=np.sort(cc)
index1=np.argsort(cc)
ee=ratio_lamda_ssp245-ratio_lamda_ssp245_basic1
ee=ee[~np.isnan(ratio_lamda_ssp245)]
index=np.argsort(ee)
for i in range(32):
    plt.bar(i,dd[i],color=cmap(list(index).index(index1[i])/32),alpha=0.8,width=0.7)
index=np.argsort(cc)
model_sort = np.array(models)[~np.isnan(ratio_lamda_ssp245)][index]
cmap = plt.cm.get_cmap('jet')
rgba = cmap(0.5)
i=0
for model in model_sort:
    plt.plot(i,AA_ssp245[models.index(model)],'ko',markersize=3)
    i=i+1
cc=ratio_lamda_ssp245_basic1
cc=cc[~np.isnan(cc)]
plt.bar(np.arange(32),cc[index],color='grey',width=0.7)
_=plt.xticks(np.arange(32),index+1,rotation=90)
plt.ylim([1.23,3.72])
plt.xlim([-0.75,31.75])
plt.plot([-0.5,-0.5],[0,2.05],'b--',linewidth=1.2)
plt.plot([2.5,2.5],[0,2.05],'b--',linewidth=1.2)
plt.plot([-0.5,2.5],[2.05,2.05],'b--',linewidth=1.2)
plt.plot([28.5,28.5],[0,3.55],'r--',linewidth=1.2)
plt.plot([31.5,31.5],[0,3.55],'r--',linewidth=1.2)
plt.plot([28.5,31.5],[3.55,3.55],'r--',linewidth=1.2)
plt.tick_params(axis='x',labelsize=7.5,direction='out',length=3.5,width=1,pad=1.5)
plt.tick_params(axis='y',labelsize=9,direction='out',length=3.5,width=1,pad=2.5)
plt.text(-0.15,0.99,'a',fontsize=12,transform=ax1.transAxes)
plt.ylabel('AA',labelpad=2,fontsize=9)

ax3=plt.subplot2grid((2,2),(1,0))
lamd_g=np.arange(-3.3,-0.4,0.1)
lamd_ag=np.arange(-0.5,3.1,0.1)
ff=np.zeros((len(lamd_ag),len(lamd_g)))
for i in range(len(lamd_ag)):
    for j in range(len(lamd_g)):
        a=2.146
        b=1.688
        ff[i,j] = (a+lamd_ag[i]+lamd_g[j]-0.6*lamd_g[j])/(b-lamd_g[j]-lamd_ag[i])-a/(b-lamd_g[j])
ff[ff>5]=np.nan
plt.contourf(lamd_g,lamd_ag,ff,np.arange(0.1,2.3,0.45),cmap=cmap,alpha=0.4,linewidths=0)
aa=np.array(list(lamda_All_globe_ssp2452.values()));aa=aa[~np.isnan(aa)]
bb=np.array(list(lamda_All_arctic_ssp2452.values()));bb=bb[~np.isnan(bb)]
aa=np.zeros(len(models))
bb=np.zeros(len(models))
j=0
for i in range(len(models)):
    aa[i]=lamda_All_globe_ssp2452[models[i]]
    bb[i]=lamda_All_arctic_ssp2452[models[i]]-lamda_All_globe_ssp2452[models[i]]
    if ~np.isnan(bb[i]):
        plt.text(aa[i]+0.02,bb[i],str(j+1),color='k',fontsize=6)
        j=j+1
aa=aa[~np.isnan(bb)]
bb=bb[~np.isnan(bb)]
dd=ratio_lamda_ssp245-ratio_lamda_ssp245_basic1
dd=dd[~np.isnan(ratio_lamda_ssp245)]
index=np.argsort(dd)
for i in index:
    if index[i] in [6,7,20,18,11,31]:
        plt.plot(aa[index[i]],bb[index[i]],'d',markersize=7.6,color=cmap(i/32),markeredgecolor='k',markeredgewidth=0.5)
    else:  
        plt.plot(aa[index[i]],bb[index[i]],'d',markersize=5.6,color=cmap(i/32),markeredgecolor='None')
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2.5)
plt.xlim([-3.25,-0.5])
plt.ylim([-0.,2.5])
plt.xlabel('$\lambda^G$ [W m$^{-2}$ K$^{-1}$]',labelpad=2,fontsize=9)
plt.ylabel('$\lambda^A-\lambda^G$ [W m$^{-2}$ K$^{-1}$]',labelpad=2,fontsize=9)
#_=plt.text(0.8,0.1,'$r_{\lambda^A,\lambda^G}=0.60$',fontsize=9,transform=ax3.transAxes,horizontalalignment='center',color='k')
plt.text(-0.15,0.99,'c',fontsize=12,transform=ax3.transAxes)
#plt.text(0.12,0.22,'$\lambda^A-\lambda^G=1.3$',fontsize=8,transform=ax3.transAxes,rotation=41.,weight='bold')
cax = fig.add_axes([0.142, 0.135, 0.1, 0.0085])
cb1=plt.colorbar(CS1, cax=cax, ticks=[0,8,16,24,32],orientation='horizontal')
cb1.ax.tick_params(labelsize=7,pad=2,length=2)
cb1.ax.set_title(r'$FF=\frac{a+\lambda^A-\gamma\lambda^G}{b-\lambda^A}-\frac{a}{b-\lambda^G}$',size=8,pad = 1.5)
cb1.ax.set_xticklabels(['0','0.45','0.9','1.35','1.8']) 


ax3=plt.subplot2grid((2,2),(0,1),colspan=1)
lamd_g=np.arange(-3.3,-0.31,0.1)
diff_ab=np.arange(-1.6,1.7,0.1)
xx=np.zeros((len(lamd_g),len(diff_ab)))
for i in range(len(lamd_g)):
    for j in range(len(diff_ab)):
        xx[i,j] = 1+(2.146+diff_ab[j])/(1.688-lamd_g[i])
plt.contourf(lamd_g,diff_ab,xx.T,np.arange(1.3,2.2,0.2),cmap=cmap,alpha=0.4,linewidths=0)
aa=np.array(list(lamda_All_globe_ssp2452.values()));aa=aa[~np.isnan(aa)]
bb=np.array(list(coef_b.values()));bb=bb[~np.isnan(bb)]
aa=np.zeros(len(models))
bb=np.zeros(len(models))
j=0
for i in range(len(models)):
    aa[i]=lamda_All_globe_ssp2452[models[i]]
    bb[i]=daht[i]
    if ~np.isnan(aa[i]):
        plt.text(aa[i]+0.02,bb[i],str(j+1),color='k',fontsize=6)
        j=j+1
aa=aa[~np.isnan(bb)]
bb=bb[~np.isnan(bb)]
dd=ratio_lamda_ssp245_basic1
dd=dd[~np.isnan(ratio_lamda_ssp245)]
index=np.argsort(dd)
for i in index:
    if index[i] in [6,7,20,18,11,31]:
        plt.plot(aa[index[i]],bb[index[i]],'d',markersize=7.6,color=cmap(i/32),markeredgecolor='k',markeredgewidth=0.5)
    else:  
        plt.plot(aa[index[i]],bb[index[i]],'d',markersize=5.6,color=cmap(i/32),markeredgecolor='None')
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2.5)
plt.xlim([-3.25,-0.5])
plt.ylim([-1.6,1.6])
plt.yticks([-1.6,-0.8,0,0.8,1.6])
plt.xlabel('$\lambda^G$ [W m$^{-2}$ K$^{-1}$]',labelpad=2,fontsize=9)
plt.ylabel(r'$d=\frac{\Delta AHT}{\Delta T^G}-\widehat{\frac{\Delta AHT}{\Delta T^G}}$  [W m$^{-2}$ K$^{-1}$]',labelpad=2,fontsize=9)
plt.text(-0.15,0.99,'b',fontsize=12,transform=ax3.transAxes)
print(min(dd))
print(max(dd))
cax = fig.add_axes([0.58, 0.55, 0.1, 0.0085])
cb1=plt.colorbar(CS1, cax=cax, ticks=[0,8,16,24,32],orientation='horizontal')
cb1.ax.tick_params(labelsize=7,pad=2,length=2)
cb1.ax.set_title(r'$I^{AA}_B=1+\frac{a}{b-\lambda^G}$',size=8,pad = 1.5)
cb1.ax.set_xticklabels(['1.3','1.5','1.7','1.9','2.1']) 

ax4=plt.subplot2grid((2,2),(1,1),colspan=1)
factors=['All','Albedo','ohf','cld','WL']
i=0
for factor in factors:
    exec('aa=np.array(list(lamda_'+factor+'_arctic_ssp2452.values()))')
    exec('bb=np.array(list(lamda_'+factor+'_globe_ssp2452.values()))')
    aa=aa[~np.isnan(aa)]
    bb=bb[~np.isnan(bb)]
    bplot=plt.boxplot(aa-bb,positions=[5+i*0.5],sym=[],widths=0.09,whis=[10,90],patch_artist=True,vert=True,flierprops=flierprops1)
    for patch, color in zip(bplot['boxes'], 'grey'):
        patch.set_facecolor('grey')  
    bplot=plt.boxplot(bb,positions=[1.5+i*0.5],sym=[],widths=0.09,whis=[10,90],patch_artist=True,vert=True,flierprops=flierprops1)
    for patch, color in zip(bplot['boxes'], 'grey'):
        patch.set_facecolor('grey') 
    i=i+1

exec('aa=np.array(list(coef_a.values()))')
aa=aa[~np.isnan(aa)]
bplot=plt.boxplot(aa,positions=[-1],sym=[],widths=0.09,whis=[10,90],patch_artist=True,vert=True,flierprops=flierprops1)
for patch, color in zip(bplot['boxes'], 'grey'):
    patch.set_facecolor('grey')  
exec('aa=np.array(list(coef_b.values()))')
aa=aa[~np.isnan(aa)]
bplot=plt.boxplot(aa,positions=[-0.5],sym=[],widths=0.09,whis=[10,90],patch_artist=True,vert=True,flierprops=flierprops1)
for patch, color in zip(bplot['boxes'], 'grey'):
    patch.set_facecolor('grey')  
bplot=plt.boxplot(daht,positions=[0],sym=[],widths=0.09,whis=[10,90],patch_artist=True,vert=True,flierprops=flierprops1)
for patch, color in zip(bplot['boxes'], 'grey'):
    patch.set_facecolor('grey')  
    
h=[]     
for k in range(len(models_ss)):
    exec('h+=plt.plot(-1+0.018*(k-1.5),coef_a[models_ss[k]],\'o\',color=colorss[k],markersize=3)')
    exec('plt.plot(-0.5+0.018*(k-1.5),coef_b[models_ss[k]],\'o\',color=colorss[k],markersize=3)')
    exec('plt.plot(0+0.018*(k-1.5),daht[models.index(models_ss[k])],\'o\',color=colorss[k],markersize=3)')
    for i in range(len(factors)):
        exec('plt.plot(5+i*0.5+0.018*(k-1.5),lamda_'+factors[i]+'_arctic_ssp2452[models_ss[k]]-lamda_'+factors[i]+'_globe_ssp2452[models_ss[k]],\'o\',color=colorss[k],markersize=3)')
        exec('plt.plot(1.5+i*0.5+0.018*(k-1.5),lamda_'+factors[i]+'_globe_ssp2452[models_ss[k]],\'o\',color=colorss[k],markersize=3)')
indexx=[]
i=0
for model in models_ss:
    indexx+= [str(list(np.array(models)[~np.isnan(ratio_lamda_ssp245)]).index(model)+1)]
    i=i+1
ll=plt.legend([h[0],h[2],h[4],h[1],h[3],h[5]],['M'+indexx[0]+' ('+models_ss[0]+')',\
                                     'M'+indexx[2]+' ('+models_ss[2]+')',\
                                     'M'+indexx[4]+' ('+models_ss[4]+')',\
                                     'M'+indexx[1]+' ('+models_ss[1]+')',\
                                     'M'+indexx[3]+' ('+models_ss[3]+')',\
                                     'M'+indexx[5]+' ('+models_ss[5]+')',\
                                    ],frameon=True,fontsize=5.5,loc='upper right',\
             labelspacing = 0.7,ncol=2)

plt.plot([-2,8],[0,0],'--',color='grey',linewidth=1.25)
plt.xlim([-1.5,7.5])
plt.ylim([-3.4,3.4])
_=plt.xticks([-1,-0.5,0,1.5,2,2.5,3,3.5,5,5.5,6,6.5,7],['$a$','$b$','$d$','$\lambda^G$','${alb}$','${ocn}$','${cld}$','$lr$+$wv$','$\lambda^A-\lambda^G$','${alb}$','${ocn}$','${cld}$','$lr$+$wv$'],rotation=90)
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2)#,right=True,labelright=True)
plt.ylabel('[W m$^{-2}$ K$^{-1}$]',fontsize=9)
plt.fill_betweenx([-4,4],[1,1],[4,4],color='grey',alpha=0.1,edgecolor='None')
plt.fill_betweenx([-4,4],[-1.5,-1.5],[0.5,0.5],color='grey',alpha=0.1,edgecolor='None')
plt.fill_betweenx([-4,4],[4.5,4.5],[7.5,7.5],color='grey',alpha=0.1,edgecolor='None')
plt.text(-0.15,0.99,'d',fontsize=12,transform=ax4.transAxes)

plt.subplots_adjust(wspace=0.3)
#plt.savefig('/Users/zhou272/Desktop/Projects/AA3/Fig4.pdf',bbox_inches='tight', format='pdf', dpi=1000)



for region in regions:
    exec('ta_zm_'+region+'=np.zeros((len(models),14))')
    exec('hus_zm_'+region+'=np.zeros((len(models),14))')
    exec('hus_clim_zm_'+region+'=np.zeros((len(models),14))')
for i in range(len(models)):    
    tmp1 = np.zeros((members_kernal_ssp245[i],14,73))
    tmp2 = np.zeros((members_kernal_ssp245[i],14,73))
    tmp3 = np.zeros((members_kernal_ssp245[i],14,73))
    for run in range(members_kernal_ssp245[i]):
        os.chdir('/Volumes/Xiao/AA/zonal_mean/r'+str(run+1))
        f = Dataset('ta_Amon_'+models[i]+'_ssp245.anom.ymon.zm.nc', 'r')
        tmp1[run,:] = np.mean(f.variables['ta'][:,0:14,:],0)
        f = Dataset('hus_Amon_'+models[i]+'_ssp245.anom.ymon.zm.nc', 'r')
        tmp2[run,:] = np.mean(f.variables['hus'][:,0:14,:],0)
        f = Dataset('hus_Amon_'+models[i]+'_198001-199412.ymon.zm.nc', 'r')
        tmp3[run,:] = np.mean(f.variables['hus'][:,0:14,:],0)        
    for region in regions:
        exec('ta_zm_'+region+'[i,::] =get_'+region+'_mean(np.mean(tmp1,0),lat_regrid)')
        exec('hus_zm_'+region+'[i,::] =get_'+region+'_mean(np.mean(tmp2,0),lat_regrid)')
        exec('hus_clim_zm_'+region+'[i,::] =get_'+region+'_mean(np.mean(tmp3,0),lat_regrid)')
plev=np.array([100000, 92500, 85000, 70000, 60000, 50000, 40000, 30000, \
               25000, 20000, 15000, 10000, 7000, 5000])/100
dtsm_tropic_ssp245=np.array(list(dtsm_tropic_ssp2452.values()))
lamda_Lapse_tropic_ssp245=np.array(list(lamda_Lapse_tropic_ssp2452.values()))
lamda_WV_tropic_ssp245=np.array(list(lamda_WV_tropic_ssp2452.values()))
dtsm_globe_ssp245=np.array(list(dtsm_globe_ssp2452.values()))
lamda_Lapse_globe_ssp245=np.array(list(lamda_Lapse_globe_ssp2452.values()))
lamda_WV_globe_ssp245=np.array(list(lamda_WV_globe_ssp2452.values()))

dtsm_tropic_ssp245=np.array(list(dtsm_tropic_ssp2452.values()))
lamda_Lapse_tropic_ssp245=np.array(list(lamda_Lapse_tropic_ssp2452.values()))
lamda_WV_tropic_ssp245=np.array(list(lamda_WV_tropic_ssp2452.values()))

dtsm_arctic_ssp245=np.array(list(dtsm_arctic_ssp2452.values()))
lamda_Lapse_arctic_ssp245=np.array(list(lamda_Lapse_arctic_ssp2452.values()))
lamda_WV_arctic_ssp245=np.array(list(lamda_WV_arctic_ssp2452.values()))

ind_s_globe=np.argsort(lamda_Lapse_globe_ssp245)[0:5]
ind_l_globe=np.argsort(lamda_Lapse_globe_ssp245)[-5:]
    
ind_s_arctic=np.argsort(lamda_Lapse_arctic_ssp245)[0:5]
ind_l_arctic=np.argsort(lamda_Lapse_arctic_ssp245)[-5:]

ind_s_tropic=np.argsort(lamda_Lapse_tropic_ssp245)[0:5]
ind_l_tropic=np.argsort(lamda_Lapse_tropic_ssp245)[-5:]

plt.figure(figsize=(12,4))
ax1=plt.subplot(133)


aa=np.array(list(lamda_Lapse_globe_ssp2452.values()))
aa=aa[~np.isnan(ratio_lamda_ssp245)]
bb=np.array(list(lamda_WV_globe_ssp2452.values()))
bb=bb[~np.isnan(ratio_lamda_ssp245)]
plt.plot(aa,bb,'r.',markersize=4)
print(pearsonr(aa,bb)[0])

aa=np.array(list(lamda_Lapse_arctic_ssp2452.values()))
aa=aa[~np.isnan(ratio_lamda_ssp245)]
bb=np.array(list(lamda_WV_arctic_ssp2452.values()))
bb=bb[~np.isnan(ratio_lamda_ssp245)]
plt.plot(aa,bb,'b.',markersize=4)
print(pearsonr(aa,bb)[0])

plt.xlim([-1.,1.])
plt.ylim([0.1,2.45])
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2)
plt.ylabel('$\lambda_{WV}$ [W m$^{-2}$ K$^{-1}$]',fontsize=9)
plt.xlabel('$\lambda_{LP}$ [W m$^{-2}$ K$^{-1}$]',fontsize=9)
_=plt.text(0.49,0.36,'Globe \n $-$0.56$\pm$0.15 \n 1.92$\pm$0.16 \n 1.36$\pm$0.11 \n 0.75',fontsize=9,transform=ax1.transAxes,horizontalalignment='center',color='r')
_=plt.text(0.81,0.36,'Arctic \n 0.75$\pm$0.11 \n 0.53$\pm$0.07 \n 1.28$\pm$0.07 \n 0.88',fontsize=9,transform=ax1.transAxes,horizontalalignment='center',color='b')
_=plt.text(0.2,0.36,'$\lambda_{LP}$ \n $\lambda_{WV}$ \n $\lambda_{LP}+\lambda_{WV}$ \n$r_{LP,WV}$',fontsize=8.5,transform=ax1.transAxes,horizontalalignment='center',color='k')
plt.text(-0.15,0.99,'c',fontsize=12,transform=ax1.transAxes)

ax1=plt.subplot(131)
h1,=plt.plot(np.ones(14)*100,plev,'k-',linewidth=1)
h2,=plt.plot(np.ones(14)*100,plev,'k--',linewidth=1)
plt.plot(np.mean(ta_zm_globe/dtsm_globe_ssp245[:,None],0),plev,'r-')
plt.plot(np.mean(ta_zm_globe[ind_s_globe,:]/dtsm_globe_ssp245[ind_s_globe,None],0),plev,'r--')
plt.plot(np.mean(ta_zm_arctic/dtsm_arctic_ssp245[:,None],0),plev,'b-')
plt.plot(np.mean(ta_zm_arctic[ind_s_arctic,:]/dtsm_arctic_ssp245[ind_s_arctic,None],0),plev,'b--')
plt.ylim([100,1000])
plt.xlim([-0.25,1.65])
plt.yticks([200,400,600,800,1000])
plt.gca().invert_yaxis()
_=plt.text(0.3,0.5,'Arctic',fontsize=9,transform=ax1.transAxes,horizontalalignment='center',color='b')
_=plt.text(0.63,0.5,'Globe',fontsize=9,transform=ax1.transAxes,horizontalalignment='center',color='r')
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2)
plt.xlabel('$\Delta T$ [K]',fontsize=9)
plt.ylabel('Plev [hPa]]',fontsize=9)
plt.text(-0.15,0.99,'a',fontsize=12,transform=ax1.transAxes)
plt.legend([h1,h2],['MME','Models with most negative \nlapse-rate feedback'],fontsize=7,frameon=False,loc='lower left')

ax1=plt.subplot(132)
h1,=plt.plot(np.ones(14)*100,plev,'k-',linewidth=1)
h2,=plt.plot(np.ones(14)*100,plev,'k--',linewidth=1)
plt.plot(np.mean(hus_zm_globe/dtsm_globe_ssp245[:,None],0)/np.mean(hus_clim_zm_globe,0)*100.,plev,'r-')
plt.plot(np.mean(hus_zm_globe[ind_s_globe,:]/dtsm_globe_ssp245[ind_s_globe,None],0)/np.mean(hus_clim_zm_globe[ind_s_globe,:],0)*100.,plev,'r--')
plt.plot(np.mean(hus_zm_arctic/dtsm_arctic_ssp245[:,None],0)/np.mean(hus_clim_zm_arctic,0)*100.,plev,'b-')
plt.plot(np.mean(hus_zm_arctic[ind_s_arctic,:]/dtsm_arctic_ssp245[ind_s_arctic,None],0)/np.mean(hus_clim_zm_arctic[ind_s_arctic,:],0)*100.,plev,'b--')
plt.ylim([100,1000])
plt.xlim([0,30])
plt.yticks([200,400,600,800,1000])
plt.gca().invert_yaxis()
_=plt.text(0.1,0.5,'Arctic',fontsize=9,transform=ax1.transAxes,horizontalalignment='center',color='b')
_=plt.text(0.54,0.5,'Globe',fontsize=9,transform=ax1.transAxes,horizontalalignment='center',color='r')
plt.tick_params(labelsize=9,direction='out',length=3.5,width=1,pad=2)
plt.xlabel('$\Delta q/q$ [%]',fontsize=9)
plt.ylabel('Plev [hPa]]',fontsize=9)
#plt.legend([h1,h2],['MME','Models with lower \nlapse-rate feedback'],fontsize=7,frameon=False)
plt.text(-0.15,0.99,'b',fontsize=12,transform=ax1.transAxes)

plt.subplots_adjust(wspace=0.3)
plt.savefig('/Users/zhou272/Desktop/Projects/AA3/Fig3.pdf',bbox_inches='tight', format='pdf', dpi=600)







