import unittest

from nacc.uds3.ivp import builder as ivp_builder
from nacc.uds3.fvp import builder as fvp_builder


class TestUDSFormSkip(unittest.TestCase):

    def test_a2_ivp_skip(self):
        """ If the IVP A2 is not present in the csv, it should be skipped
        without throwing an error """
        record = make_blank_ivp()
        record['a2sub'] = '1'

        expected = record['othcondx']
        result = ivp_builder.build_uds3_ivp_form(record)
        self.assertEqual(expected, result['OTHCONDX'])

    def test_a2_fvp_skip(self):
        """ If the FVP A2 is not present in the csv, it should be skipped
        without throwing an error """
        record = make_blank_fvp()
        record['fu_a2sub'] = '1'

        expected = record['fu_othcondx']
        result = fvp_builder.build_uds3_fvp_form(record)
        self.assertEqual(expected, result['OTHCONDX'])

    def test_ivp_b4_not_skipped(self):
        """ Form B4 is required and should never be skipped. Testing B4 in
        particular because it is in the middle of the "add form" logic rather
        than outside the try/catch and if statements. """
        record = make_blank_ivp()
        record['langb4'] = ''
        record['cdrlang'] = '1'

        expected = record['cdrlang']
        result = ivp_builder.build_uds3_ivp_form(record)
        self.assertEqual(expected, result['CDRLANG'])

    def test_fvp_b4_not_skipped(self):
        """ Same for FVP. """
        record = make_blank_fvp()
        record['fu_langb4'] = ''
        record['fu_cdrlang'] = '1'

        expected = record['fu_cdrlang']
        result = fvp_builder.build_uds3_fvp_form(record)
        self.assertEqual(expected, result['CDRLANG'])


def make_blank_ivp():
    return {
        'ptid': '1',
        'adcid': '2',
        'visitmo': '1',
        'visitday': '1',
        'visityr': '2017',
        'visitnum': '3',
        'initials': '',
        # Z1X
        'langa1': '',
        'langa2': '',
        'a2sub': '',
        'a2not': '',
        'langa3': '',
        'a3sub': '',
        'a3not': '',
        'langa4': '',
        'a4sub': '',
        'a4not': '',
        'langa5': '',
        'langb1': '',
        'b1sub': '',
        'b1not': '',
        'langb4': '',
        'langb5': '',
        'b5sub': '',
        'b5not': '',
        'langb6': '',
        'b6sub': '',
        'b6not': '',
        'langb7': '',
        'b7sub': '',
        'b7not': '',
        'langb8': '',
        'langb9': '',
        'langc2': '',
        'langd1': '',
        'langd2': '',
        'langa3a': '',
        'ftda3afs': '',
        'ftda3afr': '',
        'langb3f': '',
        'langb9f': '',
        'langc1f': '',
        'langc2f': '',
        'langc3f': '',
        'langc4f': '',
        'ftdc4fs': '',
        'ftdc4fr': '',
        'ftdc5fs': '',
        'ftdc5fr': '',
        'ftdc6fs': '',
        'ftdc6fr': '',
        'lange2f': '',
        'lange3f': '',
        'langcls': '',
        'clssub': '',
        'ivp_z1x_complete': '2',
        'reason': '',
        'refersc': '',
        'learned': '',
        'prestat': '',
        'prespart': '',
        'source': '',
        'birthmo': '',
        'birthyr': '',
        'sex': '',
        'hispanic': '',
        'hispor': '',
        'hisporx': '',
        'race': '',
        'racex': '',
        'racesec': '',
        'racesecx': '',
        'raceter': '',
        'raceterx': '',
        'primlang': '',
        'primlanx': '',
        'educ': '',
        'maristat': '',
        'livsitua': '',
        'independ': '',
        'residenc': '',
        'zip': '',
        'handed': '',
        'tobac30': '',
        'tobac100': '',
        'smokyrs': '',
        'packsper': '',
        'quitsmok': '',
        'alcoccas': '',
        'alcfreq': '',
        'cvhatt': '',
        'hattmult': '',
        'hattyear': '',
        'cvafib': '',
        'cvangio': '',
        'cvbypass': '',
        'cvpacdef': '',
        'cvchf': '',
        'cvangina': '',
        'cvhvalve': '',
        'cvothr': '',
        'cvothrx': '',
        'cbstroke': '',
        'strokmul': '',
        'strokyr': '',
        'cbtia': '',
        'tiamult': '',
        'tiayear': '',
        'pd': '',
        'pdyr': '',
        'pdothr': '',
        'pdothryr': '',
        'seizures': '',
        'tbi': '',
        'tbibrief': '',
        'tbiexten': '',
        'tbiwolos': '',
        'tbiyear': '',
        'diabetes': '',
        'diabtype': '',
        'hyperten': '',
        'hypercho': '',
        'b12def': '',
        'thyroid': '',
        'arthrit': '',
        'arthtype': '',
        'arthtypx': '',
        'arthupex': '',
        'arthloex': '',
        'arthspin': '',
        'arthunk': '',
        'incontu': '',
        'incontf': '',
        'apnea': '',
        'rbd': '',
        'insomn': '',
        'othsleep': '',
        'othsleex': '',
        'alcohol': '',
        'abusothr': '',
        'abusx': '',
        'ptsd': '',
        'bipolar': '',
        'schiz': '',
        'dep2yrs': '',
        'depothr': '',
        'anxiety': '',
        'ocd': '',
        'npsydev': '',
        'psycdis': '',
        'psycdisx': '',
        'memory': '',
        'orient': '',
        'judgment': '',
        'commun': '',
        'homehobb': '',
        'perscare': '',
        'cdrsum': '',
        'cdrglob': '',
        'comport': '',
        'cdrlang': '',
        'normexam': '',
        'parksign': '',
        'resttrl': '',
        'slowingl': '',
        'rigidl': '',
        'resttrr': '',
        'slowingr': '',
        'rigidr': '',
        'brady': '',
        'parkgait': '',
        'postinst': '',
        'cvdsigns': '',
        'cortdef': '',
        'sivdfind': '',
        'cvdmotl': '',
        'cortvisl': '',
        'somatl': '',
        'cvdmotr': '',
        'cortvisr': '',
        'somatr': '',
        'postcort': '',
        'pspcbs': '',
        'eyepsp': '',
        'dyspsp': '',
        'axialpsp': '',
        'gaitpsp': '',
        'apraxsp': '',
        'apraxl': '',
        'cortsenl': '',
        'ataxl': '',
        'alienlml': '',
        'dystonl': '',
        'myocllt': '',
        'apraxr': '',
        'cortsenr': '',
        'ataxr': '',
        'alienlmr': '',
        'dystonr': '',
        'myoclrt': '',
        'alsfind': '',
        'gaitnph': '',
        'othneur': '',
        'othneurx': '',
        'decsub': '',
        'decin': '',
        'decclcog': '',
        'cogmem': '',
        'cogori': '',
        'cogjudg': '',
        'coglang': '',
        'cogvis': '',
        'cogattn': '',
        'cogfluc': '',
        'cogflago': '',
        'cogothr': '',
        'cogothrx': '',
        'cogfpred': '',
        'cogfprex': '',
        'cogmode': '',
        'cogmodex': '',
        'decage': '',
        'decclbe': '',
        'beapathy': '',
        'bedep': '',
        'bevhall': '',
        'bevwell': '',
        'bevhago': '',
        'beahall': '',
        'bedel': '',
        'bedisin': '',
        'beirrit': '',
        'beagit': '',
        'beperch': '',
        'berem': '',
        'beremago': '',
        'beanx': '',
        'beothr': '',
        'beothrx': '',
        'befpred': '',
        'befpredx': '',
        'bemode': '',
        'bemodex': '',
        'beage': '',
        'decclmot': '',
        'mogait': '',
        'mofalls': '',
        'motrem': '',
        'moslow': '',
        'mofrst': '',
        'momode': '',
        'momodex': '',
        'momopark': '',
        'parkage': '',
        'momoals': '',
        'alsage': '',
        'moage': '',
        'course': '',
        'frstchg': '',
        'lbdeval': '',
        'ftldeval': '',
        'mocacomp': '',
        'mocareas': '',
        'mocaloc': '',
        'mocalan': '',
        'mocalanx': '',
        'mocavis': '',
        'mocahear': '',
        'mocatots': '',
        'mocatrai': '',
        'mocacube': '',
        'mocacloc': '',
        'mocaclon': '',
        'mocacloh': '',
        'mocanami': '',
        'mocaregi': '',
        'mocadigi': '',
        'mocalett': '',
        'mocaser7': '',
        'mocarepe': '',
        'mocaflue': '',
        'mocaabst': '',
        'mocarecn': '',
        'mocarecc': '',
        'mocarecr': '',
        'mocaordt': '',
        'mocaormo': '',
        'mocaoryr': '',
        'mocaordy': '',
        'mocaorpl': '',
        'mocaorct': '',
        'npsycloc_c2': '',
        'npsylan_c2': '',
        'npsylanx_c2': '',
        'craftvrs': '',
        'crafturs': '',
        'udsbentc': '',
        'digforct': '',
        'digforsl': '',
        'digbacct': '',
        'digbacls': '',
        'animals_c2': '',
        'veg_c2': '',
        'traila_c2': '',
        'trailarr_c2': '',
        'trailali_c2': '',
        'trailb_c2': '',
        'trailbrr_c2': '',
        'trailbli_c2': '',
        'craftdvr': '',
        'craftdre': '',
        'craftdti': '',
        'craftcue': '',
        'udsbentd': '',
        'udsbenrs': '',
        'minttots': '',
        'minttotw': '',
        'mintscng': '',
        'mintscnc': '',
        'mintpcng': '',
        'mintpcnc': '',
        'udsverfc': '',
        'udsverfn': '',
        'udsvernf': '',
        'udsverlc': '',
        'udsverlr': '',
        'udsverln': '',
        'udsvertn': '',
        'udsverte': '',
        'udsverti': '',
        'cogstat_c2': '',
        'dxmethod': '',
        'normcog': '',
        'demented': '',
        'amndem': '',
        'pca': '',
        'ppasyn': '',
        'ppasynt': '',
        'ftdsyn': '',
        'lbdsyn': '',
        'namndem': '',
        'mciamem': '',
        'mciaplus': '',
        'mciaplan': '',
        'mciapatt': '',
        'mciapex': '',
        'mciapvis': '',
        'mcinon1': '',
        'mcin1lan': '',
        'mcin1att': '',
        'mcin1ex': '',
        'mcin1vis': '',
        'mcinon2': '',
        'mcin2lan': '',
        'mcin2att': '',
        'mcin2ex': '',
        'mcin2vis': '',
        'impnomci': '',
        'amylpet': '',
        'amylcsf': '',
        'fdgad': '',
        'hippatr': '',
        'taupetad': '',
        'csftau': '',
        'fdgftld': '',
        'tpetftld': '',
        'mrftld': '',
        'datscan': '',
        'othbiom': '',
        'othbiomx': '',
        'imaglinf': '',
        'imaglac': '',
        'imagmach': '',
        'imagmich': '',
        'imagmwmh': '',
        'imagewmh': '',
        'admut': '',
        'ftldmut': '',
        'othmut': '',
        'othmutx': '',
        'alzdis': '',
        'alzdisif': '',
        'lbdis': '',
        'lbdif': '',
        'park': '',
        'msa': '',
        'msaif': '',
        'psp': '',
        'pspif': '',
        'cort': '',
        'cortif': '',
        'ftldmo': '',
        'ftldmoif': '',
        'ftldnos': '',
        'ftldnoif': '',
        'ftldsubt': '',
        'ftldsubx': '',
        'cvd': '',
        'cvdif': '',
        'prevstk': '',
        'strokdec': '',
        'stkimag': '',
        'infnetw': '',
        'infwmh': '',
        'esstrem': '',
        'esstreif': '',
        'downs': '',
        'downsif': '',
        'hunt': '',
        'huntif': '',
        'prion': '',
        'prionif': '',
        'brninj': '',
        'brninjif': '',
        'brnincte': '',
        'hyceph': '',
        'hycephif': '',
        'epilep': '',
        'epilepif': '',
        'neop': '',
        'neopif': '',
        'neopstat': '',
        'hiv': '',
        'hivif': '',
        'othcog': '',
        'othcogif': '',
        'othcogx': '',
        'dep': '',
        'depif': '',
        'deptreat': '',
        'bipoldx': '',
        'bipoldif': '',
        'schizop': '',
        'schizoif': '',
        'anxiet': '',
        'anxietif': '',
        'delir': '',
        'delirif': '',
        'ptsddx': '',
        'ptsddxif': '',
        'othpsy': '',
        'othpsyif': '',
        'othpsyx': '',
        'alcdem': '',
        'alcdemif': '',
        'alcabuse': '',
        'impsub': '',
        'impsubif': '',
        'dysill': '',
        'dysillif': '',
        'meds': '',
        'medsif': '',
        'cogoth': '',
        'cogothif': '',
        'cogothx': '',
        'cogoth2': '',
        'cogoth2f': '',
        'cogoth2x': '',
        'cogoth3': '',
        'cogoth3f': '',
        'cogoth3x': '',
        'cancer': '',
        'cancsite': '',
        'diabet': '',
        'myoinf': '',
        'conghrt': '',
        'afibrill': '',
        'hypert': '',
        'angina': '',
        'hypchol': '',
        'vb12def': '',
        'thydis': '',
        'arth': '',
        'artype': '',
        'artypex': '',
        'artupex': '',
        'artloex': '',
        'artspin': '',
        'artunkn': '',
        'urineinc': '',
        'bowlinc': '',
        'sleepap': '',
        'remdis': '',
        'hyposom': '',
        'sleepoth': '',
        'sleepotx': '',
        'angiocp': '',
        'angiopci': '',
        'pacemake': '',
        'hvalve': '',
        'antienc': '',
        'antiencx': '',
        'othcond': '',
        'othcondx': '1',
    }


def make_blank_fvp():
    return {
        'ptid': '1',
        'adcid': '2',
        'visitmo': '1',
        'visitday': '1',
        'visityr': '2017',
        'visitnum': '3',
        'initials': '',
        # Z1X
        'fu_langa1': '',
        'fu_langa2': '',
        'fu_a2sub': '',
        'fu_a2not': '',
        'fu_langa3': '',
        'fu_a3sub': '',
        'fu_a3not': '',
        'fu_langa4': '',
        'fu_a4sub': '',
        'fu_a4not': '',
        'fu_langb1': '',
        'fu_b1sub': '',
        'fu_b1not': '',
        'fu_langb4': '',
        'fu_langb5': '',
        'fu_b5sub': '',
        'fu_b5not': '',
        'fu_langb6': '',
        'fu_b6sub': '',
        'fu_b6not': '',
        'fu_langb7': '',
        'fu_b7sub': '',
        'fu_b7not': '',
        'fu_langb8': '',
        'fu_langb9': '',
        'fu_langc2': '',
        'fu_langd1': '',
        'fu_langd2': '',
        'fu_langa3a': '',
        'fu_ftda3afs': '',
        'fu_ftda3afr': '',
        'fu_langb3f': '',
        'fu_langb9f': '',
        'fu_langc1f': '',
        'fu_langc2f': '',
        'fu_langc3f': '',
        'fu_langc4f': '',
        'fu_ftdc4fs': '',
        'fu_ftdc4fr': '',
        'fu_ftdc5fs': '',
        'fu_ftdc5fr': '',
        'fu_ftdc6fs': '',
        'fu_ftdc6fr': '',
        'fu_lange2f': '',
        'fu_lange3f': '',
        'fu_langcls': '',
        'fu_clssub': '',
        'fvp_z1x_complete': '2',
        'fu_birthmo': '',
        'fu_birthyr': '',
        'fu_maristat': '',
        'fu_sex': '',
        'fu_livsitua': '',
        'fu_independ': '',
        'fu_residenc': '',
        'fu_zip': '',
        'fu_memory': '',
        'fu_orient': '',
        'fu_judgment': '',
        'fu_commun': '',
        'fu_homehobb': '',
        'fu_perscare': '',
        'fu_cdrsum': '',
        'fu_cdrglob': '',
        'fu_comport': '',
        'fu_cdrlang': '',
        'fu_normexam': '',
        'fu_parksign': '',
        'fu_resttrl': '',
        'fu_resttrr': '',
        'fu_slowingl': '',
        'fu_slowingr': '',
        'fu_rigidl': '',
        'fu_rigidr': '',
        'fu_brady': '',
        'fu_parkgait': '',
        'fu_postinst': '',
        'fu_cvdsigns': '',
        'fu_cortdef': '',
        'fu_sivdfind': '',
        'fu_cvdmotl': '',
        'fu_cvdmotr': '',
        'fu_cortvisl': '',
        'fu_cortvisr': '',
        'fu_somatl': '',
        'fu_somatr': '',
        'fu_postcort': '',
        'fu_pspcbs': '',
        'fu_eyepsp': '',
        'fu_dyspsp': '',
        'fu_axialpsp': '',
        'fu_gaitpsp': '',
        'fu_apraxsp': '',
        'fu_apraxl': '',
        'fu_apraxr': '',
        'fu_cortsenl': '',
        'fu_cortsenr': '',
        'fu_ataxl': '',
        'fu_ataxr': '',
        'fu_alienlml': '',
        'fu_alienlmr': '',
        'fu_dystonl': '',
        'fu_dystonr': '',
        'fu_myocllt': '',
        'fu_myoclrt': '',
        'fu_alsfind': '',
        'fu_gaitnph': '',
        'fu_othneur': '',
        'fu_othneurx': '',
        'fu_decsub': '',
        'fu_decin': '',
        'fu_decclcog': '',
        'fu_cogmem': '',
        'fu_cogori': '',
        'fu_cogjudg': '',
        'fu_coglang': '',
        'fu_cogvis': '',
        'fu_cogattn': '',
        'fu_cogfluc': '',
        'fu_cogflago': '',
        'fu_cogothr': '',
        'fu_cogothrx': '',
        'fu_cogfpred': '',
        'fu_cogfprex': '',
        'fu_cogmode': '',
        'fu_cogmodex': '',
        'fu_decage': '',
        'fu_decclbe': '',
        'fu_beapathy': '',
        'fu_bedep': '',
        'fu_bevhall': '',
        'fu_bevwell': '',
        'fu_bevhago': '',
        'fu_beahall': '',
        'fu_bedel': '',
        'fu_bedisin': '',
        'fu_beirrit': '',
        'fu_beagit': '',
        'fu_beperch': '',
        'fu_berem': '',
        'fu_beremago': '',
        'fu_beanx': '',
        'fu_beothr': '',
        'fu_beothrx': '',
        'fu_befpred': '',
        'fu_befpredx': '',
        'fu_bemode': '',
        'fu_bemodex': '',
        'fu_beage': '',
        'fu_decclmot': '',
        'fu_mogait': '',
        'fu_mofalls': '',
        'fu_motrem': '',
        'fu_moslow': '',
        'fu_mofrst': '',
        'fu_momode': '',
        'fu_momodex': '',
        'fu_momopark': '',
        'fu_parkage': '',
        'fu_momoals': '',
        'fu_alsage': '',
        'fu_moage': '',
        'fu_course': '',
        'fu_frstchg': '',
        'fu_lbdeval': '',
        'fu_ftldeval': '',
        'fu_mocacomp': '',
        'fu_mocareas': '',
        'fu_mocaloc': '',
        'fu_mocalan': '',
        'fu_mocalanx': '',
        'fu_mocavis': '',
        'fu_mocahear': '',
        'fu_mocatots': '',
        'fu_mocatrai': '',
        'fu_mocacube': '',
        'fu_mocacloc': '',
        'fu_mocaclon': '',
        'fu_mocacloh': '',
        'fu_mocanami': '',
        'fu_mocaregi': '',
        'fu_mocadigi': '',
        'fu_mocalett': '',
        'fu_mocaser7': '',
        'fu_mocarepe': '',
        'fu_mocaflue': '',
        'fu_mocaabst': '',
        'fu_mocarecn': '',
        'fu_mocarecc': '',
        'fu_mocarecr': '',
        'fu_mocaordt': '',
        'fu_mocaormo': '',
        'fu_mocaoryr': '',
        'fu_mocaordy': '',
        'fu_mocaorpl': '',
        'fu_mocaorct': '',
        'fu_npsycloc_c2': '',
        'fu_npsylan_c2': '',
        'fu_npsylanx_c2': '',
        'fu_craftvrs': '',
        'fu_crafturs': '',
        'fu_udsbentc': '',
        'fu_digforct': '',
        'fu_digforsl': '',
        'fu_digbacct': '',
        'fu_digbacls': '',
        'fu_animals_c2': '',
        'fu_veg_c2': '',
        'fu_traila_c2': '',
        'fu_trailarr_c2': '',
        'fu_trailali_c2': '',
        'fu_trailb_c2': '',
        'fu_trailbrr_c2': '',
        'fu_trailbli_c2': '',
        'fu_craftdvr': '',
        'fu_craftdre': '',
        'fu_craftdti': '',
        'fu_craftcue': '',
        'fu_udsbentd': '',
        'fu_udsbenrs': '',
        'fu_minttots': '',
        'fu_minttotw': '',
        'fu_mintscng': '',
        'fu_mintscnc': '',
        'fu_mintpcng': '',
        'fu_mintpcnc': '',
        'fu_udsverfc': '',
        'fu_udsverfn': '',
        'fu_udsvernf': '',
        'fu_udsverlc': '',
        'fu_udsverlr': '',
        'fu_udsverln': '',
        'fu_udsvertn': '',
        'fu_udsverte': '',
        'fu_udsverti': '',
        'fu_cogstat_c2': '',
        'fu_dxmethod': '',
        'fu_normcog': '',
        'fu_demented': '',
        'fu_amndem': '',
        'fu_pca': '',
        'fu_ppasyn': '',
        'fu_ppasynt': '',
        'fu_ftdsyn': '',
        'fu_lbdsyn': '',
        'fu_namndem': '',
        'fu_mciamem': '',
        'fu_mciaplus': '',
        'fu_mciaplan': '',
        'fu_mciapatt': '',
        'fu_mciapex': '',
        'fu_mciapvis': '',
        'fu_mcinon1': '',
        'fu_mcin1lan': '',
        'fu_mcin1att': '',
        'fu_mcin1ex': '',
        'fu_mcin1vis': '',
        'fu_mcinon2': '',
        'fu_mcin2lan': '',
        'fu_mcin2att': '',
        'fu_mcin2ex': '',
        'fu_mcin2vis': '',
        'fu_impnomci': '',
        'fu_amylpet': '',
        'fu_amylcsf': '',
        'fu_fdgad': '',
        'fu_hippatr': '',
        'fu_taupetad': '',
        'fu_csftau': '',
        'fu_fdgftld': '',
        'fu_tpetftld': '',
        'fu_mrftld': '',
        'fu_datscan': '',
        'fu_othbiom': '',
        'fu_othbiomx': '',
        'fu_imaglinf': '',
        'fu_imaglac': '',
        'fu_imagmach': '',
        'fu_imagmich': '',
        'fu_imagmwmh': '',
        'fu_imagewmh': '',
        'fu_admut': '',
        'fu_ftldmut': '',
        'fu_othmut': '',
        'fu_othmutx': '',
        'fu_alzdis': '',
        'fu_alzdisif': '',
        'fu_lbdis': '',
        'fu_lbdif': '',
        'fu_park': '',
        'fu_msa': '',
        'fu_msaif': '',
        'fu_psp': '',
        'fu_pspif': '',
        'fu_cort': '',
        'fu_cortif': '',
        'fu_ftldmo': '',
        'fu_ftldmoif': '',
        'fu_ftldnos': '',
        'fu_ftldnoif': '',
        'fu_ftldsubt': '',
        'fu_ftldsubx': '',
        'fu_cvd': '',
        'fu_cvdif': '',
        'fu_prevstk': '',
        'fu_strokdec': '',
        'fu_stkimag': '',
        'fu_infnetw': '',
        'fu_infwmh': '',
        'fu_esstrem': '',
        'fu_esstreif': '',
        'fu_downs': '',
        'fu_downsif': '',
        'fu_hunt': '',
        'fu_huntif': '',
        'fu_prion': '',
        'fu_prionif': '',
        'fu_brninj': '',
        'fu_brninjif': '',
        'fu_brnincte': '',
        'fu_hyceph': '',
        'fu_hycephif': '',
        'fu_epilep': '',
        'fu_epilepif': '',
        'fu_neop': '',
        'fu_neopif': '',
        'fu_neopstat': '',
        'fu_hiv': '',
        'fu_hivif': '',
        'fu_othcog': '',
        'fu_othcogif': '',
        'fu_othcogx': '',
        'fu_dep': '',
        'fu_depif': '',
        'fu_deptreat': '',
        'fu_bipoldx': '',
        'fu_bipoldif': '',
        'fu_schizop': '',
        'fu_schizoif': '',
        'fu_anxiet': '',
        'fu_anxietif': '',
        'fu_delir': '',
        'fu_delirif': '',
        'fu_ptsddx': '',
        'fu_ptsddxif': '',
        'fu_othpsy': '',
        'fu_othpsyif': '',
        'fu_othpsyx': '',
        'fu_alcdem': '',
        'fu_alcdemif': '',
        'fu_alcabuse': '',
        'fu_impsub': '',
        'fu_impsubif': '',
        'fu_dysill': '',
        'fu_dysillif': '',
        'fu_meds': '',
        'fu_medsif': '',
        'fu_cogoth': '',
        'fu_cogothif': '',
        'fu_cogothx': '',
        'fu_cogoth2': '',
        'fu_cogoth2f': '',
        'fu_cogoth2x': '',
        'fu_cogoth3': '',
        'fu_cogoth3f': '',
        'fu_cogoth3x': '',
        'fu_cancer': '',
        'fu_cancsite': '',
        'fu_diabet': '',
        'fu_myoinf': '',
        'fu_conghrt': '',
        'fu_afibrill': '',
        'fu_hypert': '',
        'fu_angina': '',
        'fu_hypchol': '',
        'fu_vb12def': '',
        'fu_thydis': '',
        'fu_arth': '',
        'fu_artype': '',
        'fu_artypex': '',
        'fu_artupex': '',
        'fu_artloex': '',
        'fu_artspin': '',
        'fu_artunkn': '',
        'fu_urineinc': '',
        'fu_bowlinc': '',
        'fu_sleepap': '',
        'fu_remdis': '',
        'fu_hyposom': '',
        'fu_sleepoth': '',
        'fu_sleepotx': '',
        'fu_angiocp': '',
        'fu_angiopci': '',
        'fu_pacemake': '',
        'fu_hvalve': '',
        'fu_antienc': '',
        'fu_antiencx': '',
        'fu_othcond': '',
        'fu_othcondx': '1',
    }


if __name__ == "__main__":
    unittest.main()
