import unittest

from nacc.ftld.ivp import builder as ivp_builder
from nacc.ftld.fvp import builder as fvp_builder


class TestUDSFormSkip(unittest.TestCase):

    def test_a3a_ivp_skip(self):
        """ If the IVP A3a is not present in the csv, it should be skipped
        without throwing an error """
        record = make_blank_ivp()
        record['ftda3afs'] = '1'

        expected = record['ftdothis']
        result = ivp_builder.build_ftld_ivp_form(record)
        self.assertEqual(expected, result['FTDOTHIS'])

    def test_a3a_fvp_skip(self):
        """ If the FVP A3a is not present in the csv, it should be skipped
        without throwing an error """
        record = make_blank_fvp()
        record['fu_ftda3afs'] = '1'

        expected = record['fu_ftdothis']
        result = fvp_builder.build_ftld_fvp_form(record)
        self.assertEqual(expected, result['FTDOTHIS'])

    def test_ivp_b3f_not_skipped(self):
        """ Form B3F is required and should never be skipped. """
        record = make_blank_ivp()
        record['langb3f'] = ''
        record['ftdltfas'] = '1'

        expected = record['ftdltfas']
        result = ivp_builder.build_ftld_ivp_form(record)
        self.assertEqual(expected, result['FTDLTFAS'])

    def test_fvp_b3f_not_skipped(self):
        """ Same for FVP. """
        record = make_blank_fvp()
        record['fu_langb3f'] = ''
        record['fu_ftdltfas'] = '1'

        expected = record['fu_ftdltfas']
        result = fvp_builder.build_ftld_fvp_form(record)
        self.assertEqual(expected, result['FTDLTFAS'])


def make_blank_ivp():
    return {
        'ptid': '1',
        'adcid': '2',
        'visitmo': '1',
        'visitday': '1',
        'visityr': '2017',
        'visitnum': '3',
        'initials': '',
        # Z1X
        'langa1': '',
        'langa2': '',
        'a2sub': '',
        'a2not': '',
        'langa3': '',
        'a3sub': '',
        'a3not': '',
        'langa4': '',
        'a4sub': '',
        'a4not': '',
        'langa5': '',
        'langb1': '',
        'b1sub': '',
        'b1not': '',
        'langb4': '',
        'langb5': '',
        'b5sub': '',
        'b5not': '',
        'langb6': '',
        'b6sub': '',
        'b6not': '',
        'langb7': '',
        'b7sub': '',
        'b7not': '',
        'langb8': '',
        'langb9': '',
        'langc2': '',
        'langd1': '',
        'langd2': '',
        'langa3a': '',
        'ftda3afs': '',
        'ftda3afr': '',
        'langb3f': '',
        'langb9f': '',
        'langc1f': '',
        'langc2f': '',
        'langc3f': '',
        'langc4f': '',
        'ftdc4fs': '',
        'ftdc4fr': '',
        'langc5f': '',
        'ftdc5fs': '',
        'ftdc5fr': '',
        'langc6f': '',
        'ftdc6fs': '',
        'ftdc6fr': '',
        'lange2f': '',
        'lange3f': '',
        'langcls': '',
        'clssub': '',
        'ivp_z1x_complete': '2',
        'ftdltfas': '',
        'ftdlimb': '',
        'ftdbulb': '',
        'ftdgsev': '',
        'ftdgsevx': '',
        'ftdgtyp': '',
        'ftdgtypg': '',
        'ftdgtypx': '',
        'ftdppasl': '',
        'ftdppapo': '',
        'ftdppaiw': '',
        'ftdppasw': '',
        'ftdppapk': '',
        'ftdppags': '',
        'ftdppaeh': '',
        'ftdppacs': '',
        'ftdppass': '',
        'ftdppasr': '',
        'ftdppasd': '',
        'ftdcppa': '',
        'ftdcppas': '',
        'ftdbvcln': '',
        'ftdbvdis': '',
        'ftdbvapa': '',
        'ftdbvlos': '',
        'ftdbvrit': '',
        'ftdbvhyp': '',
        'ftdbvneu': '',
        'ftdbvidl': '',
        'ftdbvft': '',
        'ftdemgpv': '',
        'ftdemgpy': '',
        'ftdemgmn': '',
        'ftdpabvf': '',
        'ftdworrc': '',
        'ftdworrs': '',
        'ftdworrr': '',
        'ftdworic': '',
        'ftdworis': '',
        'ftdworir': '',
        'ftdworip': '',
        'ftdsemmt': '',
        'ftdsemaa': '',
        'ftdsemta': '',
        'ftdsemsu': '',
        'ftdanasw': '',
        'ftdanaow': '',
        'ftdanats': '',
        'ftdsenas': '',
        'ftdsenos': '',
        'ftdsensr': '',
        'ftdsenpr': '',
        'ftdnounc': '',
        'ftdverbc': '',
        'ftdratio': '',
        'ftdreaas': '',
        'ftdreaos': '',
        'ftdreasr': '',
        'ftdreapr': '',
        'ftdcpc2f': '',
        'ftdhaird': '',
        'ftdspit': '',
        'ftdnose': '',
        'ftdcoage': '',
        'ftdcry': '',
        'ftdcut': '',
        'ftdytrip': '',
        'ftdeatp': '',
        'ftdtella': '',
        'ftdopin': '',
        'ftdlaugh': '',
        'ftdshirt': '',
        'ftdkeepm': '',
        'ftdpickn': '',
        'ftdover': '',
        'ftdeatr': '',
        'ftdhairl': '',
        'ftdshirw': '',
        'ftdmove': '',
        'ftdhugs': '',
        'ftdloud': '',
        'ftdlost': '',
        'ftdsntot': '',
        'ftdsntbs': '',
        'ftdsntos': '',
        'ftdsnrat': '',
        'ftdself': '',
        'ftdbadly': '',
        'ftddepr': '',
        'ftdemotd': '',
        'ftdlself': '',
        'ftddisr': '',
        'ftdbelch': '',
        'ftdgigg': '',
        'ftdpriv': '',
        'ftdnegat': '',
        'ftdecomm': '',
        'ftdinapj': '',
        'ftdfaila': '',
        'ftdresis': '',
        'ftdinter': '',
        'ftdverba': '',
        'ftdphysi': '',
        'ftdtopic': '',
        'ftdproto': '',
        'ftdpreo': '',
        'ftdfini': '',
        'ftdacted': '',
        'ftdabs': '',
        'ftdfeedb': '',
        'ftdfrust': '',
        'ftdanxi': '',
        'ftdnervo': '',
        'ftdndiag': '',
        'ftdstimb': '',
        'ftdstime': '',
        'ftdobjec': '',
        'ftdcircu': '',
        'ftdperse': '',
        'ftdrepea': '',
        'ftdanecd': '',
        'ftddinit': '',
        'ftddelay': '',
        'ftdaddve': '',
        'ftdfluct': '',
        'ftdlostt': '',
        'ftdrepru': '',
        'ftdtrain': '',
        'ftddiscl': '',
        'ftdspont': '',
        'ftdsponr': '',
        'ftdstood': '',
        'ftdtouch': '',
        'ftddsoci': '',
        'ftdexagg': '',
        'ftdsbtot': '',
        'ftdsbcto': '',
        'ftdlengt': '',
        'ftdsmri': '',
        'ftdsmmo': '',
        'ftdsmdy': '',
        'ftdsmyr': '',
        'ftdsmdic': '',
        'ftdsmdis': '',
        'ftdsmadn': '',
        'ftdsmadv': '',
        'ftdsmman': '',
        'ftdsmmao': '',
        'ftdsmmam': '',
        'ftdsmfs': '',
        'ftdsmfso': '',
        'ftdsmqu': '',
        'ftdfdgpt': '',
        'ftdfpmo': '',
        'ftdfpdy': '',
        'ftdfpyr': '',
        'ftdfddic': '',
        'ftdfddid': '',
        'ftdfdadn': '',
        'ftdfdadv': '',
        'ftdfdman': '',
        'ftdfdmao': '',
        'ftdfdmam': '',
        'ftdfdqu': '',
        'ftdamypt': '',
        'ftdammo': '',
        'ftdamdy': '',
        'ftdamyr': '',
        'ftdamdic': '',
        'ftdamdid': '',
        'ftdamlig': '',
        'ftdamlio': '',
        'ftdamadn': '',
        'ftdamadv': '',
        'ftdamman': '',
        'ftdammao': '',
        'ftdammam': '',
        'ftdamqu': '',
        'ftdother': '',
        'ftdotdop': '',
        'ftdotser': '',
        'ftdotcho': '',
        'ftdotano': '',
        'ftdotans': '',
        'ftdidiag': '',
        'ftdsmrio': '',
        'ftdmrifa': '',
        'ftdmrirf': '',
        'ftdmrilf': '',
        'ftdmrirt': '',
        'ftdmrilt': '',
        'ftdmrirm': '',
        'ftdmrilm': '',
        'ftdmrirp': '',
        'ftdmrilp': '',
        'ftdmrirb': '',
        'ftdmrilb': '',
        'ftdmriob': '',
        'ftdmrios': '',
        'ftdfdgpe': '',
        'ftdfdgfh': '',
        'ftdfdgrf': '',
        'ftdfdglf': '',
        'ftdfdgrt': '',
        'ftdfdglt': '',
        'ftdfdgrm': '',
        'ftdfdglm': '',
        'ftdfdgrp': '',
        'ftdfdglp': '',
        'ftdfdgrb': '',
        'ftdfdglb': '',
        'ftdfdgoa': '',
        'ftdfdgos': '',
        'ftdamyp': '',
        'ftdamyvi': '',
        'ftdamyrf': '',
        'ftdamylf': '',
        'ftdamyrt': '',
        'ftdamylt': '',
        'ftdamyrm': '',
        'ftdamylm': '',
        'ftdamyrp': '',
        'ftdamylp': '',
        'ftdamyrb': '',
        'ftdamylb': '',
        'ftdamyoa': '',
        'ftdamyos': '',
        'ftdcbfsp': '',
        'ftdcbfvi': '',
        'ftdcbfrf': '',
        'ftdcbflf': '',
        'ftdcbfrt': '',
        'ftdcbflt': '',
        'ftdcbfrm': '',
        'ftdcbflm': '',
        'ftdcbfrp': '',
        'ftdcbflp': '',
        'ftdcbfrb': '',
        'ftdcbflb': '',
        'ftdcbfoa': '',
        'ftdcbfos': '',
        'ftdothi': '',
        'ftdothis': '',
    }


def make_blank_fvp():
    return {
        'ptid': '1',
        'adcid': '2',
        'visitmo': '1',
        'visitday': '1',
        'visityr': '2017',
        'visitnum': '3',
        'initials': '',
        # Z1X
        'fu_langa1': '',
        'fu_langa2': '',
        'fu_a2sub': '',
        'fu_a2not': '',
        'fu_langa3': '',
        'fu_a3sub': '',
        'fu_a3not': '',
        'fu_langa4': '',
        'fu_a4sub': '',
        'fu_a4not': '',
        'fu_langb1': '',
        'fu_b1sub': '',
        'fu_b1not': '',
        'fu_langb4': '',
        'fu_langb5': '',
        'fu_b5sub': '',
        'fu_b5not': '',
        'fu_langb6': '',
        'fu_b6sub': '',
        'fu_b6not': '',
        'fu_langb7': '',
        'fu_b7sub': '',
        'fu_b7not': '',
        'fu_langb8': '',
        'fu_langb9': '',
        'fu_langc2': '',
        'fu_langd1': '',
        'fu_langd2': '',
        'fu_langa3a': '',
        'fu_ftda3afs': '',
        'fu_ftda3afr': '',
        'fu_langb3f': '',
        'fu_langb9f': '',
        'fu_langc1f': '',
        'fu_langc2f': '',
        'fu_langc3f': '',
        'fu_langc4f': '',
        'fu_ftdc4fs': '',
        'fu_ftdc4fr': '',
        'fu_langc5f': '',
        'fu_ftdc5fs': '',
        'fu_ftdc5fr': '',
        'fu_langc6f': '',
        'fu_ftdc6fs': '',
        'fu_ftdc6fr': '',
        'fu_lange2f': '',
        'fu_lange3f': '',
        'fu_langcls': '',
        'fu_clssub': '',
        'fvp_z1x_complete': '2',
        'fu_ftdltfas': '',
        'fu_ftdlimb': '',
        'fu_ftdbulb': '',
        'fu_ftdgsev': '',
        'fu_ftdgsevx': '',
        'fu_ftdgtyp': '',
        'fu_ftdgtypg': '',
        'fu_ftdgtypx': '',
        'fu_ftdppasl': '',
        'fu_ftdppapo': '',
        'fu_ftdppaiw': '',
        'fu_ftdppasw': '',
        'fu_ftdppapk': '',
        'fu_ftdppags': '',
        'fu_ftdppaeh': '',
        'fu_ftdppacs': '',
        'fu_ftdppass': '',
        'fu_ftdppasr': '',
        'fu_ftdppasd': '',
        'fu_ftdcppa': '',
        'fu_ftdcppas': '',
        'fu_ftdbvcln': '',
        'fu_ftdbvdis': '',
        'fu_ftdbvapa': '',
        'fu_ftdbvlos': '',
        'fu_ftdbvrit': '',
        'fu_ftdbvhyp': '',
        'fu_ftdbvneu': '',
        'fu_ftdbvidl': '',
        'fu_ftdbvft': '',
        'fu_ftdemgpv': '',
        'fu_ftdemgpy': '',
        'fu_ftdemgmn': '',
        'fu_ftdpabvf': '',
        'fu_ftdworrc': '',
        'fu_ftdworrs': '',
        'fu_ftdworrr': '',
        'fu_ftdworic': '',
        'fu_ftdworis': '',
        'fu_ftdworir': '',
        'fu_ftdworip': '',
        'fu_ftdsemmt': '',
        'fu_ftdsemaa': '',
        'fu_ftdsemta': '',
        'fu_ftdsemsu': '',
        'fu_ftdanasw': '',
        'fu_ftdanaow': '',
        'fu_ftdanats': '',
        'fu_ftdsenas': '',
        'fu_ftdsenos': '',
        'fu_ftdsensr': '',
        'fu_ftdsenpr': '',
        'fu_ftdnounc': '',
        'fu_ftdverbc': '',
        'fu_ftdratio': '',
        'fu_ftdreaas': '',
        'fu_ftdreaos': '',
        'fu_ftdreasr': '',
        'fu_ftdreapr': '',
        'fu_ftdcpc2f': '',
        'fu_ftdhaird': '',
        'fu_ftdspit': '',
        'fu_ftdnose': '',
        'fu_ftdcoage': '',
        'fu_ftdcry': '',
        'fu_ftdcut': '',
        'fu_ftdytrip': '',
        'fu_ftdeatp': '',
        'fu_ftdtella': '',
        'fu_ftdopin': '',
        'fu_ftdlaugh': '',
        'fu_ftdshirt': '',
        'fu_ftdkeepm': '',
        'fu_ftdpickn': '',
        'fu_ftdover': '',
        'fu_ftdeatr': '',
        'fu_ftdhairl': '',
        'fu_ftdshirw': '',
        'fu_ftdmove': '',
        'fu_ftdhugs': '',
        'fu_ftdloud': '',
        'fu_ftdlost': '',
        'fu_ftdsntot': '',
        'fu_ftdsntbs': '',
        'fu_ftdsntos': '',
        'fu_ftdsnrat': '',
        'fu_ftdself': '',
        'fu_ftdbadly': '',
        'fu_ftddepr': '',
        'fu_ftdemotd': '',
        'fu_ftdlself': '',
        'fu_ftddisr': '',
        'fu_ftdbelch': '',
        'fu_ftdgigg': '',
        'fu_ftdpriv': '',
        'fu_ftdnegat': '',
        'fu_ftdecomm': '',
        'fu_ftdinapj': '',
        'fu_ftdfaila': '',
        'fu_ftdresis': '',
        'fu_ftdinter': '',
        'fu_ftdverba': '',
        'fu_ftdphysi': '',
        'fu_ftdtopic': '',
        'fu_ftdproto': '',
        'fu_ftdpreo': '',
        'fu_ftdfini': '',
        'fu_ftdacted': '',
        'fu_ftdabs': '',
        'fu_ftdfeedb': '',
        'fu_ftdfrust': '',
        'fu_ftdanxi': '',
        'fu_ftdnervo': '',
        'fu_ftdndiag': '',
        'fu_ftdstimb': '',
        'fu_ftdstime': '',
        'fu_ftdobjec': '',
        'fu_ftdcircu': '',
        'fu_ftdperse': '',
        'fu_ftdrepea': '',
        'fu_ftdanecd': '',
        'fu_ftddinit': '',
        'fu_ftddelay': '',
        'fu_ftdaddve': '',
        'fu_ftdfluct': '',
        'fu_ftdlostt': '',
        'fu_ftdrepru': '',
        'fu_ftdtrain': '',
        'fu_ftddiscl': '',
        'fu_ftdspont': '',
        'fu_ftdsponr': '',
        'fu_ftdstood': '',
        'fu_ftdtouch': '',
        'fu_ftddsoci': '',
        'fu_ftdexagg': '',
        'fu_ftdsbtot': '',
        'fu_ftdsbcto': '',
        'fu_ftdlengt': '',
        'fu_ftdsmri': '',
        'fu_ftdsmmo': '',
        'fu_ftdsmdy': '',
        'fu_ftdsmyr': '',
        'fu_ftdsmdic': '',
        'fu_ftdsmdis': '',
        'fu_ftdsmadn': '',
        'fu_ftdsmadv': '',
        'fu_ftdsmman': '',
        'fu_ftdsmmao': '',
        'fu_ftdsmmam': '',
        'fu_ftdsmfs': '',
        'fu_ftdsmfso': '',
        'fu_ftdsmqu': '',
        'fu_ftdfdgpt': '',
        'fu_ftdfpmo': '',
        'fu_ftdfpdy': '',
        'fu_ftdfpyr': '',
        'fu_ftdfddic': '',
        'fu_ftdfddid': '',
        'fu_ftdfdadn': '',
        'fu_ftdfdadv': '',
        'fu_ftdfdman': '',
        'fu_ftdfdmao': '',
        'fu_ftdfdmam': '',
        'fu_ftdfdqu': '',
        'fu_ftdamypt': '',
        'fu_ftdammo': '',
        'fu_ftdamdy': '',
        'fu_ftdamyr': '',
        'fu_ftdamdic': '',
        'fu_ftdamdid': '',
        'fu_ftdamlig': '',
        'fu_ftdamlio': '',
        'fu_ftdamadn': '',
        'fu_ftdamadv': '',
        'fu_ftdamman': '',
        'fu_ftdammao': '',
        'fu_ftdammam': '',
        'fu_ftdamqu': '',
        'fu_ftdother': '',
        'fu_ftdotdop': '',
        'fu_ftdotser': '',
        'fu_ftdotcho': '',
        'fu_ftdotano': '',
        'fu_ftdotans': '',
        'fu_ftdidiag': '',
        'fu_ftdsmrio': '',
        'fu_ftdmrifa': '',
        'fu_ftdmrirf': '',
        'fu_ftdmrilf': '',
        'fu_ftdmrirt': '',
        'fu_ftdmrilt': '',
        'fu_ftdmrirm': '',
        'fu_ftdmrilm': '',
        'fu_ftdmrirp': '',
        'fu_ftdmrilp': '',
        'fu_ftdmrirb': '',
        'fu_ftdmrilb': '',
        'fu_ftdmriob': '',
        'fu_ftdmrios': '',
        'fu_ftdfdgpe': '',
        'fu_ftdfdgfh': '',
        'fu_ftdfdgrf': '',
        'fu_ftdfdglf': '',
        'fu_ftdfdgrt': '',
        'fu_ftdfdglt': '',
        'fu_ftdfdgrm': '',
        'fu_ftdfdglm': '',
        'fu_ftdfdgrp': '',
        'fu_ftdfdglp': '',
        'fu_ftdfdgrb': '',
        'fu_ftdfdglb': '',
        'fu_ftdfdgoa': '',
        'fu_ftdfdgos': '',
        'fu_ftdamyp': '',
        'fu_ftdamyvi': '',
        'fu_ftdamyrf': '',
        'fu_ftdamylf': '',
        'fu_ftdamyrt': '',
        'fu_ftdamylt': '',
        'fu_ftdamyrm': '',
        'fu_ftdamylm': '',
        'fu_ftdamyrp': '',
        'fu_ftdamylp': '',
        'fu_ftdamyrb': '',
        'fu_ftdamylb': '',
        'fu_ftdamyoa': '',
        'fu_ftdamyos': '',
        'fu_ftdcbfsp': '',
        'fu_ftdcbfvi': '',
        'fu_ftdcbfrf': '',
        'fu_ftdcbflf': '',
        'fu_ftdcbfrt': '',
        'fu_ftdcbflt': '',
        'fu_ftdcbfrm': '',
        'fu_ftdcbflm': '',
        'fu_ftdcbfrp': '',
        'fu_ftdcbflp': '',
        'fu_ftdcbfrb': '',
        'fu_ftdcbflb': '',
        'fu_ftdcbfoa': '',
        'fu_ftdcbfos': '',
        'fu_ftdothi': '',
        'fu_ftdothis': '',
    }


if __name__ == "__main__":
    unittest.main()
