###############################################################################
# Copyright 2015-2023 University of Florida. All rights reserved.
# This file is part of UF CTS-IT's NACCulator project.
# Use of this source code is governed by the license found in the LICENSE file.
###############################################################################

import nacc.uds3

### BEGIN non-generated code
# WARNING: When generating new forms, do not overwrite this section
from datetime import date

# WARNING: When generating new forms, use CURRENT_YEAR instead of "2014"
# WARNING: When generating new forms, use CURRENT_YEAR-15 instead of "1999"
CURRENT_YEAR = date.today().year

### END non-generated code

# This packet is for TFP (Telephone Followup) forms


def header_fields():
    """
    Generates the header info that appears in columns 1-43 of every form
    """
    fields = {}
    fields['PACKET'] = nacc.uds3.Field(name='PACKET', typename='Char', position=(1, 2), length=2, inclusive_range=None, allowable_values=[], blanks=[])
    fields['FORMID'] = nacc.uds3.Field(name='FORMID', typename='Char', position=(4, 6), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    fields['FORMVER'] = nacc.uds3.Field(name='FORMVER', typename='Num', position=(8, 10), length=3, inclusive_range=(1, 4), allowable_values=[], blanks=[])
    fields['ADCID'] = nacc.uds3.Field(name='ADCID', typename='Num', position=(12, 13), length=2, inclusive_range=(2, 99), allowable_values=[], blanks=[])
    fields['PTID'] = nacc.uds3.Field(name='PTID', typename='Char', position=(15, 24), length=10, inclusive_range=None, allowable_values=[], blanks=[])
    fields['VISITMO'] = nacc.uds3.Field(name='VISITMO', typename='Num', position=(26, 27), length=2, inclusive_range=(1, 12), allowable_values=[], blanks=[])
    fields['VISITDAY'] = nacc.uds3.Field(name='VISITDAY', typename='Num', position=(29, 30), length=2, inclusive_range=(1, 31), allowable_values=[], blanks=[])
    fields['VISITYR'] = nacc.uds3.Field(name='VISITYR', typename='Num', position=(32, 35), length=4, inclusive_range=(2005, CURRENT_YEAR), allowable_values=[], blanks=[])
    fields['VISITNUM'] = nacc.uds3.Field(name='VISITNUM', typename='Char', position=(37, 39), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    fields['INITIALS'] = nacc.uds3.Field(name='INITIALS', typename='Char', position=(41, 43), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    return fields


class FormT1(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['TELCOG'] = nacc.uds3.Field(name='TELCOG', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['TELILL'] = nacc.uds3.Field(name='TELILL', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['TELHOME'] = nacc.uds3.Field(name='TELHOME', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['TELREFU'] = nacc.uds3.Field(name='TELREFU', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['TELOTHR'] = nacc.uds3.Field(name='TELOTHR', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['TELOTHRX'] = nacc.uds3.Field(name='TELOTHRX', typename='Char', position=(55, 114), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1e TELOTHR ne 1 (Yes)'])
        self.fields['TELINPER'] = nacc.uds3.Field(name='TELINPER', typename='Num', position=(116, 116), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['TELMILE'] = nacc.uds3.Field(name='TELMILE', typename='Num', position=(118, 118), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 2 TELINPER = 0 (No)', 'Blank if Question 2 TELINPER = 9 (Unknown) and this is first telephone packet'])


class FormA1(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['BIRTHMO'] = nacc.uds3.Field(name='BIRTHMO', typename='Num', position=(45, 46), length=2, inclusive_range=(1, 12), allowable_values=[], blanks=[])
        self.fields['BIRTHYR'] = nacc.uds3.Field(name='BIRTHYR', typename='Num', position=(48, 51), length=4, inclusive_range=(1875, CURRENT_YEAR - 15), allowable_values=[], blanks=[])
        self.fields['MARISTAT'] = nacc.uds3.Field(name='MARISTAT', typename='Num', position=(53, 53), length=1, inclusive_range=(1, 6), allowable_values=['9', '3', '2', '1', '6', '5', '4'], blanks=[])
        self.fields['SEX'] = nacc.uds3.Field(name='SEX', typename='Num', position=(55, 55), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=[])
        self.fields['LIVSITUA'] = nacc.uds3.Field(name='LIVSITUA', typename='Num', position=(57, 57), length=1, inclusive_range=(1, 6), allowable_values=['9', '3', '2', '1', '6', '5', '4'], blanks=[])
        self.fields['INDEPEND'] = nacc.uds3.Field(name='INDEPEND', typename='Num', position=(59, 59), length=1, inclusive_range=(1, 4), allowable_values=['9', '3', '2', '1', '4'], blanks=[])
        self.fields['RESIDENC'] = nacc.uds3.Field(name='RESIDENC', typename='Num', position=(61, 61), length=1, inclusive_range=(1, 4), allowable_values=['9', '3', '2', '1', '4'], blanks=[])
        self.fields['ZIP'] = nacc.uds3.Field(name='RESIDENC', typename='Char', position=(63, 65), length=1, inclusive_range=(6, 999), allowable_values=[], blanks=[])


class FormA2(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['INBIRMO'] = nacc.uds3.Field(name='INBIRMO', typename='Num', position=(45, 46), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=[])
        self.fields['INBIRYR'] = nacc.uds3.Field(name='INBIRYR', typename='Num', position=(48, 51), length=4, inclusive_range=(1875, CURRENT_YEAR - 15), allowable_values=['9999'], blanks=[])
        self.fields['INSEX'] = nacc.uds3.Field(name='INSEX', typename='Num', position=(53, 53), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['NEWINF'] = nacc.uds3.Field(name='NEWINF', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['INHISP'] = nacc.uds3.Field(name='INHISP', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 3 NEWINF = 0 (No)'])
        self.fields['INHISPOR'] = nacc.uds3.Field(name='INHISPOR', typename='Num', position=(59, 60), length=2, inclusive_range=(1, 6), allowable_values=['99', '50'], blanks=['Blank if Question 4 INHISP ne 1 (Yes)'])
        self.fields['INHISPOX'] = nacc.uds3.Field(name='INHISPOX', typename='Char', position=(62, 121), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 4a INHISPOR ne 50 (Other)'])
        self.fields['INRACE'] = nacc.uds3.Field(name='INRACE', typename='Num', position=(123, 124), length=2, inclusive_range=(1, 5), allowable_values=['50', '99'], blanks=['Blank if Question 3 NEWINF = 0 (No)'])
        self.fields['INRACEX'] = nacc.uds3.Field(name='INRACEX', typename='Char', position=(126, 185), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 5 INRACE ne 50 (Other)'])
        self.fields['INRASEC'] = nacc.uds3.Field(name='INRASEC', typename='Num', position=(187, 188), length=2, inclusive_range=(1, 5), allowable_values=['50', '88', '99'], blanks=['Blank if Question 3 NEWINF = 0 (No)'])
        self.fields['INRASECX'] = nacc.uds3.Field(name='INRASECX', typename='Char', position=(190, 249), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 6 INRASEC ne 50 (Other)'])
        self.fields['INRATER'] = nacc.uds3.Field(name='INRATER', typename='Num', position=(251, 252), length=2, inclusive_range=(1, 5), allowable_values=['50', '88', '99'], blanks=['Blank if Question 3 NEWINF = 0 (No)'])
        self.fields['INRATERX'] = nacc.uds3.Field(name='INRATERX', typename='Char', position=(254, 313), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 7 INRATER ne 50 (Other)'])
        self.fields['INEDUC'] = nacc.uds3.Field(name='INEDUC', typename='Num', position=(315, 316), length=2, inclusive_range=(0, 36), allowable_values=['99'], blanks=['Blank if Question 3 NEWINF = 0 (No)'])  # in Data Dictionary says from 0-3 but form is differnt.
        self.fields['INRELTO'] = nacc.uds3.Field(name='INRELTO', typename='Num', position=(318, 318), length=1, inclusive_range=(1, 6), allowable_values=[], blanks=[])
        self.fields['INKNOWN'] = nacc.uds3.Field(name='INKNOWN', typename='Num', position=(320, 322), length=3, inclusive_range=(0, 120), allowable_values=['999'], blanks=[])
        self.fields['INLIVWTH'] = nacc.uds3.Field(name='INLIVWTH', typename='Num', position=(324, 324), length=1, inclusive_range=(0, 1), allowable_values=[], blanks=[])
        self.fields['INVISITS'] = nacc.uds3.Field(name='INVISITS', typename='Num', position=(326, 326), length=1, inclusive_range=(1, 6), allowable_values=[], blanks=['Blank if Question 10 INLIVWTH = 1 (Yes)'])
        self.fields['INCALLS'] = nacc.uds3.Field(name='INCALLS', typename='Num', position=(328, 328), length=1, inclusive_range=(1, 6), allowable_values=[], blanks=['Blank if Question 10 INLIVWTH = 1 (Yes)'])
        self.fields['INRELY'] = nacc.uds3.Field(name='INRELY', typename='Num', position=(330, 330), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])


class FormA3(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['NWINFMUT'] = nacc.uds3.Field(name='NWINFMUT', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=[])
        self.fields['FADMUT'] = nacc.uds3.Field(name='FADMUT', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=['Blank if Question 1 NWINFMUT ne 1 (Yes)'])
        self.fields['FADMUTX'] = nacc.uds3.Field(name='FADMUTX', typename='Char', position=(49, 108), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 2a FADMUT ne 8 (Other)', 'Blank if Question 1 NWINFMUT ne 1 (Yes)'])
        self.fields['FADMUSO'] = nacc.uds3.Field(name='FADMUSO', typename='Num', position=(110, 110), length=1, inclusive_range=(1, 3), allowable_values=['8', '9'], blanks=['Blank if Question 2a FADMUT = 0 (No)', 'Blank if Question 2a FADMUT = 9 (Unknown)', 'Blank if Question 1 NWINFMUT ne 1 (Yes)'])
        self.fields['FADMUSOX'] = nacc.uds3.Field(name='FADMUSOX', typename='Char', position=(112, 171), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 2a FADMUT = 0 (No)', 'Blank if Question 2a = 9 (Unknown)', 'Blank if question 2b FADMUSO ne 8 (Other)', 'Blank if Question 1 NEWINFMUT ne 1 (Yes)'])
        self.fields['FFTDMUT'] = nacc.uds3.Field(name='FFTDMUT', typename='Num', position=(173, 173), length=1, inclusive_range=(0, 4), allowable_values=['8', '9'], blanks=['Blank if Question 1 NWINFMUT ne 1 (Yes)'])
        self.fields['FFTDMUTX'] = nacc.uds3.Field(name='FFTDMUTX', typename='Char', position=(175, 234), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3a FFTDMUT ne 8 (Other)', 'Blank if Question 1 NWINFMUT ne 1 (Yes)'])
        self.fields['FFTDMUSO'] = nacc.uds3.Field(name='FFTDMUSO', typename='Num', position=(236, 236), length=1, inclusive_range=(1, 3), allowable_values=['8', '9'], blanks=['Blank if Question 3a FFTDMUT = 0 (No)', 'Blank if Question 3a FFTDMUT = 9 (Unknown)', 'Blank if Question 1 NWINFMUT ne 1 (Yes)'])
        self.fields['FFTDMUSX'] = nacc.uds3.Field(name='FFTDMUSX', typename='Char', position=(238, 297), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3a FFTDMUT = 0 (No)', 'Blank if Question 3a FFTDMUT = 9 (Unknown)', 'Blank if Question 3b FFTDMUSO ne 8 (Other)', 'Blank if Question 1 NWINFMUT ne 1 (Yes)'])
        self.fields['FOTHMUT'] = nacc.uds3.Field(name='FOTHMUT', typename='Num', position=(299, 299), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 1 NWINFMUT ne 1 (Yes)'])
        self.fields['FOTHMUTX'] = nacc.uds3.Field(name='FOTHMUTX', typename='Char', position=(301, 360), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 4a FOTHMUT ne 1 (Yes)', 'Blank if Question 1 NWINFMUT ne 1 (Yes)'])
        self.fields['FOTHMUSO'] = nacc.uds3.Field(name='FOTHMUSO', typename='Num', position=(362, 362), length=1, inclusive_range=(1, 3), allowable_values=['8', '9'], blanks=['Blank if Question 4a FOTHMUT = 0 (No)', 'Blank if Question 4a FOTHMUT = 9 (Unknown)', 'Blank if Question 1 NWINFMUT ne 1 (Yes)'])
        self.fields['FOTHMUSX'] = nacc.uds3.Field(name='FOTHMUSX', typename='Char', position=(364, 423), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 4a FOTHMUT = 0 (No)', 'Blank if Question 4a FOTHMUT = 9 (Unknown)', 'Blank if Question 4b FOTHMUSO ne 8 (Other)', 'Blank if Question 1 NEWINFMUT ne 1 (Yes)'])
        self.fields['NWINFPAR'] = nacc.uds3.Field(name='NWINFPAR', typename='Num', position=(425, 425), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['MOMMOB'] = nacc.uds3.Field(name='MOMMOB', typename='Num', position=(427, 428), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)'])
        self.fields['MOMYOB'] = nacc.uds3.Field(name='MOMYOB', typename='Num', position=(430, 433), length=4, inclusive_range=(1850, CURRENT_YEAR - 15), allowable_values=['9999'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)'])
        self.fields['MOMDAGE'] = nacc.uds3.Field(name='MOMDAGE', typename='Num', position=(435, 437), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)'])
        self.fields['MOMNEUR'] = nacc.uds3.Field(name='MOMNEUR', typename='Num', position=(439, 439), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)'])
        self.fields['MOMPRDX'] = nacc.uds3.Field(name='MOMPRDX', typename='Num', position=(441, 443), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)', 'Blank if Question 5a4 MOMNEUR = 8 (N/A)', 'Blank if Question 5a4 MOMNEUR = 9 (Unknown)'])
        self.fields['MOMMOE'] = nacc.uds3.Field(name='MOMMOE', typename='Num', position=(445, 445), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 5 NWINFPAR = 0 (No)', 'Blank if Question 5a4 MOMNEUR = 8 (N/A)', 'Blank if Question 5a4 MOMNEUR = 9 (Unknown)'])
        self.fields['MOMAGEO'] = nacc.uds3.Field(name='MOMAGEO', typename='Num', position=(447, 449), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)', 'Blank if Question 5a4 MOMNEUR = 8 (N/A)', 'Blank if Question 5a4 MOMNEUR = 9 (Unknown)'])
        self.fields['DADMOB'] = nacc.uds3.Field(name='DADMOB', typename='Num', position=(451, 452), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)'])
        self.fields['DADYOB'] = nacc.uds3.Field(name='DADYOB', typename='Num', position=(454, 457), length=4, inclusive_range=(1850, CURRENT_YEAR - 15), allowable_values=['9999'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)'])
        self.fields['DADDAGE'] = nacc.uds3.Field(name='DADDAGE', typename='Num', position=(459, 461), length=3, inclusive_range=(0, 110), allowable_values=['999', '888'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)'])
        self.fields['DADNEUR'] = nacc.uds3.Field(name='DADNEUR', typename='Num', position=(463, 463), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)'])
        self.fields['DADPRDX'] = nacc.uds3.Field(name='DADPRDX', typename='Num', position=(465, 467), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)', 'Blank if Question 5b4 DADNEUR = 8 (N/A)', 'Blank if Question 5b4 DADNEUR = 9 (Unknown)'])
        self.fields['DADMOE'] = nacc.uds3.Field(name='DADMOE', typename='Num', position=(469, 469), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 5 NWINFPAR = 0 (No)', 'Blank if Question 5b4 DADNEUR = 8 (N/A)', 'Blank if Question 5B4 DADNEUR = 9 (Unknown)'])
        self.fields['DADAGEO'] = nacc.uds3.Field(name='DADAGEO', typename='Num', position=(471, 473), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 5 NWINFPAR = 0 (No)', 'Blank if Question 5b4 DADNEUR = 8 (N/A)', 'Blank if Question 5B4 DADNEUR = 9 (Unknown)'])
        self.fields['SIBS'] = nacc.uds3.Field(name='SIBS', typename='Num', position=(475, 476), length=2, inclusive_range=(0, 20), allowable_values=['77'], blanks=[])
        self.fields['NWINFSIB'] = nacc.uds3.Field(name='NWINFSIB', typename='Num', position=(478, 478), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77'])
        self.fields['SIB1MOB'] = nacc.uds3.Field(name='SIB1MOB', typename='Num', position=(480, 481), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB1YOB'] = nacc.uds3.Field(name='SIB1YOB', typename='Num', position=(483, 486), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB1AGD'] = nacc.uds3.Field(name='SIB1AGD', typename='Num', position=(488, 490), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB1NEU'] = nacc.uds3.Field(name='SIB1NEU', typename='Num', position=(492, 492), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB1PDX'] = nacc.uds3.Field(name='SIB1PDX', typename='Num', position=(494, 496), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6aa4 SIB1NEU = 8 (N/A)', 'Blank if Question 6aa4 SIB1NEU = 9 (Unknown)'])
        self.fields['SIB1MOE'] = nacc.uds3.Field(name='SIB1MOE', typename='Num', position=(498, 498), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6aa4 SIB1NEU = 8 (N/A)', 'Blank if Question 6aa4 SIB1NEU = 9 (Unknown)'])
        self.fields['SIB1AGO'] = nacc.uds3.Field(name='SIB1AGO', typename='Num', position=(500, 502), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6aa4 SIB1NEU = 8 (N/A)', 'Blank if Question 6aa4 SIB1NEU = 9 (Unknown)'])
        self.fields['SIB2MOB'] = nacc.uds3.Field(name='SIB2MOB', typename='Num', position=(504, 505), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB2YOB'] = nacc.uds3.Field(name='SIB2YOB', typename='Num', position=(507, 510), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB2AGD'] = nacc.uds3.Field(name='SIB2AGD', typename='Num', position=(512, 514), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB2NEU'] = nacc.uds3.Field(name='SIB2NEU', typename='Num', position=(516, 516), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB2PDX'] = nacc.uds3.Field(name='SIB2PDX', typename='Num', position=(518, 520), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ab4 SIB2NEU = 8 (N/A)', 'Blank if Question 6ab4 SIB2NEU = 9 (Unknown)'])
        self.fields['SIB2MOE'] = nacc.uds3.Field(name='SIB2MOE', typename='Num', position=(522, 522), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ab4 SIB2NEU = 8 (N/A)', 'Blank if Question 6ab4 SIB2NEU = 9 (Unknown)'])
        self.fields['SIB2AGO'] = nacc.uds3.Field(name='SIB2AGO', typename='Num', position=(524, 526), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ab4 SIB2NEU = 8 (N/A)', 'Blank if Question 6ab4 SIB2NEU = 9 (Unknown)'])
        self.fields['SIB3MOB'] = nacc.uds3.Field(name='SIB3MOB', typename='Num', position=(528, 529), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB3YOB'] = nacc.uds3.Field(name='SIB3YOB', typename='Num', position=(531, 534), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB3AGD'] = nacc.uds3.Field(name='SIB3AGD', typename='Num', position=(536, 538), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB3NEU'] = nacc.uds3.Field(name='SIB3NEU', typename='Num', position=(540, 540), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB3PDX'] = nacc.uds3.Field(name='SIB3PDX', typename='Num', position=(542, 544), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ac4 SIB3NEU = 8 (N/A)', 'Blank if Question 6ac4 SIB3NEU = 9 (Unknown)'])
        self.fields['SIB3MOE'] = nacc.uds3.Field(name='SIB3MOE', typename='Num', position=(546, 546), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ac4 SIB3NEU = 8 (N/A)', 'Blank if Question 6ac4 SIB3NEU = 9 (Unknown)'])
        self.fields['SIB3AGO'] = nacc.uds3.Field(name='SIB3AGO', typename='Num', position=(548, 550), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ac4 SIB3NEU = 8 (N/A)', 'Blank if Question 6ac4 SIB3NEU = 9 (Unknown)'])
        self.fields['SIB4MOB'] = nacc.uds3.Field(name='SIB4MOB', typename='Num', position=(552, 553), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB4YOB'] = nacc.uds3.Field(name='SIB4YOB', typename='Num', position=(555, 558), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB4AGD'] = nacc.uds3.Field(name='SIB4AGD', typename='Num', position=(560, 562), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB4NEU'] = nacc.uds3.Field(name='SIB4NEU', typename='Num', position=(564, 564), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB4PDX'] = nacc.uds3.Field(name='SIB4PDX', typename='Num', position=(566, 568), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ad4 SIB4NEU = 8 (N/A)', 'Blank if Question 6ad4 SIB4NEU = 9 (Unknown)'])
        self.fields['SIB4MOE'] = nacc.uds3.Field(name='SIB4MOE', typename='Num', position=(570, 570), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ad4 SIB4NEU = 8 (N/A)', 'Blank if Question 6ad4 SIB4NEU = 9 (Unknown)'])
        self.fields['SIB4AGO'] = nacc.uds3.Field(name='SIB4AGO', typename='Num', position=(572, 574), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ad4 SIB4NEU = 8 (N/A)', 'Blank if Question 6ad4 SIB4NEU = 9 (Unknown)'])
        self.fields['SIB5MOB'] = nacc.uds3.Field(name='SIB5MOB', typename='Num', position=(576, 577), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB5YOB'] = nacc.uds3.Field(name='SIB5YOB', typename='Num', position=(579, 582), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB5AGD'] = nacc.uds3.Field(name='SIB5AGD', typename='Num', position=(584, 586), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB5NEU'] = nacc.uds3.Field(name='SIB5NEU', typename='Num', position=(588, 588), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB5PDX'] = nacc.uds3.Field(name='SIB5PDX', typename='Num', position=(590, 592), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ae4 SIB5NEU = 8 (N/A)', 'Blank if Question 6ae4 SIB5NEU = 9 (Unknown)'])
        self.fields['SIB5MOE'] = nacc.uds3.Field(name='SIB5MOE', typename='Num', position=(594, 594), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ae4 SIB5NEU = 8 (N/A)', 'Blank if Question 6ae4 SIB5NEU = 9 (Unknown)'])
        self.fields['SIB5AGO'] = nacc.uds3.Field(name='SIB5AGO', typename='Num', position=(596, 598), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ae4 SIB5NEU = 8 (N/A)', 'Blank if Question 6ae4 SIB5NEU = 9 (Unknown)'])
        self.fields['SIB6MOB'] = nacc.uds3.Field(name='SIB6MOB', typename='Num', position=(600, 601), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB6YOB'] = nacc.uds3.Field(name='SIB6YOB', typename='Num', position=(603, 606), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB6AGD'] = nacc.uds3.Field(name='SIB6AGD', typename='Num', position=(608, 610), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB6NEU'] = nacc.uds3.Field(name='SIB6NEU', typename='Num', position=(612, 612), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB6PDX'] = nacc.uds3.Field(name='SIB6PDX', typename='Num', position=(614, 616), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6af4 SIB6NEU = 8 (N/A)', 'Blank if Question 6af4 SIB6NEU = 9 (Unknown)'])
        self.fields['SIB6MOE'] = nacc.uds3.Field(name='SIB6MOE', typename='Num', position=(618, 618), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6af4 SIB6NEU = 8 (N/A)', 'Blank if Question 6af4 SIB6NEU = 9 (Unknown)'])
        self.fields['SIB6AGO'] = nacc.uds3.Field(name='SIB6AGO', typename='Num', position=(620, 622), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6af4 SIB6NEU = 8 (N/A)', 'Blank if Question 6af4 SIB6NEU = 9 (Unknown)'])
        self.fields['SIB7MOB'] = nacc.uds3.Field(name='SIB7MOB', typename='Num', position=(624, 625), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB7YOB'] = nacc.uds3.Field(name='SIB7YOB', typename='Num', position=(627, 630), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB7AGD'] = nacc.uds3.Field(name='SIB7AGD', typename='Num', position=(632, 634), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB7NEU'] = nacc.uds3.Field(name='SIB7NEU', typename='Num', position=(636, 636), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB7PDX'] = nacc.uds3.Field(name='SIB7PDX', typename='Num', position=(638, 640), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ag4 SIB7NEU = 8 (N/A)', 'Blank if Question 6ag4 SIB7NEU = 9 (Unknown)'])
        self.fields['SIB7MOE'] = nacc.uds3.Field(name='SIB7MOE', typename='Num', position=(642, 642), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ag4 SIB7NEU = 8 (N/A)', 'Blank if Question 6ag4 SIB7NEU = 9 (Unknown)'])
        self.fields['SIB7AGO'] = nacc.uds3.Field(name='SIB7AGO', typename='Num', position=(644, 646), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ag4 SIB7NEU = 8 (N/A)', 'Blank if Question 6ag4 SIB7NEU = 9 (Unknown)'])
        self.fields['SIB8MOB'] = nacc.uds3.Field(name='SIB8MOB', typename='Num', position=(648, 649), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB8YOB'] = nacc.uds3.Field(name='SIB8YOB', typename='Num', position=(651, 654), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB8AGD'] = nacc.uds3.Field(name='SIB8AGD', typename='Num', position=(656, 658), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB8NEU'] = nacc.uds3.Field(name='SIB8NEU', typename='Num', position=(660, 660), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB8PDX'] = nacc.uds3.Field(name='SIB8PDX', typename='Num', position=(662, 664), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ah4 SIB8NEU = 8 (N/A)', 'Blank if Question 6ah4 SIB8NEU = 9 (Unknown)'])
        self.fields['SIB8MOE'] = nacc.uds3.Field(name='SIB8MOE', typename='Num', position=(666, 666), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ah4 SIB8NEU = 8 (N/A)', 'Blank if Question 6ah4 SIB8NEU = 9 (Unknown)'])
        self.fields['SIB8AGO'] = nacc.uds3.Field(name='SIB8AGO', typename='Num', position=(668, 670), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ah4 SIB8NEU = 8 (N/A)', 'Blank if Question 6ah4 SIB8NEU = 9 (Unknown)'])
        self.fields['SIB9MOB'] = nacc.uds3.Field(name='SIB9MOB', typename='Num', position=(672, 673), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB9YOB'] = nacc.uds3.Field(name='SIB9YOB', typename='Num', position=(675, 678), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB9AGD'] = nacc.uds3.Field(name='SIB9AGD', typename='Num', position=(680, 682), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB9NEU'] = nacc.uds3.Field(name='SIB9NEU', typename='Num', position=(684, 684), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB9PDX'] = nacc.uds3.Field(name='SIB9PDX', typename='Num', position=(686, 688), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ai4 SIB9NEU = 8 (N/A)', 'Blank if Question 6ai4 SIB9NEU = 9 (Unknown)'])
        self.fields['SIB9MOE'] = nacc.uds3.Field(name='SIB9MOE', typename='Num', position=(690, 690), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ai4 SIB9NEU = 8 (N/A)', 'Blank if Question 6ai4 SIB9NEU = 9 (Unknown)'])
        self.fields['SIB9AGO'] = nacc.uds3.Field(name='SIB9AGO', typename='Num', position=(692, 694), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ai4 SIB9NEU = 8 (N/A)', 'Blank if Question 6ai4 SIB9NEU = 9 (Unknown)'])
        self.fields['SIB10MOB'] = nacc.uds3.Field(name='SIB10MOB', typename='Num', position=(696, 697), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB10YOB'] = nacc.uds3.Field(name='SIB10YOB', typename='Num', position=(699, 702), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB10AGD'] = nacc.uds3.Field(name='SIB10AGD', typename='Num', position=(704, 706), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB10NEU'] = nacc.uds3.Field(name='SIB10NEU', typename='Num', position=(708, 708), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB10PDX'] = nacc.uds3.Field(name='SIB10PDX', typename='Num', position=(710, 712), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6aj4 SIB10NEU = 8 (N/A)', 'Blank if Question 6aj4 SIB10NEU = 9 (Unknown)'])
        self.fields['SIB10MOE'] = nacc.uds3.Field(name='SIB10MOE', typename='Num', position=(714, 714), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6aj4 SIB10NEU = 8 (N/A)', 'Blank if Question 6aj4 SIB10NEU = 9 (Unknown)'])
        self.fields['SIB10AGO'] = nacc.uds3.Field(name='SIB10AGO', typename='Num', position=(716, 718), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6aj4 SIB10NEU = 8 (N/A)', 'Blank if Question 6aj4 SIB10NEU = 9 (Unknown)'])
        self.fields['SIB11MOB'] = nacc.uds3.Field(name='SIB11MOB', typename='Num', position=(720, 721), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB11YOB'] = nacc.uds3.Field(name='SIB11YOB', typename='Num', position=(723, 726), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB11AGD'] = nacc.uds3.Field(name='SIB11AGD', typename='Num', position=(728, 730), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB11NEU'] = nacc.uds3.Field(name='SIB11NEU', typename='Num', position=(732, 732), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB11PDX'] = nacc.uds3.Field(name='SIB11PDX', typename='Num', position=(734, 736), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ak4 SIB11NEU = 8 (N/A)', 'Blank if Question 6ak4 SIB11NEU = 9 (Unknown)'])
        self.fields['SIB11MOE'] = nacc.uds3.Field(name='SIB11MOE', typename='Num', position=(738, 738), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ak4 SIB11NEU = 8 (N/A)', 'Blank if Question 6ak4 SIB11NEU = 9 (Unknown)'])
        self.fields['SIB11AGO'] = nacc.uds3.Field(name='SIB11AGO', typename='Num', position=(740, 742), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ak4 SIB11NEU = 8 (N/A)', 'Blank if Question 6ak4 SIB11NEU = 9 (Unknown)'])
        self.fields['SIB12MOB'] = nacc.uds3.Field(name='SIB12MOB', typename='Num', position=(744, 745), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB12YOB'] = nacc.uds3.Field(name='SIB12YOB', typename='Num', position=(747, 750), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB12AGD'] = nacc.uds3.Field(name='SIB12AGD', typename='Num', position=(752, 754), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB12NEU'] = nacc.uds3.Field(name='SIB12NEU', typename='Num', position=(756, 756), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB12PDX'] = nacc.uds3.Field(name='SIB12PDX', typename='Num', position=(758, 760), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6al4 SIB12NEU = 8 (N/A)', 'Blank if Question 6al4 SIB12NEU = 9 (Unknown)'])
        self.fields['SIB12MOE'] = nacc.uds3.Field(name='SIB12MOE', typename='Num', position=(762, 762), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6al4 SIB12NEU = 8 (N/A)', 'Blank if Question 6al4 SIB12NEU = 9 (Unknown)'])
        self.fields['SIB12AGO'] = nacc.uds3.Field(name='SIB12AGO', typename='Num', position=(764, 766), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6al4 SIB12NEU = 8 (N/A)', 'Blank if Question 6al4 SIB12NEU = 9 (Unknown)'])
        self.fields['SIB13MOB'] = nacc.uds3.Field(name='SIB13MOB', typename='Num', position=(768, 769), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB13YOB'] = nacc.uds3.Field(name='SIB13YOB', typename='Num', position=(771, 774), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB13AGD'] = nacc.uds3.Field(name='SIB13AGD', typename='Num', position=(776, 778), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB13NEU'] = nacc.uds3.Field(name='SIB13NEU', typename='Num', position=(780, 780), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB13PDX'] = nacc.uds3.Field(name='SIB13PDX', typename='Num', position=(782, 784), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6am4 SIB13NEU = 8 (N/A)', 'Blank if Question 6am4 SIB13NEU = 9 (Unknown)'])
        self.fields['SIB13MOE'] = nacc.uds3.Field(name='SIB13MOE', typename='Num', position=(786, 786), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6am4 SIB13NEU = 8 (N/A)', 'Blank if Question 6am4 SIB13NEU = 9 (Unknown)'])
        self.fields['SIB13AGO'] = nacc.uds3.Field(name='SIB13AGO', typename='Num', position=(788, 790), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6am4 SIB13NEU = 8 (N/A)', 'Blank if Question 6am4 SIB13NEU = 9 (Unknown)'])
        self.fields['SIB14MOB'] = nacc.uds3.Field(name='SIB14MOB', typename='Num', position=(792, 793), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB14YOB'] = nacc.uds3.Field(name='SIB14YOB', typename='Num', position=(795, 798), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB14AGD'] = nacc.uds3.Field(name='SIB14AGD', typename='Num', position=(800, 802), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB14NEU'] = nacc.uds3.Field(name='SIB14NEU', typename='Num', position=(804, 804), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB14PDX'] = nacc.uds3.Field(name='SIB14PDX', typename='Num', position=(806, 808), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6an4 SIB14NEU = 8 (N/A)', 'Blank if Question 6an4 SIB14NEU = 9 (Unknown)'])
        self.fields['SIB14MOE'] = nacc.uds3.Field(name='SIB14MOE', typename='Num', position=(810, 810), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6an4 SIB14NEU = 8 (N/A)', 'Blank if Question 6an4 SIB14NEU = 9 (Unknown)'])
        self.fields['SIB14AGO'] = nacc.uds3.Field(name='SIB14AGO', typename='Num', position=(812, 814), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6an4 SIB14NEU = 8 (N/A)', 'Blank if Question 6an4 SIB14NEU = 9 (Unknown)'])
        self.fields['SIB15MOB'] = nacc.uds3.Field(name='SIB15MOB', typename='Num', position=(816, 817), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB15YOB'] = nacc.uds3.Field(name='SIB15YOB', typename='Num', position=(819, 822), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB15AGD'] = nacc.uds3.Field(name='SIB15AGD', typename='Num', position=(824, 826), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB15NEU'] = nacc.uds3.Field(name='SIB15NEU', typename='Num', position=(828, 828), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB15PDX'] = nacc.uds3.Field(name='SIB15PDX', typename='Num', position=(830, 832), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ao4 SIB15NEU = 8 (N/A)', 'Blank if Question 6ao4 SIB15NEU = 9 (Unknown)'])
        self.fields['SIB15MOE'] = nacc.uds3.Field(name='SIB15MOE', typename='Num', position=(834, 834), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ao4 SIB15NEU = 8 (N/A)', 'Blank if Question 6ao4 SIB15NEU = 9 (Unknown)'])
        self.fields['SIB15AGO'] = nacc.uds3.Field(name='SIB15AGO', typename='Num', position=(836, 838), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ao4 SIB15NEU = 8 (N/A)', 'Blank if Question 6ao4 SIB15NEU = 9 (Unknown)'])
        self.fields['SIB16MOB'] = nacc.uds3.Field(name='SIB16MOB', typename='Num', position=(840, 841), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB16YOB'] = nacc.uds3.Field(name='SIB16YOB', typename='Num', position=(843, 846), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB16AGD'] = nacc.uds3.Field(name='SIB16AGD', typename='Num', position=(848, 850), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB16NEU'] = nacc.uds3.Field(name='SIB16NEU', typename='Num', position=(852, 852), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB16PDX'] = nacc.uds3.Field(name='SIB16PDX', typename='Num', position=(854, 856), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ap4 SIB16NEU = 8 (N/A)', 'Blank if Question 6ap4 SIB16NEU = 9 (Unknown)'])
        self.fields['SIB16MOE'] = nacc.uds3.Field(name='SIB16MOE', typename='Num', position=(858, 858), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ap4 SIB16NEU = 8 (N/A)', 'Blank if Question 6ap4 SIB16NEU = 9 (Unknown)'])
        self.fields['SIB16AGO'] = nacc.uds3.Field(name='SIB16AGO', typename='Num', position=(860, 862), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ap4 SIB16NEU = 8 (N/A)', 'Blank if Question 6ap4 SIB16NEU = 9 (Unknown)'])
        self.fields['SIB17MOB'] = nacc.uds3.Field(name='SIB17MOB', typename='Num', position=(864, 865), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB17YOB'] = nacc.uds3.Field(name='SIB17YOB', typename='Num', position=(867, 870), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB17AGD'] = nacc.uds3.Field(name='SIB17AGD', typename='Num', position=(872, 874), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB17NEU'] = nacc.uds3.Field(name='SIB17NEU', typename='Num', position=(876, 876), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB17PDX'] = nacc.uds3.Field(name='SIB17PDX', typename='Num', position=(878, 880), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6aq4 SIB17NEU = 8 (N/A)', 'Blank if Question 6aq4 SIB17NEU = 9 (Unknown)'])
        self.fields['SIB17MOE'] = nacc.uds3.Field(name='SIB17MOE', typename='Num', position=(882, 882), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6aq4 SIB17NEU = 8 (N/A)', 'Blank if Question 6aq4 SIB17NEU = 9 (Unknown)'])
        self.fields['SIB17AGO'] = nacc.uds3.Field(name='SIB17AGO', typename='Num', position=(884, 886), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6aq4 SIB17NEU = 8 (N/A)', 'Blank if Question 6aq4 SIB17NEU = 9 (Unknown)'])
        self.fields['SIB18MOB'] = nacc.uds3.Field(name='SIB18MOB', typename='Num', position=(888, 889), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB18YOB'] = nacc.uds3.Field(name='SIB18YOB', typename='Num', position=(891, 894), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB18AGD'] = nacc.uds3.Field(name='SIB18AGD', typename='Num', position=(896, 898), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB18NEU'] = nacc.uds3.Field(name='SIB18NEU', typename='Num', position=(900, 900), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB18PDX'] = nacc.uds3.Field(name='SIB18PDX', typename='Num', position=(902, 904), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ar4 SIB18NEU = 8 (N/A)', 'Blank if Question 6ar4 SIB18NEU = 9 (Unknown)'])
        self.fields['SIB18MOE'] = nacc.uds3.Field(name='SIB18MOE', typename='Num', position=(906, 906), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ar4 SIB18NEU = 8 (N/A)', 'Blank if Question 6ar4 SIB18NEU = 9 (Unknown)'])
        self.fields['SIB18AGO'] = nacc.uds3.Field(name='SIB18AGO', typename='Num', position=(908, 910), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6ar4 SIB18NEU = 8 (N/A)', 'Blank if Question 6ar4 SIB18NEU = 9 (Unknown)'])
        self.fields['SIB19MOB'] = nacc.uds3.Field(name='SIB19MOB', typename='Num', position=(912, 913), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB19YOB'] = nacc.uds3.Field(name='SIB19YOB', typename='Num', position=(915, 918), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB19AGD'] = nacc.uds3.Field(name='SIB19AGD', typename='Num', position=(920, 922), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB19NEU'] = nacc.uds3.Field(name='SIB19NEU', typename='Num', position=(924, 924), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB19PDX'] = nacc.uds3.Field(name='SIB19PDX', typename='Num', position=(926, 928), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6as4 SIB19NEU = 8 (N/A)', 'Blank if Question 6as4 SIB19NEU = 9 (Unknown)'])
        self.fields['SIB19MOE'] = nacc.uds3.Field(name='SIB19MOE', typename='Num', position=(930, 930), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6as4 SIB19NEU = 8 (N/A)', 'Blank if Question 6as4 SIB19NEU = 9 (Unknown)'])
        self.fields['SIB19AGO'] = nacc.uds3.Field(name='SIB19AGO', typename='Num', position=(932, 934), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6as4 SIB19NEU = 8 (N/A)', 'Blank if Question 6as4 SIB19NEU = 9 (Unknown)'])
        self.fields['SIB20MOB'] = nacc.uds3.Field(name='SIB20MOB', typename='Num', position=(936, 937), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB20YOB'] = nacc.uds3.Field(name='SIB20YOB', typename='Num', position=(939, 942), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB20AGD'] = nacc.uds3.Field(name='SIB20AGD', typename='Num', position=(944, 946), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB20NEU'] = nacc.uds3.Field(name='SIB20NEU', typename='Num', position=(948, 948), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)'])
        self.fields['SIB20PDX'] = nacc.uds3.Field(name='SIB20PDX', typename='Num', position=(950, 952), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6at4 SIB20NEU = 8 (N/A)', 'Blank if Question 6at4 SIB20NEU = 9 (Unknown)'])
        self.fields['SIB20MOE'] = nacc.uds3.Field(name='SIB20MOE', typename='Num', position=(954, 954), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6at4 SIB20NEU = 8 (N/A)', 'Blank if Question 6at4 SIB20NEU = 9 (Unknown)'])
        self.fields['SIB20AGO'] = nacc.uds3.Field(name='SIB20AGO', typename='Num', position=(956, 958), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0', 'Blank if Question 6 SIBS = 77', 'Blank if Question 6a NWINFSIB = 0 (No)', 'Blank if Question 6at4 SIB20NEU = 8 (N/A)', 'Blank if Question 6at4 SIB20NEU = 9 (Unknown)'])
        self.fields['KIDS'] = nacc.uds3.Field(name='KIDS', typename='Num', position=(960, 961), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=[])
        self.fields['NWINFKID'] = nacc.uds3.Field(name='NWINFKID', typename='Num', position=(963, 963), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['KID1MOB'] = nacc.uds3.Field(name='KID1MOB', typename='Num', position=(965, 966), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID1YOB'] = nacc.uds3.Field(name='KID1YOB', typename='Num', position=(968, 971), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID1AGD'] = nacc.uds3.Field(name='KID1AGD', typename='Num', position=(973, 975), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID1NEU'] = nacc.uds3.Field(name='KID1NEU', typename='Num', position=(977, 977), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID1PDX'] = nacc.uds3.Field(name='KID1PDX', typename='Num', position=(979, 981), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7aa4 KID1NEU = 8 (N/A)', 'Blank if Question 7aa4 KID1NEU = 9 (Unknown)'])
        self.fields['KID1MOE'] = nacc.uds3.Field(name='KID1MOE', typename='Num', position=(983, 983), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7aa4 KID1NEU = 8 (N/A)', 'Blank if Question 7aa4 KID1NEU = 9 (Unknown)'])
        self.fields['KID1AGO'] = nacc.uds3.Field(name='KID1AGO', typename='Num', position=(985, 987), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7aa4 KID1NEU = 8 (N/A)', 'Blank if Question 7aa4 KID1NEU = 9 (Unknown)'])
        self.fields['KID2MOB'] = nacc.uds3.Field(name='KID2MOB', typename='Num', position=(989, 990), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID2YOB'] = nacc.uds3.Field(name='KID2YOB', typename='Num', position=(992, 995), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID2AGD'] = nacc.uds3.Field(name='KID2AGD', typename='Num', position=(997, 999), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID2NEU'] = nacc.uds3.Field(name='KID2NEU', typename='Num', position=(1001, 1001), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID2PDX'] = nacc.uds3.Field(name='KID2PDX', typename='Num', position=(1003, 1005), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ab4 KID2NEU = 8 (N/A)', 'Blank if Question 7ab4 KID2NEU = 9 (Unknown)'])
        self.fields['KID2MOE'] = nacc.uds3.Field(name='KID2MOE', typename='Num', position=(1007, 1007), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ab4 KID2NEU = 8 (N/A)', 'Blank if Question 7ab4 KID2NEU = 9 (Unknown)'])
        self.fields['KID2AGO'] = nacc.uds3.Field(name='KID2AGO', typename='Num', position=(1009, 1011), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ab4 KID2NEU = 8 (N/A)', 'Blank if Question 7ab4 KID2NEU = 9 (Unknown)'])
        self.fields['KID3MOB'] = nacc.uds3.Field(name='KID3MOB', typename='Num', position=(1013, 1014), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID3YOB'] = nacc.uds3.Field(name='KID3YOB', typename='Num', position=(1016, 1019), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID3AGD'] = nacc.uds3.Field(name='KID3AGD', typename='Num', position=(1021, 1023), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID3NEU'] = nacc.uds3.Field(name='KID3NEU', typename='Num', position=(1025, 1025), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID3PDX'] = nacc.uds3.Field(name='KID3PDX', typename='Num', position=(1027, 1029), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ac4 KID3NEU = 8 (N/A)', 'Blank if Question 7ac4 KID3NEU = 9 (Unknown)'])
        self.fields['KID3MOE'] = nacc.uds3.Field(name='KID3MOE', typename='Num', position=(1031, 1031), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ac4 KID3NEU = 8 (N/A)', 'Blank if Question 7ac4 KID3NEU = 9 (Unknown)'])
        self.fields['KID3AGO'] = nacc.uds3.Field(name='KID3AGO', typename='Num', position=(1033, 1035), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ac4 KID3NEU = 8 (N/A)', 'Blank if Question 7ac4 KID3NEU = 9 (Unknown)'])
        self.fields['KID4MOB'] = nacc.uds3.Field(name='KID4MOB', typename='Num', position=(1037, 1038), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID4YOB'] = nacc.uds3.Field(name='KID4YOB', typename='Num', position=(1040, 1043), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID4AGD'] = nacc.uds3.Field(name='KID4AGD', typename='Num', position=(1045, 1047), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID4NEU'] = nacc.uds3.Field(name='KID4NEU', typename='Num', position=(1049, 1049), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID4PDX'] = nacc.uds3.Field(name='KID4PDX', typename='Num', position=(1051, 1053), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ad4 KID4NEU = 8 (N/A)', 'Blank if Question 7ad4 KID4NEU = 9 (Unknown)'])
        self.fields['KID4MOE'] = nacc.uds3.Field(name='KID4MOE', typename='Num', position=(1055, 1055), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ad4 KID4NEU = 8 (N/A)', 'Blank if Question 7ad4 KID4NEU = 9 (Unknown)'])
        self.fields['KID4AGO'] = nacc.uds3.Field(name='KID4AGO', typename='Num', position=(1057, 1059), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ad4 KID4NEU = 8 (N/A)', 'Blank if Question 7ad4 KID4NEU = 9 (Unknown)'])
        self.fields['KID5MOB'] = nacc.uds3.Field(name='KID5MOB', typename='Num', position=(1061, 1062), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID5YOB'] = nacc.uds3.Field(name='KID5YOB', typename='Num', position=(1064, 1067), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID5AGD'] = nacc.uds3.Field(name='KID5AGD', typename='Num', position=(1069, 1071), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID5NEU'] = nacc.uds3.Field(name='KID5NEU', typename='Num', position=(1073, 1073), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID5PDX'] = nacc.uds3.Field(name='KID5PDX', typename='Num', position=(1075, 1077), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ae4 KID5NEU = 8 (N/A)', 'Blank if Question 7ae4 KID5NEU = 9 (Unknown)'])
        self.fields['KID5MOE'] = nacc.uds3.Field(name='KID5MOE', typename='Num', position=(1079, 1079), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ae4 KID5NEU = 8 (N/A)', 'Blank if Question 7ae4 KID5NEU = 9 (Unknown)'])
        self.fields['KID5AGO'] = nacc.uds3.Field(name='KID5AGO', typename='Num', position=(1081, 1083), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ae4 KID5NEU = 8 (N/A)', 'Blank if Question 7ae4 KID5NEU = 9 (Unknown)'])
        self.fields['KID6MOB'] = nacc.uds3.Field(name='KID6MOB', typename='Num', position=(1085, 1086), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID6YOB'] = nacc.uds3.Field(name='KID6YOB', typename='Num', position=(1088, 1091), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID6AGD'] = nacc.uds3.Field(name='KID6AGD', typename='Num', position=(1093, 1095), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID6NEU'] = nacc.uds3.Field(name='KID6NEU', typename='Num', position=(1097, 1097), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID6PDX'] = nacc.uds3.Field(name='KID6PDX', typename='Num', position=(1099, 1101), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7af4 KID6NEU = 8 (N/A)', 'Blank if Question 7af4 KID6NEU = 9 (Unknown)'])
        self.fields['KID6MOE'] = nacc.uds3.Field(name='KID6MOE', typename='Num', position=(1103, 1103), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7af4 KID6NEU = 8 (N/A)', 'Blank if Question 7af4 KID6NEU = 9 (Unknown)'])
        self.fields['KID6AGO'] = nacc.uds3.Field(name='KID6AGO', typename='Num', position=(1105, 1107), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7af4 KID6NEU = 8 (N/A)', 'Blank if Question 7af4 KID6NEU = 9 (Unknown)'])
        self.fields['KID7MOB'] = nacc.uds3.Field(name='KID7MOB', typename='Num', position=(1109, 1110), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID7YOB'] = nacc.uds3.Field(name='KID7YOB', typename='Num', position=(1112, 1115), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID7AGD'] = nacc.uds3.Field(name='KID7AGD', typename='Num', position=(1117, 1119), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID7NEU'] = nacc.uds3.Field(name='KID7NEU', typename='Num', position=(1121, 1121), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID7PDX'] = nacc.uds3.Field(name='KID7PDX', typename='Num', position=(1123, 1125), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ag4 KID7NEU = 8 (N/A)', 'Blank if Question 7ag4 KID7NEU = 9 (Unknown)'])
        self.fields['KID7MOE'] = nacc.uds3.Field(name='KID7MOE', typename='Num', position=(1127, 1127), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ag4 KID7NEU = 8 (N/A)', 'Blank if Question 7ag4 KID7NEU = 9 (Unknown)'])
        self.fields['KID7AGO'] = nacc.uds3.Field(name='KID7AGO', typename='Num', position=(1129, 1131), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ag4 KID7NEU = 8 (N/A)', 'Blank if Question 7ag4 KID7NEU = 9 (Unknown)'])
        self.fields['KID8MOB'] = nacc.uds3.Field(name='KID8MOB', typename='Num', position=(1133, 1134), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID8YOB'] = nacc.uds3.Field(name='KID8YOB', typename='Num', position=(1136, 1139), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID8AGD'] = nacc.uds3.Field(name='KID8AGD', typename='Num', position=(1141, 1143), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID8NEU'] = nacc.uds3.Field(name='KID8NEU', typename='Num', position=(1145, 1145), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID8PDX'] = nacc.uds3.Field(name='KID8PDX', typename='Num', position=(1147, 1149), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ah4 KID8NEU = 8 (N/A)', 'Blank if Question 7ah4 KID8NEU = 9 (Unknown)'])
        self.fields['KID8MOE'] = nacc.uds3.Field(name='KID8MOE', typename='Num', position=(1151, 1151), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ah4 KID8NEU = 8 (N/A)', 'Blank if Question 7ah4 KID8NEU = 9 (Unknown)'])
        self.fields['KID8AGO'] = nacc.uds3.Field(name='KID8AGO', typename='Num', position=(1153, 1155), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ah4 KID8NEU = 8 (N/A)', 'Blank if Question 7ah4 KID8NEU = 9 (Unknown)'])
        self.fields['KID9MOB'] = nacc.uds3.Field(name='KID9MOB', typename='Num', position=(1157, 1158), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID9YOB'] = nacc.uds3.Field(name='KID9YOB', typename='Num', position=(1160, 1163), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID9AGD'] = nacc.uds3.Field(name='KID9AGD', typename='Num', position=(1165, 1167), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID9NEU'] = nacc.uds3.Field(name='KID9NEU', typename='Num', position=(1169, 1169), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID9PDX'] = nacc.uds3.Field(name='KID9PDX', typename='Num', position=(1171, 1173), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ai4 KID9NEU = 8 (N/A)', 'Blank if Question 7ai4 KID9NEU = 9 (Unknown)'])
        self.fields['KID9MOE'] = nacc.uds3.Field(name='KID9MOE', typename='Num', position=(1175, 1175), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ai4 KID9NEU = 8 (N/A)', 'Blank if Question 7ai4 KID9NEU = 9 (Unknown)'])
        self.fields['KID9AGO'] = nacc.uds3.Field(name='KID9AGO', typename='Num', position=(1177, 1179), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ai4 KID9NEU = 8 (N/A)', 'Blank if Question 7ai4 KID9NEU = 9 (Unknown)'])
        self.fields['KID10MOB'] = nacc.uds3.Field(name='KID10MOB', typename='Num', position=(1181, 1182), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID10YOB'] = nacc.uds3.Field(name='KID10YOB', typename='Num', position=(1184, 1187), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID10AGD'] = nacc.uds3.Field(name='KID10AGD', typename='Num', position=(1189, 1191), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID10NEU'] = nacc.uds3.Field(name='KID10NEU', typename='Num', position=(1193, 1193), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID10PDX'] = nacc.uds3.Field(name='KID10PDX', typename='Num', position=(1195, 1197), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7aj4 KID10NEU = 8 (N/A)', 'Blank if Question 7aj4 KID10NEU = 9 (Unknown)'])
        self.fields['KID10MOE'] = nacc.uds3.Field(name='KID10MOE', typename='Num', position=(1199, 1199), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7aj4 KID10NEU = 8 (N/A)', 'Blank if Question 7aj4 KID10NEU = 9 (Unknown)'])
        self.fields['KID10AGO'] = nacc.uds3.Field(name='KID10AGO', typename='Num', position=(1201, 1203), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7aj4 KID10NEU = 8 (N/A)', 'Blank if Question 7aj4 KID10NEU = 9 (Unknown)'])
        self.fields['KID11MOB'] = nacc.uds3.Field(name='KID11MOB', typename='Num', position=(1205, 1206), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID11YOB'] = nacc.uds3.Field(name='KID11YOB', typename='Num', position=(1208, 1211), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID11AGD'] = nacc.uds3.Field(name='KID11AGD', typename='Num', position=(1213, 1215), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID11NEU'] = nacc.uds3.Field(name='KID11NEU', typename='Num', position=(1217, 1217), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID11PDX'] = nacc.uds3.Field(name='KID11PDX', typename='Num', position=(1219, 1221), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ak4 KID11NEU = 8 (N/A)', 'Blank if Question 7ak4 KID11NEU = 9 (Unknown)'])
        self.fields['KID11MOE'] = nacc.uds3.Field(name='KID11MOE', typename='Num', position=(1223, 1223), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ak4 KID11NEU = 8 (N/A)', 'Blank if Question 7ak4 KID11NEU = 9 (Unknown)'])
        self.fields['KID11AGO'] = nacc.uds3.Field(name='KID11AGO', typename='Num', position=(1225, 1227), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ak4 KID11NEU = 8 (N/A)', 'Blank if Question 7ak4 KID11NEU = 9 (Unknown)'])
        self.fields['KID12MOB'] = nacc.uds3.Field(name='KID12MOB', typename='Num', position=(1229, 1230), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID12YOB'] = nacc.uds3.Field(name='KID12YOB', typename='Num', position=(1232, 1235), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID12AGD'] = nacc.uds3.Field(name='KID12AGD', typename='Num', position=(1237, 1239), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID12NEU'] = nacc.uds3.Field(name='KID12NEU', typename='Num', position=(1241, 1241), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID12PDX'] = nacc.uds3.Field(name='KID12PDX', typename='Num', position=(1243, 1245), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7al4 KID12NEU = 8 (N/A)', 'Blank if Question 7al4 KID12NEU = 9 (Unknown)'])
        self.fields['KID12MOE'] = nacc.uds3.Field(name='KID12MOE', typename='Num', position=(1247, 1247), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7al4 KID12NEU = 8 (N/A)', 'Blank if Question 7al4 KID12NEU = 9 (Unknown)'])
        self.fields['KID12AGO'] = nacc.uds3.Field(name='KID12AGO', typename='Num', position=(1249, 1251), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7al4 KID12NEU = 8 (N/A)', 'Blank if Question 7al4 KID12NEU = 9 (Unknown)'])
        self.fields['KID13MOB'] = nacc.uds3.Field(name='KID13MOB', typename='Num', position=(1253, 1254), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID13YOB'] = nacc.uds3.Field(name='KID13YOB', typename='Num', position=(1256, 1259), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID13AGD'] = nacc.uds3.Field(name='KID13AGD', typename='Num', position=(1261, 1263), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID13NEU'] = nacc.uds3.Field(name='KID13NEU', typename='Num', position=(1265, 1265), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID13PDX'] = nacc.uds3.Field(name='KID13PDX', typename='Num', position=(1267, 1269), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7am4 KID13NEU = 8 (N/A)', 'Blank if Question 7am4 KID13NEU = 9 (Unknown)'])
        self.fields['KID13MOE'] = nacc.uds3.Field(name='KID13MOE', typename='Num', position=(1271, 1271), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7am4 KID13NEU = 8 (N/A)', 'Blank if Question 7am4 KID13NEU = 9 (Unknown)'])
        self.fields['KID13AGO'] = nacc.uds3.Field(name='KID13AGO', typename='Num', position=(1273, 1275), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7am4 KID13NEU = 8 (N/A)', 'Blank if Question 7am4 KID13NEU = 9 (Unknown)'])
        self.fields['KID14MOB'] = nacc.uds3.Field(name='KID14MOB', typename='Num', position=(1277, 1278), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID14YOB'] = nacc.uds3.Field(name='KID14YOB', typename='Num', position=(1280, 1283), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID14AGD'] = nacc.uds3.Field(name='KID14AGD', typename='Num', position=(1285, 1287), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID14NEU'] = nacc.uds3.Field(name='KID14NEU', typename='Num', position=(1289, 1289), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID14PDX'] = nacc.uds3.Field(name='KID14PDX', typename='Num', position=(1291, 1293), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7an4 KID14NEU = 8 (N/A)', 'Blank if Question 7an4 KID14NEU = 9 (Unknown)'])
        self.fields['KID14MOE'] = nacc.uds3.Field(name='KID14MOE', typename='Num', position=(1295, 1295), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7an4 KID14NEU = 8 (N/A)', 'Blank if Question 7an4 KID14NEU = 9 (Unknown)'])
        self.fields['KID14AGO'] = nacc.uds3.Field(name='KID14AGO', typename='Num', position=(1297, 1299), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7an4 KID14NEU = 8 (N/A)', 'Blank if Question 7an4 KID14NEU = 9 (Unknown)'])
        self.fields['KID15MOB'] = nacc.uds3.Field(name='KID15MOB', typename='Num', position=(1301, 1302), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0'])
        self.fields['KID15YOB'] = nacc.uds3.Field(name='KID15YOB', typename='Num', position=(1304, 1307), length=4, inclusive_range=(1910, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID15AGD'] = nacc.uds3.Field(name='KID15AGD', typename='Num', position=(1309, 1311), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID15NEU'] = nacc.uds3.Field(name='KID15NEU', typename='Num', position=(1313, 1313), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)'])
        self.fields['KID15PDX'] = nacc.uds3.Field(name='KID15PDX', typename='Num', position=(1315, 1317), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ao4 KID15NEU = 8 (N/A)', 'Blank if Question 7ao4 KID15NEU = 9 (Unknown)'])
        self.fields['KID15MOE'] = nacc.uds3.Field(name='KID15MOE', typename='Num', position=(1319, 1319), length=1, inclusive_range=(1, 7), allowable_values=[], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ao4 KID15NEU = 8 (N/A)', 'Blank if Question 7ao4 KID15NEU = 9 (Unknown)'])
        self.fields['KID15AGO'] = nacc.uds3.Field(name='KID15AGO', typename='Num', position=(1321, 1323), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0', 'Blank if Question 7a NWINFKID = 0 (No)', 'Blank if Question 7ao4 KID15NEU = 8 (N/A)', 'Blank if Question 7ao4 KID15NEU = 9 (Unknown)'])


class FormA4G(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['ANYMEDS'] = nacc.uds3.Field(name='ANYMEDS', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])


class FormA4D(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['DRUGID'] = nacc.uds3.Field(name='DRUGID', typename='Char', position=(45, 50), length=6, inclusive_range=None, allowable_values=[], blanks=[])


class FormB4(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['MEMORY'] = nacc.uds3.Field(name='MEMORY', typename='Num', position=(45, 47), length=3, inclusive_range=(0, 3), allowable_values=['0.0', '0.5', '1.0', '2.0', '3.0'], blanks=[])
        self.fields['ORIENT'] = nacc.uds3.Field(name='ORIENT', typename='Num', position=(49, 51), length=3, inclusive_range=(0, 3), allowable_values=['0.0', '0.5', '1.0', '2.0', '3.0'], blanks=[])
        self.fields['JUDGMENT'] = nacc.uds3.Field(name='JUDGMENT', typename='Num', position=(53, 55), length=3, inclusive_range=(0, 3), allowable_values=['0.0', '0.5', '1.0', '2.0', '3.0'], blanks=[])
        self.fields['COMMUN'] = nacc.uds3.Field(name='COMMUN', typename='Num', position=(57, 59), length=3, inclusive_range=(0, 3), allowable_values=['0.0', '0.5', '1.0', '2.0', '3.0'], blanks=[])
        self.fields['HOMEHOBB'] = nacc.uds3.Field(name='HOMEHOBB', typename='Num', position=(61, 63), length=3, inclusive_range=(0, 3), allowable_values=['0.0', '0.5', '1.0', '2.0', '3.0'], blanks=[])
        self.fields['PERSCARE'] = nacc.uds3.Field(name='PERSCARE', typename='Num', position=(65, 67), length=3, inclusive_range=(0, 3), allowable_values=['0.0', '0.5', '1.0', '2.0', '3.0'], blanks=[])
        self.fields['CDRSUM'] = nacc.uds3.Field(name='CDRSUM', typename='Num', position=(69, 72), length=4, inclusive_range=(0, 18), allowable_values=[], blanks=[])  # can not have 16.5 and 17.5
        self.fields['CDRGLOB'] = nacc.uds3.Field(name='CDRGLOB', typename='Num', position=(74, 76), length=3, inclusive_range=(0, 3), allowable_values=['0.0', '0.5', '1.0', '2.0', '3.0'], blanks=[])
        self.fields['COMPORT'] = nacc.uds3.Field(name='COMPORT', typename='Num', position=(78, 80), length=3, inclusive_range=(0, 3), allowable_values=['0.0', '0.5', '1.0', '2.0', '3.0'], blanks=[])
        self.fields['CDRLANG'] = nacc.uds3.Field(name='CDRLANG', typename='Num', position=(82, 84), length=3, inclusive_range=(0, 3), allowable_values=['0.0', '0.5', '1.0', '2.0', '3.0'], blanks=[])


class FormB5(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['NPIQINF'] = nacc.uds3.Field(name='NPIQINF', typename='Num', position=(45, 45), length=1, inclusive_range=(1, 3), allowable_values=[], blanks=[])
        self.fields['NPIQINFX'] = nacc.uds3.Field(name='NPIQINFX', typename='Char', position=(47, 106), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 NPIQINF ne 3 (Other)'])
        self.fields['DEL'] = nacc.uds3.Field(name='DEL', typename='Num', position=(108, 108), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['DELSEV'] = nacc.uds3.Field(name='DELSEV', typename='Num', position=(110, 110), length=1, inclusive_range=(1, 3), allowable_values=['1', '2', '3', '9'], blanks=['Blank if Question 2a DEL ne 1 (Yes)'])
        self.fields['HALL'] = nacc.uds3.Field(name='HALL', typename='Num', position=(112, 112), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['HALLSEV'] = nacc.uds3.Field(name='HALLSEV', typename='Num', position=(114, 114), length=1, inclusive_range=(1, 3), allowable_values=['1', '2', '3', '9'], blanks=['Blank if Question 3a HALL ne 1 (Yes)'])
        self.fields['AGIT'] = nacc.uds3.Field(name='AGIT', typename='Num', position=(116, 116), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['AGITSEV'] = nacc.uds3.Field(name='AGITSEV', typename='Num', position=(118, 118), length=1, inclusive_range=(1, 3), allowable_values=['9'], blanks=['Blank if Question 4a AGIT ne 1 (Yes)'])
        self.fields['DEPD'] = nacc.uds3.Field(name='DEPD', typename='Num', position=(120, 120), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=[])
        self.fields['DEPDSEV'] = nacc.uds3.Field(name='DEPDSEV', typename='Num', position=(122, 122), length=1, inclusive_range=(1, 3), allowable_values=['9'], blanks=['Blank if Question 5a DEPD ne 1 (Yes)'])
        self.fields['ANX'] = nacc.uds3.Field(name='ANX', typename='Num', position=(124, 124), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=[])
        self.fields['ANXSEV'] = nacc.uds3.Field(name='ANXSEV', typename='Num', position=(126, 126), length=1, inclusive_range=(1, 3), allowable_values=['9'], blanks=['Blank if Question 6a ANX ne 1 (Yes)'])
        self.fields['ELAT'] = nacc.uds3.Field(name='ELAT', typename='Num', position=(128, 128), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=[])
        self.fields['ELATSEV'] = nacc.uds3.Field(name='ELATSEV', typename='Num', position=(130, 130), length=1, inclusive_range=(1, 3), allowable_values=['9'], blanks=['Blank if Question 7a ELAT ne 1 (Yes)'])
        self.fields['APA'] = nacc.uds3.Field(name='APA', typename='Num', position=(132, 132), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=[])
        self.fields['APASEV'] = nacc.uds3.Field(name='APASEV', typename='Num', position=(134, 134), length=1, inclusive_range=(1, 3), allowable_values=['9'], blanks=['Blank if Question 8a APA ne 1 (Yes)'])
        self.fields['DISN'] = nacc.uds3.Field(name='DISN', typename='Num', position=(136, 136), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=[])
        self.fields['DISNSEV'] = nacc.uds3.Field(name='DISNSEV', typename='Num', position=(138, 138), length=1, inclusive_range=(1, 3), allowable_values=['9'], blanks=['Blank if Question 9a DISN ne 1 (Yes)'])
        self.fields['IRR'] = nacc.uds3.Field(name='IRR', typename='Num', position=(140, 140), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=[])
        self.fields['IRRSEV'] = nacc.uds3.Field(name='IRRSEV', typename='Num', position=(142, 142), length=1, inclusive_range=(1, 3), allowable_values=['9'], blanks=['Blank if Question 10a IRR ne 1 (Yes)'])
        self.fields['MOT'] = nacc.uds3.Field(name='MOT', typename='Num', position=(144, 144), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=[])
        self.fields['MOTSEV'] = nacc.uds3.Field(name='MOTSEV', typename='Num', position=(146, 146), length=1, inclusive_range=(1, 3), allowable_values=['9'], blanks=['Blank if Question 11a MOT ne 1 (Yes)'])
        self.fields['NITE'] = nacc.uds3.Field(name='NITE', typename='Num', position=(148, 148), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=[])
        self.fields['NITESEV'] = nacc.uds3.Field(name='NITESEV', typename='Num', position=(150, 150), length=1, inclusive_range=(1, 3), allowable_values=['9'], blanks=['Blank if Question 12a NITE ne 1 (Yes)'])
        self.fields['APP'] = nacc.uds3.Field(name='APP', typename='Num', position=(152, 152), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=[])
        self.fields['APPSEV'] = nacc.uds3.Field(name='APPSEV', typename='Num', position=(154, 154), length=1, inclusive_range=(1, 3), allowable_values=['9'], blanks=['Blank if Question 13a APP ne 1 (Yes)'])


class FormB7(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['BILLS'] = nacc.uds3.Field(name='BILLS', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=[])
        self.fields['TAXES'] = nacc.uds3.Field(name='TAXES', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=[])
        self.fields['SHOPPING'] = nacc.uds3.Field(name='SHOPPING', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=[])
        self.fields['GAMES'] = nacc.uds3.Field(name='GAMES', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=[])
        self.fields['STOVE'] = nacc.uds3.Field(name='STOVE', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=[])
        self.fields['MEALPREP'] = nacc.uds3.Field(name='MEALPREP', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=[])
        self.fields['EVENTS'] = nacc.uds3.Field(name='EVENTS', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=[])
        self.fields['PAYATTN'] = nacc.uds3.Field(name='PAYATTN', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=[])
        self.fields['REMDATES'] = nacc.uds3.Field(name='REMDATES', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=[])
        self.fields['TRAVEL'] = nacc.uds3.Field(name='TRAVEL', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=[])


class FormB9(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['DECSUB'] = nacc.uds3.Field(name='DECSUB', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['1', '0', '8'], blanks=[])
        self.fields['DECIN'] = nacc.uds3.Field(name='DECIN', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['1', '0', '8'], blanks=[])
        self.fields['DECCLCOG'] = nacc.uds3.Field(name='DECCLCOG', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['COGMEM'] = nacc.uds3.Field(name='COGMEM', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['1', '0', '9'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGORI'] = nacc.uds3.Field(name='COGORI', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['1', '0', '9'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGJUDG'] = nacc.uds3.Field(name='COGJUDG', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['1', '0', '9'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGLANG'] = nacc.uds3.Field(name='COGLANG', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['1', '0', '9'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGVIS'] = nacc.uds3.Field(name='COGVIS', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['1', '0', '9'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGATTN'] = nacc.uds3.Field(name='COGATTN', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['1', '0', '9'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGFLUC'] = nacc.uds3.Field(name='COGFLUC', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['1', '0', '9'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGFLAGO'] = nacc.uds3.Field(name='COGFLAGO', typename='Num', position=(65, 67), length=3, inclusive_range=(15, 110), allowable_values=['777'], blanks=['Blank if Question 4g COGFLUC ne 1 (Yes)'])
        self.fields['COGOTHR'] = nacc.uds3.Field(name='COGOTHR', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=[], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGOTHRX'] = nacc.uds3.Field(name='COGOTHRX', typename='Char', position=(71, 130), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 4h COGOTHR ne 1 (Yes)'])
        self.fields['COGFPRED'] = nacc.uds3.Field(name='COGFPRED', typename='Num', position=(132, 133), length=2, inclusive_range=(0, 8), allowable_values=['99'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGFPREX'] = nacc.uds3.Field(name='COGFPREX', typename='Char', position=(135, 194), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 5 COGFPRED ne 8 (Other)'])
        self.fields['COGMODE'] = nacc.uds3.Field(name='COGMODE', typename='Num', position=(196, 197), length=2, inclusive_range=(1, 4), allowable_values=['99'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGMODEX'] = nacc.uds3.Field(name='COGMODEX', typename='Char', position=(199, 258), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 6 COGMODE ne 4 (Other)'])
        self.fields['DECAGE'] = nacc.uds3.Field(name='DECAGE', typename='Num', position=(260, 262), length=3, inclusive_range=(15, 110), allowable_values=['777'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['DECCLBE'] = nacc.uds3.Field(name='DECCLBE', typename='Num', position=(264, 264), length=1, inclusive_range=(0, 1), allowable_values=[], blanks=[])
        self.fields['BEAPATHY'] = nacc.uds3.Field(name='BEAPATHY', typename='Num', position=(266, 266), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEDEP'] = nacc.uds3.Field(name='BEDEP', typename='Num', position=(268, 268), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEVHALL'] = nacc.uds3.Field(name='BEVHALL', typename='Num', position=(270, 270), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEVWELL'] = nacc.uds3.Field(name='BEVWELL', typename='Num', position=(272, 272), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)', 'Blank if Question 9c1 BEVHALL ne 1 (Yes)'])
        self.fields['BEVHAGO'] = nacc.uds3.Field(name='BEVHAGO', typename='Num', position=(274, 276), length=3, inclusive_range=(15, 110), allowable_values=['777', '888'], blanks=['Blank if Question 8 DECCLBE = 0 (No)', 'Blank if Question 9c1 BEVHALL ne 1 (Yes)'])
        self.fields['BEAHALL'] = nacc.uds3.Field(name='BEAHALL', typename='Num', position=(278, 278), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEDEL'] = nacc.uds3.Field(name='BEDEL', typename='Num', position=(280, 280), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEDISIN'] = nacc.uds3.Field(name='BEDISIN', typename='Num', position=(282, 282), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEIRRIT'] = nacc.uds3.Field(name='BEIRRIT', typename='Num', position=(284, 284), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEAGIT'] = nacc.uds3.Field(name='BEAGIT', typename='Num', position=(286, 286), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEPERCH'] = nacc.uds3.Field(name='BEPERCH', typename='Num', position=(288, 288), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEREM'] = nacc.uds3.Field(name='BEREM', typename='Num', position=(290, 290), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEREMAGO'] = nacc.uds3.Field(name='BEREMAGO', typename='Num', position=(292, 294), length=3, inclusive_range=(15, 110), allowable_values=['777'], blanks=['Blank if Question 9h BEREM ne 1 (Yes)'])
        self.fields['BEANX'] = nacc.uds3.Field(name='BEANX', typename='Num', position=(296, 296), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEOTHR'] = nacc.uds3.Field(name='BEOTHR', typename='Num', position=(298, 298), length=1, inclusive_range=(0, 1), allowable_values=[], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEOTHRX'] = nacc.uds3.Field(name='BEOTHRX', typename='Char', position=(300, 359), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 9j BEOTHR ne 1 (Yes)'])
        self.fields['BEFPRED'] = nacc.uds3.Field(name='BEFPRED', typename='Num', position=(361, 362), length=2, inclusive_range=(0, 10), allowable_values=['99'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEFPREDX'] = nacc.uds3.Field(name='BEFPREDX', typename='Char', position=(364, 423), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 10 BEFPRED ne 10 (Other)'])
        self.fields['BEMODE'] = nacc.uds3.Field(name='BEMODE', typename='Num', position=(425, 426), length=2, inclusive_range=(1, 4), allowable_values=['99'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEMODEX'] = nacc.uds3.Field(name='BEMODEX', typename='Char', position=(428, 487), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 11 BEMODE ne 4 (Other)'])
        self.fields['BEAGE'] = nacc.uds3.Field(name='BEAGE', typename='Num', position=(489, 491), length=3, inclusive_range=(15, 110), allowable_values=['777'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['DECCLMOT'] = nacc.uds3.Field(name='DECCLMOT', typename='Num', position=(493, 493), length=1, inclusive_range=(0, 1), allowable_values=[], blanks=['If Question 13 DECCLMOT = 0 (No) then skip to Question 20'])
        self.fields['MOGAIT'] = nacc.uds3.Field(name='MOGAIT', typename='Num', position=(495, 495), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOFALLS'] = nacc.uds3.Field(name='MOFALLS', typename='Num', position=(497, 497), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOTREM'] = nacc.uds3.Field(name='MOTREM', typename='Num', position=(499, 499), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOSLOW'] = nacc.uds3.Field(name='MOSLOW', typename='Num', position=(501, 501), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOFRST'] = nacc.uds3.Field(name='MOFRST', typename='Num', position=(503, 504), length=2, inclusive_range=(0, 4), allowable_values=['99'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOMODE'] = nacc.uds3.Field(name='MOMODE', typename='Num', position=(506, 507), length=2, inclusive_range=(0, 4), allowable_values=['99'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOMODEX'] = nacc.uds3.Field(name='MOMODEX', typename='Char', position=(509, 568), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 16 MOMODE ne 4 (Other)'])
        self.fields['MOMOPARK'] = nacc.uds3.Field(name='MOMOPARK', typename='Num', position=(570, 570), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['PARKAGE'] = nacc.uds3.Field(name='PARKAGE', typename='Num', position=(572, 574), length=3, inclusive_range=(15, 110), allowable_values=['777'], blanks=['Blank if Question 17 MOMOPARK ne 1 (Yes)'])
        self.fields['MOMOALS'] = nacc.uds3.Field(name='MOMOALS', typename='Num', position=(576, 576), length=1, inclusive_range=(0, 1), allowable_values=['9'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['ALSAGE'] = nacc.uds3.Field(name='ALSAGE', typename='Num', position=(578, 580), length=3, inclusive_range=(15, 110), allowable_values=['777'], blanks=['Blank if Question 18 MOMOALS ne 1 (Yes)'])
        self.fields['MOAGE'] = nacc.uds3.Field(name='MOAGE', typename='Num', position=(582, 584), length=3, inclusive_range=(15, 110), allowable_values=['777'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['COURSE'] = nacc.uds3.Field(name='COURSE', typename='Num', position=(586, 586), length=1, inclusive_range=(1, 5), allowable_values=['8', '9'], blanks=[])
        self.fields['FRSTCHG'] = nacc.uds3.Field(name='FRSTCHG', typename='Num', position=(588, 588), length=1, inclusive_range=(0, 3), allowable_values=['8', '9'], blanks=[])
        self.fields['LBDEVAL'] = nacc.uds3.Field(name='LBDEVAL', typename='Num', position=(590, 590), length=1, inclusive_range=(0, 1), allowable_values=[], blanks=[])
        self.fields['FTLDEVAL'] = nacc.uds3.Field(name='FTLDEVAL', typename='Num', position=(592, 592), length=1, inclusive_range=(0, 1), allowable_values=[], blanks=[])


class FormD1(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['DXMETHOD'] = nacc.uds3.Field(name='DXMETHOD', typename='Num', position=(45, 45), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=[])
        self.fields['NORMCOG'] = nacc.uds3.Field(name='NORMCOG', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['DEMENTED'] = nacc.uds3.Field(name='DEMENTED', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['AMNDEM'] = nacc.uds3.Field(name='AMNDEM', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['PCA'] = nacc.uds3.Field(name='PCA', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['PPASYN'] = nacc.uds3.Field(name='PPASYN', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['PPASYNT'] = nacc.uds3.Field(name='PPASYNT', typename='Num', position=(57, 57), length=1, inclusive_range=(1, 4), allowable_values=['3', '2', '1', '4'], blanks=['Blank if Question 4c PPASYN ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['FTDSYN'] = nacc.uds3.Field(name='FTDSYN', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['LBDSYN'] = nacc.uds3.Field(name='LBDSYN', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['NAMNDEM'] = nacc.uds3.Field(name='NAMNDEM', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['MCIAMEM'] = nacc.uds3.Field(name='MCIAMEM', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)'])
        self.fields['MCIAPLUS'] = nacc.uds3.Field(name='MCIAPLUS', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)'])
        self.fields['MCIAPLAN'] = nacc.uds3.Field(name='MCIAPLAN', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5b MCIAPLUS ne 1'])
        self.fields['MCIAPATT'] = nacc.uds3.Field(name='MCIAPATT', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5b MCIAPLUS ne 1'])
        self.fields['MCIAPEX'] = nacc.uds3.Field(name='MCIAPEX', typename='Num', position=(73, 73), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5b MCIAPLUS ne 1'])
        self.fields['MCIAPVIS'] = nacc.uds3.Field(name='MCIAPVIS', typename='Num', position=(75, 75), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5b MCIAPLUS ne 1'])
        self.fields['MCINON1'] = nacc.uds3.Field(name='MCINON1', typename='Num', position=(77, 77), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)'])
        self.fields['MCIN1LAN'] = nacc.uds3.Field(name='MCIN1LAN', typename='Num', position=(79, 79), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5c MCINON1 ne 1'])
        self.fields['MCIN1ATT'] = nacc.uds3.Field(name='MCIN1ATT', typename='Num', position=(81, 81), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5c MCINON1 ne 1'])
        self.fields['MCIN1EX'] = nacc.uds3.Field(name='MCIN1EX', typename='Num', position=(83, 83), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5c MCINON1 ne 1'])
        self.fields['MCIN1VIS'] = nacc.uds3.Field(name='MCIN1VIS', typename='Num', position=(85, 85), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5c MCINON1 ne 1'])
        self.fields['MCINON2'] = nacc.uds3.Field(name='MCINON2', typename='Num', position=(87, 87), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)'])
        self.fields['MCIN2LAN'] = nacc.uds3.Field(name='MCIN2LAN', typename='Num', position=(89, 89), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5d MCINON2 ne 1'])
        self.fields['MCIN2ATT'] = nacc.uds3.Field(name='MCIN2ATT', typename='Num', position=(91, 91), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5d MCINON2 ne 1'])
        self.fields['MCIN2EX'] = nacc.uds3.Field(name='MCIN2EX', typename='Num', position=(93, 93), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5d MCINON2 ne 1'])
        self.fields['MCIN2VIS'] = nacc.uds3.Field(name='MCIN2VIS', typename='Num', position=(95, 95), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5d MCINON2 ne 1'])
        self.fields['IMPNOMCI'] = nacc.uds3.Field(name='IMPNOMCI', typename='Num', position=(97, 97), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)'])
        self.fields['AMYLPET'] = nacc.uds3.Field(name='AMYLPET', typename='Num', position=(99, 99), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['AMYLCSF'] = nacc.uds3.Field(name='AMYLCSF', typename='Num', position=(101, 101), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['FDGAD'] = nacc.uds3.Field(name='FDGAD', typename='Num', position=(103, 103), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['HIPPATR'] = nacc.uds3.Field(name='HIPPATR', typename='Num', position=(105, 105), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['TAUPETAD'] = nacc.uds3.Field(name='TAUPETAD', typename='Num', position=(107, 107), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['CSFTAU'] = nacc.uds3.Field(name='CSFTAU', typename='Num', position=(109, 109), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['FDGFTLD'] = nacc.uds3.Field(name='FDGFTLD', typename='Num', position=(111, 111), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['TPETFTLD'] = nacc.uds3.Field(name='TPETFTLD', typename='Num', position=(113, 113), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['MRFTLD'] = nacc.uds3.Field(name='MRFTLD', typename='Num', position=(115, 115), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['DATSCAN'] = nacc.uds3.Field(name='DATSCAN', typename='Num', position=(117, 117), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['OTHBIOM'] = nacc.uds3.Field(name='OTHBIOM', typename='Num', position=(119, 119), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['OTHBIOMX'] = nacc.uds3.Field(name='OTHBIOMX', typename='Char', position=(121, 180), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 6k OTHBIOM = 0 (No)'])
        self.fields['IMAGLINF'] = nacc.uds3.Field(name='IMAGLINF', typename='Num', position=(182, 182), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['IMAGLAC'] = nacc.uds3.Field(name='IMAGLAC', typename='Num', position=(184, 184), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['IMAGMACH'] = nacc.uds3.Field(name='IMAGMACH', typename='Num', position=(186, 186), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['IMAGMICH'] = nacc.uds3.Field(name='IMAGMICH', typename='Num', position=(188, 188), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['IMAGMWMH'] = nacc.uds3.Field(name='IMAGMWMH', typename='Num', position=(190, 190), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['IMAGEWMH'] = nacc.uds3.Field(name='IMAGEWMH', typename='Num', position=(192, 192), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ADMUT'] = nacc.uds3.Field(name='ADMUT', typename='Num', position=(194, 194), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['FTLDMUT'] = nacc.uds3.Field(name='FTLDMUT', typename='Num', position=(196, 196), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['OTHMUT'] = nacc.uds3.Field(name='OTHMUT', typename='Num', position=(198, 198), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['OTHMUTX'] = nacc.uds3.Field(name='OTHMUTX', typename='Char', position=(200, 259), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 10 OTHMUT = 1 (Present)', 'Blank if Question 10 OTHMUT = 9'])
        self.fields['ALZDIS'] = nacc.uds3.Field(name='ALZDIS', typename='Num', position=(261, 261), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['ALZDISIF'] = nacc.uds3.Field(name='ALZDISIF', typename='Num', position=(263, 263), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 11 ALZDIS ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['LBDIS'] = nacc.uds3.Field(name='LBDIS', typename='Num', position=(265, 265), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['LBDIF'] = nacc.uds3.Field(name='LBDIF', typename='Num', position=(267, 267), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 12 LBDIS ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['PARK'] = nacc.uds3.Field(name='PARK', typename='Num', position=(269, 269), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 12 LBDIS ne 1 (Present)'])
        self.fields['MSA'] = nacc.uds3.Field(name='MSA', typename='Num', position=(271, 271), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['MSAIF'] = nacc.uds3.Field(name='MSAIF', typename='Num', position=(273, 273), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 13 MSA ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['PSP'] = nacc.uds3.Field(name='PSP', typename='Num', position=(275, 275), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['PSPIF'] = nacc.uds3.Field(name='PSPIF', typename='Num', position=(277, 277), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 14a PSP ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['CORT'] = nacc.uds3.Field(name='CORT', typename='Num', position=(279, 279), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['CORTIF'] = nacc.uds3.Field(name='CORTIF', typename='Num', position=(281, 281), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 14b CORT ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['FTLDMO'] = nacc.uds3.Field(name='FTLDMO', typename='Num', position=(283, 283), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['FTLDMOIF'] = nacc.uds3.Field(name='FTLDMOIF', typename='Num', position=(285, 285), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 14c FTLDMO ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['FTLDNOS'] = nacc.uds3.Field(name='FTLDNOS', typename='Num', position=(287, 287), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['FTLDNOIF'] = nacc.uds3.Field(name='FTLDNOIF', typename='Num', position=(289, 289), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 14d FTLDNOS ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['FTLDSUBT'] = nacc.uds3.Field(name='FTLDSUBT', typename='Num', position=(291, 291), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['if #14a PSP ne 1 and #14b CORT ne 1 and #14c FTLDMO ne 1 and 14d FTLDNOS ne 1'])
        self.fields['FTLDSUBX'] = nacc.uds3.Field(name='FTLDSUBX', typename='Char', position=(293, 352), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 14e FTLDSUBT ne 3'])
        self.fields['CVD'] = nacc.uds3.Field(name='CVD', typename='Num', position=(354, 354), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['CVDIF'] = nacc.uds3.Field(name='CVDIF', typename='Num', position=(356, 356), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 15 CVD ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['PREVSTK'] = nacc.uds3.Field(name='PREVSTK', typename='Num', position=(358, 358), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 15 CVD ne 1 (Present)'])
        self.fields['STROKDEC'] = nacc.uds3.Field(name='STROKDEC', typename='Num', position=(360, 360), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 15 CVD ne 1 (Present)', 'Blank if Question 15b PREVSTK ne 1 (Yes)'])
        self.fields['STKIMAG'] = nacc.uds3.Field(name='STKIMAG', typename='Num', position=(362, 362), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 15 CVD ne 1 (Present)', 'Blank if Question 15b PREVSTK ne 1 (Yes)'])
        self.fields['INFNETW'] = nacc.uds3.Field(name='INFNETW', typename='Num', position=(364, 364), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 15 CVD ne 1 (Present)'])
        self.fields['INFWMH'] = nacc.uds3.Field(name='INFWMH', typename='Num', position=(366, 366), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 15 CVD ne 1 (Present)'])
        self.fields['ESSTREM'] = nacc.uds3.Field(name='ESSTREM', typename='Num', position=(368, 368), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['ESSTREIF'] = nacc.uds3.Field(name='ESSTREIF', typename='Num', position=(370, 370), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 16 ESSTREM ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['DOWNS'] = nacc.uds3.Field(name='DOWNS', typename='Num', position=(372, 372), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['DOWNSIF'] = nacc.uds3.Field(name='DOWNSIF', typename='Num', position=(374, 374), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 17 DOWNS ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['HUNT'] = nacc.uds3.Field(name='HUNT', typename='Num', position=(376, 376), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['HUNTIF'] = nacc.uds3.Field(name='HUNTIF', typename='Num', position=(378, 378), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 18 HUNT ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['PRION'] = nacc.uds3.Field(name='PRION', typename='Num', position=(380, 380), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['PRIONIF'] = nacc.uds3.Field(name='PRIONIF', typename='Num', position=(382, 382), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 19 PRION ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['BRNINJ'] = nacc.uds3.Field(name='BRNINJ', typename='Num', position=(384, 384), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['BRNINJIF'] = nacc.uds3.Field(name='BRNINJIF', typename='Num', position=(386, 386), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 20 BRNINJ ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['BRNINCTE'] = nacc.uds3.Field(name='BRNINCTE', typename='Num', position=(388, 388), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 20 BRNINJ ne 1 (Present)'])
        self.fields['HYCEPH'] = nacc.uds3.Field(name='HYCEPH', typename='Num', position=(390, 390), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['HYCEPHIF'] = nacc.uds3.Field(name='HYCEPHIF', typename='Num', position=(392, 392), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 21 HYCEPH ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['EPILEP'] = nacc.uds3.Field(name='EPILEP', typename='Num', position=(394, 394), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['EPILEPIF'] = nacc.uds3.Field(name='EPILEPIF', typename='Num', position=(396, 396), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 22 EPILEP ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['NEOP'] = nacc.uds3.Field(name='NEOP', typename='Num', position=(398, 398), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['NEOPIF'] = nacc.uds3.Field(name='NEOPIF', typename='Num', position=(400, 400), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 23 NEOP ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['NEOPSTAT'] = nacc.uds3.Field(name='NEOPSTAT', typename='Num', position=(402, 402), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=['Blank if Question 23 NEOP ne 1 (Present)'])
        self.fields['HIV'] = nacc.uds3.Field(name='HIV', typename='Num', position=(404, 404), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['HIVIF'] = nacc.uds3.Field(name='HIVIF', typename='Num', position=(406, 406), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 24 HIV ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['OTHCOG'] = nacc.uds3.Field(name='OTHCOG', typename='Num', position=(408, 408), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['OTHCOGIF'] = nacc.uds3.Field(name='OTHCOGIF', typename='Num', position=(410, 410), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 25 OTHCOG ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['OTHCOGX'] = nacc.uds3.Field(name='OTHCOGX', typename='Char', position=(412, 471), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 25 OTHCOG ne 1 (Present)'])
        self.fields['DEP'] = nacc.uds3.Field(name='DEP', typename='Num', position=(473, 473), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['DEPIF'] = nacc.uds3.Field(name='DEPIF', typename='Num', position=(475, 475), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 26 DEP ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['DEPTREAT'] = nacc.uds3.Field(name='DEPTREAT', typename='Num', position=(477, 477), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 26 DEP ne 1 (Present)'])
        self.fields['BIPOLDX'] = nacc.uds3.Field(name='BIPOLDX', typename='Num', position=(479, 479), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['BIPOLDIF'] = nacc.uds3.Field(name='BIPOLDIF', typename='Num', position=(481, 481), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 27 BIPOLDX ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['SCHIZOP'] = nacc.uds3.Field(name='SCHIZOP', typename='Num', position=(483, 483), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['SCHIZOIF'] = nacc.uds3.Field(name='SCHIZOIF', typename='Num', position=(485, 485), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 28 SCHIZOP ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['ANXIET'] = nacc.uds3.Field(name='ANXIET', typename='Num', position=(487, 487), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['ANXIETIF'] = nacc.uds3.Field(name='ANXIETIF', typename='Num', position=(489, 489), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 29 ANXIET ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['DELIR'] = nacc.uds3.Field(name='DELIR', typename='Num', position=(491, 491), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['DELIRIF'] = nacc.uds3.Field(name='DELIRIF', typename='Num', position=(493, 493), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 30 DELIR ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['PTSDDX'] = nacc.uds3.Field(name='PTSDDX', typename='Num', position=(495, 495), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['PTSDDXIF'] = nacc.uds3.Field(name='PTSDDXIF', typename='Num', position=(497, 497), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 31 PTSDDX ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['OTHPSY'] = nacc.uds3.Field(name='OTHPSY', typename='Num', position=(499, 499), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['OTHPSYIF'] = nacc.uds3.Field(name='OTHPSYIF', typename='Num', position=(501, 501), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 32 OTHPSY ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['OTHPSYX'] = nacc.uds3.Field(name='OTHPSYX', typename='Char', position=(503, 562), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 32 OTHPSY ne 1 (Present)'])
        self.fields['ALCDEM'] = nacc.uds3.Field(name='ALCDEM', typename='Num', position=(564, 564), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['ALCDEMIF'] = nacc.uds3.Field(name='ALCDEMIF', typename='Num', position=(566, 566), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 33 ALCDEM ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['ALCABUSE'] = nacc.uds3.Field(name='ALCABUSE', typename='Num', position=(568, 568), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 33 ALCDEM ne 1 (Present)'])
        self.fields['IMPSUB'] = nacc.uds3.Field(name='IMPSUB', typename='Num', position=(570, 570), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['IMPSUBIF'] = nacc.uds3.Field(name='IMPSUBIF', typename='Num', position=(572, 572), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 34 IMPSUB ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['DYSILL'] = nacc.uds3.Field(name='DYSILL', typename='Num', position=(574, 574), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['DYSILLIF'] = nacc.uds3.Field(name='DYSILLIF', typename='Num', position=(576, 576), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 35 DYSILL ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['MEDS'] = nacc.uds3.Field(name='MEDS', typename='Num', position=(578, 578), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['MEDSIF'] = nacc.uds3.Field(name='MEDSIF', typename='Num', position=(580, 580), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 36 MEDS ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['COGOTH'] = nacc.uds3.Field(name='COGOTH', typename='Num', position=(582, 582), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['COGOTHIF'] = nacc.uds3.Field(name='COGOTHIF', typename='Num', position=(584, 584), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 37 COGOTH ne 1 (Present', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['COGOTHX'] = nacc.uds3.Field(name='COGOTHX', typename='Char', position=(586, 645), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 37 COGOTH ne 1 (Present)'])
        self.fields['COGOTH2'] = nacc.uds3.Field(name='COGOTH2', typename='Num', position=(647, 647), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['COGOTH2F'] = nacc.uds3.Field(name='COGOTH2F', typename='Num', position=(649, 649), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 38 COGOTH2 ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['COGOTH2X'] = nacc.uds3.Field(name='COGOTH2X', typename='Char', position=(651, 710), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 38 COGOTH2 ne 1 (Present)'])
        self.fields['COGOTH3'] = nacc.uds3.Field(name='COGOTH3', typename='Num', position=(712, 712), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['COGOTH3F'] = nacc.uds3.Field(name='COGOTH3F', typename='Num', position=(714, 714), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 39 COGOTH3 ne 1', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['COGOTH3X'] = nacc.uds3.Field(name='COGOTH3X', typename='Char', position=(716, 775), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 39 COGOTH3 ne 1'])


class FormD2(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['CANCER'] = nacc.uds3.Field(name='CANCER', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '8'], blanks=[])
        self.fields['CANCSITE'] = nacc.uds3.Field(name='CANCSITE', typename='Char', position=(47, 106), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 CANCER = 0 (No)', 'Blank if Question 1 CANCER = 8 (Not assessed)'])
        self.fields['DIABET'] = nacc.uds3.Field(name='DIABET', typename='Num', position=(108, 108), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '3'], blanks=[])
        self.fields['MYOINF'] = nacc.uds3.Field(name='MYOINF', typename='Num', position=(110, 110), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['CONGHRT'] = nacc.uds3.Field(name='CONGHRT', typename='Num', position=(112, 112), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['AFIBRILL'] = nacc.uds3.Field(name='AFIBRILL', typename='Num', position=(114, 114), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['HYPERT'] = nacc.uds3.Field(name='HYPERT', typename='Num', position=(116, 116), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ANGINA'] = nacc.uds3.Field(name='ANGINA', typename='Num', position=(118, 118), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['HYPCHOL'] = nacc.uds3.Field(name='HYPCHOL', typename='Num', position=(120, 120), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['VB12DEF'] = nacc.uds3.Field(name='VB12DEF', typename='Num', position=(122, 122), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['THYDIS'] = nacc.uds3.Field(name='THYDIS', typename='Num', position=(124, 124), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ARTH'] = nacc.uds3.Field(name='ARTH', typename='Num', position=(126, 126), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ARTYPE'] = nacc.uds3.Field(name='ARTYPE', typename='Num', position=(128, 128), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 11 ARTH = 0 (No)', 'Blank if Question 11 ARTH = 8 (Not assessed)'])
        self.fields['ARTYPEX'] = nacc.uds3.Field(name='ARTYPEX', typename='Char', position=(130, 189), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 11a ARTYPE ne 3 (Other)'])
        self.fields['ARTUPEX'] = nacc.uds3.Field(name='ARTUPEX', typename='Num', position=(191, 191), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 11 ARTH = 0 (No)', 'Blank if Question 11 ARTH = 8 (Not assessed)'])
        self.fields['ARTLOEX'] = nacc.uds3.Field(name='ARTLOEX', typename='Num', position=(193, 193), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 11 ARTH = 0 (No)', 'Blank if Question 11 ARTH = 8 (Not assessed)'])
        self.fields['ARTSPIN'] = nacc.uds3.Field(name='ARTSPIN', typename='Num', position=(195, 195), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 11 ARTH = 0 (No)', 'Blank if Question 11 ARTH = 8 (Not assessed)'])
        self.fields['ARTUNKN'] = nacc.uds3.Field(name='ARTUNKN', typename='Num', position=(197, 197), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 11 ARTH = 0 (No)', 'Blank if Question 11 ARTH = 8 (Not assessed)'])
        self.fields['URINEINC'] = nacc.uds3.Field(name='URINEINC', typename='Num', position=(199, 199), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['BOWLINC'] = nacc.uds3.Field(name='BOWLINC', typename='Num', position=(201, 201), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['SLEEPAP'] = nacc.uds3.Field(name='SLEEPAP', typename='Num', position=(203, 203), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['REMDIS'] = nacc.uds3.Field(name='REMDIS', typename='Num', position=(205, 205), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['HYPOSOM'] = nacc.uds3.Field(name='HYPOSOM', typename='Num', position=(207, 207), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['SLEEPOTH'] = nacc.uds3.Field(name='SLEEPOTH', typename='Num', position=(209, 209), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['SLEEPOTX'] = nacc.uds3.Field(name='SLEEPOTX', typename='Char', position=(211, 270), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 17 SLEEPOTH ne 1 (Yes)'])
        self.fields['ANGIOCP'] = nacc.uds3.Field(name='ANGIOCP', typename='Num', position=(272, 272), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ANGIOPCI'] = nacc.uds3.Field(name='ANGIOPCI', typename='Num', position=(274, 274), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['PACEMAKE'] = nacc.uds3.Field(name='PACEMAKE', typename='Num', position=(276, 276), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['HVALVE'] = nacc.uds3.Field(name='HVALVE', typename='Num', position=(278, 278), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ANTIENC'] = nacc.uds3.Field(name='ANTIENC', typename='Num', position=(280, 280), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ANTIENCX'] = nacc.uds3.Field(name='ANTIENCX', typename='Char', position=(282, 341), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 22 ANTIENC ne 1 (Yes)'])
        self.fields['OTHCOND'] = nacc.uds3.Field(name='OTHCOND', typename='Num', position=(343, 343), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['OTHCONDX'] = nacc.uds3.Field(name='OTHCONDX', typename='Char', position=(345, 404), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 23 OTHCOND ne 1 (Yes)'])


class FormZ1(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['A3SUB'] = nacc.uds3.Field(name='A3SUB', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['A3NOT'] = nacc.uds3.Field(name='A3NOT', typename='Num', position=(47, 48), length=2, inclusive_range=(95, 98), allowable_values=['98', '97', '96', '95'], blanks=['Blank if Question 4b A3SUB = 1 (Yes)'])
        self.fields['A3COMM'] = nacc.uds3.Field(name='A3COMM', typename='Char', position=(50, 109), length=60, inclusive_range=(), allowable_values=[], blanks=['Blank if Question 4b A3SUB = 1 (Yes)'])
        self.fields['A4SUB'] = nacc.uds3.Field(name='A4SUB', typename='Num', position=(111, 111), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['A4NOT'] = nacc.uds3.Field(name='A4NOT', typename='Num', position=(113, 114), length=2, inclusive_range=(95, 98), allowable_values=['98', '97', '96', '95'], blanks=['Blank if Question 5b A4SUB = 1 (Yes)'])
        self.fields['A4COMM'] = nacc.uds3.Field(name='A4COMM', typename='Char', position=(116, 175), length=60, inclusive_range=(), allowable_values=[], blanks=['Blank if Question 5b A4SUB = 1 (Yes)'])
        self.fields['B5SUB'] = nacc.uds3.Field(name='B5SUB', typename='Num', position=(177, 177), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['B5NOT'] = nacc.uds3.Field(name='B5NOT', typename='Num', position=(179, 180), length=2, inclusive_range=(95, 98), allowable_values=['98', '97', '96', '95'], blanks=['Blank if Question 7b B5SUB = 1 (Yes)'])
        self.fields['B5COMM'] = nacc.uds3.Field(name='B5COMM', typename='Char', position=(182, 241), length=60, inclusive_range=(), allowable_values=[], blanks=['Blank if Question 7b B5SUB = 1 (Yes)'])
        self.fields['B7SUB'] = nacc.uds3.Field(name='B7SUB', typename='Num', position=(243, 243), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['B7NOT'] = nacc.uds3.Field(name='B7NOT', typename='Num', position=(245, 246), length=2, inclusive_range=(95, 98), allowable_values=['98', '97', '96', '95'], blanks=['Blank if Question 8b B7SUB = 1 (Yes)'])
        self.fields['B7COMM'] = nacc.uds3.Field(name='B7COMM', typename='Char', position=(248, 307), length=60, inclusive_range=(), allowable_values=[], blanks=['Blank if Question 8b B7SUB = 1 (Yes)'])


class FormZ1X(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LANGT1'] = nacc.uds3.Field(name='LANGT1', typename='Num', position=(45, 45), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=[])
        self.fields['LANGA1'] = nacc.uds3.Field(name='LANGA1', typename='Num', position=(47, 47), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=[])
        self.fields['LANGA2'] = nacc.uds3.Field(name='LANGA2', typename='Num', position=(49, 49), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=[])
        self.fields['LANGA3'] = nacc.uds3.Field(name='LANGA3', typename='Num', position=(51, 51), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=['Blank if Question 4b A3SUB = 0 (No)'])
        self.fields['A3SUB'] = nacc.uds3.Field(name='A3SUB', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['A3NOT'] = nacc.uds3.Field(name='A3NOT', typename='Num', position=(55, 56), length=2, inclusive_range=(95, 98), allowable_values=['98', '97', '96', '95'], blanks=['Blank if Question 4b A3SUB = 1 (Yes)'])
        self.fields['LANGA4'] = nacc.uds3.Field(name='LANGA4', typename='Num', position=(58, 58), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 5b A4SUB = 0 (No)'])
        self.fields['A4SUB'] = nacc.uds3.Field(name='A4SUB', typename='Num', position=(60, 60), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['A4NOT'] = nacc.uds3.Field(name='A4NOT', typename='Num', position=(62, 63), length=2, inclusive_range=(95, 98), allowable_values=['98', '97', '96', '95'], blanks=['Blank if Question 5b A4SUB= 0 (No)'])
        self.fields['LANGB4'] = nacc.uds3.Field(name='LANGB4', typename='Num', position=(65, 65), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGB5'] = nacc.uds3.Field(name='LANGB5', typename='Num', position=(67, 67), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=['Blank if Question 7b B5SUB = 0 (No)'])
        self.fields['B5SUB'] = nacc.uds3.Field(name='B5SUB', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['B5NOT'] = nacc.uds3.Field(name='B5NOT', typename='Num', position=(71, 72), length=2, inclusive_range=(95, 98), allowable_values=['98', '97', '96', '95'], blanks=['Blank if Question 7b B5SUB = 1 (Yes)'])
        self.fields['LANGB7'] = nacc.uds3.Field(name='LANGB7', typename='Num', position=(74, 74), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=['Blank if Question 8b B7SUB = 0 (No)'])
        self.fields['B7SUB'] = nacc.uds3.Field(name='B7SUB', typename='Num', position=(76, 76), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['B7NOT'] = nacc.uds3.Field(name='B7NOT', typename='Num', position=(78, 79), length=2, inclusive_range=(95, 98), allowable_values=['98', '97', '96', '95'], blanks=['Blank if Question 8b B7SUB = 1 (Yes)'])
        self.fields['LANGB9'] = nacc.uds3.Field(name='LANGB9', typename='Num', position=(81, 81), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=[])
        self.fields['LANGD1'] = nacc.uds3.Field(name='LANGD1', typename='Num', position=(83, 83), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=[])
        self.fields['LANGD2'] = nacc.uds3.Field(name='LANGD2', typename='Num', position=(85, 85), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=[])
        self.fields['LANGCLS'] = nacc.uds3.Field(name='LANGCLS', typename='Num', position=(87, 87), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=['Blank if Question 12b CLSSUB = 0 (No)'])
        self.fields['CLSSUB'] = nacc.uds3.Field(name='CLSSUB', typename='Num', position=(89, 89), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
