###############################################################################
# Copyright 2015-2023 University of Florida. All rights reserved.
# This file is part of UF CTS-IT's NACCulator project.
# Use of this source code is governed by the license found in the LICENSE file.
###############################################################################

from nacc.uds3.np_11 import forms as np_forms
from nacc.uds3 import packet as np_packet


def build_uds3_np_form(record):
    """
    The Neuropath packet is a single form with a different format than UDS data
    """
    packet = np_packet.Packet()
    np = np_forms.FormNP()

    # If a project has both versions 10 and 11, then version 11
    # might have a suffix to the fieldnames
    try:
        np.NPFORMMO = record['npformmo_11']
        np.NPFORMDY = record['npformdy_11']
        np.NPFORMYR = record['npformyr_11']
        np.NPID = record['npid_11']
        np.NPSEX = record['npsex_11']
        np.NPDAGE = record['npdage_11']
        np.NPDODMO = record['npdodmo_11']
        np.NPDODDY = record['npdoddy_11']
        np.NPDODYR = record['npdodyr_11']
        np.NPPMIH = record['nppmih_11']
        np.NPFIX = record['npfix_11']
        np.NPFIXX = record['npfixx_11']
        np.NPWBRWT = record['npwbrwt_11']
        np.NPWBRF = record['npwbrf_11']
        np.NPGRCCA = record['npgrcca_11']
        np.NPGRLA = record['npgrla_11']
        np.NPGRHA = record['npgrha_11']
        np.NPGRSNH = record['npgrsnh_11']
        np.NPGRLCH = record['npgrlch_11']
        np.NPAVAS = record['npavas_11']
        np.NPTAN = record['nptan_11']
        np.NPTANX = record['nptanx_11']
        np.NPABAN = record['npaban_11']
        np.NPABANX = record['npabanx_11']
        np.NPASAN = record['npasan_11']
        np.NPASANX = record['npasanx_11']
        np.NPTDPAN = record['nptdpan_11']
        np.NPTDPANX = record['nptdpanx_11']
        np.NPHISMB = record['nphismb_11']
        np.NPHISG = record['nphisg_11']
        np.NPHISSS = record['nphisss_11']
        np.NPHIST = record['nphist_11']
        np.NPHISO = record['nphiso_11']
        np.NPHISOX = record['nphisox_11']
        np.NPTHAL = record['npthal_11']
        np.NPBRAAK = record['npbraak_11']
        np.NPNEUR = record['npneur_11']
        np.NPADNC = record['npadnc_11']
        np.NPDIFF = record['npdiff_11']
        np.NPAMY = record['npamy_11']
        np.NPINF = record['npinf_11']
        np.NPINF1A = record['npinf1a_11']
        np.NPINF1B = record['npinf1b_11']
        np.NPINF1D = record['npinf1d_11']
        np.NPINF1F = record['npinf1f_11']
        np.NPINF2A = record['npinf2a_11']
        np.NPINF2B = record['npinf2b_11']
        np.NPINF2D = record['npinf2d_11']
        np.NPINF2F = record['npinf2f_11']
        np.NPINF3A = record['npinf3a_11']
        np.NPINF3B = record['npinf3b_11']
        np.NPINF3D = record['npinf3d_11']
        np.NPINF3F = record['npinf3f_11']
        np.NPINF4A = record['npinf4a_11']
        np.NPINF4B = record['npinf4b_11']
        np.NPINF4D = record['npinf4d_11']
        np.NPINF4F = record['npinf4f_11']
        np.NPHEMO = record['nphemo_11']
        np.NPHEMO1 = record['nphemo1_11']
        np.NPHEMO2 = record['nphemo2_11']
        np.NPHEMO3 = record['nphemo3_11']
        np.NPOLD = record['npold_11']
        np.NPOLD1 = record['npold1_11']
        np.NPOLD2 = record['npold2_11']
        np.NPOLD3 = record['npold3_11']
        np.NPOLD4 = record['npold4_11']
        np.NPOLDD = record['npoldd_11']
        np.NPOLDD1 = record['npoldd1_11']
        np.NPOLDD2 = record['npoldd2_11']
        np.NPOLDD3 = record['npoldd3_11']
        np.NPOLDD4 = record['npoldd4_11']
        np.NPARTER = record['nparter_11']
        np.NPWMR = record['npwmr_11']
        np.NPPATH = record['nppath_11']
        np.NPNEC = record['npnec_11']
        np.NPPATH2 = record['nppath2_11']
        np.NPPATH3 = record['nppath3_11']
        np.NPPATH4 = record['nppath4_11']
        np.NPPATH5 = record['nppath5_11']
        np.NPPATH6 = record['nppath6_11']
        np.NPPATH7 = record['nppath7_11']
        np.NPPATH8 = record['nppath8_11']
        np.NPPATH9 = record['nppath9_11']
        np.NPPATH10 = record['nppath10_11']
        np.NPPATH11 = record['nppath11_11']
        np.NPPATHO = record['nppatho_11']
        np.NPPATHOX = record['nppathox_11']
        np.NPLBOD = record['nplbod_11']
        np.NPNLOSS = record['npnloss_11']
        np.NPHIPSCL = record['nphipscl_11']
        np.NPTDPA = record['nptdpa_11']
        np.NPTDPB = record['nptdpb_11']
        np.NPTDPC = record['nptdpc_11']
        np.NPTDPD = record['nptdpd_11']
        np.NPTDPE = record['nptdpe_11']
        np.NPFTDTAU = record['npftdtau_11']
        np.NPPICK = record['nppick_11']
        np.NPFTDT2 = record['npftdt2_11']
        np.NPCORT = record['npcort_11']
        np.NPPROG = record['npprog_11']
        np.NPFTDT5 = record['npftdt5_11']
        np.NPFTDT6 = record['npftdt6_11']
        np.NPFTDT7 = record['npftdt7_11']
        np.NPFTDT8 = record['npftdt8_11']
        np.NPFTDT9 = record['npftdt9_11']
        np.NPFTDT10 = record['npftdt10_11']
        np.NPFTDTDP = record['npftdtdp_11']
        np.NPALSMND = record['npalsmnd_11']
        np.NPOFTD = record['npoftd_11']
        np.NPOFTD1 = record['npoftd1_11']
        np.NPOFTD2 = record['npoftd2_11']
        np.NPOFTD3 = record['npoftd3_11']
        np.NPOFTD4 = record['npoftd4_11']
        np.NPOFTD5 = record['npoftd5_11']
        np.NPARTAG = record['npartag_11']
        np.NPATGSEV = record['npatgsev_11']
        np.NPATGAMY = record['npatgamy_11']
        np.NPATGAM1 = record['npatgam1_11']
        np.NPATGAM2 = record['npatgam2_11']
        np.NPATGAM3 = record['npatgam3_11']
        np.NPATGAM4 = record['npatgam4_11']
        np.NPATGAM5 = record['npatgam5_11']
        np.NPATGFRN = record['npatgfrn_11']
        np.NPATGFR1 = record['npatgfr1_11']
        np.NPATGFR2 = record['npatgfr2_11']
        np.NPATGFR3 = record['npatgfr3_11']
        np.NPATGFR4 = record['npatgfr4_11']
        np.NPPDXA = record['nppdxa_11']
        np.NPPDXB = record['nppdxb_11']
        np.NPPDXC = record['nppdxc_11']
        np.NPPDXD = record['nppdxd_11']
        np.NPPDXE = record['nppdxe_11']
        np.NPPDXF = record['nppdxf_11']
        np.NPPDXG = record['nppdxg_11']
        np.NPPDXH = record['nppdxh_11']
        np.NPPDXI = record['nppdxi_11']
        np.NPPDXJ = record['nppdxj_11']
        np.NPPDXK = record['nppdxk_11']
        np.NPPDXL = record['nppdxl_11']
        np.NPPDXM = record['nppdxm_11']
        np.NPPDXN = record['nppdxn_11']
        np.NPPDXO = record['nppdxo_11']
        np.NPPDXP = record['nppdxp_11']
        np.NPPDXQ = record['nppdxq_11']
        np.NPPDXR = record['nppdxr_11']
        np.NPPDXRX = record['nppdxrx_11']
        np.NPPDXS = record['nppdxs_11']
        np.NPPDXSX = record['nppdxsx_11']
        np.NPPDXT = record['nppdxt_11']
        np.NPPDXTX = record['nppdxtx_11']
        np.NPBNKA = record['npbnka_11']
        np.NPBNKB = record['npbnkb_11']
        np.NPBNKC = record['npbnkc_11']
        np.NPBNKD = record['npbnkd_11']
        np.NPBNKE = record['npbnke_11']
        np.NPBNKF = record['npbnkf_11']
        np.NPBNKG = record['npbnkg_11']
        np.NPFAUT = record['npfaut_11']
        np.NPFAUT1 = record['npfaut1_11']
        np.NPFAUT2 = record['npfaut2_11']
        np.NPFAUT3 = record['npfaut3_11']
        np.NPFAUT4 = record['npfaut4_11']

    except KeyError:
        np.NPFORMMO = record['npformmo']
        np.NPFORMDY = record['npformdy']
        np.NPFORMYR = record['npformyr']
        np.NPID = record['npid']
        np.NPSEX = record['npsex']
        np.NPDAGE = record['npdage']
        np.NPDODMO = record['npdodmo']
        np.NPDODDY = record['npdoddy']
        np.NPDODYR = record['npdodyr']
        np.NPPMIH = record['nppmih']
        np.NPFIX = record['npfix']
        np.NPFIXX = record['npfixx']
        np.NPWBRWT = record['npwbrwt']
        np.NPWBRF = record['npwbrf']
        np.NPGRCCA = record['npgrcca']
        np.NPGRLA = record['npgrla']
        np.NPGRHA = record['npgrha']
        np.NPGRSNH = record['npgrsnh']
        np.NPGRLCH = record['npgrlch']
        np.NPAVAS = record['npavas']
        np.NPTAN = record['nptan']
        np.NPTANX = record['nptanx']
        np.NPABAN = record['npaban']
        np.NPABANX = record['npabanx']
        np.NPASAN = record['npasan']
        np.NPASANX = record['npasanx']
        np.NPTDPAN = record['nptdpan']
        np.NPTDPANX = record['nptdpanx']
        np.NPHISMB = record['nphismb']
        np.NPHISG = record['nphisg']
        np.NPHISSS = record['nphisss']
        np.NPHIST = record['nphist']
        np.NPHISO = record['nphiso']
        np.NPHISOX = record['nphisox']
        np.NPTHAL = record['npthal']
        np.NPBRAAK = record['npbraak']
        np.NPNEUR = record['npneur']
        np.NPADNC = record['npadnc']
        np.NPDIFF = record['npdiff']
        np.NPAMY = record['npamy']
        np.NPINF = record['npinf']
        np.NPINF1A = record['npinf1a']
        np.NPINF1B = record['npinf1b']
        np.NPINF1D = record['npinf1d']
        np.NPINF1F = record['npinf1f']
        np.NPINF2A = record['npinf2a']
        np.NPINF2B = record['npinf2b']
        np.NPINF2D = record['npinf2d']
        np.NPINF2F = record['npinf2f']
        np.NPINF3A = record['npinf3a']
        np.NPINF3B = record['npinf3b']
        np.NPINF3D = record['npinf3d']
        np.NPINF3F = record['npinf3f']
        np.NPINF4A = record['npinf4a']
        np.NPINF4B = record['npinf4b']
        np.NPINF4D = record['npinf4d']
        np.NPINF4F = record['npinf4f']
        np.NPHEMO = record['nphemo']
        np.NPHEMO1 = record['nphemo1']
        np.NPHEMO2 = record['nphemo2']
        np.NPHEMO3 = record['nphemo3']
        np.NPOLD = record['npold']
        np.NPOLD1 = record['npold1']
        np.NPOLD2 = record['npold2']
        np.NPOLD3 = record['npold3']
        np.NPOLD4 = record['npold4']
        np.NPOLDD = record['npoldd']
        np.NPOLDD1 = record['npoldd1']
        np.NPOLDD2 = record['npoldd2']
        np.NPOLDD3 = record['npoldd3']
        np.NPOLDD4 = record['npoldd4']
        np.NPARTER = record['nparter']
        np.NPWMR = record['npwmr']
        np.NPPATH = record['nppath']
        np.NPNEC = record['npnec']
        np.NPPATH2 = record['nppath2']
        np.NPPATH3 = record['nppath3']
        np.NPPATH4 = record['nppath4']
        np.NPPATH5 = record['nppath5']
        np.NPPATH6 = record['nppath6']
        np.NPPATH7 = record['nppath7']
        np.NPPATH8 = record['nppath8']
        np.NPPATH9 = record['nppath9']
        np.NPPATH10 = record['nppath10']
        np.NPPATH11 = record['nppath11']
        np.NPPATHO = record['nppatho']
        np.NPPATHOX = record['nppathox']
        np.NPLBOD = record['nplbod']
        np.NPNLOSS = record['npnloss']
        np.NPHIPSCL = record['nphipscl']
        np.NPTDPA = record['nptdpa']
        np.NPTDPB = record['nptdpb']
        np.NPTDPC = record['nptdpc']
        np.NPTDPD = record['nptdpd']
        np.NPTDPE = record['nptdpe']
        np.NPFTDTAU = record['npftdtau']
        np.NPPICK = record['nppick']
        np.NPFTDT2 = record['npftdt2']
        np.NPCORT = record['npcort']
        np.NPPROG = record['npprog']
        np.NPFTDT5 = record['npftdt5']
        np.NPFTDT6 = record['npftdt6']
        np.NPFTDT7 = record['npftdt7']
        np.NPFTDT8 = record['npftdt8']
        np.NPFTDT9 = record['npftdt9']
        np.NPFTDT10 = record['npftdt10']
        np.NPFTDTDP = record['npftdtdp']
        np.NPALSMND = record['npalsmnd']
        np.NPOFTD = record['npoftd']
        np.NPOFTD1 = record['npoftd1']
        np.NPOFTD2 = record['npoftd2']
        np.NPOFTD3 = record['npoftd3']
        np.NPOFTD4 = record['npoftd4']
        np.NPOFTD5 = record['npoftd5']
        np.NPARTAG = record['npartag']
        np.NPATGSEV = record['npatgsev']
        np.NPATGAMY = record['npatgamy']
        np.NPATGAM1 = record['npatgam1']
        np.NPATGAM2 = record['npatgam2']
        np.NPATGAM3 = record['npatgam3']
        np.NPATGAM4 = record['npatgam4']
        np.NPATGAM5 = record['npatgam5']
        np.NPATGFRN = record['npatgfrn']
        np.NPATGFR1 = record['npatgfr1']
        np.NPATGFR2 = record['npatgfr2']
        np.NPATGFR3 = record['npatgfr3']
        np.NPATGFR4 = record['npatgfr4']
        np.NPPDXA = record['nppdxa']
        np.NPPDXB = record['nppdxb']
        np.NPPDXC = record['nppdxc']
        np.NPPDXD = record['nppdxd']
        np.NPPDXE = record['nppdxe']
        np.NPPDXF = record['nppdxf']
        np.NPPDXG = record['nppdxg']
        np.NPPDXH = record['nppdxh']
        np.NPPDXI = record['nppdxi']
        np.NPPDXJ = record['nppdxj']
        np.NPPDXK = record['nppdxk']
        np.NPPDXL = record['nppdxl']
        np.NPPDXM = record['nppdxm']
        np.NPPDXN = record['nppdxn']
        np.NPPDXO = record['nppdxo']
        np.NPPDXP = record['nppdxp']
        np.NPPDXQ = record['nppdxq']
        np.NPPDXR = record['nppdxr']
        np.NPPDXRX = record['nppdxrx']
        np.NPPDXS = record['nppdxs']
        np.NPPDXSX = record['nppdxsx']
        np.NPPDXT = record['nppdxt']
        np.NPPDXTX = record['nppdxtx']
        np.NPBNKA = record['npbnka']
        np.NPBNKB = record['npbnkb']
        np.NPBNKC = record['npbnkc']
        np.NPBNKD = record['npbnkd']
        np.NPBNKE = record['npbnke']
        np.NPBNKF = record['npbnkf']
        np.NPBNKG = record['npbnkg']
        np.NPFAUT = record['npfaut']
        np.NPFAUT1 = record['npfaut1']
        np.NPFAUT2 = record['npfaut2']
        np.NPFAUT3 = record['npfaut3']
        np.NPFAUT4 = record['npfaut4']

    packet.append(np)

    update_header(record, packet)
    return packet


def update_header(record, packet):
    for header in packet:
        header.FORMVER = 11
        header.ADCID = record['adcid']
        header.PTID = record['ptid']
