###############################################################################
# Copyright 2015-2023 University of Florida. All rights reserved.
# This file is part of UF CTS-IT's NACCulator project.
# Use of this source code is governed by the license found in the LICENSE file.
###############################################################################

import nacc.uds3

### BEGIN non-generated code
# WARNING: When generating new forms, do not overwrite this section
from datetime import date

# WARNING: When generating new forms, use CURRENT_YEAR instead of "2014"
# WARNING: When generating new forms, use CURRENT_YEAR-15 instead of "1999"
CURRENT_YEAR = date.today().year


class FormA4G(nacc.uds3.FieldBag):
    """ A4 is handled separately because it is a repeatable form """
    def __init__(self):
        self.fields = header_fields()
        self.fields['ANYMEDS'] = nacc.uds3.Field(name='ANYMEDS',
                                                 typename='Num',
                                                 position=(45, 45), length=1,
                                                 allowable_values=['0', '1'])

### END non-generated code

# This packet is for the UDS3 IVP (Initial Visit) forms


def header_fields():
    """
    Generates the header info that appears in columns 1-43 of every form
    """
    fields = {}
    fields['PACKET'] = nacc.uds3.Field(name='PACKET', typename='Char', position=(1, 2), length=2, inclusive_range=None, allowable_values=[], blanks=[])
    fields['FORMID'] = nacc.uds3.Field(name='FORMID', typename='Char', position=(4, 6), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    fields['FORMVER'] = nacc.uds3.Field(name='FORMVER', typename='Num', position=(8, 10), length=3, inclusive_range=(1, 3), allowable_values=['3.1'], blanks=[])
    fields['ADCID'] = nacc.uds3.Field(name='ADCID', typename='Num', position=(12, 13), length=2, inclusive_range=(2, 99), allowable_values=[], blanks=[])
    fields['PTID'] = nacc.uds3.Field(name='PTID', typename='Char', position=(15, 24), length=10, inclusive_range=None, allowable_values=[], blanks=[])
    fields['VISITMO'] = nacc.uds3.Field(name='VISITMO', typename='Num', position=(26, 27), length=2, inclusive_range=(1, 12), allowable_values=[], blanks=[])
    fields['VISITDAY'] = nacc.uds3.Field(name='VISITDAY', typename='Num', position=(29, 30), length=2, inclusive_range=(1, 31), allowable_values=[], blanks=[])
    fields['VISITYR'] = nacc.uds3.Field(name='VISITYR', typename='Num', position=(32, 35), length=4, inclusive_range=(2005, CURRENT_YEAR), allowable_values=[], blanks=[])
    fields['VISITNUM'] = nacc.uds3.Field(name='VISITNUM', typename='Char', position=(37, 39), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    fields['INITIALS'] = nacc.uds3.Field(name='INITIALS', typename='Char', position=(41, 43), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    return fields


class FormA1(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['REASON'] = nacc.uds3.Field(name='REASON', typename='Num', position=(45, 45), length=1, inclusive_range=(1, 4), allowable_values=['4', '2', '1', '9'], blanks=[])
        self.fields['REFERSC'] = nacc.uds3.Field(name='REFERSC', typename='Num', position=(47, 47), length=1, inclusive_range=(1, 6), allowable_values=['8', '9', '3', '2', '1', '6', '5', '4'], blanks=[])
        self.fields['LEARNED'] = nacc.uds3.Field(name='LEARNED', typename='Num', position=(49, 49), length=1, inclusive_range=(1, 4), allowable_values=['3', '2', '1', '9', '8', '4'], blanks=['Blank if Question 2a REFERSC ne 1', 'Blank if Question 2a REFERSC ne 2'])
        self.fields['PRESTAT'] = nacc.uds3.Field(name='PRESTAT', typename='Num', position=(51, 51), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=[])
        self.fields['PRESPART'] = nacc.uds3.Field(name='PRESPART', typename='Num', position=(53, 53), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=[])
        self.fields['SOURCENW'] = nacc.uds3.Field(name='SOURCENW', typename='Num', position=(55, 55), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=[])
        self.fields['BIRTHMO'] = nacc.uds3.Field(name='BIRTHMO', typename='Num', position=(57, 58), length=2, inclusive_range=(1, 12), allowable_values=[], blanks=[])
        self.fields['BIRTHYR'] = nacc.uds3.Field(name='BIRTHYR', typename='Num', position=(60, 63), length=4, inclusive_range=(1875, CURRENT_YEAR-15), allowable_values=[], blanks=[])
        self.fields['SEX'] = nacc.uds3.Field(name='SEX', typename='Num', position=(65, 65), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=[])
        self.fields['HISPANIC'] = nacc.uds3.Field(name='HISPANIC', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['HISPOR'] = nacc.uds3.Field(name='HISPOR', typename='Num', position=(69, 70), length=2, inclusive_range=(1, 6), allowable_values=['50', '99', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 8 HISPANIC ne 1 (Yes)'])
        self.fields['HISPORX'] = nacc.uds3.Field(name='HISPORX', typename='Char', position=(72, 131), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 8 HISPANIC ne 1 (Yes)', 'Blank if Question 8a HISPOR ne 50 (Other)'])
        self.fields['RACE'] = nacc.uds3.Field(name='RACE', typename='Num', position=(133, 134), length=2, inclusive_range=(1, 5), allowable_values=['99', '3', '2', '1', '50', '5', '4'], blanks=[])
        self.fields['RACEX'] = nacc.uds3.Field(name='RACEX', typename='Char', position=(136, 195), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 9 RACE ne 50 (Other)'])
        self.fields['RACESEC'] = nacc.uds3.Field(name='RACESEC', typename='Num', position=(197, 198), length=2, inclusive_range=(1, 5), allowable_values=['88', '0', '99', '3', '2', '1', '50', '5', '4'], blanks=[])
        self.fields['RACESECX'] = nacc.uds3.Field(name='RACESECX', typename='Char', position=(200, 259), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 10 RACESEC ne 50 (Other)'])
        self.fields['RACETER'] = nacc.uds3.Field(name='RACETER', typename='Num', position=(261, 262), length=2, inclusive_range=(1, 5), allowable_values=['88', '99', '3', '2', '1', '50', '5', '4'], blanks=[])
        self.fields['RACETERX'] = nacc.uds3.Field(name='RACETERX', typename='Char', position=(264, 323), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 11 RACETER ne 50 (Other)'])
        self.fields['PRIMLANG'] = nacc.uds3.Field(name='PRIMLANG', typename='Num', position=(325, 325), length=1, inclusive_range=(1, 6), allowable_values=['8', '9', '3', '2', '1', '6', '5', '4'], blanks=[])
        self.fields['PRIMLANX'] = nacc.uds3.Field(name='PRIMLANX', typename='Char', position=(327, 386), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 12 PRIMLANG ne 8 (Other)'])
        self.fields['EDUC'] = nacc.uds3.Field(name='EDUC', typename='Num', position=(388, 389), length=2, inclusive_range=(0, 36), allowable_values=['99'], blanks=[])
        self.fields['MARISTAT'] = nacc.uds3.Field(name='MARISTAT', typename='Num', position=(391, 391), length=1, inclusive_range=(1, 6), allowable_values=['9', '3', '2', '1', '6', '5', '4'], blanks=[])
        self.fields['LIVSITUA'] = nacc.uds3.Field(name='LIVSITUA', typename='Num', position=(393, 393), length=1, inclusive_range=(1, 6), allowable_values=['9', '3', '2', '1', '6', '5', '4'], blanks=[])
        self.fields['INDEPEND'] = nacc.uds3.Field(name='INDEPEND', typename='Num', position=(395, 395), length=1, inclusive_range=(1, 4), allowable_values=['3', '2', '1', '9', '4'], blanks=[])
        self.fields['RESIDENC'] = nacc.uds3.Field(name='RESIDENC', typename='Num', position=(397, 397), length=1, inclusive_range=(1, 4), allowable_values=['3', '2', '1', '9', '4'], blanks=[])
        self.fields['ZIP'] = nacc.uds3.Field(name='ZIP', typename='Char', position=(399, 401), length=3, inclusive_range=(6, 999), allowable_values=[], blanks=['Blank if Question 18 ZIP is unknown'])
        self.fields['HANDED'] = nacc.uds3.Field(name='HANDED', typename='Num', position=(403, 403), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=[])


class FormA2(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['INBIRMO'] = nacc.uds3.Field(name='INBIRMO', typename='Num', position=(45, 46), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=[])
        self.fields['INBIRYR'] = nacc.uds3.Field(name='INBIRYR', typename='Num', position=(48, 51), length=4, inclusive_range=(1875, CURRENT_YEAR-15), allowable_values=['9999'], blanks=[])
        self.fields['INSEX'] = nacc.uds3.Field(name='INSEX', typename='Num', position=(53, 53), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=[])
        self.fields['INHISP'] = nacc.uds3.Field(name='INHISP', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['INHISPOR'] = nacc.uds3.Field(name='INHISPOR', typename='Num', position=(57, 58), length=2, inclusive_range=(1, 6), allowable_values=['50', '99', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 3 INHISP ne 1 (Yes)'])
        self.fields['INHISPOX'] = nacc.uds3.Field(name='INHISPOX', typename='Char', position=(60, 119), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3a INHISPOR ne 50 (Other)'])
        self.fields['INRACE'] = nacc.uds3.Field(name='INRACE', typename='Num', position=(121, 122), length=2, inclusive_range=(1, 5), allowable_values=['99', '3', '2', '1', '50', '5', '4'], blanks=[])
        self.fields['INRACEX'] = nacc.uds3.Field(name='INRACEX', typename='Char', position=(124, 183), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 4 INRACE ne 50 (Other)'])
        self.fields['INRASEC'] = nacc.uds3.Field(name='INRASEC', typename='Num', position=(185, 186), length=2, inclusive_range=(1, 5), allowable_values=['88', '99', '3', '2', '1', '50', '5', '4'], blanks=[])
        self.fields['INRASECX'] = nacc.uds3.Field(name='INRASECX', typename='Char', position=(188, 247), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 5 INRASEC ne 50 (Other)'])
        self.fields['INRATER'] = nacc.uds3.Field(name='INRATER', typename='Num', position=(249, 250), length=2, inclusive_range=(1, 5), allowable_values=['88', '99', '3', '2', '1', '50', '5', '4'], blanks=[])
        self.fields['INRATERX'] = nacc.uds3.Field(name='INRATERX', typename='Char', position=(252, 311), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 6 INRATER ne 50 (Other)'])
        self.fields['INEDUC'] = nacc.uds3.Field(name='INEDUC', typename='Num', position=(313, 314), length=2, inclusive_range=(0, 36), allowable_values=['99'], blanks=[])
        self.fields['INRELTO'] = nacc.uds3.Field(name='INRELTO', typename='Num', position=(316, 316), length=1, inclusive_range=(1, 6), allowable_values=['3', '2', '1', '6', '5', '4'], blanks=[])
        self.fields['INKNOWN'] = nacc.uds3.Field(name='INKNOWN', typename='Num', position=(318, 320), length=3, inclusive_range=(0, 120), allowable_values=['999'], blanks=[])
        self.fields['INLIVWTH'] = nacc.uds3.Field(name='INLIVWTH', typename='Num', position=(322, 322), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['INVISITS'] = nacc.uds3.Field(name='INVISITS', typename='Num', position=(324, 324), length=1, inclusive_range=(1, 6), allowable_values=['3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 9 INLIVWTH = 1 (Yes)'])
        self.fields['INCALLS'] = nacc.uds3.Field(name='INCALLS', typename='Num', position=(326, 326), length=1, inclusive_range=(1, 6), allowable_values=['3', '2', '1', '6', '5', '5'], blanks=['Blank if Question 9 INLIVWTH = 1 (Yes)'])
        self.fields['INRELY'] = nacc.uds3.Field(name='INRELY', typename='Num', position=(328, 328), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])


class FormA3(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['AFFFAMM'] = nacc.uds3.Field(name='AFFFAMM', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['FADMUT'] = nacc.uds3.Field(name='FADMUT', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '8', '3'], blanks=[])
        self.fields['FADMUTX'] = nacc.uds3.Field(name='FADMUTX', typename='Char', position=(49, 108), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 2a FADMUT ne 8 (Other)'])
        self.fields['FADMUSO'] = nacc.uds3.Field(name='FADMUSO', typename='Num', position=(110, 110), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9', '8'], blanks=['Blank if Question 2a FADMUT = 0 (No)', 'Blank if Question 2a FADMUT = 9 (Unknown)'])
        self.fields['FADMUSOX'] = nacc.uds3.Field(name='FADMUSOX', typename='Char', position=(112, 171), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 2a FADMUT = 0 (No)', 'Blank if Question 2a FADMUT = 9 (Unknown)', 'Blank if Question 2b FADMUSO ne 8 (Other)'])
        self.fields['FFTDMUT'] = nacc.uds3.Field(name='FFTDMUT', typename='Num', position=(173, 173), length=1, inclusive_range=(0, 4), allowable_values=['9', '2', '1', '0', '8', '4', '3'], blanks=[])
        self.fields['FFTDMUTX'] = nacc.uds3.Field(name='FFTDMUTX', typename='Char', position=(175, 234), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3a FFTDMUT ne 8 (Other)'])
        self.fields['FFTDMUSO'] = nacc.uds3.Field(name='FFTDMUSO', typename='Num', position=(236, 236), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9', '8'], blanks=['Blank if Question 3a FFTDMUT = 0 (No)', 'Blank if Question 3a FFTDMUT = 9 (Unknown)'])
        self.fields['FFTDMUSX'] = nacc.uds3.Field(name='FFTDMUSX', typename='Char', position=(238, 297), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3a FFTDMUT = 0 (No)', 'Blank if Question 3a FFTDMUT = 9 (Unknown)', 'Blank if Question 3b FFTDMUSO ne 8 (Other)'])
        self.fields['FOTHMUT'] = nacc.uds3.Field(name='FOTHMUT', typename='Num', position=(299, 299), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['FOTHMUTX'] = nacc.uds3.Field(name='FOTHMUTX', typename='Char', position=(301, 360), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 4a FOTHMUT ne 1 (Yes)'])
        self.fields['FOTHMUSO'] = nacc.uds3.Field(name='FOTHMUSO', typename='Num', position=(362, 362), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9', '8'], blanks=['Blank if Question 4a FOTHMUT = 0 (No)', 'Blank if Question 4a FOTHMUT = 9 (Unknown)'])
        self.fields['FOTHMUSX'] = nacc.uds3.Field(name='FOTHMUSX', typename='Char', position=(364, 423), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 4a FOTHMUT = 0 (No)', 'Blank if Question 4a FOTHMUT = 9 (Unknown)', 'Blank if Question 4b FOTHMUSO ne 8 (Other)'])
        self.fields['MOMMOB'] = nacc.uds3.Field(name='MOMMOB', typename='Num', position=(425, 426), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=[])
        self.fields['MOMYOB'] = nacc.uds3.Field(name='MOMYOB', typename='Num', position=(428, 431), length=4, inclusive_range=(1850, CURRENT_YEAR), allowable_values=['9999'], blanks=[])
        self.fields['MOMDAGE'] = nacc.uds3.Field(name='MOMDAGE', typename='Num', position=(433, 435), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=[])
        self.fields['MOMNEUR'] = nacc.uds3.Field(name='MOMNEUR', typename='Num', position=(437, 437), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=[])
        self.fields['MOMPRDX'] = nacc.uds3.Field(name='MOMPRDX', typename='Num', position=(439, 441), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 5a4 MOMNEUR = 8 (N/A)', 'Blank if Question 5a4 MOMNEUR = 9 (Unknown)'])
        self.fields['MOMMOE'] = nacc.uds3.Field(name='MOMMOE', typename='Num', position=(443, 443), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 5a4 MOMNEUR = 8 (N/A)', 'Blank if Question 5a4 MOMNEUR = 9 (Unknown)'])
        self.fields['MOMAGEO'] = nacc.uds3.Field(name='MOMAGEO', typename='Num', position=(445, 447), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 5a4 MOMNEUR = 8 (N/A)', 'Blank if Question 5a4 MOMNEUR = 9 (Unknown)'])
        self.fields['DADMOB'] = nacc.uds3.Field(name='DADMOB', typename='Num', position=(449, 450), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=[])
        self.fields['DADYOB'] = nacc.uds3.Field(name='DADYOB', typename='Num', position=(452, 455), length=4, inclusive_range=(1850, CURRENT_YEAR), allowable_values=['9999'], blanks=[])
        self.fields['DADDAGE'] = nacc.uds3.Field(name='DADDAGE', typename='Num', position=(457, 459), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=[])
        self.fields['DADNEUR'] = nacc.uds3.Field(name='DADNEUR', typename='Num', position=(461, 461), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=[])
        self.fields['DADPRDX'] = nacc.uds3.Field(name='DADPRDX', typename='Num', position=(463, 465), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 5b4 DADNEUR = 8 (N/A)', 'Blank if Question 5b4 DADNEUR = 9 (Unknown)'])
        self.fields['DADMOE'] = nacc.uds3.Field(name='DADMOE', typename='Num', position=(467, 467), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 5b4 DADNEUR = 8 (N/A)', 'Blank if Question 5b4 DADNEUR = 9 (Unknown)'])
        self.fields['DADAGEO'] = nacc.uds3.Field(name='DADAGEO', typename='Num', position=(469, 471), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 5b4 DADNEUR = 8 (N/A)', 'Blank if Question 5b4 DADNEUR = 9 (Unknown)'])
        self.fields['SIBS'] = nacc.uds3.Field(name='SIBS', typename='Num', position=(473, 474), length=2, inclusive_range=(0, 20), allowable_values=['77'], blanks=[])
        self.fields['SIB1MOB'] = nacc.uds3.Field(name='SIB1MOB', typename='Num', position=(476, 477), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB1YOB'] = nacc.uds3.Field(name='SIB1YOB', typename='Num', position=(479, 482), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB1AGD'] = nacc.uds3.Field(name='SIB1AGD', typename='Num', position=(484, 486), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB1NEU'] = nacc.uds3.Field(name='SIB1NEU', typename='Num', position=(488, 488), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB1PDX'] = nacc.uds3.Field(name='SIB1PDX', typename='Num', position=(490, 492), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6a4 SIB1NEU = 8 (N/A)', 'Blank if Question 6a4 SIB1NEU = 9 (Unknown)'])
        self.fields['SIB1MOE'] = nacc.uds3.Field(name='SIB1MOE', typename='Num', position=(494, 494), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6a4 SIB1NEU = 8 (N/A)', 'Blank if Question 6a4 SIB1NEU = 9 (Unknown)'])
        self.fields['SIB1AGO'] = nacc.uds3.Field(name='SIB1AGO', typename='Num', position=(496, 498), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6a4 SIB1NEU = 8 (N/A)', 'Blank if Question 6a4 SIB1NEU = 9 (Unknown)'])
        self.fields['SIB2MOB'] = nacc.uds3.Field(name='SIB2MOB', typename='Num', position=(500, 501), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB2YOB'] = nacc.uds3.Field(name='SIB2YOB', typename='Num', position=(503, 506), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB2AGD'] = nacc.uds3.Field(name='SIB2AGD', typename='Num', position=(508, 510), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB2NEU'] = nacc.uds3.Field(name='SIB2NEU', typename='Num', position=(512, 512), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB2PDX'] = nacc.uds3.Field(name='SIB2PDX', typename='Num', position=(514, 516), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6b4 SIB2NEU = 8 (N/A)', 'Blank if Question 6b4 SIB2NEU = 9 (Unknown)'])
        self.fields['SIB2MOE'] = nacc.uds3.Field(name='SIB2MOE', typename='Num', position=(518, 518), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6b4 SIB2NEU = 8 (N/A)', 'Blank if Question 6b4 SIB2NEU = 9 (Unknown)'])
        self.fields['SIB2AGO'] = nacc.uds3.Field(name='SIB2AGO', typename='Num', position=(520, 522), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6b4 SIB2NEU = 8 (N/A)', 'Blank if Question 6b4 SIB2NEU = 9 (Unknown)'])
        self.fields['SIB3MOB'] = nacc.uds3.Field(name='SIB3MOB', typename='Num', position=(524, 525), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB3YOB'] = nacc.uds3.Field(name='SIB3YOB', typename='Num', position=(527, 530), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB3AGD'] = nacc.uds3.Field(name='SIB3AGD', typename='Num', position=(532, 534), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB3NEU'] = nacc.uds3.Field(name='SIB3NEU', typename='Num', position=(536, 536), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB3PDX'] = nacc.uds3.Field(name='SIB3PDX', typename='Num', position=(538, 540), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6c4 SIB3NEU = 8 (N/A)', 'Blank if Question 6c4 SIB3NEU = 9 (Unknown)'])
        self.fields['SIB3MOE'] = nacc.uds3.Field(name='SIB3MOE', typename='Num', position=(542, 542), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6c4 SIB3NEU = 8 (N/A)', 'Blank if Question 6c4 SIB3NEU = 9 (Unknown)'])
        self.fields['SIB3AGO'] = nacc.uds3.Field(name='SIB3AGO', typename='Num', position=(544, 546), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6c4 SIB3NEU = 8 (N/A)', 'Blank if Question 6c4 SIB3NEU = 9 (Unknown)'])
        self.fields['SIB4MOB'] = nacc.uds3.Field(name='SIB4MOB', typename='Num', position=(548, 549), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB4YOB'] = nacc.uds3.Field(name='SIB4YOB', typename='Num', position=(551, 554), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB4AGD'] = nacc.uds3.Field(name='SIB4AGD', typename='Num', position=(556, 558), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB4NEU'] = nacc.uds3.Field(name='SIB4NEU', typename='Num', position=(560, 560), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB4PDX'] = nacc.uds3.Field(name='SIB4PDX', typename='Num', position=(562, 564), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6d4 SIB4NEU = 8 (N/A)', 'Blank if Question 6d4 SIB4NEU = 9 (Unknown)'])
        self.fields['SIB4MOE'] = nacc.uds3.Field(name='SIB4MOE', typename='Num', position=(566, 566), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6d4 SIB4NEU = 8 (N/A)', 'Blank if Question 6d4 SIB4NEU = 9 (Unknown)'])
        self.fields['SIB4AGO'] = nacc.uds3.Field(name='SIB4AGO', typename='Num', position=(568, 570), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6d4 SIB4NEU = 8 (N/A)', 'Blank if Question 6d4 SIB4NEU = 9 (Unknown)'])
        self.fields['SIB5MOB'] = nacc.uds3.Field(name='SIB5MOB', typename='Num', position=(572, 573), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB5YOB'] = nacc.uds3.Field(name='SIB5YOB', typename='Num', position=(575, 578), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB5AGD'] = nacc.uds3.Field(name='SIB5AGD', typename='Num', position=(580, 582), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB5NEU'] = nacc.uds3.Field(name='SIB5NEU', typename='Num', position=(584, 584), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB5PDX'] = nacc.uds3.Field(name='SIB5PDX', typename='Num', position=(586, 588), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6e4 SIB5NEU = 8 (N/A)', 'Blank if Question 6e4 SIB5NEU = 9 (Unknown)'])
        self.fields['SIB5MOE'] = nacc.uds3.Field(name='SIB5MOE', typename='Num', position=(590, 590), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6e4 SIB5NEU = 8 (N/A)', 'Blank if Question 6e4 SIB5NEU = 9 (Unknown)'])
        self.fields['SIB5AGO'] = nacc.uds3.Field(name='SIB5AGO', typename='Num', position=(592, 594), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6e4 SIB5NEU = 8 (N/A)', 'Blank if Question 6e4 SIB5NEU = 9 (Unknown)'])
        self.fields['SIB6MOB'] = nacc.uds3.Field(name='SIB6MOB', typename='Num', position=(596, 597), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB6YOB'] = nacc.uds3.Field(name='SIB6YOB', typename='Num', position=(599, 602), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB6AGD'] = nacc.uds3.Field(name='SIB6AGD', typename='Num', position=(604, 606), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB6NEU'] = nacc.uds3.Field(name='SIB6NEU', typename='Num', position=(608, 608), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB6PDX'] = nacc.uds3.Field(name='SIB6PDX', typename='Num', position=(610, 612), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6f4 SIB6NEU = 8 (N/A)', 'Blank if Question 6f4 SIB6NEU = 9 (Unknown)'])
        self.fields['SIB6MOE'] = nacc.uds3.Field(name='SIB6MOE', typename='Num', position=(614, 614), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6f4 SIB6NEU = 8 (N/A)', 'Blank if Question 6f4 SIB6NEU = 9 (Unknown)'])
        self.fields['SIB6AGO'] = nacc.uds3.Field(name='SIB6AGO', typename='Num', position=(616, 618), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6f4 SIB6NEU = 8 (N/A)', 'Blank if Question 6f4 SIB6NEU = 9 (Unknown)'])
        self.fields['SIB7MOB'] = nacc.uds3.Field(name='SIB7MOB', typename='Num', position=(620, 621), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB7YOB'] = nacc.uds3.Field(name='SIB7YOB', typename='Num', position=(623, 626), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB7AGD'] = nacc.uds3.Field(name='SIB7AGD', typename='Num', position=(628, 630), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB7NEU'] = nacc.uds3.Field(name='SIB7NEU', typename='Num', position=(632, 632), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB7PDX'] = nacc.uds3.Field(name='SIB7PDX', typename='Num', position=(634, 636), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6g4 SIB7NEU = 8 (N/A)', 'Blank if Question 6g4 SIB7NEU = 9 (Unknown)'])
        self.fields['SIB7MOE'] = nacc.uds3.Field(name='SIB7MOE', typename='Num', position=(638, 638), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6g4 SIB7NEU = 8 (N/A)', 'Blank if Question 6g4 SIB7NEU = 9 (Unknown)'])
        self.fields['SIB7AGO'] = nacc.uds3.Field(name='SIB7AGO', typename='Num', position=(640, 642), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6g4 SIB7NEU = 8 (N/A)', 'Blank if Question 6g4 SIB7NEU = 9 (Unknown)'])
        self.fields['SIB8MOB'] = nacc.uds3.Field(name='SIB8MOB', typename='Num', position=(644, 645), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB8YOB'] = nacc.uds3.Field(name='SIB8YOB', typename='Num', position=(647, 650), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB8AGD'] = nacc.uds3.Field(name='SIB8AGD', typename='Num', position=(652, 654), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB8NEU'] = nacc.uds3.Field(name='SIB8NEU', typename='Num', position=(656, 656), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB8PDX'] = nacc.uds3.Field(name='SIB8PDX', typename='Num', position=(658, 660), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6h4 SIB8NEU = 8 (N/A)', 'Blank if Question 6h4 SIB8NEU = 9 (Unknown)'])
        self.fields['SIB8MOE'] = nacc.uds3.Field(name='SIB8MOE', typename='Num', position=(662, 662), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6h4 SIB8NEU = 8 (N/A)', 'Blank if Question 6h4 SIB8NEU = 9 (Unknown)'])
        self.fields['SIB8AGO'] = nacc.uds3.Field(name='SIB8AGO', typename='Num', position=(664, 666), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6h4 SIB8NEU = 8 (N/A)', 'Blank if Question 6h4 SIB8NEU = 9 (Unknown)'])
        self.fields['SIB9MOB'] = nacc.uds3.Field(name='SIB9MOB', typename='Num', position=(668, 669), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB9YOB'] = nacc.uds3.Field(name='SIB9YOB', typename='Num', position=(671, 674), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB9AGD'] = nacc.uds3.Field(name='SIB9AGD', typename='Num', position=(676, 678), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB9NEU'] = nacc.uds3.Field(name='SIB9NEU', typename='Num', position=(680, 680), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB9PDX'] = nacc.uds3.Field(name='SIB9PDX', typename='Num', position=(682, 684), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6i4 SIB9NEU = 8 (N/A)', 'Blank if Question 6i4 SIB9NEU = 9 (Unknown)'])
        self.fields['SIB9MOE'] = nacc.uds3.Field(name='SIB9MOE', typename='Num', position=(686, 686), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6i4 SIB9NEU = 8 (N/A)', 'Blank if Question 6i4 SIB9NEU = 9 (Unknown)'])
        self.fields['SIB9AGO'] = nacc.uds3.Field(name='SIB9AGO', typename='Num', position=(688, 690), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6i4 SIB9NEU = 8 (N/A)', 'Blank if Question 6i4 SIB9NEU = 9 (Unknown)'])
        self.fields['SIB10MOB'] = nacc.uds3.Field(name='SIB10MOB', typename='Num', position=(692, 693), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB10YOB'] = nacc.uds3.Field(name='SIB10YOB', typename='Num', position=(695, 698), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB10AGD'] = nacc.uds3.Field(name='SIB10AGD', typename='Num', position=(700, 702), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB10NEU'] = nacc.uds3.Field(name='SIB10NEU', typename='Num', position=(704, 704), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB10PDX'] = nacc.uds3.Field(name='SIB10PDX', typename='Num', position=(706, 708), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6j4 SIB10NEU = 8 (N/A)', 'Blank if Question 6j4 SIB10NEU = 9 (Unknown)'])
        self.fields['SIB10MOE'] = nacc.uds3.Field(name='SIB10MOE', typename='Num', position=(710, 710), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6j4 SIB10NEU = 8 (N/A)', 'Blank if Question 6j4 SIB10NEU = 9 (Unknown)'])
        self.fields['SIB10AGO'] = nacc.uds3.Field(name='SIB10AGO', typename='Num', position=(712, 714), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6j4 SIB10NEU = 8 (N/A)', 'Blank if Question 6j4 SIB10NEU = 9 (Unknown)'])
        self.fields['SIB11MOB'] = nacc.uds3.Field(name='SIB11MOB', typename='Num', position=(716, 717), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB11YOB'] = nacc.uds3.Field(name='SIB11YOB', typename='Num', position=(719, 722), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB11AGD'] = nacc.uds3.Field(name='SIB11AGD', typename='Num', position=(724, 726), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB11NEU'] = nacc.uds3.Field(name='SIB11NEU', typename='Num', position=(728, 728), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB11PDX'] = nacc.uds3.Field(name='SIB11PDX', typename='Num', position=(730, 732), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6k4 SIB11NEU = 8 (N/A)', 'Blank if Question 6k4 SIB11NEU = 9 (Unknown)'])
        self.fields['SIB11MOE'] = nacc.uds3.Field(name='SIB11MOE', typename='Num', position=(734, 734), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6k4 SIB11NEU = 8 (N/A)', 'Blank if Question 6k4 SIB11NEU = 9 (Unknown)'])
        self.fields['SIB11AGO'] = nacc.uds3.Field(name='SIB11AGO', typename='Num', position=(736, 738), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6k4 SIB11NEU = 8 (N/A)', 'Blank if Question 6k4 SIB11NEU = 9 (Unknown)'])
        self.fields['SIB12MOB'] = nacc.uds3.Field(name='SIB12MOB', typename='Num', position=(740, 741), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB12YOB'] = nacc.uds3.Field(name='SIB12YOB', typename='Num', position=(743, 746), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB12AGD'] = nacc.uds3.Field(name='SIB12AGD', typename='Num', position=(748, 750), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB12NEU'] = nacc.uds3.Field(name='SIB12NEU', typename='Num', position=(752, 752), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB12PDX'] = nacc.uds3.Field(name='SIB12PDX', typename='Num', position=(754, 756), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6l4 SIB12NEU = 8 (N/A)', 'Blank if Question 6l4 SIB12NEU = 9 (Unknown)'])
        self.fields['SIB12MOE'] = nacc.uds3.Field(name='SIB12MOE', typename='Num', position=(758, 758), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6l4 SIB12NEU = 8 (N/A)', 'Blank if Question 6l4 SIB12NEU = 9 (Unknown)'])
        self.fields['SIB12AGO'] = nacc.uds3.Field(name='SIB12AGO', typename='Num', position=(760, 762), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6l4 SIB12NEU = 8 (N/A)', 'Blank if Question 6l4 SIB12NEU = 9 (Unknown)'])
        self.fields['SIB13MOB'] = nacc.uds3.Field(name='SIB13MOB', typename='Num', position=(764, 765), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB13YOB'] = nacc.uds3.Field(name='SIB13YOB', typename='Num', position=(767, 770), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB13AGD'] = nacc.uds3.Field(name='SIB13AGD', typename='Num', position=(772, 774), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB13NEU'] = nacc.uds3.Field(name='SIB13NEU', typename='Num', position=(776, 776), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB13PDX'] = nacc.uds3.Field(name='SIB13PDX', typename='Num', position=(778, 780), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6m3 SIB13NEU = 8 (N/A)', 'Blank if Question 6m3 SIB13NEU = 9 (Unknown)'])
        self.fields['SIB13MOE'] = nacc.uds3.Field(name='SIB13MOE', typename='Num', position=(782, 782), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6m4 SIB13NEU = 8 (N/A)', 'Blank if Question 6m4 SIB13NEU = 9 (Unknown)'])
        self.fields['SIB13AGO'] = nacc.uds3.Field(name='SIB13AGO', typename='Num', position=(784, 786), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6m4 SIB13NEU = 8 (N/A)', 'Blank if Question 6m4 SIB13NEU = 9 (Unknown)'])
        self.fields['SIB14MOB'] = nacc.uds3.Field(name='SIB14MOB', typename='Num', position=(788, 789), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB14YOB'] = nacc.uds3.Field(name='SIB14YOB', typename='Num', position=(791, 794), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB14AGD'] = nacc.uds3.Field(name='SIB14AGD', typename='Num', position=(796, 798), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB14NEU'] = nacc.uds3.Field(name='SIB14NEU', typename='Num', position=(800, 800), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB14PDX'] = nacc.uds3.Field(name='SIB14PDX', typename='Num', position=(802, 804), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6n4 SIB14NEU = 8 (N/A)', 'Blank if Question 6n4 SIB14NEU = 9 (Unknown)'])
        self.fields['SIB14MOE'] = nacc.uds3.Field(name='SIB14MOE', typename='Num', position=(806, 806), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6n4 SIB14NEU = 8 (N/A)', 'Blank if Question 6n4 SIB14NEU = 9 (Unknown)'])
        self.fields['SIB14AGO'] = nacc.uds3.Field(name='SIB14AGO', typename='Num', position=(808, 810), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6n4 SIB14NEU = 8 (N/A)', 'Blank if Question 6n4 SIB14NEU = 9 (Unknown)'])
        self.fields['SIB15MOB'] = nacc.uds3.Field(name='SIB15MOB', typename='Num', position=(812, 813), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB15YOB'] = nacc.uds3.Field(name='SIB15YOB', typename='Num', position=(815, 818), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB15AGD'] = nacc.uds3.Field(name='SIB15AGD', typename='Num', position=(820, 822), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB15NEU'] = nacc.uds3.Field(name='SIB15NEU', typename='Num', position=(824, 824), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB15PDX'] = nacc.uds3.Field(name='SIB15PDX', typename='Num', position=(826, 828), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6o4 SIB15NEU = 8 (N/A)', 'Blank if Question 6o4 SIB15NEU = 9 (Unknown)'])
        self.fields['SIB15MOE'] = nacc.uds3.Field(name='SIB15MOE', typename='Num', position=(830, 830), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6o3 SIB15NEU = 8 (N/A)', 'Blank if Question 6o3 SIB15NEU = 9 (Unknown)'])
        self.fields['SIB15AGO'] = nacc.uds3.Field(name='SIB15AGO', typename='Num', position=(832, 834), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6o4 SIB15NEU = 8 (N/A)', 'Blank if Question 6o4 SIB15NEU = 9 (Unknown)'])
        self.fields['SIB16MOB'] = nacc.uds3.Field(name='SIB16MOB', typename='Num', position=(836, 837), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB16YOB'] = nacc.uds3.Field(name='SIB16YOB', typename='Num', position=(839, 842), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB16AGD'] = nacc.uds3.Field(name='SIB16AGD', typename='Num', position=(844, 846), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB16NEU'] = nacc.uds3.Field(name='SIB16NEU', typename='Num', position=(848, 848), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB16PDX'] = nacc.uds3.Field(name='SIB16PDX', typename='Num', position=(850, 852), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6p4 SIB16NEU = 8 (N/A)', 'Blank if Question 6p4 SIB16NEU = 9 (Unknown)'])
        self.fields['SIB16MOE'] = nacc.uds3.Field(name='SIB16MOE', typename='Num', position=(854, 854), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6p4 SIB16NEU = 8 (N/A)', 'Blank if Question 6p4 SIB16NEU = 9 (Unknown)'])
        self.fields['SIB16AGO'] = nacc.uds3.Field(name='SIB16AGO', typename='Num', position=(856, 858), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6p4 SIB16NEU = 8 (N/A)', 'Blank if Question 6p4 SIB16NEU = 9 (Unknown)'])
        self.fields['SIB17MOB'] = nacc.uds3.Field(name='SIB17MOB', typename='Num', position=(860, 861), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB17YOB'] = nacc.uds3.Field(name='SIB17YOB', typename='Num', position=(863, 866), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB17AGD'] = nacc.uds3.Field(name='SIB17AGD', typename='Num', position=(868, 870), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB17NEU'] = nacc.uds3.Field(name='SIB17NEU', typename='Num', position=(872, 872), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB17PDX'] = nacc.uds3.Field(name='SIB17PDX', typename='Num', position=(874, 876), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6q4 SIB17NEU = 8 (N/A)', 'Blank if Question 6q4 SIB17NEU = 9 (Unknown)'])
        self.fields['SIB17MOE'] = nacc.uds3.Field(name='SIB17MOE', typename='Num', position=(878, 878), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6q4 SIB17NEU = 8 (N/A)', 'Blank if Question 6q4 SIB17NEU = 9 (Unknown)'])
        self.fields['SIB17AGO'] = nacc.uds3.Field(name='SIB17AGO', typename='Num', position=(880, 882), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6q4 SIB17NEU = 8 (N/A)', 'Blank if Question 6q4 SIB17NEU = 9 (Unknown)'])
        self.fields['SIB18MOB'] = nacc.uds3.Field(name='SIB18MOB', typename='Num', position=(884, 885), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB18YOB'] = nacc.uds3.Field(name='SIB18YOB', typename='Num', position=(887, 890), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB18AGD'] = nacc.uds3.Field(name='SIB18AGD', typename='Num', position=(892, 894), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB18NEU'] = nacc.uds3.Field(name='SIB18NEU', typename='Num', position=(896, 896), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB18PDX'] = nacc.uds3.Field(name='SIB18PDX', typename='Num', position=(898, 900), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6r4 SIB18NEU = 8 (N/A)', 'Blank if Question 6r4 SIB18NEU = 9 (Unknown)'])
        self.fields['SIB18MOE'] = nacc.uds3.Field(name='SIB18MOE', typename='Num', position=(902, 902), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6r4 SIB18NEU = 8 (N/A)', 'Blank if Question 6r4 SIB18NEU = 9 (Unknown)'])
        self.fields['SIB18AGO'] = nacc.uds3.Field(name='SIB18AGO', typename='Num', position=(904, 906), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6r4 SIB18NEU = 8 (N/A)', 'Blank if Question 6r4 SIB18NEU = 9 (Unknown)'])
        self.fields['SIB19MOB'] = nacc.uds3.Field(name='SIB19MOB', typename='Num', position=(908, 909), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB19YOB'] = nacc.uds3.Field(name='SIB19YOB', typename='Num', position=(911, 914), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB19AGD'] = nacc.uds3.Field(name='SIB19AGD', typename='Num', position=(916, 918), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB19NEU'] = nacc.uds3.Field(name='SIB19NEU', typename='Num', position=(920, 920), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB19PDX'] = nacc.uds3.Field(name='SIB19PDX', typename='Num', position=(922, 924), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6s4 SIB19NEU = 8 (N/A)', 'Blank if Question 6s4 SIB19NEU = 9 (Unknown)'])
        self.fields['SIB19MOE'] = nacc.uds3.Field(name='SIB19MOE', typename='Num', position=(926, 926), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6s4 SIB19NEU = 8 (N/A)', 'Blank if Question 6s4 SIB19NEU = 9 (Unknown)'])
        self.fields['SIB19AGO'] = nacc.uds3.Field(name='SIB19AGO', typename='Num', position=(928, 930), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6s4 SIB19NEU = 8 (N/A)', 'Blank if Question 6s4 SIB19NEU = 9 (Unknown)'])
        self.fields['SIB20MOB'] = nacc.uds3.Field(name='SIB20MOB', typename='Num', position=(932, 933), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB20YOB'] = nacc.uds3.Field(name='SIB20YOB', typename='Num', position=(935, 938), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB20AGD'] = nacc.uds3.Field(name='SIB20AGD', typename='Num', position=(940, 942), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB20NEU'] = nacc.uds3.Field(name='SIB20NEU', typename='Num', position=(944, 944), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)'])
        self.fields['SIB20PDX'] = nacc.uds3.Field(name='SIB20PDX', typename='Num', position=(946, 948), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6t4 SIB20NEU = 8 (N/A)', 'Blank if Question 6t4 SIB20NEU = 9 (Unknown)'])
        self.fields['SIB20MOE'] = nacc.uds3.Field(name='SIB20MOE', typename='Num', position=(950, 950), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6t4 SIB20NEU = 8 (N/A)', 'Blank if Question 6t4 SIB20NEU = 9 (Unknown)'])
        self.fields['SIB20AGO'] = nacc.uds3.Field(name='SIB20AGO', typename='Num', position=(952, 954), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 6 SIBS = 0 (No)', 'Blank if Question 6 SIBS = 77 (Adopted, unknown)', 'Blank if Question 6t4 SIB20NEU = 8 (N/A)', 'Blank if Question 6t4 SIB20NEU = 9 (Unknown)'])
        self.fields['KIDS'] = nacc.uds3.Field(name='KIDS', typename='Num', position=(956, 957), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=[])
        self.fields['KID1MOB'] = nacc.uds3.Field(name='KID1MOB', typename='Num', position=(959, 960), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID1YOB'] = nacc.uds3.Field(name='KID1YOB', typename='Num', position=(962, 965), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID1AGD'] = nacc.uds3.Field(name='KID1AGD', typename='Num', position=(967, 969), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID1NEU'] = nacc.uds3.Field(name='KID1NEU', typename='Num', position=(971, 971), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID1PDX'] = nacc.uds3.Field(name='KID1PDX', typename='Num', position=(973, 975), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7a4 KID1NEU = 8 (N/A)', 'Blank if Question 7a4 KID1NEU = 9 (Unknown)'])
        self.fields['KID1MOE'] = nacc.uds3.Field(name='KID1MOE', typename='Num', position=(977, 977), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7a4 KID1NEU = 8 (N/A)', 'Blank if Question 7a4 KID1NEU = 9 (Unknown)'])
        self.fields['KID1AGO'] = nacc.uds3.Field(name='KID1AGO', typename='Num', position=(979, 981), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7a4 KID1NEU = 8 (N/A)', 'Blank if Question 7a4 KID1NEU = 9 (Unknown)'])
        self.fields['KID2MOB'] = nacc.uds3.Field(name='KID2MOB', typename='Num', position=(983, 984), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID2YOB'] = nacc.uds3.Field(name='KID2YOB', typename='Num', position=(986, 989), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID2AGD'] = nacc.uds3.Field(name='KID2AGD', typename='Num', position=(991, 993), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID2NEU'] = nacc.uds3.Field(name='KID2NEU', typename='Num', position=(995, 995), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID2PDX'] = nacc.uds3.Field(name='KID2PDX', typename='Num', position=(997, 999), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7b4 KID2NEU = 8 (N/A)', 'Blank if Question 7b4 KID2NEU = 9 (Unknown)'])
        self.fields['KID2MOE'] = nacc.uds3.Field(name='KID2MOE', typename='Num', position=(1001, 1001), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7b4 KID2NEU = 8 (N/A)', 'Blank if Question 7b4 KID2NEU = 9 (Unknown)'])
        self.fields['KID2AGO'] = nacc.uds3.Field(name='KID2AGO', typename='Num', position=(1003, 1005), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7b4 KID2NEU = 8 (N/A)', 'Blank if Question 7b4 KID2NEU = 9 (Unknown)'])
        self.fields['KID3MOB'] = nacc.uds3.Field(name='KID3MOB', typename='Num', position=(1007, 1008), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID3YOB'] = nacc.uds3.Field(name='KID3YOB', typename='Num', position=(1010, 1013), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID3AGD'] = nacc.uds3.Field(name='KID3AGD', typename='Num', position=(1015, 1017), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID3NEU'] = nacc.uds3.Field(name='KID3NEU', typename='Num', position=(1019, 1019), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID3PDX'] = nacc.uds3.Field(name='KID3PDX', typename='Num', position=(1021, 1023), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7c4 KID3NEU = 8 (N/A)', 'Blank if Question 7c4 KID3NEU = 9 (Unknown)'])
        self.fields['KID3MOE'] = nacc.uds3.Field(name='KID3MOE', typename='Num', position=(1025, 1025), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7c4 KID3NEU = 8 (N/A)', 'Blank if Question 7c4 KID3NEU = 9 (Unknown)'])
        self.fields['KID3AGO'] = nacc.uds3.Field(name='KID3AGO', typename='Num', position=(1027, 1029), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7c4 KID3NEU = 8 (N/A)', 'Blank if Question 7c4 KID3NEU = 9 (Unknown)'])
        self.fields['KID4MOB'] = nacc.uds3.Field(name='KID4MOB', typename='Num', position=(1031, 1032), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID4YOB'] = nacc.uds3.Field(name='KID4YOB', typename='Num', position=(1034, 1037), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID4AGD'] = nacc.uds3.Field(name='KID4AGD', typename='Num', position=(1039, 1041), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID4NEU'] = nacc.uds3.Field(name='KID4NEU', typename='Num', position=(1043, 1043), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID4PDX'] = nacc.uds3.Field(name='KID4PDX', typename='Num', position=(1045, 1047), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7d4 KID4NEU = 8 (N/A)', 'Blank if Question 7d4 KID4NEU = 9 (Unknown)'])
        self.fields['KID4MOE'] = nacc.uds3.Field(name='KID4MOE', typename='Num', position=(1049, 1049), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7d4 KID4NEU = 8 (N/A)', 'Blank if Question 7d4 KID4NEU = 9 (Unknown)'])
        self.fields['KID4AGO'] = nacc.uds3.Field(name='KID4AGO', typename='Num', position=(1051, 1053), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7d4 KID4NEU = 8 (N/A)', 'Blank if Question 7d4 KID4NEU = 9 (Unknown)'])
        self.fields['KID5MOB'] = nacc.uds3.Field(name='KID5MOB', typename='Num', position=(1055, 1056), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID5YOB'] = nacc.uds3.Field(name='KID5YOB', typename='Num', position=(1058, 1061), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID5AGD'] = nacc.uds3.Field(name='KID5AGD', typename='Num', position=(1063, 1065), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID5NEU'] = nacc.uds3.Field(name='KID5NEU', typename='Num', position=(1067, 1067), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID5PDX'] = nacc.uds3.Field(name='KID5PDX', typename='Num', position=(1069, 1071), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7e4 KID5NEU = 8 (N/A)', 'Blank if Question 7e4 KID5NEU = 9 (Unknown)'])
        self.fields['KID5MOE'] = nacc.uds3.Field(name='KID5MOE', typename='Num', position=(1073, 1073), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7e4 KID5NEU = 8 (N/A)', 'Blank if Question 7e4 KID5NEU = 9 (Unknown)'])
        self.fields['KID5AGO'] = nacc.uds3.Field(name='KID5AGO', typename='Num', position=(1075, 1077), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7e4 KID5NEU = 8 (N/A)', 'Blank if Question 7e4 KID5NEU = 9 (Unknown)'])
        self.fields['KID6MOB'] = nacc.uds3.Field(name='KID6MOB', typename='Num', position=(1079, 1080), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID6YOB'] = nacc.uds3.Field(name='KID6YOB', typename='Num', position=(1082, 1085), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID6AGD'] = nacc.uds3.Field(name='KID6AGD', typename='Num', position=(1087, 1089), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID6NEU'] = nacc.uds3.Field(name='KID6NEU', typename='Num', position=(1091, 1091), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID6PDX'] = nacc.uds3.Field(name='KID6PDX', typename='Num', position=(1093, 1095), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=[])
        self.fields['KID6MOE'] = nacc.uds3.Field(name='KID6MOE', typename='Num', position=(1097, 1097), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=[])
        self.fields['KID6AGO'] = nacc.uds3.Field(name='KID6AGO', typename='Num', position=(1099, 1101), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=[])
        self.fields['KID7MOB'] = nacc.uds3.Field(name='KID7MOB', typename='Num', position=(1103, 1104), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID7YOB'] = nacc.uds3.Field(name='KID7YOB', typename='Num', position=(1106, 1109), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID7AGD'] = nacc.uds3.Field(name='KID7AGD', typename='Num', position=(1111, 1113), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID7NEU'] = nacc.uds3.Field(name='KID7NEU', typename='Num', position=(1115, 1115), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID7PDX'] = nacc.uds3.Field(name='KID7PDX', typename='Num', position=(1117, 1119), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7g4 KID7NEU = 8 (N/A)', 'Blank if Question 7g4 KID7NEU = 9 (Unknown)'])
        self.fields['KID7MOE'] = nacc.uds3.Field(name='KID7MOE', typename='Num', position=(1121, 1121), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7g4 KID7NEU = 8 (N/A)', 'Blank if Question 7g4 KID7NEU = 9 (Unknown)'])
        self.fields['KID7AGO'] = nacc.uds3.Field(name='KID7AGO', typename='Num', position=(1123, 1125), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7g4 KID7NEU = 8 (N/A)', 'Blank if Question 7g4 KID7NEU = 9 (Unknown)'])
        self.fields['KID8MOB'] = nacc.uds3.Field(name='KID8MOB', typename='Num', position=(1127, 1128), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID8YOB'] = nacc.uds3.Field(name='KID8YOB', typename='Num', position=(1130, 1133), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID8AGD'] = nacc.uds3.Field(name='KID8AGD', typename='Num', position=(1135, 1137), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID8NEU'] = nacc.uds3.Field(name='KID8NEU', typename='Num', position=(1139, 1139), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID8PDX'] = nacc.uds3.Field(name='KID8PDX', typename='Num', position=(1141, 1143), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7h4 KID8NEU = 8 (N/A)', 'Blank if Question 7h4 KID8NEU = 9 (Unknown)'])
        self.fields['KID8MOE'] = nacc.uds3.Field(name='KID8MOE', typename='Num', position=(1145, 1145), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7h4 KID8NEU = 8 (N/A)', 'Blank if Question 7h4 KID8NEU = 9 (Unknown)'])
        self.fields['KID8AGO'] = nacc.uds3.Field(name='KID8AGO', typename='Num', position=(1147, 1149), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7h4 KID8NEU = 8 (N/A)', 'Blank if Question 7h4 KID8NEU = 9 (Unknown)'])
        self.fields['KID9MOB'] = nacc.uds3.Field(name='KID9MOB', typename='Num', position=(1151, 1152), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID9YOB'] = nacc.uds3.Field(name='KID9YOB', typename='Num', position=(1154, 1157), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID9AGD'] = nacc.uds3.Field(name='KID9AGD', typename='Num', position=(1159, 1161), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID9NEU'] = nacc.uds3.Field(name='KID9NEU', typename='Num', position=(1163, 1163), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID9PDX'] = nacc.uds3.Field(name='KID9PDX', typename='Num', position=(1165, 1167), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7i4 KID9NEU = 8 (N/A)', 'Blank if Question 7i4 KID9NEU = 9 (Unknown)'])
        self.fields['KID9MOE'] = nacc.uds3.Field(name='KID9MOE', typename='Num', position=(1169, 1169), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7i4 KID9NEU = 8 (N/A)', 'Blank if Question 7i4 KID9NEU = 9 (Unknown)'])
        self.fields['KID9AGO'] = nacc.uds3.Field(name='KID9AGO', typename='Num', position=(1171, 1173), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7i4 KID9NEU = 8 (N/A)', 'Blank if Question 7i4 KID9NEU = 9 (Unknown)'])
        self.fields['KID10MOB'] = nacc.uds3.Field(name='KID10MOB', typename='Num', position=(1175, 1176), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID10YOB'] = nacc.uds3.Field(name='KID10YOB', typename='Num', position=(1178, 1181), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID10AGD'] = nacc.uds3.Field(name='KID10AGD', typename='Num', position=(1183, 1185), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID10NEU'] = nacc.uds3.Field(name='KID10NEU', typename='Num', position=(1187, 1187), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID10PDX'] = nacc.uds3.Field(name='KID10PDX', typename='Num', position=(1189, 1191), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7j4 KID10NEU = 8 (N/A)', 'Blank if Question 7j4 KID10NEU = 9 (Unknown)'])
        self.fields['KID10MOE'] = nacc.uds3.Field(name='KID10MOE', typename='Num', position=(1193, 1193), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7j4 KID10NEU = 8 (N/A)', 'Blank if Question 7j4 KID10NEU = 9 (Unknown)'])
        self.fields['KID10AGO'] = nacc.uds3.Field(name='KID10AGO', typename='Num', position=(1195, 1197), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7j4 KID10NEU = 8 (N/A)', 'Blank if Question 7j4 KID10NEU = 9 (Unknown)'])
        self.fields['KID11MOB'] = nacc.uds3.Field(name='KID11MOB', typename='Num', position=(1199, 1200), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID11YOB'] = nacc.uds3.Field(name='KID11YOB', typename='Num', position=(1202, 1205), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID11AGD'] = nacc.uds3.Field(name='KID11AGD', typename='Num', position=(1207, 1209), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID11NEU'] = nacc.uds3.Field(name='KID11NEU', typename='Num', position=(1211, 1211), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID11PDX'] = nacc.uds3.Field(name='KID11PDX', typename='Num', position=(1213, 1215), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7k4 KID11NEU = 8 (N/A)', 'Blank if Question 7k4 KID11NEU = 9 (Unknown)'])
        self.fields['KID11MOE'] = nacc.uds3.Field(name='KID11MOE', typename='Num', position=(1217, 1217), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7k4 KID11NEU = 8 (N/A)', 'Blank if Question 7k4 KID11NEU = 9 (Unknown)'])
        self.fields['KID11AGO'] = nacc.uds3.Field(name='KID11AGO', typename='Num', position=(1219, 1221), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7k4 KID11NEU = 8 (N/A)', 'Blank if Question 7k4 KID11NEU = 9 (Unknown)'])
        self.fields['KID12MOB'] = nacc.uds3.Field(name='KID12MOB', typename='Num', position=(1223, 1224), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID12YOB'] = nacc.uds3.Field(name='KID12YOB', typename='Num', position=(1226, 1229), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID12AGD'] = nacc.uds3.Field(name='KID12AGD', typename='Num', position=(1231, 1233), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID12NEU'] = nacc.uds3.Field(name='KID12NEU', typename='Num', position=(1235, 1235), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID12PDX'] = nacc.uds3.Field(name='KID12PDX', typename='Num', position=(1237, 1239), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7l4 KID12NEU = 8 (N/A)', 'Blank if Question 7l4 KID12NEU = 9 (Unknown)'])
        self.fields['KID12MOE'] = nacc.uds3.Field(name='KID12MOE', typename='Num', position=(1241, 1241), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7l4 KID12NEU = 8 (N/A)', 'Blank if Question 7l4 KID12NEU = 9 (Unknown)'])
        self.fields['KID12AGO'] = nacc.uds3.Field(name='KID12AGO', typename='Num', position=(1243, 1245), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7l4 KID12NEU = 8 (N/A)', 'Blank if Question 7l4 KID12NEU = 9 (Unknown)'])
        self.fields['KID13MOB'] = nacc.uds3.Field(name='KID13MOB', typename='Num', position=(1247, 1248), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID13YOB'] = nacc.uds3.Field(name='KID13YOB', typename='Num', position=(1250, 1253), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID13AGD'] = nacc.uds3.Field(name='KID13AGD', typename='Num', position=(1255, 1257), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID13NEU'] = nacc.uds3.Field(name='KID13NEU', typename='Num', position=(1259, 1259), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID13PDX'] = nacc.uds3.Field(name='KID13PDX', typename='Num', position=(1261, 1263), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7m4 KID13NEU = 8 (N/A)', 'Blank if Question 7m4 KID13NEU = 9 (Unknown)'])
        self.fields['KID13MOE'] = nacc.uds3.Field(name='KID13MOE', typename='Num', position=(1265, 1265), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7m4 KID13NEU = 8 (N/A)', 'Blank if Question 7m4 KID13NEU = 9 (Unknown)'])
        self.fields['KID13AGO'] = nacc.uds3.Field(name='KID13AGO', typename='Num', position=(1267, 1269), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7m4 KID13NEU = 8 (N/A)', 'Blank if Question 7m4 KID13NEU = 9 (Unknown)'])
        self.fields['KID14MOB'] = nacc.uds3.Field(name='KID14MOB', typename='Num', position=(1271, 1272), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID14YOB'] = nacc.uds3.Field(name='KID14YOB', typename='Num', position=(1274, 1277), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID14AGD'] = nacc.uds3.Field(name='KID14AGD', typename='Num', position=(1279, 1281), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID14NEU'] = nacc.uds3.Field(name='KID14NEU', typename='Num', position=(1283, 1283), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID14PDX'] = nacc.uds3.Field(name='KID14PDX', typename='Num', position=(1285, 1287), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7n4 KID14NEU = 8 (N/A)', 'Blank if Question 7n4 KID14NEU = 9 (Unknown)'])
        self.fields['KID14MOE'] = nacc.uds3.Field(name='KID14MOE', typename='Num', position=(1289, 1289), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7n4 KID14NEU = 8 (N/A)', 'Blank if Question 7n4 KID14NEU = 9 (Unknown)'])
        self.fields['KID14AGO'] = nacc.uds3.Field(name='KID14AGO', typename='Num', position=(1291, 1293), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7n4 KID14NEU = 8 (N/A)', 'Blank if Question 7n4 KID14NEU = 9 (Unknown)'])
        self.fields['KID15MOB'] = nacc.uds3.Field(name='KID15MOB', typename='Num', position=(1295, 1296), length=2, inclusive_range=(1, 12), allowable_values=['99'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID15YOB'] = nacc.uds3.Field(name='KID15YOB', typename='Num', position=(1298, 1301), length=4, inclusive_range=(1875, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID15AGD'] = nacc.uds3.Field(name='KID15AGD', typename='Num', position=(1303, 1305), length=3, inclusive_range=(0, 110), allowable_values=['888', '999'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID15NEU'] = nacc.uds3.Field(name='KID15NEU', typename='Num', position=(1307, 1307), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)'])
        self.fields['KID15PDX'] = nacc.uds3.Field(name='KID15PDX', typename='Num', position=(1309, 1311), length=3, inclusive_range=(40, 490), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7o4 KID15NEU = 8 (N/A)', 'Blank if Question 7o4 KID15NEU = 9 (Unknown)'])
        self.fields['KID15MOE'] = nacc.uds3.Field(name='KID15MOE', typename='Num', position=(1313, 1313), length=1, inclusive_range=(1, 7), allowable_values=['7', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7o4 KID15NEU = 8 (N/A)', 'Blank if Question 7o4 KID15NEU = 9 (Unknown)'])
        self.fields['KID15AGO'] = nacc.uds3.Field(name='KID15AGO', typename='Num', position=(1315, 1317), length=3, inclusive_range=(0, 110), allowable_values=['999'], blanks=['Blank if Question 7 KIDS = 0 (No)', 'Blank if Question 7o4 KID15NEU = 8 (N/A)', 'Blank if Question 7o4 KID15NEU = 9 (Unknown)'])


class FormA4D(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['DRUGID'] = nacc.uds3.Field(name='DRUGID', typename='Char', position=(45, 50), length=6, inclusive_range=None, allowable_values=[], blanks=[])


class FormA5(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['TOBAC30'] = nacc.uds3.Field(name='TOBAC30', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['TOBAC100'] = nacc.uds3.Field(name='TOBAC100', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['SMOKYRS'] = nacc.uds3.Field(name='SMOKYRS', typename='Num', position=(49, 50), length=2, inclusive_range=(0, 87), allowable_values=['99'], blanks=['Blank if Question 1b TOBAC100 ne 1 (Yes)'])
        self.fields['PACKSPER'] = nacc.uds3.Field(name='PACKSPER', typename='Num', position=(52, 52), length=1, inclusive_range=(1, 5), allowable_values=['3', '2', '1', '9', '5', '4'], blanks=['Blank if Question 1b TOBAC100 ne 1 (Yes)'])
        self.fields['QUITSMOK'] = nacc.uds3.Field(name='QUITSMOK', typename='Num', position=(54, 56), length=3, inclusive_range=(8, 110), allowable_values=['999', '888'], blanks=['Blank if Question 1b TOBAC100 ne 1 (Yes)'])
        self.fields['ALCOCCAS'] = nacc.uds3.Field(name='ALCOCCAS', typename='Num', position=(58, 58), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['ALCFREQ'] = nacc.uds3.Field(name='ALCFREQ', typename='Num', position=(60, 60), length=1, inclusive_range=(0, 4), allowable_values=['2', '1', '0', '9', '4', '3'], blanks=['Blank if Question 1f ALCOCCAS ne 1 (Yes)'])
        self.fields['CVHATT'] = nacc.uds3.Field(name='CVHATT', typename='Num', position=(62, 62), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['HATTMULT'] = nacc.uds3.Field(name='HATTMULT', typename='Num', position=(64, 64), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 2a CVHATT = 0 (Absent)', 'Blank if Question 2a CVHATT = 9 (Unknown)'])
        self.fields['HATTYEAR'] = nacc.uds3.Field(name='HATTYEAR', typename='Num', position=(66, 69), length=4, inclusive_range=(1900, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 2a CVHATT = 0 (Absent)', 'Blank if Question 2a CVHATT = 9 (Unknown)'])
        self.fields['CVAFIB'] = nacc.uds3.Field(name='CVAFIB', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['CVANGIO'] = nacc.uds3.Field(name='CVANGIO', typename='Num', position=(73, 73), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['CVBYPASS'] = nacc.uds3.Field(name='CVBYPASS', typename='Num', position=(75, 75), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['CVPACDEF'] = nacc.uds3.Field(name='CVPACDEF', typename='Num', position=(77, 77), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['CVCHF'] = nacc.uds3.Field(name='CVCHF', typename='Num', position=(79, 79), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['CVANGINA'] = nacc.uds3.Field(name='CVANGINA', typename='Num', position=(81, 81), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['CVHVALVE'] = nacc.uds3.Field(name='CVHVALVE', typename='Num', position=(83, 83), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['CVOTHR'] = nacc.uds3.Field(name='CVOTHR', typename='Num', position=(85, 85), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['CVOTHRX'] = nacc.uds3.Field(name='CVOTHRX', typename='Char', position=(87, 146), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 2i CVOTHR = 0 (Absent)', 'Blank if Question 2i CVOTHR = 9 (Unknown)'])
        self.fields['CBSTROKE'] = nacc.uds3.Field(name='CBSTROKE', typename='Num', position=(148, 148), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['STROKMUL'] = nacc.uds3.Field(name='STROKMUL', typename='Num', position=(150, 150), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 3a CBSTROKE = 0 (Absent)', 'Blank if Question 3a CBSTROKE = 9 (Unknown)'])
        self.fields['STROKYR'] = nacc.uds3.Field(name='STROKYR', typename='Num', position=(152, 155), length=4, inclusive_range=(1900, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 3a CBSTROKE = 0 (Absent)', 'Blank if Question 3a CBSTROKE = 9 (Unknown)'])
        self.fields['CBTIA'] = nacc.uds3.Field(name='CBTIA', typename='Num', position=(157, 157), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['TIAMULT'] = nacc.uds3.Field(name='TIAMULT', typename='Num', position=(159, 159), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 3b CBTIA = 0 (Absent)', 'Blank if Question 3b CBTIA = 9 (Unknown)'])
        self.fields['TIAYEAR'] = nacc.uds3.Field(name='TIAYEAR', typename='Num', position=(161, 164), length=4, inclusive_range=(1900, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 3b CBTIA = 0 (Absent)', 'Blank if Question 3b CBTIA = 9 (Unknown)'])
        self.fields['PD'] = nacc.uds3.Field(name='PD', typename='Num', position=(166, 166), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['PDYR'] = nacc.uds3.Field(name='PDYR', typename='Num', position=(168, 171), length=4, inclusive_range=(1900, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 4a PD = 0 (Absent)', 'Blank if Question 4a PD = 9 (Unknown)'])
        self.fields['PDOTHR'] = nacc.uds3.Field(name='PDOTHR', typename='Num', position=(173, 173), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['PDOTHRYR'] = nacc.uds3.Field(name='PDOTHRYR', typename='Num', position=(175, 178), length=4, inclusive_range=(1900, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 4b PDOTHR = 0 (Absent)', 'Blank if Question 4b PDOTHR = 9 (Unknown)'])
        self.fields['SEIZURES'] = nacc.uds3.Field(name='SEIZURES', typename='Num', position=(180, 180), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['TBI'] = nacc.uds3.Field(name='TBI', typename='Num', position=(182, 182), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['TBIBRIEF'] = nacc.uds3.Field(name='TBIBRIEF', typename='Num', position=(184, 184), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=['Blank if Question 4d TBI = 0 (Absent)', 'Blank if Question 4d TBI = 9 (Unknown)'])
        self.fields['TBIEXTEN'] = nacc.uds3.Field(name='TBIEXTEN', typename='Num', position=(186, 186), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=['Blank if Question 4d TBI = 0 (Absent)', 'Blank if Question 4d TBI = 9 (Unknown)'])
        self.fields['TBIWOLOS'] = nacc.uds3.Field(name='TBIWOLOS', typename='Num', position=(188, 188), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=['Blank if Question 4d TBI = 0 (Absent)', 'Blank if Question 4d TBI = 9 (Unknown)'])
        self.fields['TBIYEAR'] = nacc.uds3.Field(name='TBIYEAR', typename='Num', position=(190, 193), length=4, inclusive_range=(1900, CURRENT_YEAR), allowable_values=['9999'], blanks=['Blank if Question 4d TBI = 0 (Absent) or 9 (Unknown)'])
        self.fields['DIABETES'] = nacc.uds3.Field(name='DIABETES', typename='Num', position=(195, 195), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['DIABTYPE'] = nacc.uds3.Field(name='DIABTYPE', typename='Num', position=(197, 197), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 5a DIABETES = 0 (Absent)', 'Blank if Question 5a DIABETES = 9 (Unknown)'])
        self.fields['HYPERTEN'] = nacc.uds3.Field(name='HYPERTEN', typename='Num', position=(199, 199), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['HYPERCHO'] = nacc.uds3.Field(name='HYPERCHO', typename='Num', position=(201, 201), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['B12DEF'] = nacc.uds3.Field(name='B12DEF', typename='Num', position=(203, 203), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['THYROID'] = nacc.uds3.Field(name='THYROID', typename='Num', position=(205, 205), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['ARTHRIT'] = nacc.uds3.Field(name='ARTHRIT', typename='Num', position=(207, 207), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['ARTHTYPE'] = nacc.uds3.Field(name='ARTHTYPE', typename='Num', position=(209, 209), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 5f ARTHRIT = 0 (Absent)', 'Blank if Question 5f ARTHRIT = 9 (Unknown)'])
        self.fields['ARTHTYPX'] = nacc.uds3.Field(name='ARTHTYPX', typename='Char', position=(211, 270), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 5f ARTHRIT = 0 (Absent)', 'Blank if Question 5f ARTHRIT = 9 (Unknown)', 'Blank if Question 5f1 ARTHTYPE ne 3 (Other)'])
        self.fields['ARTHUPEX'] = nacc.uds3.Field(name='ARTHUPEX', typename='Num', position=(272, 272), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 5f ARTHRIT = 0 (Absent)', 'Blank if Question 5f ARTHRIT = 9 (Unknown)'])
        self.fields['ARTHLOEX'] = nacc.uds3.Field(name='ARTHLOEX', typename='Num', position=(274, 274), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 5f ARTHRIT = 0 (Absent)', 'Blank if Question 5f ARTHRIT = 9 (Unknown)'])
        self.fields['ARTHSPIN'] = nacc.uds3.Field(name='ARTHSPIN', typename='Num', position=(276, 276), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 5f ARTHRIT = 0 (Absent)', 'Blank if Question 5f ARTHRIT = 9 (Unknown)'])
        self.fields['ARTHUNK'] = nacc.uds3.Field(name='ARTHUNK', typename='Num', position=(278, 278), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 5f ARTHRIT = 0 (Absent)', 'Blank if Question 5f ARTHRIT = 9 (Unknown)'])
        self.fields['INCONTU'] = nacc.uds3.Field(name='INCONTU', typename='Num', position=(280, 280), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['INCONTF'] = nacc.uds3.Field(name='INCONTF', typename='Num', position=(282, 282), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['APNEA'] = nacc.uds3.Field(name='APNEA', typename='Num', position=(284, 284), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['RBD'] = nacc.uds3.Field(name='RBD', typename='Num', position=(286, 286), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['INSOMN'] = nacc.uds3.Field(name='INSOMN', typename='Num', position=(288, 288), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['OTHSLEEP'] = nacc.uds3.Field(name='OTHSLEEP', typename='Num', position=(290, 290), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['OTHSLEEX'] = nacc.uds3.Field(name='OTHSLEEX', typename='Char', position=(292, 351), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 5l OTHSLEEP = 0 (Absent)', 'Blank if Question5l OTHSLEEP = 9 (Unknown)'])
        self.fields['ALCOHOL'] = nacc.uds3.Field(name='ALCOHOL', typename='Num', position=(353, 353), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['ABUSOTHR'] = nacc.uds3.Field(name='ABUSOTHR', typename='Num', position=(355, 355), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['ABUSX'] = nacc.uds3.Field(name='ABUSX', typename='Char', position=(357, 416), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 6b ABUSOTHR = 0 (Absent)', 'Blank if Question 6b ABUSOTHR = 9 (Unknown)'])
        self.fields['PTSD'] = nacc.uds3.Field(name='PTSD', typename='Num', position=(418, 418), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['BIPOLAR'] = nacc.uds3.Field(name='BIPOLAR', typename='Num', position=(420, 420), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['SCHIZ'] = nacc.uds3.Field(name='SCHIZ', typename='Num', position=(422, 422), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['DEP2YRS'] = nacc.uds3.Field(name='DEP2YRS', typename='Num', position=(424, 424), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['DEPOTHR'] = nacc.uds3.Field(name='DEPOTHR', typename='Num', position=(426, 426), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['ANXIETY'] = nacc.uds3.Field(name='ANXIETY', typename='Num', position=(428, 428), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['OCD'] = nacc.uds3.Field(name='OCD', typename='Num', position=(430, 430), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['NPSYDEV'] = nacc.uds3.Field(name='NPSYDEV', typename='Num', position=(432, 432), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['PSYCDIS'] = nacc.uds3.Field(name='PSYCDIS', typename='Num', position=(434, 434), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '9'], blanks=[])
        self.fields['PSYCDISX'] = nacc.uds3.Field(name='PSYCDISX', typename='Char', position=(436, 495), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 7h PSYCDIS = 0 (Absent) or 9 (Unknown)'])


class FormB1(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['HEIGHT'] = nacc.uds3.Field(name='HEIGHT', typename='Num', position=(45, 48), length=4, inclusive_range=(36, 96), allowable_values=['88.8'], blanks=[])
        self.fields['WEIGHT'] = nacc.uds3.Field(name='WEIGHT', typename='Num', position=(50, 52), length=3, inclusive_range=(50, 400), allowable_values=['888'], blanks=[])
        self.fields['BPSYS'] = nacc.uds3.Field(name='BPSYS', typename='Num', position=(54, 56), length=3, inclusive_range=(70, 230), allowable_values=['888'], blanks=[])
        self.fields['BPDIAS'] = nacc.uds3.Field(name='BPDIAS', typename='Num', position=(58, 60), length=3, inclusive_range=(30, 140), allowable_values=['888'], blanks=[])
        self.fields['HRATE'] = nacc.uds3.Field(name='HRATE', typename='Num', position=(62, 64), length=3, inclusive_range=(33, 160), allowable_values=['888'], blanks=[])
        self.fields['VISION'] = nacc.uds3.Field(name='VISION', typename='Num', position=(66, 66), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['VISCORR'] = nacc.uds3.Field(name='VISCORR', typename='Num', position=(68, 68), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['VISWCORR'] = nacc.uds3.Field(name='VISWCORR', typename='Num', position=(70, 70), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 6 VISCORR ne 1 (Yes)'])
        self.fields['HEARING'] = nacc.uds3.Field(name='HEARING', typename='Num', position=(72, 72), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['HEARAID'] = nacc.uds3.Field(name='HEARAID', typename='Num', position=(74, 74), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['HEARWAID'] = nacc.uds3.Field(name='HEARWAID', typename='Num', position=(76, 76), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 HEARAID ne 1 (Yes)'])


class FormB4(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['MEMORY'] = nacc.uds3.Field(name='MEMORY', typename='Num', position=(45, 47), length=3, inclusive_range=(0, 3), allowable_values=['1.0', '0.5', '0.0', '3.0', '2.0'], blanks=[])
        self.fields['ORIENT'] = nacc.uds3.Field(name='ORIENT', typename='Num', position=(49, 51), length=3, inclusive_range=(0, 3), allowable_values=['1.0', '0.5', '0.0', '3.0', '2.0'], blanks=[])
        self.fields['JUDGMENT'] = nacc.uds3.Field(name='JUDGMENT', typename='Num', position=(53, 55), length=3, inclusive_range=(0, 3), allowable_values=['1.0', '0.5', '0.0', '3.0', '2.0'], blanks=[])
        self.fields['COMMUN'] = nacc.uds3.Field(name='COMMUN', typename='Num', position=(57, 59), length=3, inclusive_range=(0, 3), allowable_values=['1.0', '0.5', '0.0', '3.0', '2.0'], blanks=[])
        self.fields['HOMEHOBB'] = nacc.uds3.Field(name='HOMEHOBB', typename='Num', position=(61, 63), length=3, inclusive_range=(0, 3), allowable_values=['1.0', '0.5', '0.0', '3.0', '2.0'], blanks=[])
        self.fields['PERSCARE'] = nacc.uds3.Field(name='PERSCARE', typename='Num', position=(65, 67), length=3, inclusive_range=(0, 3), allowable_values=['2.0', '1.0', '0.0', '3.0'], blanks=[])
        self.fields['CDRSUM'] = nacc.uds3.Field(name='CDRSUM', typename='Num', position=(69, 72), length=4, inclusive_range=(0, 18), allowable_values=[], blanks=[])
        self.fields['CDRGLOB'] = nacc.uds3.Field(name='CDRGLOB', typename='Num', position=(74, 76), length=3, inclusive_range=(0, 3), allowable_values=['1.0', '0.5', '0.0', '3.0', '2.0'], blanks=[])
        self.fields['COMPORT'] = nacc.uds3.Field(name='COMPORT', typename='Num', position=(78, 80), length=3, inclusive_range=(0, 3), allowable_values=['1.0', '0.5', '0.0', '3.0', '2.0'], blanks=[])
        self.fields['CDRLANG'] = nacc.uds3.Field(name='CDRLANG', typename='Num', position=(82, 84), length=3, inclusive_range=(0, 3), allowable_values=['1.0', '0.5', '0.0', '3.0', '2.0'], blanks=[])


class FormB5(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['NPIQINF'] = nacc.uds3.Field(name='NPIQINF', typename='Num', position=(45, 45), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=[])
        self.fields['NPIQINFX'] = nacc.uds3.Field(name='NPIQINFX', typename='Char', position=(47, 106), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 NPIQINF ne 3 (Other)'])
        self.fields['DEL'] = nacc.uds3.Field(name='DEL', typename='Num', position=(108, 108), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['DELSEV'] = nacc.uds3.Field(name='DELSEV', typename='Num', position=(110, 110), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 2a DEL ne 1 (Yes)'])
        self.fields['HALL'] = nacc.uds3.Field(name='HALL', typename='Num', position=(112, 112), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['HALLSEV'] = nacc.uds3.Field(name='HALLSEV', typename='Num', position=(114, 114), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 3a HALL ne 1 (Yes)'])
        self.fields['AGIT'] = nacc.uds3.Field(name='AGIT', typename='Num', position=(116, 116), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['AGITSEV'] = nacc.uds3.Field(name='AGITSEV', typename='Num', position=(118, 118), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 4a AGIT ne 1 (Yes)'])
        self.fields['DEPD'] = nacc.uds3.Field(name='DEPD', typename='Num', position=(120, 120), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['DEPDSEV'] = nacc.uds3.Field(name='DEPDSEV', typename='Num', position=(122, 122), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 5a DEPD ne 1 (Yes)'])
        self.fields['ANX'] = nacc.uds3.Field(name='ANX', typename='Num', position=(124, 124), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['ANXSEV'] = nacc.uds3.Field(name='ANXSEV', typename='Num', position=(126, 126), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 6a ANX ne 1 (Yes)'])
        self.fields['ELAT'] = nacc.uds3.Field(name='ELAT', typename='Num', position=(128, 128), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['ELATSEV'] = nacc.uds3.Field(name='ELATSEV', typename='Num', position=(130, 130), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 7a ELAT ne 1 (Yes)'])
        self.fields['APA'] = nacc.uds3.Field(name='APA', typename='Num', position=(132, 132), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['APASEV'] = nacc.uds3.Field(name='APASEV', typename='Num', position=(134, 134), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 8a APA ne 1 (Yes)'])
        self.fields['DISN'] = nacc.uds3.Field(name='DISN', typename='Num', position=(136, 136), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['DISNSEV'] = nacc.uds3.Field(name='DISNSEV', typename='Num', position=(138, 138), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 9a DISN ne 1 (Yes)'])
        self.fields['IRR'] = nacc.uds3.Field(name='IRR', typename='Num', position=(140, 140), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['IRRSEV'] = nacc.uds3.Field(name='IRRSEV', typename='Num', position=(142, 142), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 10a IRR ne 1 (Yes)'])
        self.fields['MOT'] = nacc.uds3.Field(name='MOT', typename='Num', position=(144, 144), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['MOTSEV'] = nacc.uds3.Field(name='MOTSEV', typename='Num', position=(146, 146), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 11a MOT ne 1 (Yes)'])
        self.fields['NITE'] = nacc.uds3.Field(name='NITE', typename='Num', position=(148, 148), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['NITESEV'] = nacc.uds3.Field(name='NITESEV', typename='Num', position=(150, 150), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 12a NITE ne 1 (Yes)'])
        self.fields['APP'] = nacc.uds3.Field(name='APP', typename='Num', position=(152, 152), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['APPSEV'] = nacc.uds3.Field(name='APPSEV', typename='Num', position=(154, 154), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 13a APP ne 1 (Yes)'])


class FormB6(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['NOGDS'] = nacc.uds3.Field(name='NOGDS', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['SATIS'] = nacc.uds3.Field(name='SATIS', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['DROPACT'] = nacc.uds3.Field(name='DROPACT', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['9', '0', '1'], blanks=[])
        self.fields['EMPTY'] = nacc.uds3.Field(name='EMPTY', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['9', '0', '1'], blanks=[])
        self.fields['BORED'] = nacc.uds3.Field(name='BORED', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['9', '0', '1'], blanks=[])
        self.fields['SPIRITS'] = nacc.uds3.Field(name='SPIRITS', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['AFRAID'] = nacc.uds3.Field(name='AFRAID', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['9', '0', '1'], blanks=[])
        self.fields['HAPPY'] = nacc.uds3.Field(name='HAPPY', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['HELPLESS'] = nacc.uds3.Field(name='HELPLESS', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['9', '0', '1'], blanks=[])
        self.fields['STAYHOME'] = nacc.uds3.Field(name='STAYHOME', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['9', '0', '1'], blanks=[])
        self.fields['MEMPROB'] = nacc.uds3.Field(name='MEMPROB', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 1), allowable_values=['9', '0', '1'], blanks=[])
        self.fields['WONDRFUL'] = nacc.uds3.Field(name='WONDRFUL', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['WRTHLESS'] = nacc.uds3.Field(name='WRTHLESS', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['9', '0', '1'], blanks=[])
        self.fields['ENERGY'] = nacc.uds3.Field(name='ENERGY', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['HOPELESS'] = nacc.uds3.Field(name='HOPELESS', typename='Num', position=(73, 73), length=1, inclusive_range=(0, 1), allowable_values=['9', '0', '1'], blanks=[])
        self.fields['BETTER'] = nacc.uds3.Field(name='BETTER', typename='Num', position=(75, 75), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '1'], blanks=[])
        self.fields['GDS'] = nacc.uds3.Field(name='GDS', typename='Num', position=(77, 78), length=2, inclusive_range=(0, 15), allowable_values=['88'], blanks=[])


class FormB7(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['BILLS'] = nacc.uds3.Field(name='BILLS', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '8', '3'], blanks=[])
        self.fields['TAXES'] = nacc.uds3.Field(name='TAXES', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '8', '3'], blanks=[])
        self.fields['SHOPPING'] = nacc.uds3.Field(name='SHOPPING', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '8', '3'], blanks=[])
        self.fields['GAMES'] = nacc.uds3.Field(name='GAMES', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '8', '3'], blanks=[])
        self.fields['STOVE'] = nacc.uds3.Field(name='STOVE', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '8', '3'], blanks=[])
        self.fields['MEALPREP'] = nacc.uds3.Field(name='MEALPREP', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '8', '3'], blanks=[])
        self.fields['EVENTS'] = nacc.uds3.Field(name='EVENTS', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '8', '3'], blanks=[])
        self.fields['PAYATTN'] = nacc.uds3.Field(name='PAYATTN', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '8', '3'], blanks=[])
        self.fields['REMDATES'] = nacc.uds3.Field(name='REMDATES', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '8', '3'], blanks=[])
        self.fields['TRAVEL'] = nacc.uds3.Field(name='TRAVEL', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '8', '3'], blanks=[])


class FormB8(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['NORMEXAM'] = nacc.uds3.Field(name='NORMEXAM', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0'], blanks=[])
        self.fields['PARKSIGN'] = nacc.uds3.Field(name='PARKSIGN', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)'])
        self.fields['RESTTRL'] = nacc.uds3.Field(name='RESTTRL', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 2 PARKSIGN = 0 (No)'])
        self.fields['RESTTRR'] = nacc.uds3.Field(name='RESTTRR', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 2 PARKSIGN = 0 (No)'])
        self.fields['SLOWINGL'] = nacc.uds3.Field(name='SLOWINGL', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 2 PARKSIGN = 0 (No)'])
        self.fields['SLOWINGR'] = nacc.uds3.Field(name='SLOWINGR', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 2 PARKSIGN = 0 (No)'])
        self.fields['RIGIDL'] = nacc.uds3.Field(name='RIGIDL', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 2 PARKSIGN = 0 (No)'])
        self.fields['RIGIDR'] = nacc.uds3.Field(name='RIGIDR', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 2 PARKSIGN = 0 (No)'])
        self.fields['BRADY'] = nacc.uds3.Field(name='BRADY', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 2 PARKSIGN = 0 (No)'])
        self.fields['PARKGAIT'] = nacc.uds3.Field(name='PARKGAIT', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 2 PARKSIGN = 0 (No)'])
        self.fields['POSTINST'] = nacc.uds3.Field(name='POSTINST', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 2 PARKSIGN = 0 (No)'])
        self.fields['CVDSIGNS'] = nacc.uds3.Field(name='CVDSIGNS', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)'])
        self.fields['CORTDEF'] = nacc.uds3.Field(name='CORTDEF', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 3 CVDSIGNS = 0 (No)'])
        self.fields['SIVDFIND'] = nacc.uds3.Field(name='SIVDFIND', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 3 CVDSIGNS = 0 (No)'])
        self.fields['CVDMOTL'] = nacc.uds3.Field(name='CVDMOTL', typename='Num', position=(73, 73), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 3 CVDSIGNS = 0 (No)'])
        self.fields['CVDMOTR'] = nacc.uds3.Field(name='CVDMOTR', typename='Num', position=(75, 75), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 3 CVDSIGNS = 0 (No)'])
        self.fields['CORTVISL'] = nacc.uds3.Field(name='CORTVISL', typename='Num', position=(77, 77), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 3 CVDSIGNS = 0 (No)'])
        self.fields['CORTVISR'] = nacc.uds3.Field(name='CORTVISR', typename='Num', position=(79, 79), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 3 CVDSIGNS = 0 (No)'])
        self.fields['SOMATL'] = nacc.uds3.Field(name='SOMATL', typename='Num', position=(81, 81), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 3 CVDSIGNS = 0 (No)'])
        self.fields['SOMATR'] = nacc.uds3.Field(name='SOMATR', typename='Num', position=(83, 83), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 3 CVDSIGNS = 0 (No)'])
        self.fields['POSTCORT'] = nacc.uds3.Field(name='POSTCORT', typename='Num', position=(85, 85), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)'])
        self.fields['PSPCBS'] = nacc.uds3.Field(name='PSPCBS', typename='Num', position=(87, 87), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)'])
        self.fields['EYEPSP'] = nacc.uds3.Field(name='EYEPSP', typename='Num', position=(89, 89), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['DYSPSP'] = nacc.uds3.Field(name='DYSPSP', typename='Num', position=(91, 91), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['AXIALPSP'] = nacc.uds3.Field(name='AXIALPSP', typename='Num', position=(93, 93), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['GAITPSP'] = nacc.uds3.Field(name='GAITPSP', typename='Num', position=(95, 95), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['APRAXSP'] = nacc.uds3.Field(name='APRAXSP', typename='Num', position=(97, 97), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['APRAXL'] = nacc.uds3.Field(name='APRAXL', typename='Num', position=(99, 99), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['APRAXR'] = nacc.uds3.Field(name='APRAXR', typename='Num', position=(101, 101), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['CORTSENL'] = nacc.uds3.Field(name='CORTSENL', typename='Num', position=(103, 103), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['CORTSENR'] = nacc.uds3.Field(name='CORTSENR', typename='Num', position=(105, 105), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['ATAXL'] = nacc.uds3.Field(name='ATAXL', typename='Num', position=(107, 107), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['ATAXR'] = nacc.uds3.Field(name='ATAXR', typename='Num', position=(109, 109), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['ALIENLML'] = nacc.uds3.Field(name='ALIENLML', typename='Num', position=(111, 111), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['ALIENLMR'] = nacc.uds3.Field(name='ALIENLMR', typename='Num', position=(113, 113), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['DYSTONL'] = nacc.uds3.Field(name='DYSTONL', typename='Num', position=(115, 115), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['DYSTONR'] = nacc.uds3.Field(name='DYSTONR', typename='Num', position=(117, 117), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['MYOCLLT'] = nacc.uds3.Field(name='MYOCLLT', typename='Num', position=(119, 119), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['MYOCLRT'] = nacc.uds3.Field(name='MYOCLRT', typename='Num', position=(121, 121), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)', 'Blank if Question 5 PSPCBS = 0 (No)'])
        self.fields['ALSFIND'] = nacc.uds3.Field(name='ALSFIND', typename='Num', position=(123, 123), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)'])
        self.fields['GAITNPH'] = nacc.uds3.Field(name='GAITNPH', typename='Num', position=(125, 125), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 1 NORMEXAM ne 1 (Yes)'])
        self.fields['OTHNEUR'] = nacc.uds3.Field(name='OTHNEUR', typename='Num', position=(127, 127), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 1 NORMEXAM = 0 (No)'])
        self.fields['OTHNEURX'] = nacc.uds3.Field(name='OTHNEURX', typename='Char', position=(129, 188), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 NORMEXAM = 0 (No)', 'Blank if Question 8 OTHNEUR = 0 (No)'])


class FormB9(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['DECSUB'] = nacc.uds3.Field(name='DECSUB', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['DECIN'] = nacc.uds3.Field(name='DECIN', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['DECCLCOG'] = nacc.uds3.Field(name='DECCLCOG', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['COGMEM'] = nacc.uds3.Field(name='COGMEM', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGORI'] = nacc.uds3.Field(name='COGORI', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGJUDG'] = nacc.uds3.Field(name='COGJUDG', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGLANG'] = nacc.uds3.Field(name='COGLANG', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGVIS'] = nacc.uds3.Field(name='COGVIS', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGATTN'] = nacc.uds3.Field(name='COGATTN', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGFLUC'] = nacc.uds3.Field(name='COGFLUC', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGFLAGO'] = nacc.uds3.Field(name='COGFLAGO', typename='Num', position=(65, 67), length=3, inclusive_range=(15, 110), allowable_values=[], blanks=['Blank if Question 4g COGFLUC ne 1 (Yes)'])
        self.fields['COGOTHR'] = nacc.uds3.Field(name='COGOTHR', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGOTHRX'] = nacc.uds3.Field(name='COGOTHRX', typename='Char', position=(71, 130), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 4h COGOTHR ne 1 (Yes)'])
        self.fields['COGFPRED'] = nacc.uds3.Field(name='COGFPRED', typename='Num', position=(132, 133), length=2, inclusive_range=(1, 8), allowable_values=['7', '99', '8', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGFPREX'] = nacc.uds3.Field(name='COGFPREX', typename='Char', position=(135, 194), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 5 COGFPRED ne 8 (Other)'])
        self.fields['COGMODE'] = nacc.uds3.Field(name='COGMODE', typename='Num', position=(196, 197), length=2, inclusive_range=(1, 4), allowable_values=['3', '2', '1', '99', '4'], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['COGMODEX'] = nacc.uds3.Field(name='COGMODEX', typename='Char', position=(199, 258), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 6 COGMODE ne 4 (Other)'])
        self.fields['DECAGE'] = nacc.uds3.Field(name='DECAGE', typename='Num', position=(260, 262), length=3, inclusive_range=(15, 110), allowable_values=[], blanks=['Blank if Question 3 DECCLCOG = 0 (No)'])
        self.fields['DECCLBE'] = nacc.uds3.Field(name='DECCLBE', typename='Num', position=(264, 264), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['BEAPATHY'] = nacc.uds3.Field(name='BEAPATHY', typename='Num', position=(266, 266), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEDEP'] = nacc.uds3.Field(name='BEDEP', typename='Num', position=(268, 268), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEVHALL'] = nacc.uds3.Field(name='BEVHALL', typename='Num', position=(270, 270), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEVWELL'] = nacc.uds3.Field(name='BEVWELL', typename='Num', position=(272, 272), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)', 'Blank if Question 9c1 BEVHALL ne 1 (Yes)'])
        self.fields['BEVHAGO'] = nacc.uds3.Field(name='BEVHAGO', typename='Num', position=(274, 276), length=3, inclusive_range=(15, 110), allowable_values=['888'], blanks=['Blank if Question 8 DECCLBE = 0 (No)', 'Blank if Question 9c1 BEVHALL ne 1 (Yes)'])
        self.fields['BEAHALL'] = nacc.uds3.Field(name='BEAHALL', typename='Num', position=(278, 278), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEDEL'] = nacc.uds3.Field(name='BEDEL', typename='Num', position=(280, 280), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEDISIN'] = nacc.uds3.Field(name='BEDISIN', typename='Num', position=(282, 282), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEIRRIT'] = nacc.uds3.Field(name='BEIRRIT', typename='Num', position=(284, 284), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEAGIT'] = nacc.uds3.Field(name='BEAGIT', typename='Num', position=(286, 286), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEPERCH'] = nacc.uds3.Field(name='BEPERCH', typename='Num', position=(288, 288), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEREM'] = nacc.uds3.Field(name='BEREM', typename='Num', position=(290, 290), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEREMAGO'] = nacc.uds3.Field(name='BEREMAGO', typename='Num', position=(292, 294), length=3, inclusive_range=(15, 110), allowable_values=[], blanks=['Blank if Question 9h BEREM ne 1 (Yes)'])
        self.fields['BEANX'] = nacc.uds3.Field(name='BEANX', typename='Num', position=(296, 296), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEOTHR'] = nacc.uds3.Field(name='BEOTHR', typename='Num', position=(298, 298), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEOTHRX'] = nacc.uds3.Field(name='BEOTHRX', typename='Char', position=(300, 359), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 9j BEOTHR ne 1 (Yes)'])
        self.fields['BEFPRED'] = nacc.uds3.Field(name='BEFPRED', typename='Num', position=(361, 362), length=2, inclusive_range=(1, 10), allowable_values=['99', '10', '7', '9', '8', '3', '2', '1', '6', '5', '4'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEFPREDX'] = nacc.uds3.Field(name='BEFPREDX', typename='Char', position=(364, 423), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 10 BEFPRED ne 10 (Other)'])
        self.fields['BEMODE'] = nacc.uds3.Field(name='BEMODE', typename='Num', position=(425, 426), length=2, inclusive_range=(1, 4), allowable_values=['3', '2', '1', '99', '4'], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['BEMODEX'] = nacc.uds3.Field(name='BEMODEX', typename='Char', position=(428, 487), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 11 BEMODE ne 4 (Other)'])
        self.fields['BEAGE'] = nacc.uds3.Field(name='BEAGE', typename='Num', position=(489, 491), length=3, inclusive_range=(15, 110), allowable_values=[], blanks=['Blank if Question 8 DECCLBE = 0 (No)'])
        self.fields['DECCLMOT'] = nacc.uds3.Field(name='DECCLMOT', typename='Num', position=(493, 493), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['If Question 13 = 0 (No) then skip to Question 20'])
        self.fields['MOGAIT'] = nacc.uds3.Field(name='MOGAIT', typename='Num', position=(495, 495), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOFALLS'] = nacc.uds3.Field(name='MOFALLS', typename='Num', position=(497, 497), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOTREM'] = nacc.uds3.Field(name='MOTREM', typename='Num', position=(499, 499), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOSLOW'] = nacc.uds3.Field(name='MOSLOW', typename='Num', position=(501, 501), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOFRST'] = nacc.uds3.Field(name='MOFRST', typename='Num', position=(503, 504), length=2, inclusive_range=(1, 4), allowable_values=['3', '2', '1', '99', '4'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOMODE'] = nacc.uds3.Field(name='MOMODE', typename='Num', position=(506, 507), length=2, inclusive_range=(1, 4), allowable_values=['3', '2', '1', '99', '4'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['MOMODEX'] = nacc.uds3.Field(name='MOMODEX', typename='Char', position=(509, 568), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 16 MOMODE ne 4 (Other)'])
        self.fields['MOMOPARK'] = nacc.uds3.Field(name='MOMOPARK', typename='Num', position=(570, 570), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['PARKAGE'] = nacc.uds3.Field(name='PARKAGE', typename='Num', position=(572, 574), length=3, inclusive_range=(15, 110), allowable_values=[], blanks=['Blank if Question 17 MOMOPARK ne 1 (Yes)'])
        self.fields['MOMOALS'] = nacc.uds3.Field(name='MOMOALS', typename='Num', position=(576, 576), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['ALSAGE'] = nacc.uds3.Field(name='ALSAGE', typename='Num', position=(578, 580), length=3, inclusive_range=(15, 110), allowable_values=[], blanks=['Blank if Question 18 MOMOALS ne 1 (Yes)'])
        self.fields['MOAGE'] = nacc.uds3.Field(name='MOAGE', typename='Num', position=(582, 584), length=3, inclusive_range=(15, 110), allowable_values=[], blanks=['Blank if Question 13 DECCLMOT = 0 (No)'])
        self.fields['COURSE'] = nacc.uds3.Field(name='COURSE', typename='Num', position=(586, 586), length=1, inclusive_range=(1, 5), allowable_values=['9', '3', '2', '1', '8', '5', '4'], blanks=[])
        self.fields['FRSTCHG'] = nacc.uds3.Field(name='FRSTCHG', typename='Num', position=(588, 588), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9', '8'], blanks=[])
        self.fields['LBDEVAL'] = nacc.uds3.Field(name='LBDEVAL', typename='Num', position=(590, 590), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['FTLDEVAL'] = nacc.uds3.Field(name='FTLDEVAL', typename='Num', position=(592, 592), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])


class FormC1S(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['MMSELOC'] = nacc.uds3.Field(name='MMSELOC', typename='Num', position=(45, 45), length=1, inclusive_range=(1,3), allowable_values=['1', '2', '3'], blanks=[])
        self.fields['MMSELAN'] = nacc.uds3.Field(name='MMSELAN', typename='Num', position=(47, 47), length=1, inclusive_range=(1,3), allowable_values=['1', '2', '3'], blanks=[])
        self.fields['MMSELANX'] = nacc.uds3.Field(name='MMSELANX', typename='Char', position=(49, 108), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1A1 MMSELAN ne 3 (Other)'])
        self.fields['MMSEORDA'] = nacc.uds3.Field(name='MMSEORDA', typename='Num', position=(110, 111), length=2, inclusive_range=(0, 5), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['MMSEORLO'] = nacc.uds3.Field(name='MMSEORLO', typename='Num', position=(113, 114), length=2, inclusive_range=(0, 5), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['PENTAGON'] = nacc.uds3.Field(name='PENTAGON', typename='Num', position=(116, 117), length=2, inclusive_range=(0, 1), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['MMSE'] = nacc.uds3.Field(name='MMSE', typename='Num', position=(119, 120), length=2, inclusive_range=(0, 30), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['NPSYCLOC'] = nacc.uds3.Field(name='NPSYCLOC', typename='Num', position=(122, 122), length=1, inclusive_range=(1, 3), allowable_values=[], blanks=[])
        self.fields['NPSYLAN'] = nacc.uds3.Field(name='NPSYLAN', typename='Num', position=(124, 124), length=1, inclusive_range=(1, 3), allowable_values=[], blanks=[])
        self.fields['NPSYLANX'] = nacc.uds3.Field(name='NPSYLANX', typename='Char', position=(126, 185), length=60, inclusive_range=(), allowable_values=[], blanks=["Blank if Question 2A NPSYLAN ne 3 (Other)"])
        self.fields['LOGIMO'] = nacc.uds3.Field(name='LOGIMO', typename='Num', position=(187, 188), length=2, inclusive_range=(1, 12), allowable_values=['88'], blanks=[])
        self.fields['LOGIDAY'] = nacc.uds3.Field(name='LOGIDAY', typename='Num', position=(190, 191), length=2, inclusive_range=(1, 31), allowable_values=['88'], blanks=[])
        self.fields['LOGIYR'] = nacc.uds3.Field(name='LOGIYR', typename='Num', position=(193, 196), length=4, inclusive_range=(CURRENT_YEAR-1, CURRENT_YEAR), allowable_values=['88', '8888'], blanks=[])
        self.fields['LOGIPREV'] = nacc.uds3.Field(name='LOGIPREV', typename='Num', position=(198, 199), length=2, inclusive_range=(0, 25), allowable_values=['88', '99'], blanks=[])
        self.fields['LOGIMEM'] = nacc.uds3.Field(name='LOGIMEM', typename='Num', position=(201, 202), length=2, inclusive_range=(0, 25), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['DIGIF'] = nacc.uds3.Field(name='DIGIF', typename='Num', position=(204, 205), length=2, inclusive_range=(0, 12), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['DIGIFLEN'] = nacc.uds3.Field(name='DIGIFLEN', typename='Num', position=(207, 208), length=2, inclusive_range=(0, 8), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['DIGIB'] = nacc.uds3.Field(name='DIGIB', typename='Num', position=(210, 211), length=2, inclusive_range=(0, 12), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['DIGIBLEN'] = nacc.uds3.Field(name='DIGIBLEN', typename='Num', position=(213, 214), length=2, inclusive_range=(0, 7), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['ANIMALS'] = nacc.uds3.Field(name='ANIMALS', typename='Num', position=(216, 217), length=2, inclusive_range=(0, 77), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['VEG'] = nacc.uds3.Field(name='VEG', typename='Num', position=(219, 220), length=2, inclusive_range=(0, 77), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['TRAILA'] = nacc.uds3.Field(name='TRAILA', typename='Num', position=(222, 224), length=3, inclusive_range=(0, 150), allowable_values=['995', '996', '997', '998'], blanks=[])
        self.fields['TRAILARR'] = nacc.uds3.Field(name='TRAILARR', typename='Num', position=(226, 227), length=2, inclusive_range=(0, 40), allowable_values=['88'], blanks=['Blank if Question 7a TRAILA = 995-998'])
        self.fields['TRAILALI'] = nacc.uds3.Field(name='TRAILALI', typename='Num', position=(229, 230), length=2, inclusive_range=(0, 24), allowable_values=['88'], blanks=['Blank if Question 7a TRAILA = 995-998'])
        self.fields['TRAILB'] = nacc.uds3.Field(name='TRAILB', typename='Num', position=(232, 234), length=3, inclusive_range=(0, 300), allowable_values=['995', '996', '997', '998'], blanks=[])
        self.fields['TRAILBRR'] = nacc.uds3.Field(name='TRAILBRR', typename='Num', position=(236, 237), length=2, inclusive_range=(0, 40), allowable_values=['88'], blanks=['Blank if Question 7b TRAILB = 995-998'])
        self.fields['TRAILBLI'] = nacc.uds3.Field(name='TRAILBLI', typename='Num', position=(239, 240), length=2, inclusive_range=(0, 24), allowable_values=['88'], blanks=['Blank if Question 7b TRAILB = 995-998'])
        self.fields['WAIS'] = nacc.uds3.Field(name='WAIS', typename='Num', position=(242, 243), length=2, inclusive_range=(0, 93), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['MEMUNITS'] = nacc.uds3.Field(name='MEMUNITS', typename='Num', position=(245, 246), length=2, inclusive_range=(0, 25), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['MEMTIME'] = nacc.uds3.Field(name='MEMTIME', typename='Num', position=(248, 249), length=2, inclusive_range=(0, 85), allowable_values=['88', '99'], blanks=[])
        self.fields['BOSTON'] = nacc.uds3.Field(name='BOSTON', typename='Num', position=(251, 252), length=2, inclusive_range=(0, 30), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['COGSTAT'] = nacc.uds3.Field(name='COGSTAT', typename='Num', position=(254, 254), length=1, inclusive_range=(0, 5), allowable_values=[], blanks=[])


class FormC2(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['MOCACOMP'] = nacc.uds3.Field(name='MOCACOMP', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['MOCAREAS'] = nacc.uds3.Field(name='MOCAREAS', typename='Num', position=(47, 48), length=2, inclusive_range=(95, 98), allowable_values=['97', '96', '95', '98'], blanks=['Blank if 1a MOCACOMP = 1 (Yes)'])
        self.fields['MOCALOC'] = nacc.uds3.Field(name='MOCALOC', typename='Num', position=(50, 50), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCALAN'] = nacc.uds3.Field(name='MOCALAN', typename='Num', position=(52, 52), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCALANX'] = nacc.uds3.Field(name='MOCALANX', typename='Char', position=(54, 113), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1a MOCACOMP = 0 (No)', 'Blank if Question 1c MOCALAN = 1', 'Blank if Question 1c MOCALAN = 2'])
        self.fields['MOCAVIS'] = nacc.uds3.Field(name='MOCAVIS', typename='Num', position=(115, 115), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCAHEAR'] = nacc.uds3.Field(name='MOCAHEAR', typename='Num', position=(117, 117), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCATOTS'] = nacc.uds3.Field(name='MOCATOTS', typename='Num', position=(119, 120), length=2, inclusive_range=(0, 30), allowable_values=['88'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCATRAI'] = nacc.uds3.Field(name='MOCATRAI', typename='Num', position=(122, 123), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '0', '98', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCACUBE'] = nacc.uds3.Field(name='MOCACUBE', typename='Num', position=(125, 126), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCACLOC'] = nacc.uds3.Field(name='MOCACLOC', typename='Num', position=(128, 129), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCACLON'] = nacc.uds3.Field(name='MOCACLON', typename='Num', position=(131, 132), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCACLOH'] = nacc.uds3.Field(name='MOCACLOH', typename='Num', position=(134, 135), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCANAMI'] = nacc.uds3.Field(name='MOCANAMI', typename='Num', position=(137, 138), length=2, inclusive_range=(0, 3), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCAREGI'] = nacc.uds3.Field(name='MOCAREGI', typename='Num', position=(140, 141), length=2, inclusive_range=(0, 10), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCADIGI'] = nacc.uds3.Field(name='MOCADIGI', typename='Num', position=(143, 144), length=2, inclusive_range=(0, 2), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCALETT'] = nacc.uds3.Field(name='MOCALETT', typename='Num', position=(146, 147), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCASER7'] = nacc.uds3.Field(name='MOCASER7', typename='Num', position=(149, 150), length=2, inclusive_range=(0, 3), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCAREPE'] = nacc.uds3.Field(name='MOCAREPE', typename='Num', position=(152, 153), length=2, inclusive_range=(0, 2), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCAFLUE'] = nacc.uds3.Field(name='MOCAFLUE', typename='Num', position=(155, 156), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCAABST'] = nacc.uds3.Field(name='MOCAABST', typename='Num', position=(158, 159), length=2, inclusive_range=(0, 2), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCARECN'] = nacc.uds3.Field(name='MOCARECN', typename='Num', position=(161, 162), length=2, inclusive_range=(0, 5), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCARECC'] = nacc.uds3.Field(name='MOCARECC', typename='Num', position=(164, 165), length=2, inclusive_range=(0, 5), allowable_values=['88'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCARECR'] = nacc.uds3.Field(name='MOCARECR', typename='Num', position=(167, 168), length=2, inclusive_range=(0, 5), allowable_values=['88'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCAORDT'] = nacc.uds3.Field(name='MOCAORDT', typename='Num', position=(170, 171), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCAORMO'] = nacc.uds3.Field(name='MOCAORMO', typename='Num', position=(173, 174), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCAORYR'] = nacc.uds3.Field(name='MOCAORYR', typename='Num', position=(176, 177), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCAORDY'] = nacc.uds3.Field(name='MOCAORDY', typename='Num', position=(179, 180), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCAORPL'] = nacc.uds3.Field(name='MOCAORPL', typename='Num', position=(182, 183), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['MOCAORCT'] = nacc.uds3.Field(name='MOCAORCT', typename='Num', position=(185, 186), length=2, inclusive_range=(0, 1), allowable_values=['96', '95', '98', '97'], blanks=['Blank if Question 1a MOCACOMP = 0 (No)'])
        self.fields['NPSYCLOC'] = nacc.uds3.Field(name='NPSYCLOC', typename='Num', position=(188, 188), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=[])
        self.fields['NPSYLAN'] = nacc.uds3.Field(name='NPSYLAN', typename='Num', position=(190, 190), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=[])
        self.fields['NPSYLANX'] = nacc.uds3.Field(name='NPSYLANX', typename='Char', position=(192, 251), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Questions 2b NPSYLAN ne 3 (Other)'])
        self.fields['CRAFTVRS'] = nacc.uds3.Field(name='CRAFTVRS', typename='Num', position=(253, 254), length=2, inclusive_range=(0, 44), allowable_values=['96', '95', '98', '97'], blanks=[])
        self.fields['CRAFTURS'] = nacc.uds3.Field(name='CRAFTURS', typename='Num', position=(256, 257), length=2, inclusive_range=(0, 25), allowable_values=[], blanks=['Blank if Question 3a CRAFTVRS = 95-98'])
        self.fields['UDSBENTC'] = nacc.uds3.Field(name='UDSBENTC', typename='Num', position=(259, 260), length=2, inclusive_range=(0, 17), allowable_values=['96', '95', '98', '97'], blanks=[])
        self.fields['DIGFORCT'] = nacc.uds3.Field(name='DIGFORCT', typename='Num', position=(262, 263), length=2, inclusive_range=(0, 14), allowable_values=['96', '95', '98', '97'], blanks=[])
        self.fields['DIGFORSL'] = nacc.uds3.Field(name='DIGFORSL', typename='Num', position=(265, 266), length=2, inclusive_range=(3, 9), allowable_values=['0'], blanks=['Blank if Question 5a DIGFORCT = 95-98'])
        self.fields['DIGBACCT'] = nacc.uds3.Field(name='DIGBACCT', typename='Num', position=(268, 269), length=2, inclusive_range=(0, 14), allowable_values=['96', '95', '98', '97'], blanks=[])
        self.fields['DIGBACLS'] = nacc.uds3.Field(name='DIGBACLS', typename='Num', position=(271, 272), length=2, inclusive_range=(2, 8), allowable_values=['0'], blanks=['Blank if Question 6a DIGBACCT = 95-98'])
        self.fields['ANIMALS'] = nacc.uds3.Field(name='ANIMALS', typename='Num', position=(274, 275), length=2, inclusive_range=(0, 77), allowable_values=['96', '95', '98', '97'], blanks=[])
        self.fields['VEG'] = nacc.uds3.Field(name='VEG', typename='Num', position=(277, 278), length=2, inclusive_range=(0, 77), allowable_values=['96', '95', '98', '97'], blanks=[])
        self.fields['TRAILA'] = nacc.uds3.Field(name='TRAILA', typename='Num', position=(280, 282), length=3, inclusive_range=(0, 150), allowable_values=['996', '995', '998', '997'], blanks=[])
        self.fields['TRAILARR'] = nacc.uds3.Field(name='TRAILARR', typename='Num', position=(284, 285), length=2, inclusive_range=(0, 40), allowable_values=[], blanks=['Blank if Question 8a TRAILA = 995-998'])
        self.fields['TRAILALI'] = nacc.uds3.Field(name='TRAILALI', typename='Num', position=(287, 288), length=2, inclusive_range=(0, 24), allowable_values=[], blanks=['Blank if 8a TRAILA = 995-998'])
        self.fields['TRAILB'] = nacc.uds3.Field(name='TRAILB', typename='Num', position=(290, 292), length=3, inclusive_range=(0, 300), allowable_values=['996', '995', '998', '997'], blanks=[])
        self.fields['TRAILBRR'] = nacc.uds3.Field(name='TRAILBRR', typename='Num', position=(294, 295), length=2, inclusive_range=(0, 40), allowable_values=[], blanks=['Blank if Question 8b TRAILB = 995-998'])
        self.fields['TRAILBLI'] = nacc.uds3.Field(name='TRAILBLI', typename='Num', position=(297, 298), length=2, inclusive_range=(0, 24), allowable_values=[], blanks=['Blank if Question 8b TRAILB = 995-998'])
        self.fields['CRAFTDVR'] = nacc.uds3.Field(name='CRAFTDVR', typename='Num', position=(300, 301), length=2, inclusive_range=(0, 44), allowable_values=['96', '95', '98', '97'], blanks=[])
        self.fields['CRAFTDRE'] = nacc.uds3.Field(name='CRAFTDRE', typename='Num', position=(303, 304), length=2, inclusive_range=(0, 25), allowable_values=[], blanks=['Blank if Question Question 9a CRAFTDVR = 95-98'])
        self.fields['CRAFTDTI'] = nacc.uds3.Field(name='CRAFTDTI', typename='Num', position=(306, 307), length=2, inclusive_range=(0, 85), allowable_values=['99'], blanks=['Blank if Question 9a CRAFTDVR = 95-98'])
        self.fields['CRAFTCUE'] = nacc.uds3.Field(name='CRAFTCUE', typename='Num', position=(309, 309), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 9a CRAFTDVR = 95-98'])
        self.fields['UDSBENTD'] = nacc.uds3.Field(name='UDSBENTD', typename='Num', position=(311, 312), length=2, inclusive_range=(0, 17), allowable_values=['96', '95', '98', '97'], blanks=[])
        self.fields['UDSBENRS'] = nacc.uds3.Field(name='UDSBENRS', typename='Num', position=(314, 314), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 10a UDSBENTD = 95-98'])
        self.fields['MINTTOTS'] = nacc.uds3.Field(name='MINTTOTS', typename='Num', position=(316, 317), length=2, inclusive_range=(0, 32), allowable_values=['96', '95', '98', '97'], blanks=[])
        self.fields['MINTTOTW'] = nacc.uds3.Field(name='MINTTOTW', typename='Num', position=(319, 320), length=2, inclusive_range=(0, 32), allowable_values=[], blanks=['Blank if Question 11a MINTTOTS = 95-98'])
        self.fields['MINTSCNG'] = nacc.uds3.Field(name='MINTSCNG', typename='Num', position=(322, 323), length=2, inclusive_range=(0, 32), allowable_values=[], blanks=['Blank if Question 11a MINTTOTS = 95-98'])
        self.fields['MINTSCNC'] = nacc.uds3.Field(name='MINTSCNC', typename='Num', position=(325, 326), length=2, inclusive_range=(0, 32), allowable_values=['88'], blanks=['Blank if Question 11a MINTTOTS = 95-98'])
        self.fields['MINTPCNG'] = nacc.uds3.Field(name='MINTPCNG', typename='Num', position=(328, 329), length=2, inclusive_range=(0, 32), allowable_values=[], blanks=['Blank if Question 11a MINTTOTS = 95-98'])
        self.fields['MINTPCNC'] = nacc.uds3.Field(name='MINTPCNC', typename='Num', position=(331, 332), length=2, inclusive_range=(0, 32), allowable_values=['88'], blanks=['Blank if Question 11a MINTTOTS = 95-98'])
        self.fields['UDSVERFC'] = nacc.uds3.Field(name='UDSVERFC', typename='Num', position=(334, 335), length=2, inclusive_range=(0, 40), allowable_values=['96', '95', '98', '97'], blanks=[])
        self.fields['UDSVERFN'] = nacc.uds3.Field(name='UDSVERFN', typename='Num', position=(337, 338), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=['Blank if Question 12a UDSVERFC = 95-98'])
        self.fields['UDSVERNF'] = nacc.uds3.Field(name='UDSVERNF', typename='Num', position=(340, 341), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=['Blank if Question 12a UDSVERFC = 95-98'])
        self.fields['UDSVERLC'] = nacc.uds3.Field(name='UDSVERLC', typename='Num', position=(343, 344), length=2, inclusive_range=(0, 40), allowable_values=['96', '95', '98', '97'], blanks=[])
        self.fields['UDSVERLR'] = nacc.uds3.Field(name='UDSVERLR', typename='Num', position=(346, 347), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=['Blank if Question 12d UDSVERLC = 95-98'])
        self.fields['UDSVERLN'] = nacc.uds3.Field(name='UDSVERLN', typename='Num', position=(349, 350), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=['Blank if Question 12d UDSVERLC = 95-98'])
        self.fields['UDSVERTN'] = nacc.uds3.Field(name='UDSVERTN', typename='Num', position=(352, 353), length=2, inclusive_range=(0, 80), allowable_values=[], blanks=['Blank if Question 12d UDSVERLC = 95-98'])
        self.fields['UDSVERTE'] = nacc.uds3.Field(name='UDSVERTE', typename='Num', position=(355, 356), length=2, inclusive_range=(0, 30), allowable_values=[], blanks=['Blank if Question 12d UDSVERLC = 95-98'])
        self.fields['UDSVERTI'] = nacc.uds3.Field(name='UDSVERTI', typename='Num', position=(358, 359), length=2, inclusive_range=(0, 30), allowable_values=[], blanks=['Blank if Question 12d UDSVERLC = 95-98'])
        self.fields['COGSTAT'] = nacc.uds3.Field(name='COGSTAT', typename='Num', position=(361, 361), length=1, inclusive_range=(0, 4), allowable_values=['3', '2', '1', '0', '4'], blanks=[])

class FormCLS(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['APREFLAN'] = nacc.uds3.Field(name='APREFLAN', typename='Num', position=(45, 45), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['AYRSPAN'] = nacc.uds3.Field(name='AYRSPAN', typename='Num', position=(47, 49), length=3, inclusive_range=(0, 110), allowable_values=[], blanks=[])
        self.fields['AYRENGL'] = nacc.uds3.Field(name='AYRENGL', typename='Num', position=(51, 53), length=3, inclusive_range=(0, 110), allowable_values=[], blanks=[])
        self.fields['APCSPAN'] = nacc.uds3.Field(name='APCSPAN', typename='Num', position=(55, 57), length=3, inclusive_range=(0, 100), allowable_values=[], blanks=[])
        self.fields['APCENGL'] = nacc.uds3.Field(name='APCENGL', typename='Num', position=(59, 61), length=3, inclusive_range=(0, 110), allowable_values=[], blanks=[])
        self.fields['ASPKSPAN'] = nacc.uds3.Field(name='ASPKSPAN', typename='Num', position=(63, 63), length=1, inclusive_range=(1, 7), allowable_values=['1', '2', '3', '4', '5', '6', '7'], blanks=[])
        self.fields['AREASPAN'] = nacc.uds3.Field(name='AREASPAN', typename='Num', position=(65, 65), length=1, inclusive_range=(1, 7), allowable_values=['1', '2', '3', '4', '5', '6', '7'], blanks=[])
        self.fields['AWRISPAN'] = nacc.uds3.Field(name='AWRISPAN', typename='Num', position=(67, 67), length=1, inclusive_range=(1, 7), allowable_values=['1', '2', '3', '4', '5', '6', '7'], blanks=[])
        self.fields['AUNDSPAN'] = nacc.uds3.Field(name='AUNDSPAN', typename='Num', position=(69, 69), length=1, inclusive_range=(1, 7), allowable_values=['1', '2', '3', '4', '5', '6', '7'], blanks=[])
        self.fields['ASPKENGL'] = nacc.uds3.Field(name='ASPKENGL', typename='Num', position=(71, 71), length=1, inclusive_range=(1, 7), allowable_values=['1', '2', '3', '4', '5', '6', '7'], blanks=[])
        self.fields['AREAENGL'] = nacc.uds3.Field(name='AREAENGL', typename='Num', position=(73, 73), length=1, inclusive_range=(1, 7), allowable_values=['1', '2', '3', '4', '5', '6', '7'], blanks=[])
        self.fields['AWRIENGL'] = nacc.uds3.Field(name='AWRIENGL', typename='Num', position=(75, 75), length=1, inclusive_range=(1, 7), allowable_values=['1', '2', '3', '4', '5', '6', '7'], blanks=[])
        self.fields['AUNDENGL'] = nacc.uds3.Field(name='AUNDENGL', typename='Num', position=(77, 77), length=1, inclusive_range=(1, 7), allowable_values=['1', '2', '3', '4', '5', '6', '7'], blanks=[])

class FormD1(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['DXMETHOD'] = nacc.uds3.Field(name='DXMETHOD', typename='Num', position=(45, 45), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=[])
        self.fields['NORMCOG'] = nacc.uds3.Field(name='NORMCOG', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['DEMENTED'] = nacc.uds3.Field(name='DEMENTED', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1( Yes)'])
        self.fields['AMNDEM'] = nacc.uds3.Field(name='AMNDEM', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['PCA'] = nacc.uds3.Field(name='PCA', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['PPASYN'] = nacc.uds3.Field(name='PPASYN', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['PPASYNT'] = nacc.uds3.Field(name='PPASYNT', typename='Num', position=(57, 57), length=1, inclusive_range=(1, 4), allowable_values=['3', '2', '1', '4'], blanks=['Blank if Question 4c PPASYN ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['FTDSYN'] = nacc.uds3.Field(name='FTDSYN', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['LBDSYN'] = nacc.uds3.Field(name='LBDSYN', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['NAMNDEM'] = nacc.uds3.Field(name='NAMNDEM', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 0 (No)'])
        self.fields['MCIAMEM'] = nacc.uds3.Field(name='MCIAMEM', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)'])
        self.fields['MCIAPLUS'] = nacc.uds3.Field(name='MCIAPLUS', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)'])
        self.fields['MCIAPLAN'] = nacc.uds3.Field(name='MCIAPLAN', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5b MCIAPLUS ne 1'])
        self.fields['MCIAPATT'] = nacc.uds3.Field(name='MCIAPATT', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5b MCIAPLUS ne 1'])
        self.fields['MCIAPEX'] = nacc.uds3.Field(name='MCIAPEX', typename='Num', position=(73, 73), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5b MCIAPLUS ne 1'])
        self.fields['MCIAPVIS'] = nacc.uds3.Field(name='MCIAPVIS', typename='Num', position=(75, 75), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes', 'Blank if Question 5b MCIAPLUS ne 1'])
        self.fields['MCINON1'] = nacc.uds3.Field(name='MCINON1', typename='Num', position=(77, 77), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)'])
        self.fields['MCIN1LAN'] = nacc.uds3.Field(name='MCIN1LAN', typename='Num', position=(79, 79), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5c MCINON1 ne 1'])
        self.fields['MCIN1ATT'] = nacc.uds3.Field(name='MCIN1ATT', typename='Num', position=(81, 81), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5c MCINON1 ne 1'])
        self.fields['MCIN1EX'] = nacc.uds3.Field(name='MCIN1EX', typename='Num', position=(83, 83), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5c MCINON1 ne 1'])
        self.fields['MCIN1VIS'] = nacc.uds3.Field(name='MCIN1VIS', typename='Num', position=(85, 85), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5c MCINON1 ne 1'])
        self.fields['MCINON2'] = nacc.uds3.Field(name='MCINON2', typename='Num', position=(87, 87), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)'])
        self.fields['MCIN2LAN'] = nacc.uds3.Field(name='MCIN2LAN', typename='Num', position=(89, 89), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5d MCINON2 ne 1'])
        self.fields['MCIN2ATT'] = nacc.uds3.Field(name='MCIN2ATT', typename='Num', position=(91, 91), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5d MCINON2 ne 1'])
        self.fields['MCIN2EX'] = nacc.uds3.Field(name='MCIN2EX', typename='Num', position=(93, 93), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5d MCINON2 ne 1'])
        self.fields['MCIN2VIS'] = nacc.uds3.Field(name='MCIN2VIS', typename='Num', position=(95, 95), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)', 'Blank if Question 5d MCINON2 ne 1'])
        self.fields['IMPNOMCI'] = nacc.uds3.Field(name='IMPNOMCI', typename='Num', position=(97, 97), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 2 NORMCOG = 1 (Yes)', 'Blank if Question 3 DEMENTED = 1 (Yes)'])
        self.fields['AMYLPET'] = nacc.uds3.Field(name='AMYLPET', typename='Num', position=(99, 99), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['AMYLCSF'] = nacc.uds3.Field(name='AMYLCSF', typename='Num', position=(101, 101), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['FDGAD'] = nacc.uds3.Field(name='FDGAD', typename='Num', position=(103, 103), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['HIPPATR'] = nacc.uds3.Field(name='HIPPATR', typename='Num', position=(105, 105), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['TAUPETAD'] = nacc.uds3.Field(name='TAUPETAD', typename='Num', position=(107, 107), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['CSFTAU'] = nacc.uds3.Field(name='CSFTAU', typename='Num', position=(109, 109), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['FDGFTLD'] = nacc.uds3.Field(name='FDGFTLD', typename='Num', position=(111, 111), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['TPETFTLD'] = nacc.uds3.Field(name='TPETFTLD', typename='Num', position=(113, 113), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['MRFTLD'] = nacc.uds3.Field(name='MRFTLD', typename='Num', position=(115, 115), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['DATSCAN'] = nacc.uds3.Field(name='DATSCAN', typename='Num', position=(117, 117), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['OTHBIOM'] = nacc.uds3.Field(name='OTHBIOM', typename='Num', position=(119, 119), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['OTHBIOMX'] = nacc.uds3.Field(name='OTHBIOMX', typename='Char', position=(121, 180), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 6k OTHBIOM = 0 (No)'])
        self.fields['IMAGLINF'] = nacc.uds3.Field(name='IMAGLINF', typename='Num', position=(182, 182), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['IMAGLAC'] = nacc.uds3.Field(name='IMAGLAC', typename='Num', position=(184, 184), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['IMAGMACH'] = nacc.uds3.Field(name='IMAGMACH', typename='Num', position=(186, 186), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['IMAGMICH'] = nacc.uds3.Field(name='IMAGMICH', typename='Num', position=(188, 188), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['IMAGMWMH'] = nacc.uds3.Field(name='IMAGMWMH', typename='Num', position=(190, 190), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['IMAGEWMH'] = nacc.uds3.Field(name='IMAGEWMH', typename='Num', position=(192, 192), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ADMUT'] = nacc.uds3.Field(name='ADMUT', typename='Num', position=(194, 194), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['FTLDMUT'] = nacc.uds3.Field(name='FTLDMUT', typename='Num', position=(196, 196), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['OTHMUT'] = nacc.uds3.Field(name='OTHMUT', typename='Num', position=(198, 198), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=[])
        self.fields['OTHMUTX'] = nacc.uds3.Field(name='OTHMUTX', typename='Char', position=(200, 259), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 10 OTHMUT ne 1 (Present)'])
        self.fields['ALZDIS'] = nacc.uds3.Field(name='ALZDIS', typename='Num', position=(261, 261), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['ALZDISIF'] = nacc.uds3.Field(name='ALZDISIF', typename='Num', position=(263, 263), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 11 ALZDIS ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['LBDIS'] = nacc.uds3.Field(name='LBDIS', typename='Num', position=(265, 265), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['LBDIF'] = nacc.uds3.Field(name='LBDIF', typename='Num', position=(267, 267), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 12 LBDIS ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['PARK'] = nacc.uds3.Field(name='PARK', typename='Num', position=(269, 269), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 12 LBDIS ne 1 (Present)'])
        self.fields['MSA'] = nacc.uds3.Field(name='MSA', typename='Num', position=(271, 271), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['MSAIF'] = nacc.uds3.Field(name='MSAIF', typename='Num', position=(273, 273), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 13 MSA ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['PSP'] = nacc.uds3.Field(name='PSP', typename='Num', position=(275, 275), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['PSPIF'] = nacc.uds3.Field(name='PSPIF', typename='Num', position=(277, 277), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 14a PSP ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['CORT'] = nacc.uds3.Field(name='CORT', typename='Num', position=(279, 279), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['CORTIF'] = nacc.uds3.Field(name='CORTIF', typename='Num', position=(281, 281), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 14b CORT ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['FTLDMO'] = nacc.uds3.Field(name='FTLDMO', typename='Num', position=(283, 283), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['FTLDMOIF'] = nacc.uds3.Field(name='FTLDMOIF', typename='Num', position=(285, 285), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 14c FTLDMO ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['FTLDNOS'] = nacc.uds3.Field(name='FTLDNOS', typename='Num', position=(287, 287), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['FTLDNOIF'] = nacc.uds3.Field(name='FTLDNOIF', typename='Num', position=(289, 289), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 14d FTLDNOS ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['FTLDSUBT'] = nacc.uds3.Field(name='FTLDSUBT', typename='Num', position=(291, 291), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['if #14a PSP ne 1 and #14b CORT ne 1 and #14c FTLDMO ne 1 and 14d FTLDNOS ne 1'])
        self.fields['FTLDSUBX'] = nacc.uds3.Field(name='FTLDSUBX', typename='Char', position=(293, 352), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 14e FTLDSUBT ne 3'])
        self.fields['CVD'] = nacc.uds3.Field(name='CVD', typename='Num', position=(354, 354), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['CVDIF'] = nacc.uds3.Field(name='CVDIF', typename='Num', position=(356, 356), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 15 CVD ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['PREVSTK'] = nacc.uds3.Field(name='PREVSTK', typename='Num', position=(358, 358), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 15 CVD ne 1 (Present)'])
        self.fields['STROKDEC'] = nacc.uds3.Field(name='STROKDEC', typename='Num', position=(360, 360), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 15 CVD ne 1 (Present)', 'Blank if Question 15b PREVSTK ne 1 (Yes)'])
        self.fields['STKIMAG'] = nacc.uds3.Field(name='STKIMAG', typename='Num', position=(362, 362), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 15 CVD ne 1 (Present)', 'Blank if Question 15b PREVSTK ne 1 (Yes)'])
        self.fields['INFNETW'] = nacc.uds3.Field(name='INFNETW', typename='Num', position=(364, 364), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 15 CVD ne 1 (Present)'])
        self.fields['INFWMH'] = nacc.uds3.Field(name='INFWMH', typename='Num', position=(366, 366), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 15 CVD ne 1 (Present)'])
        self.fields['ESSTREM'] = nacc.uds3.Field(name='ESSTREM', typename='Num', position=(368, 368), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['ESSTREIF'] = nacc.uds3.Field(name='ESSTREIF', typename='Num', position=(370, 370), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 16 ESSTREM ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['DOWNS'] = nacc.uds3.Field(name='DOWNS', typename='Num', position=(372, 372), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['DOWNSIF'] = nacc.uds3.Field(name='DOWNSIF', typename='Num', position=(374, 374), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 17 DOWNS ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['HUNT'] = nacc.uds3.Field(name='HUNT', typename='Num', position=(376, 376), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['HUNTIF'] = nacc.uds3.Field(name='HUNTIF', typename='Num', position=(378, 378), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 18 HUNT ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['PRION'] = nacc.uds3.Field(name='PRION', typename='Num', position=(380, 380), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['PRIONIF'] = nacc.uds3.Field(name='PRIONIF', typename='Num', position=(382, 382), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 19 PRION ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['BRNINJ'] = nacc.uds3.Field(name='BRNINJ', typename='Num', position=(384, 384), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['BRNINJIF'] = nacc.uds3.Field(name='BRNINJIF', typename='Num', position=(386, 386), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 20 BRNINJ ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['BRNINCTE'] = nacc.uds3.Field(name='BRNINCTE', typename='Num', position=(388, 388), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 20 BRNINJ ne 1 (Present)'])
        self.fields['HYCEPH'] = nacc.uds3.Field(name='HYCEPH', typename='Num', position=(390, 390), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['HYCEPHIF'] = nacc.uds3.Field(name='HYCEPHIF', typename='Num', position=(392, 392), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 21 HYCEPH ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['EPILEP'] = nacc.uds3.Field(name='EPILEP', typename='Num', position=(394, 394), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['EPILEPIF'] = nacc.uds3.Field(name='EPILEPIF', typename='Num', position=(396, 396), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 22 EPILEP ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['NEOP'] = nacc.uds3.Field(name='NEOP', typename='Num', position=(398, 398), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['NEOPIF'] = nacc.uds3.Field(name='NEOPIF', typename='Num', position=(400, 400), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 23 NEOP ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['NEOPSTAT'] = nacc.uds3.Field(name='NEOPSTAT', typename='Num', position=(402, 402), length=1, inclusive_range=(1, 2), allowable_values=['2', '1'], blanks=['Blank if Question 23 NEOP ne 1 (Present)'])
        self.fields['HIV'] = nacc.uds3.Field(name='HIV', typename='Num', position=(404, 404), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['HIVIF'] = nacc.uds3.Field(name='HIVIF', typename='Num', position=(406, 406), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 24 HIV ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['OTHCOG'] = nacc.uds3.Field(name='OTHCOG', typename='Num', position=(408, 408), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['OTHCOGIF'] = nacc.uds3.Field(name='OTHCOGIF', typename='Num', position=(410, 410), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 25 OTHCOG ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['OTHCOGX'] = nacc.uds3.Field(name='OTHCOGX', typename='Char', position=(412, 471), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 25 OTHCOG ne 1 (Present)'])
        self.fields['DEP'] = nacc.uds3.Field(name='DEP', typename='Num', position=(473, 473), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['DEPIF'] = nacc.uds3.Field(name='DEPIF', typename='Num', position=(475, 475), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 26 DEP ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['DEPTREAT'] = nacc.uds3.Field(name='DEPTREAT', typename='Num', position=(477, 477), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 26 DEP ne 1 (Present)'])
        self.fields['BIPOLDX'] = nacc.uds3.Field(name='BIPOLDX', typename='Num', position=(479, 479), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['BIPOLDIF'] = nacc.uds3.Field(name='BIPOLDIF', typename='Num', position=(481, 481), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 27 BIPOLDX ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['SCHIZOP'] = nacc.uds3.Field(name='SCHIZOP', typename='Num', position=(483, 483), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['SCHIZOIF'] = nacc.uds3.Field(name='SCHIZOIF', typename='Num', position=(485, 485), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 28 SCHIZOP ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['ANXIET'] = nacc.uds3.Field(name='ANXIET', typename='Num', position=(487, 487), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['ANXIETIF'] = nacc.uds3.Field(name='ANXIETIF', typename='Num', position=(489, 489), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 29 ANXIET ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['DELIR'] = nacc.uds3.Field(name='DELIR', typename='Num', position=(491, 491), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['DELIRIF'] = nacc.uds3.Field(name='DELIRIF', typename='Num', position=(493, 493), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 30 DELIR ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['PTSDDX'] = nacc.uds3.Field(name='PTSDDX', typename='Num', position=(495, 495), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['PTSDDXIF'] = nacc.uds3.Field(name='PTSDDXIF', typename='Num', position=(497, 497), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 31 PTSDDX ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['OTHPSY'] = nacc.uds3.Field(name='OTHPSY', typename='Num', position=(499, 499), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['OTHPSYIF'] = nacc.uds3.Field(name='OTHPSYIF', typename='Num', position=(501, 501), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 32 OTHPSY ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['OTHPSYX'] = nacc.uds3.Field(name='OTHPSYX', typename='Char', position=(503, 562), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 32 OTHPSY ne 1 (Present)'])
        self.fields['ALCDEM'] = nacc.uds3.Field(name='ALCDEM', typename='Num', position=(564, 564), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['ALCDEMIF'] = nacc.uds3.Field(name='ALCDEMIF', typename='Num', position=(566, 566), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 33 ALCDEM ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['ALCABUSE'] = nacc.uds3.Field(name='ALCABUSE', typename='Num', position=(568, 568), length=1, inclusive_range=(0, 1), allowable_values=['9', '1', '0'], blanks=['Blank if Question 33 ALCDEM ne 1 (Present)'])
        self.fields['IMPSUB'] = nacc.uds3.Field(name='IMPSUB', typename='Num', position=(570, 570), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['IMPSUBIF'] = nacc.uds3.Field(name='IMPSUBIF', typename='Num', position=(572, 572), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 34 IMPSUB ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['DYSILL'] = nacc.uds3.Field(name='DYSILL', typename='Num', position=(574, 574), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['DYSILLIF'] = nacc.uds3.Field(name='DYSILLIF', typename='Num', position=(576, 576), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 35 DYSILL ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['MEDS'] = nacc.uds3.Field(name='MEDS', typename='Num', position=(578, 578), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['MEDSIF'] = nacc.uds3.Field(name='MEDSIF', typename='Num', position=(580, 580), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 36 MEDS ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['COGOTH'] = nacc.uds3.Field(name='COGOTH', typename='Num', position=(582, 582), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['COGOTHIF'] = nacc.uds3.Field(name='COGOTHIF', typename='Num', position=(584, 584), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 37 COGOTH ne 1 (Present', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['COGOTHX'] = nacc.uds3.Field(name='COGOTHX', typename='Char', position=(586, 645), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 37 COGOTH ne 1 (Present)'])
        self.fields['COGOTH2'] = nacc.uds3.Field(name='COGOTH2', typename='Num', position=(647, 647), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['COGOTH2F'] = nacc.uds3.Field(name='COGOTH2F', typename='Num', position=(649, 649), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 38 COGOTH2 ne 1 (Present)', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['COGOTH2X'] = nacc.uds3.Field(name='COGOTH2X', typename='Char', position=(651, 710), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 38 COGOTH2 ne 1 (Present)'])
        self.fields['COGOTH3'] = nacc.uds3.Field(name='COGOTH3', typename='Num', position=(712, 712), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['COGOTH3F'] = nacc.uds3.Field(name='COGOTH3F', typename='Num', position=(714, 714), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1'], blanks=['Blank if Question 39 COGOTH3 ne 1', 'Blank if Question 2 NORMCOG = 1 (Yes)'])
        self.fields['COGOTH3X'] = nacc.uds3.Field(name='COGOTH3X', typename='Char', position=(716, 775), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 39 COGOTH3 ne 1'])


class FormD2(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['CANCER'] = nacc.uds3.Field(name='CANCER', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 2), allowable_values=['2', '1', '0', '8'], blanks=[])
        self.fields['CANCSITE'] = nacc.uds3.Field(name='CANCSITE', typename='Char', position=(47, 106), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 CANCER = 0 (No)', 'Blank if Question 1 CANCER = 8 (Not assessed)'])
        self.fields['DIABET'] = nacc.uds3.Field(name='DIABET', typename='Num', position=(108, 108), length=1, inclusive_range=(0, 3), allowable_values=['2', '1', '0', '9', '3'], blanks=[])
        self.fields['MYOINF'] = nacc.uds3.Field(name='MYOINF', typename='Num', position=(110, 110), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['CONGHRT'] = nacc.uds3.Field(name='CONGHRT', typename='Num', position=(112, 112), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['AFIBRILL'] = nacc.uds3.Field(name='AFIBRILL', typename='Num', position=(114, 114), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['HYPERT'] = nacc.uds3.Field(name='HYPERT', typename='Num', position=(116, 116), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ANGINA'] = nacc.uds3.Field(name='ANGINA', typename='Num', position=(118, 118), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['HYPCHOL'] = nacc.uds3.Field(name='HYPCHOL', typename='Num', position=(120, 120), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['VB12DEF'] = nacc.uds3.Field(name='VB12DEF', typename='Num', position=(122, 122), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['THYDIS'] = nacc.uds3.Field(name='THYDIS', typename='Num', position=(124, 124), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ARTH'] = nacc.uds3.Field(name='ARTH', typename='Num', position=(126, 126), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ARTYPE'] = nacc.uds3.Field(name='ARTYPE', typename='Num', position=(128, 128), length=1, inclusive_range=(1, 3), allowable_values=['3', '2', '1', '9'], blanks=['Blank if Question 11 ARTH = 0 (No)', 'Blank if Question 11 ARTH = 8 (Not assessed)'])
        self.fields['ARTYPEX'] = nacc.uds3.Field(name='ARTYPEX', typename='Char', position=(130, 189), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 11a ARTYPE ne 3 (Other)'])
        self.fields['ARTUPEX'] = nacc.uds3.Field(name='ARTUPEX', typename='Num', position=(191, 191), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 11 ARTH = 0 (No)', 'Blank if Question 11 ARTH = 8 (Not assessed)'])
        self.fields['ARTLOEX'] = nacc.uds3.Field(name='ARTLOEX', typename='Num', position=(193, 193), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 11 ARTH = 0 (No)', 'Blank if Question 11 ARTH = 8 (Not assessed)'])
        self.fields['ARTSPIN'] = nacc.uds3.Field(name='ARTSPIN', typename='Num', position=(195, 195), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 11 ARTH = 0 (No)', 'Blank if Question 11 ARTH = 8 (Not assessed)'])
        self.fields['ARTUNKN'] = nacc.uds3.Field(name='ARTUNKN', typename='Num', position=(197, 197), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=['Blank if Question 11 ARTH = 0 (No)', 'Blank if Question 11 ARTH = 8 (Not assessed)'])
        self.fields['URINEINC'] = nacc.uds3.Field(name='URINEINC', typename='Num', position=(199, 199), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['BOWLINC'] = nacc.uds3.Field(name='BOWLINC', typename='Num', position=(201, 201), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['SLEEPAP'] = nacc.uds3.Field(name='SLEEPAP', typename='Num', position=(203, 203), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['REMDIS'] = nacc.uds3.Field(name='REMDIS', typename='Num', position=(205, 205), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['HYPOSOM'] = nacc.uds3.Field(name='HYPOSOM', typename='Num', position=(207, 207), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['SLEEPOTH'] = nacc.uds3.Field(name='SLEEPOTH', typename='Num', position=(209, 209), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['SLEEPOTX'] = nacc.uds3.Field(name='SLEEPOTX', typename='Char', position=(211, 270), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 17 SLEEPOTH ne 1 (Yes)'])
        self.fields['ANGIOCP'] = nacc.uds3.Field(name='ANGIOCP', typename='Num', position=(272, 272), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ANGIOPCI'] = nacc.uds3.Field(name='ANGIOPCI', typename='Num', position=(274, 274), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['PACEMAKE'] = nacc.uds3.Field(name='PACEMAKE', typename='Num', position=(276, 276), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['HVALVE'] = nacc.uds3.Field(name='HVALVE', typename='Num', position=(278, 278), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ANTIENC'] = nacc.uds3.Field(name='ANTIENC', typename='Num', position=(280, 280), length=1, inclusive_range=(0, 1), allowable_values=['8', '1', '0'], blanks=[])
        self.fields['ANTIENCX'] = nacc.uds3.Field(name='ANTIENCX', typename='Char', position=(282, 341), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 22 ANTIENC ne 1 (Yes)'])
        self.fields['OTHCOND'] = nacc.uds3.Field(name='OTHCOND', typename='Num', position=(343, 343), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['OTHCONDX'] = nacc.uds3.Field(name='OTHCONDX', typename='Char', position=(345, 404), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 23 OTHCOND ne 1 (Yes)'])

class FormZ1(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['A2SUB'] = nacc.uds3.Field(name='A2SUB', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['A2NOT'] = nacc.uds3.Field(name='A2NOT', typename='Num', position=(47, 48), length=2, inclusive_range=(95, 98), allowable_values=['97', '96', '95', '98'], blanks=['Blank if Question 1 A2SUB = 1 (Yes)'])
        self.fields['A2COMM'] = nacc.uds3.Field(name='A2COMM', typename='Char', position=(50, 109), length=60, inclusive_range=None, allowable_values=[], blanks=[])
        self.fields['A2COMM'] = nacc.uds3.Field(name='A2COMM', typename='Char', position=(50, 109), length=60, inclusive_range=None, allowable_values=[], blanks=[])
        self.fields['A3SUB'] = nacc.uds3.Field(name='A3SUB', typename='Num', position=(111, 111), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['A3NOT'] = nacc.uds3.Field(name='A3NOT', typename='Num', position=(113, 114), length=2, inclusive_range=(95, 98), allowable_values=['97', '96', '95', '98'], blanks=['Blank if Question 2 A3SUB = 1 (Yes)'])
        self.fields['A3COMM'] = nacc.uds3.Field(name='A3COMM', typename='Char', position=(116, 175), length=60, inclusive_range=None, allowable_values=[], blanks=[])
        self.fields['A4SUB'] = nacc.uds3.Field(name='A4SUB', typename='Num', position=(177, 177), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['A4NOT'] = nacc.uds3.Field(name='A4NOT', typename='Num', position=(179, 180), length=2, inclusive_range=(95, 98), allowable_values=['97', '96', '95', '98'], blanks=['Blank if Question 3 A4SUB = 1 (Yes)'])
        self.fields['A4COMM'] = nacc.uds3.Field(name='A4COMM', typename='Char', position=(182, 241), length=60, inclusive_range=None, allowable_values=[], blanks=[])
        self.fields['B1SUB'] = nacc.uds3.Field(name='B1SUB', typename='Num', position=(243, 243), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['B1NOT'] = nacc.uds3.Field(name='B1NOT', typename='Num', position=(245, 246), length=2, inclusive_range=(95, 98), allowable_values=['97', '96', '95', '98'], blanks=['Blank if Question 4 B1SUB = 1 (Yes)'])
        self.fields['B1COMM'] = nacc.uds3.Field(name='B1COMM', typename='Char', position=(248, 307), length=60, inclusive_range=None, allowable_values=[], blanks=[])
        self.fields['B5SUB'] = nacc.uds3.Field(name='B5SUB', typename='Num', position=(309, 309), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['B5NOT'] = nacc.uds3.Field(name='B5NOT', typename='Num', position=(311, 312), length=2, inclusive_range=(95, 98), allowable_values=['97', '96', '95', '98'], blanks=['Blank if Question 5 B5SUB = 1 (Yes)'])
        self.fields['B5COMM'] = nacc.uds3.Field(name='B5COMM', typename='Char', position=(314, 373), length=60, inclusive_range=None, allowable_values=[], blanks=[])
        self.fields['B6SUB'] = nacc.uds3.Field(name='B6SUB', typename='Num', position=(375, 375), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['B6NOT'] = nacc.uds3.Field(name='B6NOT', typename='Num', position=(377, 378), length=2, inclusive_range=(95, 98), allowable_values=['97', '96', '95', '98'], blanks=['Blank if Question 6 B6SUB = 1 (Yes)'])
        self.fields['B6COMM'] = nacc.uds3.Field(name='B6COMM', typename='Char', position=(380, 439), length=60, inclusive_range=None, allowable_values=[], blanks=[])
        self.fields['B7SUB'] = nacc.uds3.Field(name='B7SUB', typename='Num', position=(441, 441), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['B7NOT'] = nacc.uds3.Field(name='B7NOT', typename='Num', position=(443, 444), length=2, inclusive_range=(95, 98), allowable_values=['97', '96', '95', '98'], blanks=['Blank if Question 7 B7SUB = 1 (Yes)'])
        self.fields['B7COMM'] = nacc.uds3.Field(name='B7COMM', typename='Char', position=(446, 505), length=60, inclusive_range=None, allowable_values=[], blanks=[])


class FormZ1X(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LANGA1'] = nacc.uds3.Field(name='LANGA1', typename='Num', position=(45, 45), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGA2'] = nacc.uds3.Field(name='LANGA2', typename='Num', position=(47, 47), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=['Blank if Question 2 A2SUB = 0 (No)'])
        self.fields['A2SUB'] = nacc.uds3.Field(name='A2SUB', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['1', '0'], blanks=[])
        self.fields['A2NOT']  = nacc.uds3.Field(name='A2NOT', typename='Num', position=(51, 52), length=2, inclusive_range=(95,98), allowable_values=['98','97','96','95'], blanks=['Blank if Question 2 A2SUB = 1 (Yes)'])
        self.fields['LANGA3'] = nacc.uds3.Field(name='LANGA3', typename='Num', position=(54, 54), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=['Blank if Question 3 A3SUB = 0 (No)'])
        self.fields['A3SUB'] = nacc.uds3.Field(name='A3SUB', typename='Num', position=(56, 56), length=1, inclusive_range=(0,1), allowable_values=['1','0'], blanks=[])
        self.fields['A3NOT'] = nacc.uds3.Field(name='A3NOT', typename='Num', position=(58, 59), length=2, inclusive_range=(95,98), allowable_values=['98','97','96','95'], blanks=['Blank if Question 3 A3SUB = 1 (Yes)'])
        self.fields['LANGA4'] = nacc.uds3.Field(name='LANGA4', typename='Num', position=(61, 61), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=['Blank if Question 4 A4SUB = 0 (No)'])
        self.fields['A4SUB'] = nacc.uds3.Field(name='A4SUB', typename='Num', position=(63, 63), length=1, inclusive_range=(0,1), allowable_values=['1','0'], blanks=[])
        self.fields['A4NOT']  = nacc.uds3.Field(name='A4NOT', typename='Num', position=(65, 66), length=2, inclusive_range=(95,98), allowable_values=['98','97','96','95'], blanks=['Blank if Question 4 A4SUB = 1 (Yes)'])
        self.fields['LANGA5'] = nacc.uds3.Field(name='LANGA5', typename='Num', position=(68, 68), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGB1'] = nacc.uds3.Field(name='LANGB1', typename='Num', position=(70, 70), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=['Blank if Question 6 B1SUB = 0 (No)'])
        self.fields['B1SUB'] = nacc.uds3.Field(name='B1SUB', typename='Num', position=(72, 72), length=1, inclusive_range=(0,1), allowable_values=['1','0'], blanks=[])
        self.fields['B1NOT'] = nacc.uds3.Field(name='B1NOT', typename='Num', position=(74, 75), length=2, inclusive_range=(95,98), allowable_values=['98','97','96','95'], blanks=['Blank if Question 6 B1SUB = 1 (Yes)'])
        self.fields['LANGB4'] = nacc.uds3.Field(name='LANGB4', typename='Num', position=(77, 77), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGB5'] = nacc.uds3.Field(name='LANGB5', typename='Num', position=(79, 79), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=['Blank if Question 8 B5SUB = 0 (No)'])
        self.fields['B5SUB'] = nacc.uds3.Field(name='B5SUB', typename='Num', position=(81, 81), length=1, inclusive_range=(0,1), allowable_values=['1','0'], blanks=[])
        self.fields['B5NOT'] = nacc.uds3.Field(name='B5NOT', typename='Num', position=(83, 84), length=2, inclusive_range=(95,98), allowable_values=['98','97','96','95'], blanks=['Blank if Question 8 B5SUB = 1 (Yes)'])
        self.fields['LANGB6'] = nacc.uds3.Field(name='LANGB6', typename='Num', position=(86, 86), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=['Blank if Question 9 B6SUB = 0 (No)'])
        self.fields['B6SUB'] = nacc.uds3.Field(name='B6SUB', typename='Num', position=(88, 88), length=1, inclusive_range=(0,1), allowable_values=['1','0'], blanks=[])
        self.fields['B6NOT'] = nacc.uds3.Field(name='B6NOT', typename='Num', position=(90, 91), length=2, inclusive_range=(95,98), allowable_values=['98','97','96','95'], blanks=['Blank if Question 9 B6SUB = 1 (Yes)'])
        self.fields['LANGB7'] = nacc.uds3.Field(name='LANGB7', typename='Num', position=(93, 93), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=['Blank if Question 10 B7SUB = 0 (No)'])
        self.fields['B7SUB'] = nacc.uds3.Field(name='B7SUB', typename='Num', position=(95, 95), length=1, inclusive_range=(0,1), allowable_values=['1','0'], blanks=[])
        self.fields['B7NOT'] = nacc.uds3.Field(name='B7NOT', typename='Num', position=(97, 98), length=2, inclusive_range=(95,98), allowable_values=['98','97','96','95'], blanks=['Blank if Question 10 B7SUB = 1 (Yes)'])
        self.fields['LANGB8'] = nacc.uds3.Field(name='LANGB8', typename='Num', position=(100, 100), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGB9'] = nacc.uds3.Field(name='LANGB9', typename='Num', position=(102, 102), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGC2'] = nacc.uds3.Field(name='LANGC2', typename='Num', position=(104, 104), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGD1'] = nacc.uds3.Field(name='LANGD1', typename='Num', position=(106, 106), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGD2'] = nacc.uds3.Field(name='LANGD2', typename='Num', position=(108, 108), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGA3A'] = nacc.uds3.Field(name='LANGA3A', typename='Num', position=(110, 110), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=['Blank if Question 16 FTDA3AFS = 0 (No)'])
        self.fields['FTDA3AFS'] = nacc.uds3.Field(name='FTDA3AFS', typename='Num', position=(112, 112), length=1, inclusive_range=(0,1), allowable_values=['1','0'], blanks=[])
        self.fields['FTDA3AFR'] = nacc.uds3.Field(name='FTDA3AFR', typename='Num', position=(114, 115), length=2, inclusive_range=(95,99), allowable_values=['99','98','97','96','95'], blanks=['Blank if Question 16 FTDA3AFS = 1 (Yes)'])
        self.fields['LANGB3F'] = nacc.uds3.Field(name='LANGB3F', typename='Num', position=(117, 117), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGB9F'] = nacc.uds3.Field(name='LANGB9F', typename='Num', position=(119, 119), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGC1F'] = nacc.uds3.Field(name='LANGC1F', typename='Num', position=(121, 121), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGC2F'] = nacc.uds3.Field(name='LANGC2F', typename='Num', position=(123, 123), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGC3F'] = nacc.uds3.Field(name='LANGC3F', typename='Num', position=(125, 125), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGC4F'] = nacc.uds3.Field(name='LANGC4F', typename='Num', position=(127, 127), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=['Blank if Question 22 FTDC4FS = 0 (No)'])
        self.fields['FTDC4FS'] = nacc.uds3.Field(name='FTDC4FS', typename='Num', position=(129, 129), length=1, inclusive_range=(0,1), allowable_values=['1','0'], blanks=[])
        self.fields['FTDC4FR'] = nacc.uds3.Field(name='FTDC4FR', typename='Num', position=(131, 132), length=2, inclusive_range=(95,99), allowable_values=['99','98','97','96','95'], blanks=['Blank if Question 22 FTDC4FS = 1 (Yes)'])
        self.fields['LANGC5F'] = nacc.uds3.Field(name='LANGC5F', typename='Num', position=(134, 134), length=1, inclusive_range=(1,2), allowable_values=['1','2'], blanks=['Blank if Question 23 FTDC5FS = 0 (No)'])
        self.fields['FTDC5FS'] = nacc.uds3.Field(name='FTDC5FS', typename='Num', position=(136, 136), length=1, inclusive_range=(0,1), allowable_values=['1','0'], blanks=[])
        self.fields['FTDC5FR'] = nacc.uds3.Field(name='FTDC5FR', typename='Num', position=(138, 139), length=2, inclusive_range=(95,99), allowable_values=['99','98','97','96','95'], blanks=['Blank if Question 23 FTDC5FS = 1 (Yes)'])
        self.fields['LANGC6F'] = nacc.uds3.Field(name='LANGC6F', typename='Num', position=(141, 141), length=1, inclusive_range=(2,1), allowable_values=['1','2'], blanks=['Blank if Question 24 FTDC6FS = 0 (No)'])
        self.fields['FTDC6FS'] = nacc.uds3.Field(name='FTDC6FS', typename='Num', position=(143, 143), length=1, inclusive_range=(0,1), allowable_values=['1','0'], blanks=[])
        self.fields['FTDC6FR'] = nacc.uds3.Field(name='FTDC6FR', typename='Num', position=(145, 146), length=2, inclusive_range=(95,99), allowable_values=['99','98','97','96','95'], blanks=['Blank if Question 24 FTDC6FS = 1 (Yes)'])
        self.fields['LANGE2F'] = nacc.uds3.Field(name='LANGE2F', typename='Num', position=(148, 148), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGE3F'] = nacc.uds3.Field(name='LANGE3F', typename='Num', position=(150, 150), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=[])
        self.fields['LANGCLS'] = nacc.uds3.Field(name='LANGCLS', typename='Num', position=(152, 152), length=1, inclusive_range=(1,2), allowable_values=['2','1'], blanks=['Blank if Question 27 CLSSUB = 0 (No)'])
        self.fields['CLSSUB'] = nacc.uds3.Field(name='CLSSUB', typename='Num', position=(154, 154), length=1, inclusive_range=(0,1), allowable_values=['1','0'], blanks=[])
        self.fields['B2LSUB'] = nacc.uds3.Field(name='B2LSUB', typename='Num', position=(156, 156), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B2LNOT'] = nacc.uds3.Field(name='B2LNOT', typename='Num', position=(158, 159), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 28b B2LSUB = 1 (Yes)'])
        self.fields['B6LSUB'] = nacc.uds3.Field(name='B6LSUB', typename='Num', position=(161, 161), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B6LNOT'] = nacc.uds3.Field(name='B6LNOT', typename='Num', position=(163, 164), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 29b B6LSUB = 1 (Yes)'])
