###############################################################################
# Copyright 2015-2023 University of Florida. All rights reserved.
# This file is part of UF CTS-IT's NACCulator project.
# Use of this source code is governed by the license found in the LICENSE file.
###############################################################################

import nacc.uds3

### BEGIN non-generated code
# WARNING: When generating new forms, do not overwrite this section
from datetime import date

# WARNING: When generating new forms, use CURRENT_YEAR instead of "2014"
# WARNING: When generating new forms, use CURRENT_YEAR-15 instead of "1999"
CURRENT_YEAR = date.today().year

### END non-generated code

# This form is for LBD IVP's short forms (Lewy Body Initial, version 3.1)


def header_fields():
    """
    Generates the header info that appears in columns 1-43 of every form
    """
    fields = {}
    fields['PACKET'] = nacc.uds3.Field(name='PACKET', typename='Char', position=(1, 2), length=2, inclusive_range=None, allowable_values=[], blanks=[])
    fields['FORMID'] = nacc.uds3.Field(name='FORMID', typename='Char', position=(4, 6), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    fields['FORMVER'] = nacc.uds3.Field(name='FORMVER', typename='Num', position=(8, 10), length=3, inclusive_range=(1, 4), allowable_values=[], blanks=[])
    fields['ADCID'] = nacc.uds3.Field(name='ADCID', typename='Num', position=(12, 13), length=2, inclusive_range=(2, 99), allowable_values=[], blanks=[])
    fields['PTID'] = nacc.uds3.Field(name='PTID', typename='Char', position=(15, 24), length=10, inclusive_range=None, allowable_values=[], blanks=[])
    fields['VISITMO'] = nacc.uds3.Field(name='VISITMO', typename='Num', position=(26, 27), length=2, inclusive_range=(1, 12), allowable_values=[], blanks=[])
    fields['VISITDAY'] = nacc.uds3.Field(name='VISITDAY', typename='Num', position=(29, 30), length=2, inclusive_range=(1, 31), allowable_values=[], blanks=[])
    fields['VISITYR'] = nacc.uds3.Field(name='VISITYR', typename='Num', position=(32, 35), length=4, inclusive_range=(2005, CURRENT_YEAR), allowable_values=[], blanks=[])
    fields['VISITNUM'] = nacc.uds3.Field(name='VISITNUM', typename='Char', position=(37, 39), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    fields['INITIALS'] = nacc.uds3.Field(name='INITIALS', typename='Char', position=(41, 43), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    return fields


class FormZ1X(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LANGA1'] = nacc.uds3.Field(name='LANGA1', typename='Num', position=(45, 45), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGA2'] = nacc.uds3.Field(name='LANGA2', typename='Num', position=(47, 47), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 2b A2SUB = 0 (No)'])
        self.fields['A2SUB'] = nacc.uds3.Field(name='A2SUB', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['A2NOT'] = nacc.uds3.Field(name='A2NOT', typename='Num', position=(51, 52), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 2b A2SUB = 1 (Yes)'])
        self.fields['LANGA3'] = nacc.uds3.Field(name='LANGA3', typename='Num', position=(54, 54), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 3b A3SUB = 0 (No)'])
        self.fields['A3SUB'] = nacc.uds3.Field(name='A3SUB', typename='Num', position=(56, 56), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['A3NOT'] = nacc.uds3.Field(name='A3NOT', typename='Num', position=(58, 59), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 3b A3SUB = 1 (Yes)'])
        self.fields['LANGA4'] = nacc.uds3.Field(name='LANGA4', typename='Num', position=(61, 61), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 4b A4SUB = 0 (No)'])
        self.fields['A4SUB'] = nacc.uds3.Field(name='A4SUB', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['A4NOT'] = nacc.uds3.Field(name='A4NOT', typename='Num', position=(65, 66), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 4b A4SUB = 1 (Yes)'])
        self.fields['LANGA5'] = nacc.uds3.Field(name='LANGA5', typename='Num', position=(68, 68), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGB1'] = nacc.uds3.Field(name='LANGB1', typename='Num', position=(70, 70), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 6b B1SUB = 0 (No)'])
        self.fields['B1SUB'] = nacc.uds3.Field(name='B1SUB', typename='Num', position=(72, 72), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B1NOT'] = nacc.uds3.Field(name='B1NOT', typename='Num', position=(74, 75), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 6b B1SUB = 1 (Yes)'])
        self.fields['LANGB4'] = nacc.uds3.Field(name='LANGB4', typename='Num', position=(77, 77), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGB5'] = nacc.uds3.Field(name='LANGB5', typename='Num', position=(79, 79), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 8b B5SUB = 0 (No)'])
        self.fields['B5SUB'] = nacc.uds3.Field(name='B5SUB', typename='Num', position=(81, 81), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B5NOT'] = nacc.uds3.Field(name='B5NOT', typename='Num', position=(83, 84), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 8b B5SUB = 1 (Yes)'])
        self.fields['LANGB6'] = nacc.uds3.Field(name='LANGB6', typename='Num', position=(86, 86), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 9b B6SUB = 0 (No)'])
        self.fields['B6SUB'] = nacc.uds3.Field(name='B6SUB', typename='Num', position=(88, 88), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B6NOT'] = nacc.uds3.Field(name='B6NOT', typename='Num', position=(90, 91), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 9b B6SUB = 1 (Yes)'])
        self.fields['LANGB7'] = nacc.uds3.Field(name='LANGB7', typename='Num', position=(93, 93), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 10b B7SUB = 0 (No)'])
        self.fields['B7SUB'] = nacc.uds3.Field(name='B7SUB', typename='Num', position=(95, 95), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B7NOT'] = nacc.uds3.Field(name='B7NOT', typename='Num', position=(97, 98), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 10b B7SUB = 1 (Yes)'])
        self.fields['LANGB8'] = nacc.uds3.Field(name='LANGB8', typename='Num', position=(100, 100), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGB9'] = nacc.uds3.Field(name='LANGB9', typename='Num', position=(102, 102), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGC2'] = nacc.uds3.Field(name='LANGC2', typename='Num', position=(104, 104), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGD1'] = nacc.uds3.Field(name='LANGD1', typename='Num', position=(106, 106), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGD2'] = nacc.uds3.Field(name='LANGD2', typename='Num', position=(108, 108), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGA3A'] = nacc.uds3.Field(name='LANGA3A', typename='Num', position=(110, 110), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 16b FTDA3AFS = 0 (No)'])
        self.fields['FTDA3AFS'] = nacc.uds3.Field(name='FTDA3AFS', typename='Num', position=(112, 112), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDA3AFR'] = nacc.uds3.Field(name='FTDA3AFR', typename='Num', position=(114, 115), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 16b FTDA3AFS = 1 (Yes)'])
        self.fields['LANGB3F'] = nacc.uds3.Field(name='LANGB3F', typename='Num', position=(117, 117), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGB9F'] = nacc.uds3.Field(name='LANGB9F', typename='Num', position=(119, 119), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGC1F'] = nacc.uds3.Field(name='LANGC1F', typename='Num', position=(121, 121), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGC2F'] = nacc.uds3.Field(name='LANGC2F', typename='Num', position=(123, 123), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGC3F'] = nacc.uds3.Field(name='LANGC3F', typename='Num', position=(125, 125), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGC4F'] = nacc.uds3.Field(name='LANGC4F', typename='Num', position=(127, 127), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 22b FTDC4FS = 0 (No)'])
        self.fields['FTDC4FS'] = nacc.uds3.Field(name='FTDC4FS', typename='Num', position=(129, 129), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDC4FR'] = nacc.uds3.Field(name='FTDC4FR', typename='Num', position=(131, 132), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 22b FTDC4FS = 1 (Yes)'])
        self.fields['LANGC5F'] = nacc.uds3.Field(name='LANGC5F', typename='Num', position=(134, 134), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 23b FTDC5FS = 0 (No)'])
        self.fields['FTDC5FS'] = nacc.uds3.Field(name='FTDC5FS', typename='Num', position=(136, 136), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDC5FR'] = nacc.uds3.Field(name='FTDC5FR', typename='Num', position=(138, 139), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 23b FTDC5FS = 1 (Yes)'])
        self.fields['LANGC6F'] = nacc.uds3.Field(name='LANGC6F', typename='Num', position=(141, 141), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 24b FTDC6FS = 0 (No)'])
        self.fields['FTDC6FS'] = nacc.uds3.Field(name='FTDC6FS', typename='Num', position=(143, 143), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDC6FR'] = nacc.uds3.Field(name='FTDC6FR', typename='Num', position=(145, 146), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 24b FTDC6FS= 1 (Yes)'])
        self.fields['LANGE2F'] = nacc.uds3.Field(name='LANGE2F', typename='Num', position=(148, 148), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGE3F'] = nacc.uds3.Field(name='LANGE3F', typename='Num', position=(150, 150), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGCLS'] = nacc.uds3.Field(name='LANGCLS', typename='Num', position=(152, 152), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 27b CLSSUB = 0 (No)'])
        self.fields['CLSSUB'] = nacc.uds3.Field(name='CLSSUB', typename='Num', position=(154, 154), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B2LSUB'] = nacc.uds3.Field(name='B2LSUB', typename='Num', position=(156, 156), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B2LNOT'] = nacc.uds3.Field(name='B2LNOT', typename='Num', position=(158, 159), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 28b B2LSUB = 1 (Yes)'])
        self.fields['B6LSUB'] = nacc.uds3.Field(name='B6LSUB', typename='Num', position=(161, 161), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B6LNOT'] = nacc.uds3.Field(name='B6LNOT', typename='Num', position=(163, 164), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 29b B6LSUB = 1 (Yes)'])


class FormB1L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBSSALIV'] = nacc.uds3.Field(name='LBSSALIV', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBSSWALL'] = nacc.uds3.Field(name='LBSSWALL', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBSSMeLL'] = nacc.uds3.Field(name='LBSSMeLL', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBSSWeAt'] = nacc.uds3.Field(name='LBSSWeAt', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBSCoNSt'] = nacc.uds3.Field(name='LBSCoNSt', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBSUBLAD'] = nacc.uds3.Field(name='LBSUBLAD', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBSDZStU'] = nacc.uds3.Field(name='LBSDZStU', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBSDZStN'] = nacc.uds3.Field(name='LBSDZStN', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBSFAINt'] = nacc.uds3.Field(name='LBSFAINt', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBPSyAGe'] = nacc.uds3.Field(name='LBPSyAGe', typename='Num', position=(63, 65), length=3, inclusive_range=(15, 110), allowable_values=['888', '999'], blanks=[])
        self.fields['LBSStNSy'] = nacc.uds3.Field(name='LBSStNSy', typename='Num', position=(67, 69), length=3, inclusive_range=(50, 240), allowable_values=['888'], blanks=[])
        self.fields['LBSITSy'] = nacc.uds3.Field(name='LBSITSy', typename='Num', position=(71, 73), length=3, inclusive_range=(50, 240), allowable_values=['888'], blanks=[])
        self.fields['LBSStNDI'] = nacc.uds3.Field(name='LBSStNDI', typename='Num', position=(75, 77), length=3, inclusive_range=(20, 150), allowable_values=['888'], blanks=[])
        self.fields['LBSITDI'] = nacc.uds3.Field(name='LBSITDI', typename='Num', position=(79, 81), length=3, inclusive_range=(20, 150), allowable_values=['888'], blanks=[])
        self.fields['LBSStNHt'] = nacc.uds3.Field(name='LBSStNHt', typename='Num', position=(83, 85), length=3, inclusive_range=(33, 180), allowable_values=['888'], blanks=[])
        self.fields['LBSITHR'] = nacc.uds3.Field(name='LBSITHR', typename='Num', position=(87, 89), length=3, inclusive_range=(33, 180), allowable_values=['888'], blanks=[])
        self.fields['LBSAGerM'] = nacc.uds3.Field(name='LBSAGerM', typename='Num', position=(91, 93), length=3, inclusive_range=(15, 110), allowable_values=['888', '999'], blanks=[])
        self.fields['LBSAGeSM'] = nacc.uds3.Field(name='LBSAGeSM', typename='Num', position=(95, 97), length=3, inclusive_range=(15, 110), allowable_values=['888', '999'], blanks=[])
        self.fields['LBSAGeGt'] = nacc.uds3.Field(name='LBSAGeGt', typename='Num', position=(99, 101), length=3, inclusive_range=(9, 110), allowable_values=['888', '999'], blanks=[])
        self.fields['LBSAGeFL'] = nacc.uds3.Field(name='LBSAGeFL', typename='Num', position=(103, 105), length=3, inclusive_range=(9, 110), allowable_values=['888', '999'], blanks=[])
        self.fields['LBSAGetr'] = nacc.uds3.Field(name='LBSAGetr', typename='Num', position=(107, 109), length=3, inclusive_range=(9, 110), allowable_values=['888', '999'], blanks=[])
        self.fields['LBSAGeBr'] = nacc.uds3.Field(name='LBSAGeBr', typename='Num', position=(111, 113), length=3, inclusive_range=(9, 110), allowable_values=['888', '999'], blanks=[])


class FormB2L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBUDSPCH'] = nacc.uds3.Field(name='LBUDSPCH', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUDSALV'] = nacc.uds3.Field(name='LBUDSALV', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUDSWAL'] = nacc.uds3.Field(name='LBUDSWAL', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUWrIte'] = nacc.uds3.Field(name='LBUWrIte', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUDFooD'] = nacc.uds3.Field(name='LBUDFooD', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUDreSS'] = nacc.uds3.Field(name='LBUDreSS', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUDHyGN'] = nacc.uds3.Field(name='LBUDHyGN', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUDtUrN'] = nacc.uds3.Field(name='LBUDtUrN', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUDFALL'] = nacc.uds3.Field(name='LBUDFALL', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUDFrZ'] = nacc.uds3.Field(name='LBUDFrZ', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUDWALK'] = nacc.uds3.Field(name='LBUDWALK', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUDtreM'] = nacc.uds3.Field(name='LBUDtreM', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])
        self.fields['LBUDSeNS'] = nacc.uds3.Field(name='LBUDSeNS', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8', '9'], blanks=[])


class FormB3L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBUMSPCH'] = nacc.uds3.Field(name='LBUMSPCH', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUMSPCX'] = nacc.uds3.Field(name='LBUMSPCX', typename='Char', position=(47, 106), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 LBUMSPCH ne 8 (Untestable)'])
        self.fields['LBUMFACe'] = nacc.uds3.Field(name='LBUMFACe', typename='Num', position=(108, 108), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUMFACX'] = nacc.uds3.Field(name='LBUMFACX', typename='Char', position=(110, 169), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 2 LBUMFACe ne 8 (Untestable)'])
        self.fields['LBUMtrFA'] = nacc.uds3.Field(name='LBUMtrFA', typename='Num', position=(171, 171), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUtrFAX'] = nacc.uds3.Field(name='LBUtrFAX', typename='Char', position=(173, 232), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3a LBUMtrFA ne 8 (Untestable)'])
        self.fields['LBUMtrrH'] = nacc.uds3.Field(name='LBUMtrrH', typename='Num', position=(234, 234), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUtrrHX'] = nacc.uds3.Field(name='LBUtrrHX', typename='Char', position=(236, 295), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3b LBUMtrrH ne 8 (Untestable)'])
        self.fields['LBUMtrLH'] = nacc.uds3.Field(name='LBUMtrLH', typename='Num', position=(297, 297), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUtrLHX'] = nacc.uds3.Field(name='LBUtrLHX', typename='Char', position=(299, 358), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3c LBUMtrLH ne 8 (Untestable)'])
        self.fields['LBUMtrrF'] = nacc.uds3.Field(name='LBUMtrrF', typename='Num', position=(360, 360), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUtrrFX'] = nacc.uds3.Field(name='LBUtrrFX', typename='Char', position=(362, 421), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3d LBUMtrrF ne 8 (Untestable)'])
        self.fields['LBUMtrLF'] = nacc.uds3.Field(name='LBUMtrLF', typename='Num', position=(423, 423), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUtrLFX'] = nacc.uds3.Field(name='LBUtrLFX', typename='Char', position=(425, 484), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3e LBUMtrLF ne 8 (Untestable)'])
        self.fields['LBUMAtrH'] = nacc.uds3.Field(name='LBUMAtrH', typename='Num', position=(486, 486), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUAtrHX'] = nacc.uds3.Field(name='LBUAtrHX', typename='Char', position=(488, 547), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 4a LBUMAtrH ne 8 (Untestable)'])
        self.fields['LBUMAtLH'] = nacc.uds3.Field(name='LBUMAtLH', typename='Num', position=(549, 549), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUAtLHX'] = nacc.uds3.Field(name='LBUAtLHX', typename='Char', position=(551, 610), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 4b LBUMAtLH ne 8 (Untestable)'])
        self.fields['LBUMrGNK'] = nacc.uds3.Field(name='LBUMrGNK', typename='Num', position=(612, 612), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUrGNKX'] = nacc.uds3.Field(name='LBUrGNKX', typename='Char', position=(614, 673), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 5a LBUMrGNK ne 8 (Untestable)'])
        self.fields['LBUMrGrU'] = nacc.uds3.Field(name='LBUMrGrU', typename='Num', position=(675, 675), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUrGrUX'] = nacc.uds3.Field(name='LBUrGrUX', typename='Char', position=(677, 736), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 5b LBUMrGrU ne 8 (Untestable)'])
        self.fields['LBUMrGLU'] = nacc.uds3.Field(name='LBUMrGLU', typename='Num', position=(738, 738), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUrGLUX'] = nacc.uds3.Field(name='LBUrGLUX', typename='Char', position=(740, 799), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 5c LBUMrGLU ne 8 (Untestable)'])
        self.fields['LBUMrGrL'] = nacc.uds3.Field(name='LBUMrGrL', typename='Num', position=(801, 801), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUrGrLX'] = nacc.uds3.Field(name='LBUrGrLX', typename='Char', position=(803, 862), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 5d LBUMrGrL ne 8 (Untestable)'])
        self.fields['LBUMrGLL'] = nacc.uds3.Field(name='LBUMrGLL', typename='Num', position=(864, 864), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUrGLLX'] = nacc.uds3.Field(name='LBUrGLLX', typename='Char', position=(866, 925), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 5e LBUMrGLL ne 8 (Untestable)'])
        self.fields['LBUMFtrH'] = nacc.uds3.Field(name='LBUMFtrH', typename='Num', position=(927, 927), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUFtrHX'] = nacc.uds3.Field(name='LBUFtrHX', typename='Char', position=(929, 988), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 6a LBUMFtrH ne 8 (Untestable)'])
        self.fields['LBUMFtLH'] = nacc.uds3.Field(name='LBUMFtLH', typename='Num', position=(990, 990), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUFtLHX'] = nacc.uds3.Field(name='LBUFtLHX', typename='Char', position=(992, 1051), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 6b LBUMFtLH ne 8 (Untestable)'])
        self.fields['LBUMHMrH'] = nacc.uds3.Field(name='LBUMHMrH', typename='Num', position=(1053, 1053), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUHMrHX'] = nacc.uds3.Field(name='LBUHMrHX', typename='Char', position=(1055, 1114), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 7a LBUMHMrH ne 8 (Untestable)'])
        self.fields['LBUMHMLH'] = nacc.uds3.Field(name='LBUMHMLH', typename='Num', position=(1116, 1116), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUHMLHX'] = nacc.uds3.Field(name='LBUHMLHX', typename='Char', position=(1118, 1177), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 7b LBUMHMLH ne 8 (Untestable)'])
        self.fields['LBUMPSrH'] = nacc.uds3.Field(name='LBUMPSrH', typename='Num', position=(1179, 1179), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUPSrHX'] = nacc.uds3.Field(name='LBUPSrHX', typename='Char', position=(1181, 1240), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 8a LBUMPSrH ne 8 (Untestable)'])
        self.fields['LBUMPSLH'] = nacc.uds3.Field(name='LBUMPSLH', typename='Num', position=(1242, 1242), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUPSLHX'] = nacc.uds3.Field(name='LBUPSLHX', typename='Char', position=(1244, 1303), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 8b LBUMPSLH ne 8 (Untestable)'])
        self.fields['LBUMLGrL'] = nacc.uds3.Field(name='LBUMLGrL', typename='Num', position=(1305, 1305), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBULGrLX'] = nacc.uds3.Field(name='LBULGrLX', typename='Char', position=(1307, 1366), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 9a LBUMLGrL ne 8 (Untestable)'])
        self.fields['LBUMLGLL'] = nacc.uds3.Field(name='LBUMLGLL', typename='Num', position=(1368, 1368), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBULGLLX'] = nacc.uds3.Field(name='LBULGLLX', typename='Char', position=(1370, 1429), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 9b LBUMLGLL ne 8 (Untestable)'])
        self.fields['LBUMrISe'] = nacc.uds3.Field(name='LBUMrISe', typename='Num', position=(1431, 1431), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUMrISX'] = nacc.uds3.Field(name='LBUMrISX', typename='Char', position=(1433, 1492), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 10 LBUMrISe ne 8 (Untestable)'])
        self.fields['LBUMPoSt'] = nacc.uds3.Field(name='LBUMPoSt', typename='Num', position=(1494, 1494), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUMPoSX'] = nacc.uds3.Field(name='LBUMPoSX', typename='Char', position=(1496, 1555), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 11 LBUMPoSt ne 8 (Untestable)'])
        self.fields['LBUMGAIt'] = nacc.uds3.Field(name='LBUMGAIt', typename='Num', position=(1557, 1557), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUMGAIX'] = nacc.uds3.Field(name='LBUMGAIX', typename='Char', position=(1559, 1618), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 12 LBUMGAIt ne 8 (Untestable)'])
        self.fields['LBUPStBL'] = nacc.uds3.Field(name='LBUPStBL', typename='Num', position=(1620, 1620), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUPStBX'] = nacc.uds3.Field(name='LBUPStBX', typename='Char', position=(1622, 1681), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 13 LBUPStBL ne 8 (Untestable)'])
        self.fields['LBUMBrAD'] = nacc.uds3.Field(name='LBUMBrAD', typename='Num', position=(1683, 1683), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['LBUMBrAX'] = nacc.uds3.Field(name='LBUMBrAX', typename='Char', position=(1685, 1744), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 14 LBUMBrAD ne 8 (Untestable)'])
        self.fields['LBUMHNyr'] = nacc.uds3.Field(name='LBUMHNyr', typename='Num', position=(1746, 1746), length=1, inclusive_range=(0, 7), allowable_values=['0', '1', '2', '3', '4', '5', '6', '7', '8'], blanks=[])
        self.fields['LBUMHNyX'] = nacc.uds3.Field(name='LBUMHNyX', typename='Char', position=(1748, 1807), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 15 LBUMHNyr ne 8 (Untestable)'])


class FormB4L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBDeLUS'] = nacc.uds3.Field(name='LBDeLUS', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8'], blanks=[])
        self.fields['LBDHUrt'] = nacc.uds3.Field(name='LBDHUrt', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBDeLUS ne 1 (Yes)'])
        self.fields['LBDSteAL'] = nacc.uds3.Field(name='LBDSteAL', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBDeLUS ne 1 (Yes)'])
        self.fields['LBDAFFr'] = nacc.uds3.Field(name='LBDAFFr', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBDeLUS ne 1 (Yes)'])
        self.fields['LBDGUeSt'] = nacc.uds3.Field(name='LBDGUeSt', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBDeLUS ne 1 (Yes)'])
        self.fields['LBDIMPoS'] = nacc.uds3.Field(name='LBDIMPoS', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBDeLUS ne 1 (Yes)'])
        self.fields['LBDHoMe'] = nacc.uds3.Field(name='LBDHoMe', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBDeLUS ne 1 (Yes)'])
        self.fields['LBDABAND'] = nacc.uds3.Field(name='LBDABAND', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBDeLUS ne 1 (Yes)'])
        self.fields['LBDPreS'] = nacc.uds3.Field(name='LBDPreS', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBDeLUS ne 1 (Yes)'])
        self.fields['LBDotHer'] = nacc.uds3.Field(name='LBDotHer', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBDeLUS ne 1 (Yes)'])
        self.fields['LBHALL'] = nacc.uds3.Field(name='LBHALL', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8'], blanks=[])
        self.fields['LBHVoICe'] = nacc.uds3.Field(name='LBHVoICe', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 2 LBHALL ne 1 (Yes)'])
        self.fields['LBHPeoPL'] = nacc.uds3.Field(name='LBHPeoPL', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 2 LBHALL ne 1 (Yes)'])
        self.fields['LBHNotPr'] = nacc.uds3.Field(name='LBHNotPr', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 2 LBHALL ne 1 (Yes)'])
        self.fields['LBHoDor'] = nacc.uds3.Field(name='LBHoDor', typename='Num', position=(73, 73), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 2 LBHALL ne 1 (Yes)'])
        self.fields['LBHFeeL'] = nacc.uds3.Field(name='LBHFeeL', typename='Num', position=(75, 75), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 2 LBHALL ne 1 (Yes)'])
        self.fields['LBHtASte'] = nacc.uds3.Field(name='LBHtASte', typename='Num', position=(77, 77), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 2 LBHALL ne 1 (Yes)'])
        self.fields['LBHotSeN'] = nacc.uds3.Field(name='LBHotSeN', typename='Num', position=(79, 79), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 2 LBHALL ne 1 (Yes)'])
        self.fields['LBANXIet'] = nacc.uds3.Field(name='LBANXIet', typename='Num', position=(81, 81), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8'], blanks=[])
        self.fields['LBANeVNt'] = nacc.uds3.Field(name='LBANeVNt', typename='Num', position=(83, 83), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 3 LBANXIet ne 1 (Yes)'])
        self.fields['LBANreLX'] = nacc.uds3.Field(name='LBANreLX', typename='Num', position=(85, 85), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 3 LBANXIet ne 1 (Yes)'])
        self.fields['LBANBrtH'] = nacc.uds3.Field(name='LBANBrtH', typename='Num', position=(87, 87), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 3 LBANXIet ne 1 (Yes)'])
        self.fields['LBANBUtt'] = nacc.uds3.Field(name='LBANBUtt', typename='Num', position=(89, 89), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 3 LBANXIet ne 1 (Yes)'])
        self.fields['LBANPLAC'] = nacc.uds3.Field(name='LBANPLAC', typename='Num', position=(91, 91), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 3 LBANXIet ne 1 (Yes)'])
        self.fields['LBANSePr'] = nacc.uds3.Field(name='LBANSePr', typename='Num', position=(93, 93), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 3 LBANXIet ne 1 (Yes)'])
        self.fields['LBANotHr'] = nacc.uds3.Field(name='LBANotHr', typename='Num', position=(95, 95), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 3 LBANXIet ne 1 (Yes)'])
        self.fields['LBAPAtHy'] = nacc.uds3.Field(name='LBAPAtHy', typename='Num', position=(97, 97), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8'], blanks=[])
        self.fields['LBAPSPNt'] = nacc.uds3.Field(name='LBAPSPNt', typename='Num', position=(99, 99), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 4 LBAPAtHy ne 1 (Yes)'])
        self.fields['LBAPCoNV'] = nacc.uds3.Field(name='LBAPCoNV', typename='Num', position=(101, 101), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 4 LBAPAtHy ne 1 (Yes)'])
        self.fields['LBAPAFF'] = nacc.uds3.Field(name='LBAPAFF', typename='Num', position=(103, 103), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 4 LBAPAtHy ne 1 (Yes)'])
        self.fields['LBAPCHor'] = nacc.uds3.Field(name='LBAPCHor', typename='Num', position=(105, 105), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 4 LBAPAtHy ne 1 (Yes)'])
        self.fields['LBAPINt'] = nacc.uds3.Field(name='LBAPINt', typename='Num', position=(107, 107), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 4 LBAPAtHy ne 1 (Yes)'])
        self.fields['LBAPFAML'] = nacc.uds3.Field(name='LBAPFAML', typename='Num', position=(109, 109), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 4 LBAPAtHy ne 1 (Yes)'])
        self.fields['LBAPINtr'] = nacc.uds3.Field(name='LBAPINtr', typename='Num', position=(111, 111), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 4 LBAPAtHy ne 1 (Yes)'])
        self.fields['LBAPotH'] = nacc.uds3.Field(name='LBAPotH', typename='Num', position=(113, 113), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 4 LBAPAtHy ne 1 (Yes)'])


class FormB5L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBMLtHrG'] = nacc.uds3.Field(name='LBMLtHrG', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBMSLeeP'] = nacc.uds3.Field(name='LBMSLeeP', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBMDISrG'] = nacc.uds3.Field(name='LBMDISrG', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBMStAre'] = nacc.uds3.Field(name='LBMStAre', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        

class FormB6L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBSPCGIM'] = nacc.uds3.Field(name='LBSPCGIM', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBSPDrM'] = nacc.uds3.Field(name='LBSPDrM', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes)'])
        self.fields['LBSPyrS'] = nacc.uds3.Field(name='LBSPyrS', typename='Num', position=(49, 50), length=2, inclusive_range=(0, 99), allowable_values=[], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes) or Question 1 LBSPDrM = 0 (No)'])
        self.fields['LBSPMoS'] = nacc.uds3.Field(name='LBSPMoS', typename='Num', position=(52, 53), length=2, inclusive_range=(0, 11), allowable_values=[], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes) or Question 1 LBSPDrM = 0 (No)'])
        self.fields['LBSPINJS'] = nacc.uds3.Field(name='LBSPINJS', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes) or Question 1 LBSPDrM = 0 (No)'])
        self.fields['LBSPINJP'] = nacc.uds3.Field(name='LBSPINJP', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes) or Question 1 LBSPDrM = 0 (No)'])
        self.fields['LBSPCHAS'] = nacc.uds3.Field(name='LBSPCHAS', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes) or Question 1 LBSPDrM = 0 (No)'])
        self.fields['LBSPMoVe'] = nacc.uds3.Field(name='LBSPMoVe', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes) or Question 1 LBSPDrM = 0 (No)'])
        self.fields['LBSPLeGS'] = nacc.uds3.Field(name='LBSPLeGS', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes)'])
        self.fields['LBSPNerV'] = nacc.uds3.Field(name='LBSPNerV', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes)'])
        self.fields['LBSPUrGL'] = nacc.uds3.Field(name='LBSPUrGL', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes) or Question 3 LBSPNerV = 0 (No)'])
        self.fields['LBSPSeNS'] = nacc.uds3.Field(name='LBSPSeNS', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes) or Question 3 LBSPNerV = 0 (No)'])
        self.fields['LBSPWorS'] = nacc.uds3.Field(name='LBSPWorS', typename='Num', position=(71, 71), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes) or Question 3 LBSPNerV = 0 (No)'])
        self.fields['LBSPWALK'] = nacc.uds3.Field(name='LBSPWALK', typename='Num', position=(73, 73), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes)'])
        self.fields['LBSPAWAK'] = nacc.uds3.Field(name='LBSPAWAK', typename='Num', position=(75, 75), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes)'])
        self.fields['LBSPBrtH'] = nacc.uds3.Field(name='LBSPBrtH', typename='Num', position=(77, 77), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes)'])
        self.fields['LBSPtrt'] = nacc.uds3.Field(name='LBSPtrt', typename='Num', position=(79, 79), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes) or Question 6 LBSPBRTH = 0 (No)'])
        self.fields['LBSPCrMP'] = nacc.uds3.Field(name='LBSPCrMP', typename='Num', position=(81, 81), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes)'])
        self.fields['LBSPALrt'] = nacc.uds3.Field(name='LBSPALrt', typename='Num', position=(83, 84), length=2, inclusive_range=(1, 10), allowable_values=[], blanks=['Blank if Question 0 LBSPCGIM = 1 (Yes)'])


class FormB7L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBSCLIV'] = nacc.uds3.Field(name='LBSCLIV', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBSCSLP'] = nacc.uds3.Field(name='LBSCSLP', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No)'])
        self.fields['LBSCBeHV'] = nacc.uds3.Field(name='LBSCBeHV', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No) or Question 2 LBSCSLP = 1 (Yes)'])
        self.fields['LBSCDrM'] = nacc.uds3.Field(name='LBSCDrM', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No)'])
        self.fields['LBSCyrS'] = nacc.uds3.Field(name='LBSCyrS', typename='Num', position=(53, 54), length=2, inclusive_range=(0, 99), allowable_values=[], blanks=['Blank if Question 1 LBSCLIV = 0 (No) or Question 3 LBSCDrM = 0 (No)'])
        self.fields['LBSCMoS'] = nacc.uds3.Field(name='LBSCMoS', typename='Num', position=(56, 57), length=2, inclusive_range=(0, 11), allowable_values=[], blanks=['Blank if Question 1 LBSCLIV = 0 (No) or Question 3 LBSCDrM = 0 (No)'])
        self.fields['LBSCINJS'] = nacc.uds3.Field(name='LBSCINJS', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No) or Question 3 LBSCDrM = 0 (No)'])
        self.fields['LBSCINJP'] = nacc.uds3.Field(name='LBSCINJP', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8'], blanks=['Blank if Question 1 LBSCLIV = 0 (No) or Question 3 LBSCDrM = 0 (No)'])
        self.fields['LBSCCHAS'] = nacc.uds3.Field(name='LBSCCHAS', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8'], blanks=['Blank if Question 1 LBSCLIV = 0 (No) or Question 3 LBSCDrM = 0 (No)'])
        self.fields['LBSCMoVe'] = nacc.uds3.Field(name='LBSCMoVe', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8'], blanks=['Blank if Question 1 LBSCLIV = 0 (No) or Question 3 LBSCDrM = 0 (No)'])
        self.fields['LBSCLeGS'] = nacc.uds3.Field(name='LBSCLeGS', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No)'])
        self.fields['LBSCNerV'] = nacc.uds3.Field(name='LBSCNerV', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No)'])
        self.fields['LBSCSeNS'] = nacc.uds3.Field(name='LBSCSeNS', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No) or Question 5 LBSCNerV = 0 (No)'])
        self.fields['LBSCWorS'] = nacc.uds3.Field(name='LBSCWorS', typename='Num', position=(73, 73), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 1 LBSCLIV = 0 (No) or Question 5 LBSCNerV = 0 (No)'])
        self.fields['LBSCWALK'] = nacc.uds3.Field(name='LBSCWALK', typename='Num', position=(75, 75), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No)'])
        self.fields['LBSCAWAK'] = nacc.uds3.Field(name='LBSCAWAK', typename='Num', position=(77, 77), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No)'])
        self.fields['LBSCBrtH'] = nacc.uds3.Field(name='LBSCBrtH', typename='Num', position=(79, 79), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No)'])
        self.fields['LBSCtrt'] = nacc.uds3.Field(name='LBSCtrt', typename='Num', position=(81, 81), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No) or Question 8 LBSCBrtH = 0 (No)'])
        self.fields['LBSCCrMP'] = nacc.uds3.Field(name='LBSCCrMP', typename='Num', position=(83, 83), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBSCLIV = 0 (No)'])
        self.fields['LBSCALrt'] = nacc.uds3.Field(name='LBSCALrt', typename='Num', position=(85, 86), length=2, inclusive_range=(0, 10), allowable_values=[], blanks=['Blank if Question 1 LBSCLIV = 0 (No)'])


class FormB9L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['CoNSFALL'] = nacc.uds3.Field(name='CoNSFALL', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['CoNSWKoF'] = nacc.uds3.Field(name='CoNSWKoF', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['CoNSLyAW'] = nacc.uds3.Field(name='CoNSLyAW', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['CoNSWKer'] = nacc.uds3.Field(name='CoNSWKer', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['CoNSLttL'] = nacc.uds3.Field(name='CoNSLttL', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['SCCorAte'] = nacc.uds3.Field(name='SCCorAte', typename='Num', position=(55, 55), length=1, inclusive_range=(1, 7), allowable_values=['1', '2', '3', '4', '5', '6', '7'], blanks=[])
        self.fields['CoDSUNeX'] = nacc.uds3.Field(name='CoDSUNeX', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['CoDSSItP'] = nacc.uds3.Field(name='CoDSSItP', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['CoDSWAtV'] = nacc.uds3.Field(name='CoDSWAtV', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['CoDStALK'] = nacc.uds3.Field(name='CoDStALK', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['CoDSAWDy'] = nacc.uds3.Field(name='CoDSAWDy', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['CoDSFLDy'] = nacc.uds3.Field(name='CoDSFLDy', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])


class FormC1L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBNPFACe'] = nacc.uds3.Field(name='LBNPFACe', typename='Num', position=(45, 46), length=2, inclusive_range=(0, 7), allowable_values=['0', '1', '2', '3', '4', '5', '6', '7', '95', '96', '97', '98'], blanks=[])
        self.fields['LBNPNoIS'] = nacc.uds3.Field(name='LBNPNoIS', typename='Num', position=(48, 49), length=2, inclusive_range=(0, 13), allowable_values=[], blanks=['Blank if Question 2a LBNPFACe = 95-98'])
        self.fields['LBNPtCor'] = nacc.uds3.Field(name='LBNPtCor', typename='Num', position=(51, 52), length=2, inclusive_range=(0, 20), allowable_values=[], blanks=['Blank if Question 2a LBNPFACe = 95-98'])
        self.fields['LBNPPArD'] = nacc.uds3.Field(name='LBNPPArD', typename='Num', position=(54, 55), length=2, inclusive_range=(0, 13), allowable_values=[], blanks=['Blank if Question 2a LBNPFACe = 95-98'])


class FormD1L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBCDSCoG'] = nacc.uds3.Field(name='LBCDSCoG', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBCCMeM'] = nacc.uds3.Field(name='LBCCMeM', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 1 LBCDSCoG = 0 (No).'])
        self.fields['LBCCLANG'] = nacc.uds3.Field(name='LBCCLANG', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 1 LBCDSCoG = 0 (No).'])
        self.fields['LBCCAtt'] = nacc.uds3.Field(name='LBCCAtt', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 1 LBCDSCoG = 0 (No).'])
        self.fields['LBCCeXDe'] = nacc.uds3.Field(name='LBCCeXDe', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 1 LBCDSCoG = 0 (No).'])
        self.fields['LBCCVIS'] = nacc.uds3.Field(name='LBCCVIS', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 1 LBCDSCoG = 0 (No).'])
        self.fields['LBCDSMoV'] = nacc.uds3.Field(name='LBCDSMoV', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBCMBrAD'] = nacc.uds3.Field(name='LBCMBrAD', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 2 LBCDSMoV = 0 (No).'])
        self.fields['LBCMrIGD'] = nacc.uds3.Field(name='LBCMrIGD', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 2 LBCDSMoV = 0 (No).'])
        self.fields['LBCMrtrM'] = nacc.uds3.Field(name='LBCMrtrM', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 2 LBCDSMoV = 0 (No).'])
        self.fields['LBCMPtrM'] = nacc.uds3.Field(name='LBCMPtrM', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 2 LBCDSMoV = 0 (No).'])
        self.fields['LBCMAtrM'] = nacc.uds3.Field(name='LBCMAtrM', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 2 LBCDSMoV = 0 (No).'])
        self.fields['LBCMMyoC'] = nacc.uds3.Field(name='LBCMMyoC', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 2 LBCDSMoV = 0 (No).'])
        self.fields['LBCMGAIt'] = nacc.uds3.Field(name='LBCMGAIt', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 2 LBCDSMoV = 0 (No).'])
        self.fields['LBCMPINS'] = nacc.uds3.Field(name='LBCMPINS', typename='Num', position=(73, 73), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 2 LBCDSMoV = 0 (No).'])
        self.fields['LBCDSBeV'] = nacc.uds3.Field(name='LBCDSBeV', typename='Num', position=(75, 75), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBCBDeP'] = nacc.uds3.Field(name='LBCBDeP', typename='Num', position=(77, 77), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 3 LBCDSBeV = 0 (No).'])
        self.fields['LBCBAPA'] = nacc.uds3.Field(name='LBCBAPA', typename='Num', position=(79, 79), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 3 LBCDSBeV = 0 (No).'])
        self.fields['LBCBANX'] = nacc.uds3.Field(name='LBCBANX', typename='Num', position=(81, 81), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 3 LBCDSBeV = 0 (No).'])
        self.fields['LBCBHALL'] = nacc.uds3.Field(name='LBCBHALL', typename='Num', position=(83, 83), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 3 LBCDSBeV = 0 (No).'])
        self.fields['LBCBDeL'] = nacc.uds3.Field(name='LBCBDeL', typename='Num', position=(85, 85), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 3 LBCDSBeV = 0 (No).'])
        self.fields['LBCDSAUt'] = nacc.uds3.Field(name='LBCDSAUt', typename='Num', position=(87, 87), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBCAreM'] = nacc.uds3.Field(name='LBCAreM', typename='Num', position=(89, 89), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCAAPN'] = nacc.uds3.Field(name='LBCAAPN', typename='Num', position=(91, 91), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCALGSL'] = nacc.uds3.Field(name='LBCALGSL', typename='Num', position=(93, 93), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCArSLe'] = nacc.uds3.Field(name='LBCArSLe', typename='Num', position=(95, 95), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCADtSL'] = nacc.uds3.Field(name='LBCADtSL', typename='Num', position=(97, 97), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCACGFL'] = nacc.uds3.Field(name='LBCACGFL', typename='Num', position=(99, 99), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCAHyPt'] = nacc.uds3.Field(name='LBCAHyPt', typename='Num', position=(101, 101), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCACoNS'] = nacc.uds3.Field(name='LBCACoNS', typename='Num', position=(103, 103), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCAHyPS'] = nacc.uds3.Field(name='LBCAHyPS', typename='Num', position=(105, 105), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCAFALL'] = nacc.uds3.Field(name='LBCAFALL', typename='Num', position=(107, 107), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCASyNC'] = nacc.uds3.Field(name='LBCASyNC', typename='Num', position=(109, 109), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCASNAP'] = nacc.uds3.Field(name='LBCASNAP', typename='Num', position=(111, 111), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '8'], blanks=['Blank if Question 4 LBCDSAUt = 0 (No).'])
        self.fields['LBCoGSt'] = nacc.uds3.Field(name='LBCoGSt', typename='Num', position=(113, 113), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4'], blanks=[])
        self.fields['LBCoGDX'] = nacc.uds3.Field(name='LBCoGDX', typename='Num', position=(115, 115), length=1, inclusive_range=(1, 6), allowable_values=['1', '2', '3', '4', '5', '6', '8'], blanks=[])


class FormE1L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBGLrrK2'] = nacc.uds3.Field(name='LBGLrrK2', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBGLrKIS'] = nacc.uds3.Field(name='LBGLrKIS', typename='Num', position=(47, 47), length=1, inclusive_range=(1, 3), allowable_values=['1', '2', '3', '9'], blanks=['Blank if Question 1 LBGLrrK2 = 0 (No)\nor 9 (Unknown)'])
        self.fields['LBGPArK2'] = nacc.uds3.Field(name='LBGPArK2', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBGPK2IS'] = nacc.uds3.Field(name='LBGPK2IS', typename='Num', position=(51, 51), length=1, inclusive_range=(1, 3), allowable_values=['1', '2', '3', '9'], blanks=['Blank if Question 2 LBGPArK2 = 0 (No)\nor 9 (Unknown)'])
        self.fields['LBGPArK7'] = nacc.uds3.Field(name='LBGPArK7', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBGPK7IS'] = nacc.uds3.Field(name='LBGPK7IS', typename='Num', position=(55, 55), length=1, inclusive_range=(1, 3), allowable_values=['1', '2', '3', '9'], blanks=['Blank if Question 3 LBGPArK7 = 0 (No)\nor 9 (Unknown)'])
        self.fields['LBGPINK1'] = nacc.uds3.Field(name='LBGPINK1', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBGPNKIS'] = nacc.uds3.Field(name='LBGPNKIS', typename='Num', position=(59, 59), length=1, inclusive_range=(1, 3), allowable_values=['1', '2', '3', '9'], blanks=['Blank if Question 4 LBGPINK1 = 0 (No)\nor 9 (Unknown)'])
        self.fields['LBGSNCA'] = nacc.uds3.Field(name='LBGSNCA', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBGSNCIS'] = nacc.uds3.Field(name='LBGSNCIS', typename='Num', position=(63, 63), length=1, inclusive_range=(1, 3), allowable_values=['1', '2', '3', '9'], blanks=['Blank if Question 5 LBGSNCA= 0 (No) or\n9 (Unknown)'])
        self.fields['LBGGBA'] = nacc.uds3.Field(name='LBGGBA', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBGGBAIS'] = nacc.uds3.Field(name='LBGGBAIS', typename='Num', position=(67, 67), length=1, inclusive_range=(1, 3), allowable_values=['1', '2', '3', '9'], blanks=['Blank if Question 6 LBGGBA = 0 (No) or\n9 (Unknown)'])
        self.fields['LBGotHr'] = nacc.uds3.Field(name='LBGotHr', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=[])
        self.fields['LBGotHIS'] = nacc.uds3.Field(name='LBGotHIS', typename='Num', position=(71, 71), length=1, inclusive_range=(1, 3), allowable_values=['1', '2', '3', '9'], blanks=['Blank if Question 7 LBGotHr = 0 (No)\nor 9 (Unknown)'])
        self.fields['LBGotHX'] = nacc.uds3.Field(name='LBGotHX', typename='Char', position=(73, 102), length=30, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 7 LBGotHr = 0 (No)\nor 9 (Unknown).'])


class FormE2L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBISMrI'] = nacc.uds3.Field(name='LBISMrI', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBISMHIP'] = nacc.uds3.Field(name='LBISMHIP', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8', '9'], blanks=['Blank if Question 1 LBISMrI = 0 (No or unknown)'])
        self.fields['LBISMAVL'] = nacc.uds3.Field(name='LBISMAVL', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBISMrI = 0 (No or\nunknown)'])
        self.fields['LBIFPet'] = nacc.uds3.Field(name='LBIFPet', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBIFPoCC'] = nacc.uds3.Field(name='LBIFPoCC', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8', '9'], blanks=['Blank if Question 2 LBIFPet = 0 (No or unknown)'])
        self.fields['LBIFPtPP'] = nacc.uds3.Field(name='LBIFPtPP', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8', '9'], blanks=['Blank if Question 2 LBIFPet = 0 (No or unknown)'])
        self.fields['LBIFPISL'] = nacc.uds3.Field(name='LBIFPISL', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8', '9'], blanks=['Blank if Question 2 LBIFPet = 0 (No or unknown)',])
        self.fields['LBIFPAVL'] = nacc.uds3.Field(name='LBIFPAVL', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 2 LBIFPet = 0 (No or\nunknown)'])
        self.fields['LBIAPet'] = nacc.uds3.Field(name='LBIAPet', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBIAPAVL'] = nacc.uds3.Field(name='LBIAPAVL', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 3 LBIAPet = 0 (No or\nunknown)'])
        self.fields['LBItPet'] = nacc.uds3.Field(name='LBItPet', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBItPAVL'] = nacc.uds3.Field(name='LBItPAVL', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 4 LBItPet = 0 (No or\nunknown)'])
        self.fields['LBIDAtS'] = nacc.uds3.Field(name='LBIDAtS', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBIDSABN'] = nacc.uds3.Field(name='LBIDSABN', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8', '9'], blanks=['Blank if Question 5 LBIDAtS = 0 (No or unknown)'])


class FormE3L(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LBoPoLyS'] = nacc.uds3.Field(name='LBoPoLyS', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBoPoPoS'] = nacc.uds3.Field(name='LBoPoPoS', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8', '9'], blanks=['Blank if Question 1 LBoPoLyS = 0 (No or\nunknown)'])
        self.fields['LBoPoAVL'] = nacc.uds3.Field(name='LBoPoAVL', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 LBoPoLyS = 0 (No or\nunknown)'])
        self.fields['LBoCMIBG'] = nacc.uds3.Field(name='LBoCMIBG', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBoCMPoS'] = nacc.uds3.Field(name='LBoCMPoS', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8', '9'], blanks=['Blank if Question 2 LBoCMIBG = 0 (No\nor unknown)'])
        self.fields['LBoCMAVL'] = nacc.uds3.Field(name='LBoCMAVL', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=['Blank if Question 2 LBoCMIBG = 0 (No\nor unknown)'])
        self.fields['LBoANoS'] = nacc.uds3.Field(name='LBoANoS', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBoANPoS'] = nacc.uds3.Field(name='LBoANPoS', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8', '9'], blanks=['Blank if Question 3 LBoANoS = 0 (No or\nunknown)'])
        self.fields['LBoANAVL'] = nacc.uds3.Field(name='LBoANAVL', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 3 LBoANoS = 0 (No or\nunknown)'])
        self.fields['LBoANVer'] = nacc.uds3.Field(name='LBoANVer', typename='Num', position=(63, 63), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4'], blanks=['Blank if Question 3 LBoANoS = 0 (No or unknown)', 'Blank if Question 3c LBoANAVL = 0 (No or unknown).'])
        self.fields['LBoANotH'] = nacc.uds3.Field(name='LBoANotH', typename='Char', position=(65, 94), length=30, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3 LBoANoS = 0 (No or unknown)', 'Blank if 3c LBoANAVL = 0 (No or unknown)', 'Blank if Question 3d LBoANVer ne 4 (Other)'])
        self.fields['LBoCGAIt'] = nacc.uds3.Field(name='LBoCGAIt', typename='Num', position=(96, 96), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LBoCGPoS'] = nacc.uds3.Field(name='LBoCGPoS', typename='Num', position=(98, 98), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '8', '9'], blanks=['Blank if Question 9 LBoCGAIt = 0 (No or\nunknown)'])
        self.fields['LBoCGAVL'] = nacc.uds3.Field(name='LBoCGAVL', typename='Num', position=(100, 100), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=['Blank if Question 9 LBoCGAIt = 0 (No or\nunknown)'])
