###############################################################################
# Copyright 2015-2023 University of Florida. All rights reserved.
# This file is part of UF CTS-IT's NACCulator project.
# Use of this source code is governed by the license found in the LICENSE file.
###############################################################################

import nacc.uds3

### BEGIN non-generated code
# WARNING: When generating new forms, do not overwrite this section
from datetime import date

# WARNING: When generating new forms, use CURRENT_YEAR instead of "2014"
# WARNING: When generating new forms, use CURRENT_YEAR-15 instead of "1999"
CURRENT_YEAR = date.today().year

### END non-generated code

# This form is for FTLD FVP (FrontoTemporal Lobar Followup)


def header_fields():
    """
    Generates the header info that appears in columns 1-43 of every form
    """
    fields = {}
    fields['PACKET'] = nacc.uds3.Field(name='PACKET', typename='Char', position=(1, 2), length=2, inclusive_range=None, allowable_values=[], blanks=[])
    fields['FORMID'] = nacc.uds3.Field(name='FORMID', typename='Char', position=(4, 6), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    fields['FORMVER'] = nacc.uds3.Field(name='FORMVER', typename='Num', position=(8, 10), length=3, inclusive_range=None, allowable_values=['3'], blanks=[])
    fields['ADCID'] = nacc.uds3.Field(name='ADCID', typename='Num', position=(12, 13), length=2, inclusive_range=(2, 99), allowable_values=[], blanks=[])
    fields['PTID'] = nacc.uds3.Field(name='PTID', typename='Char', position=(15, 24), length=10, inclusive_range=None, allowable_values=[], blanks=[])
    fields['VISITMO'] = nacc.uds3.Field(name='VISITMO', typename='Num', position=(26, 27), length=2, inclusive_range=(1, 12), allowable_values=[], blanks=[])
    fields['VISITDAY'] = nacc.uds3.Field(name='VISITDAY', typename='Num', position=(29, 30), length=2, inclusive_range=(1, 31), allowable_values=[], blanks=[])
    fields['VISITYR'] = nacc.uds3.Field(name='VISITYR', typename='Num', position=(32, 35), length=4, inclusive_range=(2015, CURRENT_YEAR), allowable_values=[], blanks=[])
    fields['VISITNUM'] = nacc.uds3.Field(name='VISITNUM', typename='Char', position=(37, 39), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    fields['INITIALS'] = nacc.uds3.Field(name='INITIALS', typename='Char', position=(41, 43), length=3, inclusive_range=None, allowable_values=[], blanks=[])
    return fields


class FormZ1X(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['LANGA1'] = nacc.uds3.Field(name='LANGA1', typename='Num', position=(45, 45), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGA2'] = nacc.uds3.Field(name='LANGA2', typename='Num', position=(47, 47), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 2b A2SUB = 0 (No)'])
        self.fields['A2SUB'] = nacc.uds3.Field(name='A2SUB', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['A2NOT'] = nacc.uds3.Field(name='A2NOT', typename='Num', position=(51, 52), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 2b A2SUB = 1 (Yes)'])
        self.fields['LANGA3'] = nacc.uds3.Field(name='LANGA3', typename='Num', position=(54, 54), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 3b A3SUB = 0 (No)'])
        self.fields['A3SUB'] = nacc.uds3.Field(name='A3SUB', typename='Num', position=(56, 56), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['A3NOT'] = nacc.uds3.Field(name='A3NOT', typename='Num', position=(58, 59), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 3b A3SUB = 1 (Yes)'])
        self.fields['LANGA4'] = nacc.uds3.Field(name='LANGA4', typename='Num', position=(61, 61), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 4b A4SUB = 0 (No)'])
        self.fields['A4SUB'] = nacc.uds3.Field(name='A4SUB', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['A4NOT'] = nacc.uds3.Field(name='A4NOT', typename='Num', position=(65, 66), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 4b A4SUB = 1 (Yes)'])
        self.fields['LANGB1'] = nacc.uds3.Field(name='LANGB1', typename='Num', position=(68, 68), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 6b B1SUB = 0 (No)'])
        self.fields['B1SUB'] = nacc.uds3.Field(name='B1SUB', typename='Num', position=(70, 70), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B1NOT'] = nacc.uds3.Field(name='B1NOT', typename='Num', position=(72, 73), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 6b B1SUB = 1 (Yes)'])
        self.fields['LANGB4'] = nacc.uds3.Field(name='LANGB4', typename='Num', position=(75, 75), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGB5'] = nacc.uds3.Field(name='LANGB5', typename='Num', position=(77, 77), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 8b B5SUB = 0 (No)'])
        self.fields['B5SUB'] = nacc.uds3.Field(name='B5SUB', typename='Num', position=(79, 79), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B5NOT'] = nacc.uds3.Field(name='B5NOT', typename='Num', position=(81, 82), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 8b B5SUB = 1 (Yes)'])
        self.fields['LANGB6'] = nacc.uds3.Field(name='LANGB6', typename='Num', position=(84, 84), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 9b B6SUB = 0 (No)'])
        self.fields['B6SUB'] = nacc.uds3.Field(name='B6SUB', typename='Num', position=(86, 86), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B6NOT'] = nacc.uds3.Field(name='B6NOT', typename='Num', position=(88, 89), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 9b B6SUB = 1 (Yes)'])
        self.fields['LANGB7'] = nacc.uds3.Field(name='LANGB7', typename='Num', position=(91, 91), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 10b B7SUB = 0 (No)'])
        self.fields['B7SUB'] = nacc.uds3.Field(name='B7SUB', typename='Num', position=(93, 93), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B7NOT'] = nacc.uds3.Field(name='B7NOT', typename='Num', position=(95, 96), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if Question 10b B7SUB = 1 (Yes)'])
        self.fields['LANGB8'] = nacc.uds3.Field(name='LANGB8', typename='Num', position=(98, 98), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGB9'] = nacc.uds3.Field(name='LANGB9', typename='Num', position=(100, 100), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGC1'] = nacc.uds3.Field(name='LANGC1', typename='Num', position=(102, 102), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['LANGC2'] = nacc.uds3.Field(name='LANGC2', typename='Num', position=(104, 104), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGD1'] = nacc.uds3.Field(name='LANGD1', typename='Num', position=(106, 106), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGD2'] = nacc.uds3.Field(name='LANGD2', typename='Num', position=(108, 108), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGA3A'] = nacc.uds3.Field(name='LANGA3A', typename='Num', position=(110, 110), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 16b FTDA3AFS = 0 (No)'])
        self.fields['FTDA3AFS'] = nacc.uds3.Field(name='FTDA3AFS', typename='Num', position=(112, 112), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDA3AFR'] = nacc.uds3.Field(name='FTDA3AFR', typename='Num', position=(114, 115), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 16b FTDA3AFS = 1 (Yes)'])
        self.fields['LANGB3F'] = nacc.uds3.Field(name='LANGB3F', typename='Num', position=(117, 117), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGB9F'] = nacc.uds3.Field(name='LANGB9F', typename='Num', position=(119, 119), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGC1F'] = nacc.uds3.Field(name='LANGC1F', typename='Num', position=(121, 121), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGC2F'] = nacc.uds3.Field(name='LANGC2F', typename='Num', position=(123, 123), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGC3F'] = nacc.uds3.Field(name='LANGC3F', typename='Num', position=(125, 125), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGC4F'] = nacc.uds3.Field(name='LANGC4F', typename='Num', position=(127, 127), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 22b FTDC4FS = 0 (No)'])
        self.fields['FTDC4FS'] = nacc.uds3.Field(name='FTDC4FS', typename='Num', position=(129, 129), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDC4FR'] = nacc.uds3.Field(name='FTDC4FR', typename='Num', position=(131, 132), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 22b FTDC4FS = 1 (Yes)'])
        self.fields['LANGC5F'] = nacc.uds3.Field(name='LANGC5F', typename='Num', position=(134, 134), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 23b FTDC5FS = 0 (No)'])
        self.fields['FTDC5FS'] = nacc.uds3.Field(name='FTDC5FS', typename='Num', position=(136, 136), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDC5FR'] = nacc.uds3.Field(name='FTDC5FR', typename='Num', position=(138, 139), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 23b FTDC5FS = 1 (Yes)'])
        self.fields['LANGC6F'] = nacc.uds3.Field(name='LANGC6F', typename='Num', position=(141, 141), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 24b FTDC6FS = 0 (No)'])
        self.fields['FTDC6FS'] = nacc.uds3.Field(name='FTDC6FS', typename='Num', position=(143, 143), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDC6FR'] = nacc.uds3.Field(name='FTDC6FR', typename='Num', position=(145, 146), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 24b FTDC6FS= 1 (Yes)'])
        self.fields['LANGE2F'] = nacc.uds3.Field(name='LANGE2F', typename='Num', position=(148, 148), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGE3F'] = nacc.uds3.Field(name='LANGE3F', typename='Num', position=(150, 150), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['LANGCLS'] = nacc.uds3.Field(name='LANGCLS', typename='Num', position=(152, 152), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=['Blank if Question 27b CLSSUB = 0 (No)'])
        self.fields['CLSSUB'] = nacc.uds3.Field(name='CLSSUB', typename='Num', position=(154, 154), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B2LSUB'] = nacc.uds3.Field(name='B2LSUB', typename='Num', position=(156, 156), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B2LNOT'] = nacc.uds3.Field(name='B2LNOT', typename='Num', position=(158, 159), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 28b B2LSUB = 1 (Yes)'])
        self.fields['B6LSUB'] = nacc.uds3.Field(name='B6LSUB', typename='Num', position=(161, 161), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['B6LNOT'] = nacc.uds3.Field(name='B6LNOT', typename='Num', position=(163, 164), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98', '99'], blanks=['Blank if Question 29b B6LSUB = 1 (Yes)'])


class FormA3a(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['FTDRELCO'] = nacc.uds3.Field(name='FTDRELCO', typename='Num', position=(45, 45), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4'], blanks=[])
        self.fields['FTDSIBBY'] = nacc.uds3.Field(name='FTDSIBBY', typename='Num', position=(47, 50), length=4, inclusive_range=(1885, 2000), allowable_values=[], blanks=['Blank if Question 1 FTDRELCO ne 3 (Sibling)'])
        self.fields['FTDChDBY'] = nacc.uds3.Field(name='FTDChDBY', typename='Num', position=(52, 55), length=4, inclusive_range=(1920, 2000), allowable_values=[], blanks=['Blank if Question 1 FTDRELCO ne 4 (Child)'])
        self.fields['FTDSTORE'] = nacc.uds3.Field(name='FTDSTORE', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDSLEAR'] = nacc.uds3.Field(name='FTDSLEAR', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDCOMME'] = nacc.uds3.Field(name='FTDCOMME', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])


class FormB3F(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['FTDLTFAS'] = nacc.uds3.Field(name='FTDLTFAS', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDLIMB'] = nacc.uds3.Field(name='FTDLIMB', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDBULB'] = nacc.uds3.Field(name='FTDBULB', typename='Num', position=(49, 49), length=1, inclusive_range=None, allowable_values=['0', '3'], blanks=[])
        self.fields['FTDGSEV'] = nacc.uds3.Field(name='FTDGSEV', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 4), allowable_values=['0', '1', '2', '3', '4', '8'], blanks=[])
        self.fields['FTDGSEVX'] = nacc.uds3.Field(name='FTDGSEVX', typename='Char', position=(53, 112), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question B1 FTDGSEV ne 8 (Untestable)'])
        self.fields['FTDGTYP'] = nacc.uds3.Field(name='FTDGTYP', typename='Num', position=(114, 114), length=1, inclusive_range=(0, 7), allowable_values=['0', '1', '2', '3', '4', '5', '6', '7', '8'], blanks=[])
        self.fields['FTDGTYPG'] = nacc.uds3.Field(name='FTDGTYPG', typename='Char', position=(116, 175), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question B2 FTDGTYP ne 7 (Other gait disorder not listed above)'])
        self.fields['FTDGTYPX'] = nacc.uds3.Field(name='FTDGTYPX', typename='Char', position=(177, 236), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question B2 FTDGTYP ne 8 (Untestable)'])


class FormB9F(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['FTDPPASL'] = nacc.uds3.Field(name='FTDPPASL', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDPPAPO'] = nacc.uds3.Field(name='FTDPPAPO', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)'])
        self.fields['FTDPPAIW'] = nacc.uds3.Field(name='FTDPPAIW', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)'])
        self.fields['FTDPPASW'] = nacc.uds3.Field(name='FTDPPASW', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)'])
        self.fields['FTDPPAPK'] = nacc.uds3.Field(name='FTDPPAPK', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)'])
        self.fields['FTDPPAGS'] = nacc.uds3.Field(name='FTDPPAGS', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)'])
        self.fields['FTDPPAEh'] = nacc.uds3.Field(name='FTDPPAEh', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)'])
        self.fields['FTDPPACS'] = nacc.uds3.Field(name='FTDPPACS', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)'])
        self.fields['FTDPPASS'] = nacc.uds3.Field(name='FTDPPASS', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)'])
        self.fields['FTDPPASR'] = nacc.uds3.Field(name='FTDPPASR', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)'])
        self.fields['FTDPPASD'] = nacc.uds3.Field(name='FTDPPASD', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)'])
        self.fields['FTDCPPA'] = nacc.uds3.Field(name='FTDCPPA', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)'])
        self.fields['FTDCPPAS'] = nacc.uds3.Field(name='FTDCPPAS', typename='Num', position=(69, 69), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4'], blanks=['Blank if Question 1 FTDPPASL = 0 (No)', 'Blank if Question 12 FTDCPPA = 0 (No)'])
        self.fields['FTDBVCLN'] = nacc.uds3.Field(name='FTDBVCLN', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDBVDIS'] = nacc.uds3.Field(name='FTDBVDIS', typename='Num', position=(73, 73), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 14 FTDBVCLN = 0 (No)'])
        self.fields['FTDBVAPA'] = nacc.uds3.Field(name='FTDBVAPA', typename='Num', position=(75, 75), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 14 FTDBVCLN = 0 (No)'])
        self.fields['FTDBVLOS'] = nacc.uds3.Field(name='FTDBVLOS', typename='Num', position=(77, 77), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 14 FTDBVCLN = 0 (No)'])
        self.fields['FTDBVRIT'] = nacc.uds3.Field(name='FTDBVRIT', typename='Num', position=(79, 79), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 14 FTDBVCLN = 0 (No)'])
        self.fields['FTDBVhYP'] = nacc.uds3.Field(name='FTDBVhYP', typename='Num', position=(81, 81), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 14 FTDBVCLN = 0 (No)'])
        self.fields['FTDBVNEU'] = nacc.uds3.Field(name='FTDBVNEU', typename='Num', position=(83, 83), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 14 FTDBVCLN = 0 (No)'])
        self.fields['FTDBVIDL'] = nacc.uds3.Field(name='FTDBVIDL', typename='Num', position=(85, 85), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2', '9'], blanks=['Blank if Question 14 FTDBVCLN = 0 (No)'])
        self.fields['FTDBVFT'] = nacc.uds3.Field(name='FTDBVFT', typename='Num', position=(87, 87), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=['Blank if Question 14 FTDBVCLN = 0 (No)'])
        self.fields['FTDEMGPV'] = nacc.uds3.Field(name='FTDEMGPV', typename='Num', position=(89, 89), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDEMGPY'] = nacc.uds3.Field(name='FTDEMGPY', typename='Num', position=(91, 91), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 23 FTDEMGPV = 1 (Yes)'])
        self.fields['FTDEMGMN'] = nacc.uds3.Field(name='FTDEMGMN', typename='Num', position=(93, 93), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 24 FTDEMGPY = 0 (No)'])
        self.fields['FTDPABVF'] = nacc.uds3.Field(name='FTDPABVF', typename='Num', position=(95, 95), length=1, inclusive_range=(1, 5), allowable_values=['1', '2', '3', '4', '5', '9'], blanks=['Blank if Question 12 FTDCPPA = 0 (No) ', 'Blank if Question 12 FTDCPPA = blank', 'Blank if Question 22 FTDBVFT = 0 (Does not meet criteria)', 'Blank if Question 22 FTDBVFT = blank'])


class FormC1F(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['FTDWORRC'] = nacc.uds3.Field(name='FTDWORRC', typename='Num', position=(45, 46), length=2, inclusive_range=(0, 15), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['FTDWORRS'] = nacc.uds3.Field(name='FTDWORRS', typename='Num', position=(48, 49), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=['Blank if Question 1a FTDWORRC = 95', 'Blank if Question 1a FTDWORRC = 96', 'Blank if Question 1a FTDWORRC = 97', 'Blank if Question 1a FTDWORRC = 98'])
        self.fields['FTDWORRR'] = nacc.uds3.Field(name='FTDWORRR', typename='Num', position=(51, 52), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=['Blank if Question 1a FTDWORRC = 95', 'Blank if Question 1a FTDWORRC = 96', 'Blank if Question 1a FTDWORRC = 97', 'Blank if Question 1a FTDWORRC = 98'])
        self.fields['FTDWORIC'] = nacc.uds3.Field(name='FTDWORIC', typename='Num', position=(54, 55), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=['Blank if Question 1a FTDWORRC = 95', 'Blank if Question 1a FTDWORRC = 96', 'Blank if Question 1a FTDWORRC = 97', 'Blank if Question 1a FTDWORRC = 98'])
        self.fields['FTDWORIS'] = nacc.uds3.Field(name='FTDWORIS', typename='Num', position=(57, 58), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=['Blank if Question 1a FTDWORRC = 95', 'Blank if Question 1a FTDWORRC = 96', 'Blank if Question 1a FTDWORRC = 97', 'Blank if Question 1a FTDWORRC = 98'])
        self.fields['FTDWORIR'] = nacc.uds3.Field(name='FTDWORIR', typename='Num', position=(60, 61), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=['Blank if Question 1a FTDWORRC = 95', 'Blank if Question 1a FTDWORRC = 96', 'Blank if Question 1a FTDWORRC = 97', 'Blank if Question 1a FTDWORRC = 98'])
        self.fields['FTDWORIP'] = nacc.uds3.Field(name='FTDWORIP', typename='Num', position=(63, 64), length=2, inclusive_range=(0, 15), allowable_values=[], blanks=['Blank if Question 1a FTDWORRC = 95', 'Blank if Question 1a FTDWORRC = 96', 'Blank if Question 1a FTDWORRC = 97', 'Blank if Question 1a FTDWORRC = 98'])
        self.fields['FTDSEMMT'] = nacc.uds3.Field(name='FTDSEMMT', typename='Num', position=(66, 67), length=2, inclusive_range=(0, 20), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['FTDSEMAA'] = nacc.uds3.Field(name='FTDSEMAA', typename='Num', position=(69, 70), length=2, inclusive_range=(0, 8), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['FTDSEMTA'] = nacc.uds3.Field(name='FTDSEMTA', typename='Num', position=(72, 73), length=2, inclusive_range=(0, 8), allowable_values=[], blanks=['Blank if Question 3a FTDSEMAA = 95-98'])
        self.fields['FTDSEMSU'] = nacc.uds3.Field(name='FTDSEMSU', typename='Num', position=(75, 76), length=2, inclusive_range=(0, 16), allowable_values=[], blanks=['Blank if Question 3a FTDSEMAA = 95-98'])
        self.fields['FTDANASW'] = nacc.uds3.Field(name='FTDANASW', typename='Num', position=(78, 79), length=2, inclusive_range=(0, 5), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['FTDANAOW'] = nacc.uds3.Field(name='FTDANAOW', typename='Num', position=(81, 82), length=2, inclusive_range=(0, 5), allowable_values=[], blanks=['Blank if Question 4a FTDANASW = 95-98'])
        self.fields['FTDANATS'] = nacc.uds3.Field(name='FTDANATS', typename='Num', position=(84, 85), length=2, inclusive_range=(0, 10), allowable_values=[], blanks=['Blank if Question 4a FTDANASW = 95-98'])
        self.fields['FTDSENAS'] = nacc.uds3.Field(name='FTDSENAS', typename='Num', position=(87, 88), length=2, inclusive_range=(0, 5), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['FTDSENOS'] = nacc.uds3.Field(name='FTDSENOS', typename='Num', position=(90, 91), length=2, inclusive_range=(0, 37), allowable_values=[], blanks=['Blank if Question 5a FTDSENAS = 95-98'])
        self.fields['FTDSENSR'] = nacc.uds3.Field(name='FTDSENSR', typename='Num', position=(93, 94), length=2, inclusive_range=(0, 20), allowable_values=[], blanks=['Blank if Question 5a FTDSENAS = 95-98'])
        self.fields['FTDSENPR'] = nacc.uds3.Field(name='FTDSENPR', typename='Num', position=(96, 97), length=2, inclusive_range=(0, 20), allowable_values=[], blanks=['Blank if Question 5a FTDSENAS = 95-98'])
        self.fields['FTDNOUNC'] = nacc.uds3.Field(name='FTDNOUNC', typename='Num', position=(99, 100), length=2, inclusive_range=(0, 16), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['FTDVERBC'] = nacc.uds3.Field(name='FTDVERBC', typename='Num', position=(102, 103), length=2, inclusive_range=(0, 16), allowable_values=[], blanks=['Blank if Question 6a FTDNOUNC = 95-98'])
        self.fields['FTDRATIO'] = nacc.uds3.Field(name='FTDRATIO', typename='Num', position=(105, 109), length=5, inclusive_range=(0,16), allowable_values=[88.88], blanks=['Blank if Question 6a FTDNOUNC = 95-98'])
        self.fields['FTDREAAS'] = nacc.uds3.Field(name='FTDREAAS', typename='Num', position=(111, 112), length=2, inclusive_range=(0, 5), allowable_values=['95', '96', '97', '98'], blanks=[])
        self.fields['FTDREAOS'] = nacc.uds3.Field(name='FTDREAOS', typename='Num', position=(114, 115), length=2, inclusive_range=(0, 37), allowable_values=[], blanks=['Blank if Question 7a FTDREAAS = 95-98'])
        self.fields['FTDREASR'] = nacc.uds3.Field(name='FTDREASR', typename='Num', position=(117, 118), length=2, inclusive_range=(0, 20), allowable_values=[], blanks=['Blank if Question 7a FTDREAAS = 95-98'])
        self.fields['FTDREAPR'] = nacc.uds3.Field(name='FTDREAPR', typename='Num', position=(120, 121), length=2, inclusive_range=(0, 20), allowable_values=[], blanks=['Blank if Question 7a FTDREAAS = 95-98'])


class FormC2F(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['FTDCPC2F'] = nacc.uds3.Field(name='FTDCPC2F', typename='Num', position=(45, 46), length=2, inclusive_range=None, allowable_values=['95', '96', '97', '98'], blanks=['Blank if form completed'])
        self.fields['FTDhAIRD'] = nacc.uds3.Field(name='FTDhAIRD', typename='Num', position=(48, 48), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDSPIT'] = nacc.uds3.Field(name='FTDSPIT', typename='Num', position=(50, 50), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDNOSE'] = nacc.uds3.Field(name='FTDNOSE', typename='Num', position=(52, 52), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDCOAGE'] = nacc.uds3.Field(name='FTDCOAGE', typename='Num', position=(54, 54), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDCRY'] = nacc.uds3.Field(name='FTDCRY', typename='Num', position=(56, 56), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDCUT'] = nacc.uds3.Field(name='FTDCUT', typename='Num', position=(58, 58), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDYTRIP'] = nacc.uds3.Field(name='FTDYTRIP', typename='Num', position=(60, 60), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDEATP'] = nacc.uds3.Field(name='FTDEATP', typename='Num', position=(62, 62), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDTELLA'] = nacc.uds3.Field(name='FTDTELLA', typename='Num', position=(64, 64), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDOPIN'] = nacc.uds3.Field(name='FTDOPIN', typename='Num', position=(66, 66), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDLAUGh'] = nacc.uds3.Field(name='FTDLAUGh', typename='Num', position=(68, 68), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDShIRT'] = nacc.uds3.Field(name='FTDShIRT', typename='Num', position=(70, 70), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDKEEPM'] = nacc.uds3.Field(name='FTDKEEPM', typename='Num', position=(72, 72), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDPICKN'] = nacc.uds3.Field(name='FTDPICKN', typename='Num', position=(74, 74), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDOVER'] = nacc.uds3.Field(name='FTDOVER', typename='Num', position=(76, 76), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDEATR'] = nacc.uds3.Field(name='FTDEATR', typename='Num', position=(78, 78), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDhAIRL'] = nacc.uds3.Field(name='FTDhAIRL', typename='Num', position=(80, 80), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDShIRW'] = nacc.uds3.Field(name='FTDShIRW', typename='Num', position=(82, 82), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDMOVE'] = nacc.uds3.Field(name='FTDMOVE', typename='Num', position=(84, 84), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDhUGS'] = nacc.uds3.Field(name='FTDhUGS', typename='Num', position=(86, 86), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDLOUD'] = nacc.uds3.Field(name='FTDLOUD', typename='Num', position=(88, 88), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDLOST'] = nacc.uds3.Field(name='FTDLOST', typename='Num', position=(90, 90), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98', 'Blank if question not answered'])
        self.fields['FTDSNTOT'] = nacc.uds3.Field(name='FTDSNTOT', typename='Num', position=(92, 93), length=2, inclusive_range=(0, 22), allowable_values=['88'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98'])
        self.fields['FTDSNTBS'] = nacc.uds3.Field(name='FTDSNTBS', typename='Num', position=(95, 96), length=2, inclusive_range=(0, 12), allowable_values=['88'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98'])
        self.fields['FTDSNTOS'] = nacc.uds3.Field(name='FTDSNTOS', typename='Num', position=(98, 99), length=2, inclusive_range=(0, 10), allowable_values=['88'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98'])
        self.fields['FTDSNRAT'] = nacc.uds3.Field(name='FTDSNRAT', typename='Num', position=(101, 105), length=5, inclusive_range=(0, 22), allowable_values=['88.88'], blanks=['Blank if Question 0 FTDCPC2F = 95', 'Blank if Question 0 FTDCPC2F = 96', 'Blank if Question 0 FTDCPC2F = 97', 'Blank if Question 0 FTDCPC2F = 98'])


class FormC3F(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['FTDSELF'] = nacc.uds3.Field(name='FTDSELF', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDBADLY'] = nacc.uds3.Field(name='FTDBADLY', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDDEPR'] = nacc.uds3.Field(name='FTDDEPR', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDEMOTD'] = nacc.uds3.Field(name='FTDEMOTD', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDLSELF'] = nacc.uds3.Field(name='FTDLSELF', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDDISR'] = nacc.uds3.Field(name='FTDDISR', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDBELCh'] = nacc.uds3.Field(name='FTDBELCh', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDGIGG'] = nacc.uds3.Field(name='FTDGIGG', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDPRIV'] = nacc.uds3.Field(name='FTDPRIV', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDNEGAT'] = nacc.uds3.Field(name='FTDNEGAT', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDECOMM'] = nacc.uds3.Field(name='FTDECOMM', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDINAPJ'] = nacc.uds3.Field(name='FTDINAPJ', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDFAILA'] = nacc.uds3.Field(name='FTDFAILA', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDRESIS'] = nacc.uds3.Field(name='FTDRESIS', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDINTER'] = nacc.uds3.Field(name='FTDINTER', typename='Num', position=(73, 73), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDVERBA'] = nacc.uds3.Field(name='FTDVERBA', typename='Num', position=(75, 75), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDPhYSI'] = nacc.uds3.Field(name='FTDPhYSI', typename='Num', position=(77, 77), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDTOPIC'] = nacc.uds3.Field(name='FTDTOPIC', typename='Num', position=(79, 79), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDPROTO'] = nacc.uds3.Field(name='FTDPROTO', typename='Num', position=(81, 81), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDPREO'] = nacc.uds3.Field(name='FTDPREO', typename='Num', position=(83, 83), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDFINI'] = nacc.uds3.Field(name='FTDFINI', typename='Num', position=(85, 85), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDACTED'] = nacc.uds3.Field(name='FTDACTED', typename='Num', position=(87, 87), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDABS'] = nacc.uds3.Field(name='FTDABS', typename='Num', position=(89, 89), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDFEEDB'] = nacc.uds3.Field(name='FTDFEEDB', typename='Num', position=(91, 91), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDFRUST'] = nacc.uds3.Field(name='FTDFRUST', typename='Num', position=(93, 93), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDANXI'] = nacc.uds3.Field(name='FTDANXI', typename='Num', position=(95, 95), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDNERVO'] = nacc.uds3.Field(name='FTDNERVO', typename='Num', position=(97, 97), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDNDIAG'] = nacc.uds3.Field(name='FTDNDIAG', typename='Num', position=(99, 99), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDSTIMB'] = nacc.uds3.Field(name='FTDSTIMB', typename='Num', position=(101, 101), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDSTIME'] = nacc.uds3.Field(name='FTDSTIME', typename='Num', position=(103, 103), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDOBJEC'] = nacc.uds3.Field(name='FTDOBJEC', typename='Num', position=(105, 105), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDCIRCU'] = nacc.uds3.Field(name='FTDCIRCU', typename='Num', position=(107, 107), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDPERSE'] = nacc.uds3.Field(name='FTDPERSE', typename='Num', position=(109, 109), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDREPEA'] = nacc.uds3.Field(name='FTDREPEA', typename='Num', position=(111, 111), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDANECD'] = nacc.uds3.Field(name='FTDANECD', typename='Num', position=(113, 113), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDDINIT'] = nacc.uds3.Field(name='FTDDINIT', typename='Num', position=(115, 115), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDDELAY'] = nacc.uds3.Field(name='FTDDELAY', typename='Num', position=(117, 117), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDADDVE'] = nacc.uds3.Field(name='FTDADDVE', typename='Num', position=(119, 119), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDFLUCT'] = nacc.uds3.Field(name='FTDFLUCT', typename='Num', position=(121, 121), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDLOSTT'] = nacc.uds3.Field(name='FTDLOSTT', typename='Num', position=(123, 123), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDREPRU'] = nacc.uds3.Field(name='FTDREPRU', typename='Num', position=(125, 125), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDTRAIN'] = nacc.uds3.Field(name='FTDTRAIN', typename='Num', position=(127, 127), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDDISCL'] = nacc.uds3.Field(name='FTDDISCL', typename='Num', position=(129, 129), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDSPONT'] = nacc.uds3.Field(name='FTDSPONT', typename='Num', position=(131, 131), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDSPONR'] = nacc.uds3.Field(name='FTDSPONR', typename='Num', position=(133, 133), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDSTOOD'] = nacc.uds3.Field(name='FTDSTOOD', typename='Num', position=(135, 135), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDTOUCh'] = nacc.uds3.Field(name='FTDTOUCh', typename='Num', position=(137, 137), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDDSOCI'] = nacc.uds3.Field(name='FTDDSOCI', typename='Num', position=(139, 139), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDEXAGG'] = nacc.uds3.Field(name='FTDEXAGG', typename='Num', position=(141, 141), length=1, inclusive_range=(0, 3), allowable_values=['0', '1', '2', '3'], blanks=[])
        self.fields['FTDSBTOT'] = nacc.uds3.Field(name='FTDSBTOT', typename='Num', position=(143, 144), length=2, inclusive_range=(0, 42), allowable_values=[], blanks=[])
        self.fields['FTDSBCTO'] = nacc.uds3.Field(name='FTDSBCTO', typename='Num', position=(146, 148), length=3, inclusive_range=(0, 105), allowable_values=[], blanks=[])
        self.fields['FTDLENGT'] = nacc.uds3.Field(name='FTDLENGT', typename='Num', position=(150, 152), length=3, inclusive_range=(20, 240), allowable_values=[], blanks=[])


class FormC4F(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['FTDCPC4F'] = nacc.uds3.Field(name='FTDCPC4F', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2'], blanks=[])
        self.fields['FTDWORKU'] = nacc.uds3.Field(name='FTDWORKU', typename='Num', position=(47, 47), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4'], blanks=['Blank if question not answered'])
        self.fields['FTDMIST'] = nacc.uds3.Field(name='FTDMIST', typename='Num', position=(49, 49), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4'], blanks=['Blank if question not answered'])
        self.fields['FTDCRIT'] = nacc.uds3.Field(name='FTDCRIT', typename='Num', position=(51, 51), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4'], blanks=['Blank if question not answered'])
        self.fields['FTDWORR'] = nacc.uds3.Field(name='FTDWORR', typename='Num', position=(53, 53), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4'], blanks=['Blank if question not answered'])
        self.fields['FTDBAD'] = nacc.uds3.Field(name='FTDBAD', typename='Num', position=(55, 55), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4'], blanks=['Blank if question not answered'])
        self.fields['FTDPOOR'] = nacc.uds3.Field(name='FTDPOOR', typename='Num', position=(57, 57), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4'], blanks=['Blank if question not answered'])
        self.fields['FTDFFEAR'] = nacc.uds3.Field(name='FTDFFEAR', typename='Num', position=(59, 59), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4'], blanks=['Blank if question not answered'])
        self.fields['FTDBIST'] = nacc.uds3.Field(name='FTDBIST', typename='Num', position=(61, 62), length=2, inclusive_range=(7, 28), allowable_values=['88'], blanks=[])


class FormC5F(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['FTDCPC5F'] = nacc.uds3.Field(name='FTDCPC5F', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2'], blanks=[])
        self.fields['FTDINSEX'] = nacc.uds3.Field(name='FTDINSEX', typename='Num', position=(47, 47), length=1, inclusive_range=(1, 2), allowable_values=['1', '2'], blanks=[])
        self.fields['FTDINFMO'] = nacc.uds3.Field(name='FTDINFMO', typename='Num', position=(49, 50), length=2, inclusive_range=(1, 12), allowable_values=[], blanks=[])
        self.fields['FTDINFYR'] = nacc.uds3.Field(name='FTDINFYR', typename='Num', position=(52, 55), length=4, inclusive_range=(1900, 1990), allowable_values=[], blanks=[])
        self.fields['FTDINFRE'] = nacc.uds3.Field(name='FTDINFRE', typename='Num', position=(57, 57), length=1, inclusive_range=(1, 6), allowable_values=['1', '2', '3', '4', '5', '6'], blanks=[])
        self.fields['FTDFEEL'] = nacc.uds3.Field(name='FTDFEEL', typename='Num', position=(59, 59), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDDIFF'] = nacc.uds3.Field(name='FTDDIFF', typename='Num', position=(61, 61), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDSORR'] = nacc.uds3.Field(name='FTDSORR', typename='Num', position=(63, 63), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDSIDE'] = nacc.uds3.Field(name='FTDSIDE', typename='Num', position=(65, 65), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDADVAN'] = nacc.uds3.Field(name='FTDADVAN', typename='Num', position=(67, 67), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDIMAG'] = nacc.uds3.Field(name='FTDIMAG', typename='Num', position=(69, 69), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDMISF'] = nacc.uds3.Field(name='FTDMISF', typename='Num', position=(71, 71), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDWASTE'] = nacc.uds3.Field(name='FTDWASTE', typename='Num', position=(73, 73), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDPITY'] = nacc.uds3.Field(name='FTDPITY', typename='Num', position=(75, 75), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDQTOUC'] = nacc.uds3.Field(name='FTDQTOUC', typename='Num', position=(77, 77), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDSIDES'] = nacc.uds3.Field(name='FTDSIDES', typename='Num', position=(79, 79), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDSOFTh'] = nacc.uds3.Field(name='FTDSOFTh', typename='Num', position=(81, 81), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDUPSET'] = nacc.uds3.Field(name='FTDUPSET', typename='Num', position=(83, 83), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDCRITI'] = nacc.uds3.Field(name='FTDCRITI', typename='Num', position=(85, 85), length=1, inclusive_range=(1, 5), allowable_values=['1', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDIRIEC'] = nacc.uds3.Field(name='FTDIRIEC', typename='Num', position=(87, 88), length=2, inclusive_range=(7, 35), allowable_values=['88'], blanks=[])
        self.fields['FTDIRIPT'] = nacc.uds3.Field(name='FTDIRIPT', typename='Num', position=(90, 91), length=2, inclusive_range=(7, 35), allowable_values=['88'], blanks=[])


class FormC6F(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['FTDCPC6F'] = nacc.uds3.Field(name='FTDCPC6F', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 2), allowable_values=['0', '1', '2'], blanks=[])
        self.fields['FTDALTER'] = nacc.uds3.Field(name='FTDALTER', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDEMOT'] = nacc.uds3.Field(name='FTDEMOT', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDACROS'] = nacc.uds3.Field(name='FTDACROS', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDCONV'] = nacc.uds3.Field(name='FTDCONV', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDINTUI'] = nacc.uds3.Field(name='FTDINTUI', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDJOKE'] = nacc.uds3.Field(name='FTDJOKE', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDIMAGP'] = nacc.uds3.Field(name='FTDIMAGP', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDINAPP'] = nacc.uds3.Field(name='FTDINAPP', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDChBEh'] = nacc.uds3.Field(name='FTDChBEh', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDADBEh'] = nacc.uds3.Field(name='FTDADBEh', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDLYING'] = nacc.uds3.Field(name='FTDLYING', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDGOODF'] = nacc.uds3.Field(name='FTDGOODF', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDREGUL'] = nacc.uds3.Field(name='FTDREGUL', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 5), allowable_values=['0', '1', '2', '3', '4', '5'], blanks=['Blank if question not answered'])
        self.fields['FTDSMSCR'] = nacc.uds3.Field(name='FTDSMSCR', typename='Num', position=(73, 74), length=2, inclusive_range=(0, 30), allowable_values=['88'], blanks=[])
        self.fields['FTDSPSCR'] = nacc.uds3.Field(name='FTDSPSCR', typename='Num', position=(76, 77), length=2, inclusive_range=(0, 35), allowable_values=['88'], blanks=[])
        self.fields['FTDRSMST'] = nacc.uds3.Field(name='FTDRSMST', typename='Num', position=(79, 80), length=2, inclusive_range=(0, 65), allowable_values=['88'], blanks=[])


class FormE2F(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['FTDSMRI'] = nacc.uds3.Field(name='FTDSMRI', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDSMMO'] = nacc.uds3.Field(name='FTDSMMO', typename='Num', position=(47, 48), length=2, inclusive_range=(1, 12), allowable_values=[], blanks=['Blank if Question 1 FTDSMRI = 0 (No)'])
        self.fields['FTDSMDY'] = nacc.uds3.Field(name='FTDSMDY', typename='Num', position=(50, 51), length=2, inclusive_range=(1, 31), allowable_values=[], blanks=['Blank if Question 1 FTDSMRI = 0 (No)'])
        self.fields['FTDSMYR'] = nacc.uds3.Field(name='FTDSMYR', typename='Num', position=(53, 56), length=4, inclusive_range=(2000, CURRENT_YEAR), allowable_values=[], blanks=['Blank if Question 1 FTDSMRI = 0 (No)'])
        self.fields['FTDSMDIC'] = nacc.uds3.Field(name='FTDSMDIC', typename='Num', position=(58, 58), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDSMRI = 0 (No)'])
        self.fields['FTDSMDIS'] = nacc.uds3.Field(name='FTDSMDIS', typename='Char', position=(60, 119), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 FTDSMRI = 0 (No)', 'Blank if Question 1b FTDSMDIC ne 1 (Yes)'])
        self.fields['FTDSMADN'] = nacc.uds3.Field(name='FTDSMADN', typename='Num', position=(121, 121), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDSMRI = 0 (No)'])
        self.fields['FTDSMADV'] = nacc.uds3.Field(name='FTDSMADV', typename='Char', position=(123, 182), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 FTDSMRI = 0 (No)', 'Blank if Question 1c FTDSMADN ne 1 (Yes)'])
        self.fields['FTDSMMAN'] = nacc.uds3.Field(name='FTDSMMAN', typename='Num', position=(184, 184), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4', '9'], blanks=['Blank if Question 1 FTDSMRI = 0 (No)'])
        self.fields['FTDSMMAO'] = nacc.uds3.Field(name='FTDSMMAO', typename='Char', position=(186, 245), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 FTDSMRI = 0 (No)', 'Blank if Question 1d FTDSMMAN ne 4 (Other)'])
        self.fields['FTDSMMAM'] = nacc.uds3.Field(name='FTDSMMAM', typename='Char', position=(247, 306), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 FTDSMRI = 0 (No)', 'Blank if Question 1d FTDSMMAN = 9 (Unknown)'])
        self.fields['FTDSMFS'] = nacc.uds3.Field(name='FTDSMFS', typename='Num', position=(308, 308), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4', '9'], blanks=['Blank if Question 1 FTDSMRI = 0 (No)'])
        self.fields['FTDSMFSO'] = nacc.uds3.Field(name='FTDSMFSO', typename='Char', position=(310, 369), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 FTDSMRI = 0 (No)', 'Blank if Question 1e FTDSMFS ne 4 (Other)'])
        self.fields['FTDSMQU'] = nacc.uds3.Field(name='FTDSMQU', typename='Num', position=(371, 371), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 FTDSMRI = 0 (No)'])
        self.fields['FTDFDGPT'] = nacc.uds3.Field(name='FTDFDGPT', typename='Num', position=(373, 373), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDFPMO'] = nacc.uds3.Field(name='FTDFPMO', typename='Num', position=(375, 376), length=2, inclusive_range=(1, 12), allowable_values=[], blanks=['Blank if Question 2 FTDFDGPT = 0 (No)'])
        self.fields['FTDFPDY'] = nacc.uds3.Field(name='FTDFPDY', typename='Num', position=(378, 379), length=2, inclusive_range=(1, 31), allowable_values=['99'], blanks=['Blank if Question 2 FTDFDGPT = 0 (No)'])
        self.fields['FTDFPYR'] = nacc.uds3.Field(name='FTDFPYR', typename='Num', position=(381, 384), length=4, inclusive_range=(2000, CURRENT_YEAR), allowable_values=[], blanks=['Blank if Question 2 FTDFDGPT = 0 (No)'])
        self.fields['FTDFDDIC'] = nacc.uds3.Field(name='FTDFDDIC', typename='Num', position=(386, 386), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 2 FTDFDGPT = 0 (No)'])
        self.fields['FTDFDDID'] = nacc.uds3.Field(name='FTDFDDID', typename='Char', position=(388, 447), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 2 FTDFDGPT = 0 (No)', 'Blank if Question 2b FTDFDDIC ne 1 (Yes)'])
        self.fields['FTDFDADN'] = nacc.uds3.Field(name='FTDFDADN', typename='Num', position=(449, 449), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 2 FTDFDGPT = 0 (No)'])
        self.fields['FTDFDADV'] = nacc.uds3.Field(name='FTDFDADV', typename='Char', position=(451, 510), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 2 FTDFDGPT = 0 (No)', 'Blank if Question 2c FTDFDADN ne 1 (Yes)'])
        self.fields['FTDFDMAN'] = nacc.uds3.Field(name='FTDFDMAN', typename='Num', position=(512, 512), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4', '9'], blanks=['Blank if Question 2 FTDFDGPT = 0 (No)'])
        self.fields['FTDFDMAO'] = nacc.uds3.Field(name='FTDFDMAO', typename='Char', position=(514, 573), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 2 FTDFDGPT = 0 (No) ', 'Blank if Question 2d FTDFDMAN ne 4 (Other)'])
        self.fields['FTDFDMAM'] = nacc.uds3.Field(name='FTDFDMAM', typename='Char', position=(575, 634), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 2 FTDFDGPT = 0 (No)', 'Blank if Question 2d FTDFDMAN = 9 (Unknown)'])
        self.fields['FTDFDQU'] = nacc.uds3.Field(name='FTDFDQU', typename='Num', position=(636, 636), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 2 FTDFDGPT = 0 (No)'])
        self.fields['FTDAMYPT'] = nacc.uds3.Field(name='FTDAMYPT', typename='Num', position=(638, 638), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDAMMO'] = nacc.uds3.Field(name='FTDAMMO', typename='Num', position=(640, 641), length=2, inclusive_range=(1, 12), allowable_values=[], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)'])
        self.fields['FTDAMDY'] = nacc.uds3.Field(name='FTDAMDY', typename='Num', position=(643, 644), length=2, inclusive_range=(1, 31), allowable_values=['99'], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)'])
        self.fields['FTDAMYR'] = nacc.uds3.Field(name='FTDAMYR', typename='Num', position=(646, 649), length=4, inclusive_range=(2000, CURRENT_YEAR), allowable_values=[], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)'])
        self.fields['FTDAMDIC'] = nacc.uds3.Field(name='FTDAMDIC', typename='Num', position=(651, 651), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)'])
        self.fields['FTDAMDID'] = nacc.uds3.Field(name='FTDAMDID', typename='Char', position=(653, 712), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)', 'Blank if Question 3b, FTDAMDIC, ne 1 (Yes)'])
        self.fields['FTDAMLIG'] = nacc.uds3.Field(name='FTDAMLIG', typename='Num', position=(714, 714), length=1, inclusive_range=(1, 3), allowable_values=['1', '2', '3', '9'], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)'])
        self.fields['FTDAMLIO'] = nacc.uds3.Field(name='FTDAMLIO', typename='Char', position=(716, 775), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)', 'Blank if Question 3c, FTDAMLIG, ne 3 (Other)'])
        self.fields['FTDAMADN'] = nacc.uds3.Field(name='FTDAMADN', typename='Num', position=(777, 777), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)'])
        self.fields['FTDAMADV'] = nacc.uds3.Field(name='FTDAMADV', typename='Char', position=(779, 838), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)', 'Blank if Question 3d, FTDAMADN, ne 1 (Yes)'])
        self.fields['FTDAMMAN'] = nacc.uds3.Field(name='FTDAMMAN', typename='Num', position=(840, 840), length=1, inclusive_range=(1, 4), allowable_values=['1', '2', '3', '4', '9'], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)'])
        self.fields['FTDAMMAO'] = nacc.uds3.Field(name='FTDAMMAO', typename='Char', position=(842, 901), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)', 'Blank if Question 3e FTDAMMAN ne 4 (Other)'])
        self.fields['FTDAMMAM'] = nacc.uds3.Field(name='FTDAMMAM', typename='Char', position=(903, 962), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)', 'Blank if Question 3e FTDAMMAN = 9 (Unknown)'])
        self.fields['FTDAMQU'] = nacc.uds3.Field(name='FTDAMQU', typename='Num', position=(964, 964), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 3 FTDAMYPT = 0 (No)'])
        self.fields['FTDOThER'] = nacc.uds3.Field(name='FTDOThER', typename='Num', position=(966, 966), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDOTDOP'] = nacc.uds3.Field(name='FTDOTDOP', typename='Num', position=(968, 968), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 4 FTDOThER = 0 (No)'])
        self.fields['FTDOTSER'] = nacc.uds3.Field(name='FTDOTSER', typename='Num', position=(970, 970), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 4 FTDOThER = 0 (No)'])
        self.fields['FTDOTChO'] = nacc.uds3.Field(name='FTDOTChO', typename='Num', position=(972, 972), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 4 FTDOThER = 0 (No)'])
        self.fields['FTDOTANO'] = nacc.uds3.Field(name='FTDOTANO', typename='Num', position=(974, 974), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 4 FTDOThER = 0 (No)'])
        self.fields['FTDOTANS'] = nacc.uds3.Field(name='FTDOTANS', typename='Char', position=(976, 1035), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 4 FTDOThER = 0 (No)', 'Blank if Question 4d FTDOTANO ne 1 (Yes)'])


class FormE3F(nacc.uds3.FieldBag):
    def __init__(self):
        self.fields = header_fields()
        self.fields['FTDIDIAG'] = nacc.uds3.Field(name='FTDIDIAG', typename='Num', position=(45, 45), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=[])
        self.fields['FTDSMRIO'] = nacc.uds3.Field(name='FTDSMRIO', typename='Num', position=(47, 47), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)'])
        self.fields['FTDMRIFA'] = nacc.uds3.Field(name='FTDMRIFA', typename='Num', position=(49, 49), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)'])
        self.fields['FTDMRIRF'] = nacc.uds3.Field(name='FTDMRIRF', typename='Num', position=(51, 51), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)'])
        self.fields['FTDMRILF'] = nacc.uds3.Field(name='FTDMRILF', typename='Num', position=(53, 53), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)'])
        self.fields['FTDMRIRT'] = nacc.uds3.Field(name='FTDMRIRT', typename='Num', position=(55, 55), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)'])
        self.fields['FTDMRILT'] = nacc.uds3.Field(name='FTDMRILT', typename='Num', position=(57, 57), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)'])
        self.fields['FTDMRIRM'] = nacc.uds3.Field(name='FTDMRIRM', typename='Num', position=(59, 59), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)'])
        self.fields['FTDMRILM'] = nacc.uds3.Field(name='FTDMRILM', typename='Num', position=(61, 61), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)'])
        self.fields['FTDMRIRP'] = nacc.uds3.Field(name='FTDMRIRP', typename='Num', position=(63, 63), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)'])
        self.fields['FTDMRILP'] = nacc.uds3.Field(name='FTDMRILP', typename='Num', position=(65, 65), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)'])
        self.fields['FTDMRIRB'] = nacc.uds3.Field(name='FTDMRIRB', typename='Num', position=(67, 67), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)'])
        self.fields['FTDMRILB'] = nacc.uds3.Field(name='FTDMRILB', typename='Num', position=(69, 69), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)'])
        self.fields['FTDMRIOB'] = nacc.uds3.Field(name='FTDMRIOB', typename='Num', position=(71, 71), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)'])
        self.fields['FTDMRIOS'] = nacc.uds3.Field(name='FTDMRIOS', typename='Char', position=(73, 132), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 2 FTDSMRIO = 0 (No)', 'Blank if Question 2a, FTDMRIFA, = 0 (No) or 9 (Unknown)', 'Blank if Question 2a11 FTDMRIOB ne 1 (Yes)'])
        self.fields['FTDFDGPE'] = nacc.uds3.Field(name='FTDFDGPE', typename='Num', position=(134, 134), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)'])
        self.fields['FTDFDGFh'] = nacc.uds3.Field(name='FTDFDGFh', typename='Num', position=(136, 136), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)'])
        self.fields['FTDFDGRF'] = nacc.uds3.Field(name='FTDFDGRF', typename='Num', position=(138, 138), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)'])
        self.fields['FTDFDGLF'] = nacc.uds3.Field(name='FTDFDGLF', typename='Num', position=(140, 140), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)'])
        self.fields['FTDFDGRT'] = nacc.uds3.Field(name='FTDFDGRT', typename='Num', position=(142, 142), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)'])
        self.fields['FTDFDGLT'] = nacc.uds3.Field(name='FTDFDGLT', typename='Num', position=(144, 144), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)'])
        self.fields['FTDFDGRM'] = nacc.uds3.Field(name='FTDFDGRM', typename='Num', position=(146, 146), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)'])
        self.fields['FTDFDGLM'] = nacc.uds3.Field(name='FTDFDGLM', typename='Num', position=(148, 148), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)'])
        self.fields['FTDFDGRP'] = nacc.uds3.Field(name='FTDFDGRP', typename='Num', position=(150, 150), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)'])
        self.fields['FTDFDGLP'] = nacc.uds3.Field(name='FTDFDGLP', typename='Num', position=(152, 152), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)'])
        self.fields['FTDFDGRB'] = nacc.uds3.Field(name='FTDFDGRB', typename='Num', position=(154, 154), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)'])
        self.fields['FTDFDGLB'] = nacc.uds3.Field(name='FTDFDGLB', typename='Num', position=(156, 156), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)'])
        self.fields['FTDFDGOA'] = nacc.uds3.Field(name='FTDFDGOA', typename='Num', position=(158, 158), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)'])
        self.fields['FTDFDGOS'] = nacc.uds3.Field(name='FTDFDGOS', typename='Char', position=(160, 219), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 3 FTDFDGPE = 0 (No)', 'Blank if Question 3a FTDFDGFh = 0 (No) or 9 (Unknown)', 'Blank if Question 3a11, FTDFDGOA, ne 1 (Yes)'])
        self.fields['FTDAMYP'] = nacc.uds3.Field(name='FTDAMYP', typename='Num', position=(221, 221), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)'])
        self.fields['FTDAMYVI'] = nacc.uds3.Field(name='FTDAMYVI', typename='Num', position=(223, 223), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)'])
        self.fields['FTDAMYRF'] = nacc.uds3.Field(name='FTDAMYRF', typename='Num', position=(225, 225), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDAMYLF'] = nacc.uds3.Field(name='FTDAMYLF', typename='Num', position=(227, 227), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDAMYRT'] = nacc.uds3.Field(name='FTDAMYRT', typename='Num', position=(229, 229), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDAMYLT'] = nacc.uds3.Field(name='FTDAMYLT', typename='Num', position=(231, 231), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDAMYRM'] = nacc.uds3.Field(name='FTDAMYRM', typename='Num', position=(233, 233), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDAMYLM'] = nacc.uds3.Field(name='FTDAMYLM', typename='Num', position=(235, 235), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDAMYRP'] = nacc.uds3.Field(name='FTDAMYRP', typename='Num', position=(237, 237), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDAMYLP'] = nacc.uds3.Field(name='FTDAMYLP', typename='Num', position=(239, 239), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDAMYRB'] = nacc.uds3.Field(name='FTDAMYRB', typename='Num', position=(241, 241), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDAMYLB'] = nacc.uds3.Field(name='FTDAMYLB', typename='Num', position=(243, 243), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDAMYOA'] = nacc.uds3.Field(name='FTDAMYOA', typename='Num', position=(245, 245), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDAMYOS'] = nacc.uds3.Field(name='FTDAMYOS', typename='Char', position=(247, 306), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 4 FTDAMYP = 0 (No)', 'Blank if Question 4a FTDAMYVI = 0 (No) or 9 (Unknown)', 'Blank if Question 4a11, FTDAMYOA, ne 1 (Yes)'])
        self.fields['FTDCBFSP'] = nacc.uds3.Field(name='FTDCBFSP', typename='Num', position=(308, 308), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)'])
        self.fields['FTDCBFVI'] = nacc.uds3.Field(name='FTDCBFVI', typename='Num', position=(310, 310), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)'])
        self.fields['FTDCBFRF'] = nacc.uds3.Field(name='FTDCBFRF', typename='Num', position=(312, 312), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDCBFLF'] = nacc.uds3.Field(name='FTDCBFLF', typename='Num', position=(314, 314), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDCBFRT'] = nacc.uds3.Field(name='FTDCBFRT', typename='Num', position=(316, 316), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDCBFLT'] = nacc.uds3.Field(name='FTDCBFLT', typename='Num', position=(318, 318), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDCBFRM'] = nacc.uds3.Field(name='FTDCBFRM', typename='Num', position=(320, 320), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDCBFLM'] = nacc.uds3.Field(name='FTDCBFLM', typename='Num', position=(322, 322), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDCBFRP'] = nacc.uds3.Field(name='FTDCBFRP', typename='Num', position=(324, 324), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDCBFLP'] = nacc.uds3.Field(name='FTDCBFLP', typename='Num', position=(326, 326), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDCBFRB'] = nacc.uds3.Field(name='FTDCBFRB', typename='Num', position=(328, 328), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDCBFLB'] = nacc.uds3.Field(name='FTDCBFLB', typename='Num', position=(330, 330), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDCBFOA'] = nacc.uds3.Field(name='FTDCBFOA', typename='Num', position=(332, 332), length=1, inclusive_range=(0, 1), allowable_values=['0', '1', '9'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)'])
        self.fields['FTDCBFOS'] = nacc.uds3.Field(name='FTDCBFOS', typename='Char', position=(334, 393), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 5 FTDCBFSP = 0 (No)', 'Blank if Question 5a FTDCBFVI = 0 (No) or 9 (Unknown)', 'Blank if Question 5a11, FTDCBFOA, ne 1 (Yes)'])
        self.fields['FTDOTHI'] = nacc.uds3.Field(name='FTDOTHI', typename='Num', position=(395, 395), length=1, inclusive_range=(0, 1), allowable_values=['0', '1'], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)'])
        self.fields['FTDOTHIS'] = nacc.uds3.Field(name='FTDOTHIS', typename='Char', position=(397, 456), length=60, inclusive_range=None, allowable_values=[], blanks=['Blank if Question 1 FTDIDIAG = 0 (No)', 'Blank if Question 6, FTDOTHI, = 0 (No)'])
