[![Binder](https://mybinder.org/badge.svg)](https://mybinder.org/v2/gh/fangohr/introduction-to-python-for-computational-science-and-engineering/master?urlpath=tree/book/index.ipynb)
<!-- markdown-link-check-disable -->
<!-- TODO: Enable this AFTER first merge and deploy to master! -->
![Book Deploy](https://github.com/fangohr/introduction-to-python-for-computational-science-and-engineering/workflows/Book%20Deploy/badge.svg)
[![nbval in repo2docker container](https://github.com/fangohr/introduction-to-python-for-computational-science-and-engineering/actions/workflows/binder-nbval.yml/badge.svg)](https://github.com/fangohr/introduction-to-python-for-computational-science-and-engineering/actions/workflows/binder-nbval.yml) [![nbval](https://github.com/fangohr/introduction-to-python-for-computational-science-and-engineering/actions/workflows/nbval.yml/badge.svg)](https://github.com/fangohr/introduction-to-python-for-computational-science-and-engineering/actions/workflows/nbval.yml)
<!-- markdown-link-check-enable -->
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1411868.svg)](https://doi.org/10.5281/zenodo.1411868)
[![License: CC BY-NC 4.0](https://img.shields.io/badge/License-CC%20BY--NC%204.0-lightgrey.svg)](https://creativecommons.org/licenses/by-nc/4.0/)

# Introduction to Python for Computational Science and Engineering

<a href="https://fangohr.github.io/introduction-to-python-for-computational-science-and-engineering/book.pdf">
<img src="https://github.com/fangohr/introduction-to-python-for-computational-science-and-engineering/raw/master/static/images/logo.png" style="float" align="right" width="30%">
</a>

An Introduction to Python for Computational Science and Engineering, developed
by Hans Fangohr since 2003.(2003-2024).

The content and methods taught are intended for a target audience of scientists
and engineers who need to use computational methods and data processing in their
work, but typically have no prior programming experience or formal computer
science training.

The book is available:

- [As a web page (html)](https://fangohr.github.io/introduction-to-python-for-computational-science-and-engineering/)
<!-- markdown-link-check-enable -->
<!-- TODO: Enable this AFTER first merge and deploy to master! -->
- [As a PDF](https://fangohr.github.io/introduction-to-python-for-computational-science-and-engineering/book.pdf)
<!-- markdown-link-check-enable -->
- Interactively [as Jupyter Notebooks on MyBinder](https://mybinder.org/v2/gh/fangohr/introduction-to-python-for-computational-science-and-engineering/master?urlpath=tree/book/index.ipynb) (or [use JupyterLab](https://mybinder.org/v2/gh/fangohr/introduction-to-python-for-computational-science-and-engineering/master?urlpath=lab/tree/book/index.ipynb) instead of the traditional Notebook.)

The book is based on Python 3.

(A Python 2.7 version is [available
online](https://www.southampton.ac.uk/~fangohr/training/python/pdfs/Python2-for-Computational-Science-and-Engineering.pdf))

# Why use this book? (Feedback from user)

> *Readers looking for a beginner's guide to Python are faced with a
> bafflingarray of choices. However, Introduction to Python for Computational
> Science and Engineering, by Hans Fangohr is uniquely valuable because it is
> specifically aimed at those of us who are engaged in applied science or
> scientific research. The book is concise, well organized and full of practical
> examples that the reader can implement as they are going along. The key
> concepts of programming are introduced in the first half of the book, while
> the second half focuses on science/engineering applications: numerical
> methods, optimization, scientific plotting, and data science. This book is a
> must-have companion for anyone learning to use Python to enable their work in
> applied science or scientific research."
                   - Simon Box, Head of Virtual Development at Aurora Innovation.*


# Translation

The [book is available in
Portuguese](https://github.com/gcpeixoto/lecture-ipynb/blob/master/README.md)
([pdf](https://github.com/gcpeixoto/lecture-ipynb/raw/master/pdf/Introducao-Python-para-Ciencias-Computacionais-Engenharia.pdf)).

# Acknowledgments

Thanks go to Robert Rosca, Thomas Kluyver, Neil O'Brien, Jacek Generowicz, and Mark Molinari
for various contributions (see last chapter for details). Special thanks to all
readers, users and students who have provided feedback and corrections.

We acknowledge support from EPSRC (GR/T09156/01 and EP/G03690X/1) and from the
OpenDreamKit Horizon 2020 European Research Infrastructures project (#676541).

# Feedback?

If you have used these materials and have some feedback (positive or negative),
please get in touch with [Hans Fangohr](mailto:fangohr@soton.ac.uk).

# Favour request and citation

If you are using the book (be it as a teacher in your lecture course, as a
student to support your learning, or in any other role), please send a short
message to Hans (mailto:fangohr@soton.ac.uk) . Ideally, this would contain at which
university/institution/company you are and how you use the book (in one
sentence). This kind of data is useful to support further maintenance and
extensions of the materials.

Please use this citation:

* Hans Fangohr, *Python for Computational Science and Engineering*, 2018, DOI:
  [10.5281/zenodo.1411868](https://doi.org/10.5281/zenodo.1411868),
  [github.com/fangohr/introduction-to-python-for-computational-science-and-engineering](https://github.com/fangohr/introduction-to-python-for-computational-science-and-engineering/blob/master/Readme.md)

For BibTeX:
```
@misc{fangohr-python-book,
  doi = {10.5281/ZENODO.1411868},
  url = {https://github.com/fangohr/introduction-to-python-for-computational-science-and-engineering},
  author = {Fangohr,  Hans},
  keywords = {Python,  Education,  Textbook,  Computational Science,  Data Science,  Jupyter},
  language = {en},
  title = {Introduction To {Python} For Computational Science And Engineering},
  publisher = {Zenodo},
  year = {2018}
}
```

# License

<a rel="license" href="https://creativecommons.org/licenses/by-nc/4.0/"><img
alt="Creative Commons License" style="border-width:0"
src="https://i.creativecommons.org/l/by-nc/4.0/88x31.png" /></a><br /> This work
is <a
href="https://raw.githubusercontent.com/fangohr/introduction-to-python-for-computational-science-and-engineering/master/LICENSE.TXT">licensed</a>
under a <a rel="license"
href="https://creativecommons.org/licenses/by-nc/4.0/">Creative Commons
Attribution-NonCommercial 4.0 International License</a>.

The book can be downloaded, used and re-distributed for non-commercial purposes,
i.e in particular for education purposes at universities, research institutes
and schools. Please send a message to the author if you do so.


# Author

Hans Fangohr is a researcher and teacher (see
[homepage](https://fangohr.github.io), [blog](https://fangohr.github.io/blog),
[mastodon](https://fosstodon.org/@ProfCompMod)). His interests include effective
software engineering for computational science and data science, researching
computational modelling and data analysis methods, and education. He is a
<!-- markdown-link-check-disable -->
Professor at the [University of Southampton (UK)](https://www.southampton.ac.uk)
<!-- markdown-link-check-enable -->
and Head of the Scientific Support Unit for Computational Science at the  [Max Planck Institute for Structure and Dynamics of Matter (Germany)](https://www.mpsd.mpg.de/research/ssus/comput-science).

----

Historical note: CI was done on [Circle
CI](https://app.circleci.com/pipelines/github/fangohr/introduction-to-python-for-computational-science-and-engineering)
until 23 August 2018, then switched to [Travis
CI](https://travis-ci.org/fangohr/introduction-to-python-for-computational-science-and-engineering). A further switch in December 2020 to GitHub workflows.
