// ------------ Material Functions -------------------------------------------
Function {
  //  material correcetions due to TSA. Not used.
  f_kappa[] = 1.;
  f_heatCap[] = 1.;

  // Parameters for the material fitting functions
  RRR_Cu     = 200; // Residual resistance ratio
  Tup_RRR_Cu = 295; // Residual resistance ratio

  // values for MBXF, see https://espace.cern.ch/HiLumi/WP3/SitePages/MBXF.aspx
  // taken from STEAM/steam_models gitlab repository
  // https://gitlab.cern.ch/steam/steam_models/-/blob/master/conductors/conductor_MBXF/input/modelData_conductor_MBXF.yaml
  // NEWD1 conductor type
  C1 = 65821.9; // for fitting IC of NbTi
  C2 = -5042.6; // for fitting IC of NbTi
  nominal_current = 12047.0; // applied nominal current in A
  Cu_noCu_strand = 1.95; // f_Cu_strand_inGroup / f_SC_strand_inGroup
  f_SC_strand_inGroup = 1 / (1 + Cu_noCu_strand); // percentage of SC mat inside strand

  // imposed uniform background field
  magnField = 5; // applied magnetic field in T

  // thermal conductivity of the bare part w/o correction in W/mK
  kappa_SCSt[] = (1 - f_SC_strand_inGroup) *
    CFUN_kCu_T_rho0_rho[$1, CFUN_rhoCu_T[$1]{0, RRR_Cu},
    CFUN_rhoCu_T[$1]{magnField, RRR_Cu}]{RRR_Cu} +
    f_SC_strand_inGroup * 0;

  // thermal conductivity of the bare part after correction in W/mK
  kappa_Bare[] = f_kappa[] * kappa_SCSt[$1];

  // thermal conductivity of the insulation in W/mK
  kappa_Insulation[] = CFUN_kKapton_T[$1];

  // heat capacity of bare part w/o correction in J/m^3 K
  heatCap_SCSt[] = (1 - f_SC_strand_inGroup) * CFUN_CvCu_T[$1] +
                      f_SC_strand_inGroup * CFUN_CvNbTi_T[$1]{magnField, nominal_current, C1, C2};

  // heat capacity of the bare part after correction in J/m^3 K
  heatCap_Bare[] = f_heatCap[] * heatCap_SCSt[$1];

  // heat capacity of insulation in J/m^3 K
  heatCap_Insulation[] = CFUN_CvKapton_T[$1];
}