### Getting started

##### Create virtual environment and install required python packages
```
python -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt
```

##### Obtain GetDP and Gmsh
- For information on gmsh, see https://gmsh.info.
- For information on GetDP, see https://getdp.info.
- To solve the nonlinear problem, additional material laws are needed. See https://gitlab.cern.ch/steam/steam-material-library/-/tags/cerngetdp_2024.4.0 for the material laws, or https://gitlab.cern.ch/steam/cerngetdp/-/releases/2024.4.0 for a version of GetDP that includes the necessary functions.

##### Usage example
```
cd thermal_nonlin
python mesh.py --reference --refine 2
python solve.py --reference
gmsh v_ref.pos
```

### Model problems

##### thermal_3d
- This problem features a 3D block, cut in half by an insulation layer
- By default, the insulation layer is oriented vertically (YZ-plane) and placed in the middle of the block. Placement and angle can be changed by modifying the variables `L1` and `L2`. Thickness of the insulation layer can be changed by modifying the value of `w_Ins`
- Mesh resolution for left and right subdomain can be set via `cl1` and `cl2`.

##### thermal_nonlin
- This problem features a simplified model of a superconducting accelerator magnet
- Dimensions of the coils and yoke, insulation thickness and mesh size can be changed. See `geometry_parameters.pro` for the variable names.

##### h-phi_3d
- This problem features a rectangular conductor surrounded by air
- This simple example of a magnetoquasistatic problem using the H-phi formulation seems to work
- Compared to problems in H^1, the mapping of functions supported on mesh A onto mesh B is more complicated for H(curl).
- In general, this mapping currently does not work in GetDP. See https://gitlab.onelab.info/getdp/getdp/-/issues/109 for further information
