proc format;
	value ncohort 0="0: Siblings" 1="1: Survivors";
	value grouptime 0="0: 2002 Original survey" 1="1: FU-6 survey";
	value group 1="1: Original" 2="2: Expansion";
	value race6f 1="1: White" 2="2: Black" 3="3: Hispanic" 4="4: Asian or Pacific Islander" 5="5: American Indian / Alaska Native" 6="6: Other";
	value race4f 1="1: White, Non-Hispanic" 2="2: Black, Non-Hispanic" 3="3: Hispanic/Latino" 4="4: Other";
	value agegrp 1="1: 18-29" 2="2: 30-39" 3="3: 40-49" 4="4: 50+";
	value agedxgrp 1="1: 0-4" 2="2: 5-9" 3="3: 10-14" 4="4: 15+";
	*value incomegrp 1="1: <20,000" 2="2: 20,000-59,999" 3="3: 60,000-99,999" 4=">=100,000";
	*value edugrp 1="1: High school (HS) or below HS" 2="2: Some college" 3="3: College graduate and above";
	*value empgrp 1="1: Employed - Full Time" 2="2: Employed - Part Time" 3="3: Unemployed/not in labor force";
	*value insurancegrp 0="0: None" 1="1: Private" 2="2: Public" 3="3: Canadian";
	*value maritalgrp 1="1: Married" 2="2: Divorced/Separated" 3="3: Never married" 4="4: Widowed";
	value bmif 1="1: Normal/underweight" 2="2: Overweight" 3="3: Obesity" 9="9: Unknown";
	value chcgrp 0="0: Max Grade 0/1" 1="1: Max Grade 2" 2="2: Max Grade 3 or 4";
	value nchcgrp 0="0: 0" 1="1: 1" 2="2: >=2";
	value chcburdengrp 0,1="0-1: None/low" 2="2: Medium" 3="3: High" 4="4: Very high";

	value cyclgrp 0="0: None" 1="1: >0 to <4000 mg/m2" 2="2: >=4000 to <8000 mg/m2" 3="3: >=8000 mg/m2" 9="4: Unknown";
	value anthgrp 0="0: None" 1="1: 1-249 mg/m2" 2="2: >=250 mg/m2";

	value brianrtgrp 0="0: None" 1="1: <20 Gy" 2="2: >=20 Gy";
	value neckrtgrp 0="0: None" 1="1: <30 Gy" 2="2: >=30 Gy";
	value chestrtgrp 0="0: None" 1="1: <30 Gy" 2="2: >=30 Gy";
	value abdrtgrp 0="0: None" 1="1: <30 Gy" 2="2: >=30 Gy";

	value sleephour2gf .='.: Missing' 0="0: Total sleep time >=6 hours" 1="1: Total sleep time <6 hours";
	value slpla2gf .= '.: Missing' 0='0: <30' 1='1: >=30';
	value hse2gf .= '.: Missing' 0='0: >=85%' 1='1: <85%';
	*value slp23gf .= '.: Missing' 1='1: 0-19' 2='2: 20-29' 3='3: 30+';
	value threetimesf .= '.: Missing' 0='0: Less than 3 times a week' 1='1: 3 or more times a week';
	value onetimesf .= '.: Missing' 0='0: Less than 1 time a week' 1='1: 1 or more times a week';
	value anytimesf .= '.: Missing' 0='0: Not during the past month' 1='1: Any during the past month';
	value slpos2gf .= '.: Missing' 0='0: On or before 1am' 1='1: After 1am';
  	value wkt2gf .= '.: Missing' 0='0: On or before 10 am' 1='1: After 10am';
  	*value bdtb9pmf .= '.: Missing' 0='0: On or after 9 pm' 1='1: Before 9pm';
  	*value wktb5amf .= '.: Missing' 0='0: On or after 5 am' 1='1: Before 5am';
  	value yes1no0f .= '.: Missing' 0='0: No' 1='1: Yes';
	value PSQI2gf .='.: Missing' 0='0: PSQI Total Score <=5' 1='1: PSQI Total Score >5';

	value sexmenof .='.: Missing' 1="1: Male" 2="2: Female-AOF" 3="3: Female-AOF-no menarche" 4="4: Female-Cranial or pituitary radiation >= 30Gy" 
								  5="5: Female-Normal" 6="6: Female-PM" 7="7: Female-Surgical PM";
run;

proc format;
value agef 0-19='  <20' 20-29=' 20-29' 30-39=' 30-39' 40-49=' 40-49' 50-59=' 50-59' 60-high='>=60';
value age2f 0-29='  <=29' 30-39=' 30-39' 40-49=' 40-49' 50-59=' 50-59' 60-high='>=60';
value abasef 0-<18='<18' 18-25='18-25' 26-35='26-35' 35-high='35+';
value ins3f 1,3='Yes/Canadian' 2,9='No,Unknown';
value hlth3f 1='Excellent' 2='Very good' 3='Good' 4='Fair' 5,9='Poor/Unknown';
/*for FU3 model:collapse due to very few in no trt group*/
value trt3f 1='        Chemo+RT+Surgery'
        	2='       Chemo+RT'
        	3='     Chemo+Surgery'
        	4='   Chemo Only'
        	5='  RT+Surgery'
        	6=' RT Only'
        	7,8=' Surgery Only/No treatment'
        	9='Treatment unknown'
        	99='No MRAF';
/*for FU4 model:collapse due to very few in RT only group*/
value trt4f 1='        Chemo+RT+Surgery'
        	2='       Chemo+RT'
        	3='     Chemo+Surgery'
        	4='   Chemo Only'
        	5,6='RT Only/RT+Surgery'
        	7,8=' Surgery Only/No treatment'
        	9='Treatment unknown'
        	99='No MRAF';
/*collapse unknown for hispanic in with no to prevent collinearity with race*/
value hisp2f 1='Hispanic' 2,9='Non-Hispanic/Unknown';
value inst2f 1-29='1-29' 30-33='30-33';
value incomelf 1="<$20,000" 2="$20,000-39,999" 3="$40,000-59,999" 4="$60,000+" 9="Unknown";
value yncan2f 1="Yes" 2="No" 3="Canadian" 9="Unknown";
value bmi2f 1="<18.5" 2="18.5-24" 3="25-29" 4="30+" 9="Unknown";
value smkf 1="Never smoker" 2="Former smoker" 3="Current smoker" 9,99="Unknown";
value adxf 0-4="0-4" 5-9="5-9" 10-14="10-14" 15-20="15-20";
value ydx2f 1970-1978="1970-78" 1979-1986="1979-86" 1987-1993="1987-93" 1994-1999="1994-99";
value edf 0,1,2="< High school graduate" 3="High school graduate" 4,5,6,7=">High school graduate" 8="Special Ed" 9,99="Other/Unknown";
value gradef 0="Grade 0" 1,2="Grade 1-2" 3,4="Grade 3-4" 99="Unknown";
run;