#!/bin/bash

pheno=$1
ss=$2
chr_bgen=$3
chr=$4
from=$5
to=$6
thr=$7
n_sample=$8

################
## make files ##
################

tmp=${pheno}/${pheno}_${chr}_${from}_${to}/tmp
out=${pheno}/${pheno}_${chr}_${from}_${to}/finemap

mkdir -p $(dirname $out)

Ngwas=$(tabix ${ss} ${chr}:${from}-${to} | cut -f 6 | sort | uniq | sort -nr | head -n 1)

tabix -h ${ss} ${chr}:${from}-${to}
  | cut -f 1,7,10,12 \
  | sed '1d' \
  | sort -k 1,1 > ${tmp}.pval

tabix ${ss} ${chr}:${from}-${to} \
  | cut -f 1,2,3,4,5,7,8,9 \
  | awk '{print $1,$2,$3,$5,$4,($6>0.5?1-$6:$6),$7,$8}' \
  | sed '1s/^/rsid chromosome position allele1 allele2 maf beta se\n/' \
   > ${tmp}.finemap.z

cat ${tmp}.finemap.z \
  | cut -d ' ' -f -5 > ${tmp}.ldstore.z

cat ${tmp}.finemap.z \
  | sed '1d' \
  | cut -d ' ' -f -1 > ${tmp}.bgen.z

{
  echo "z;bgen;bgi;bcor;bdose;ld;n_samples"
  echo "${tmp}.ldstore.z;${tmp}.bgen;${tmp}.bgen.bgi;${tmp}.bcor;${tmp}.bdose;${tmp}.ld;${n_sample}"
} > ${tmp}.ldstore.in

##############
## analysis ##
##############

ls bgenfiles/chr${chr_bgen}/*.bgen | while read line; do
  bn=$(basename ${line} | sed 's/.bgen/.tmp.bgen/')
  bgenix -g ${line} -incl-rsids ${tmp}.bgen.z > ${tmp}.${bn}
done

bgens=$(ls ${tmp}.*.tmp.bgen)

cat-bgen -clobber -g ${bgens} -og ${tmp}.bgen
bgenix -clobber -index -g ${tmp}.bgen

rm ${bgens}

${HOME}/repo/ldstore_v2.0_x86_64/ldstore_v2.0_x86_64 \
  --write-bcor \
  --write-bdose \
  --n-threads ${thr} \
  --memory 12 \
  --in-files ${tmp}.ldstore.in

for N in {10,20}; do

  {
    echo "z;bcor;snp;config;cred;log;n_samples"
    echo "${tmp}.finemap.z;${tmp}.bcor;${out}.${N}.snp;${out}.${N}.config;${out}.${N}.cred;${out}.${N}.log;${Ngwas}"
  } > $tmp.finemap.${N}.in

  ~/repo/finemap_v1.4_x86_64/finemap_v1.4_x86_64 \
    --sss \
    --n-causal-snps ${N} \
    --n-threads ${thr} \
    --force-n-samples \
    --log \
    --in-files ${tmp}.finemap.${N}.in

  cat ${out}.${N}.snp | head -n 1 | \
    awk '{print $0,"AAF","P","LOGP"}' | tr " " "\t" > ${out}.${N}.snp.mod

  join -t $'\t' \
    <(cat ${out}.${N}.snp | sed '1d' | awk '{print $2,$0}' | tr " " "\t" |  sort -k 1,1) \
    <(cat ${tmp}.pval) | cut -f 2- >> ${out}.${N}.snp.mod

done

ls ${out}.* | grep -v .gz | while read line; do
  gzip -f ${line}
done

rm ${tmp}.*
