#!/bin/bash

#############
# EXECUTION #
#############

## BINARY ##

bolt=/home/repo/BOLT-LMM_v2.3.4/bolt
ldscore=/home/dat/ldscore/1000G_EAS_Phase3.tab.gz
gmap=/home/repo/BOLT-LMM_v2.3.4/tables/genetic_map_hg19_withX.txt.gz

## PLINK FILES ##

tag=$2

## SAMPLE ##

samplefile=$3

## GENOTYPE ##

bgenfile=$4

## OUTPUT ##

statsFile=$5.bolt_genotype
statsFileBgenSnps=$5.bolt_imputed

mkdir -p ../tmp/$bnpheno

$bolt \
  --lmm \
  --lmmForceNonInf \
  --bfile=$tag \
  --phenoFile=$pheno \
  --phenoCol=PHENO \
  --LDscoresFile=$ldscore \
  --LDscoresMatchBp \
  --geneticMapFile=$gmap \
  --bgenFile=$bgenfile \
  --sampleFile=$samplefile \
  --numThreads=$thr \
  --statsFile=$statsFile \
  --statsFileBgenSnps=$statsFileBgenSnps
