% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate_flooding.R
\name{interpolate_flooding}
\alias{interpolate_flooding}
\title{Interpolate flooding}
\usage{
interpolate_flooding(df, interval = "week", wateryear, sum = FALSE)
}
\arguments{
\item{df}{Input tibble from \code{\link[=estimate_flood_extent]{estimate_flood_extent()}}}

\item{interval}{one of "day", "week", "month", "quarter" or "year"; see
\code{\link[=seq.Date]{seq.Date()}}}

\item{wateryear}{numeric; water years to interpolate over}

\item{sum}{Logical; if TRUE, summarize by date across all units}
}
\value{
tibble with fields: \code{date}, \code{year}, \code{month}, \code{wateryear},
\code{AreaWater_ha}, and \code{AreaWater_ac}
}
\description{
Interpolate adjusted estimates of flooded area from \code{\link[=estimate_flood_extent]{estimate_flood_extent()}}
to cover specific dates, facilitating a sum across multiple units.
}
\details{
For each unit, this function interpolates values of
\code{ObservedAreaWater_adjust} generated form \code{\link[=estimate_flood_extent]{estimate_flood_extent()}} across a
desired water years. For each water year, the sequence of dates to
interpolate is first generated from Oct 1 through Sep 30 at the desired
interval. For intervals of weeks or days in leap years, leap day is
intentionally skipped in the sequence of dates, facilitating comparisons
across multiple years on common dates.

Values are then interpreted using \code{\link[zoo:na.approx]{zoo::na.spline()}}, and any values less
than zero are changed to zero. Optionally, if \code{sum = TRUE}, summarizes
across all units for each unique date to return the total area flooded.
}
\examples{
df = format_watertracker(sampledat) |> estimate_flood_extent()
interpolate_flooding(df, wateryear = c(2015, 2016))
}
