% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalize_wetland_mode.R
\name{generalize_wetland_mode}
\alias{generalize_wetland_mode}
\title{Generalize monthly management modes}
\usage{
generalize_wetland_mode(df, fullmode = NULL, clean = FALSE)
}
\arguments{
\item{df}{Input tibble from \code{\link[=estimate_wetland_mode]{estimate_wetland_mode()}}}

\item{fullmode}{One of \code{M} or \code{H}; only necessary if \code{clean = TRUE}; see
Details}

\item{clean}{Logical; determines whether to correct for repeat values of F
and D}
}
\value{
Input tibble with only one entry for each month for each unit, the
most frequent value for "mode", and an additional field \code{weight} giving the
proportion of years observed containing that management mode in that month.
}
\description{
Identify typical water management schedule across multiple water years of
data
}
\details{
For each unit, identifies and returns the most frequent management
mode in each month and calculates \code{weight} as the proportion of water years
in which that mode was detected. Low values for weight reflect months with
more annual variability in the monthly management schedules.

Note that ties are not returned, and in the case of ties, the function
favors returning modes in the following order: F, D, I, M, H, N (see
\code{\link[=estimate_wetland_mode]{estimate_wetland_mode()}} for details). It is therefore possible for the
function to return multiple months with values for F and D. Setting
\code{clean=TRUE} will reclassify duplicate values of F and D to \code{fullmode}, but
will also remove \code{weight} estimates since they may no longer be valid.
}
\examples{
df = format_watertracker(sampledat) |> estimate_flood_extent() |>
  estimate_flood_delta() |> estimate_wetland_mode()
generalize_wetland_mode(df)

}
