% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_duplicates.R
\name{find_duplicates}
\alias{find_duplicates}
\title{Find pseudoreplicate/duplicate data in Water Tracker output}
\usage{
find_duplicates(df)
}
\arguments{
\item{df}{Input data frame from water tracker}
}
\value{
tibble with added logical field "dup"
}
\description{
Find pseudoreplicate/duplicate data in Water Tracker output
}
\details{
Internal to \code{\link[=format_watertracker]{format_watertracker()}}. Not meant to be called
separately.

An observation is considered to be a likely duplicate of a previous
observation (i.e. representing the same individual scene) if: (1) the date
range of the mosaic starts on or before previous mosaic's end date, (2) the
PercentWater and ObservedAreaHa stats match, and (3) PercentWater is either
NA or greater than zero (because difficult to distinguish multiple dry
images from duplicates).
}
