% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_wetland_mode.R
\name{estimate_wetland_mode}
\alias{estimate_wetland_mode}
\title{Estimate monthly wetland operational modes}
\usage{
estimate_wetland_mode(df, fullmode = "M")
}
\arguments{
\item{df}{Input tibble from \code{\link[=estimate_flood_delta]{estimate_flood_delta()}}}

\item{fullmode}{One of \code{M} or \code{H}; default operational mode for units
considered fully flooded}
}
\value{
tibble with additional field "mode"
}
\description{
Interprets results of \code{\link[=estimate_flood_delta]{estimate_flood_delta()}} to estimate assign monthly
water management modes for use with the \verb{Wetland Water Budget Tool} a simple
spread-sheet based tool allowing non-specialists to estimate wetland water
budgets from a combination of management unit size and schedule of monthly
operational modes.
}
\details{
The sequence of Water Tracker observations for each unit is analyzed
to interpret monthly operational mode codes, as defined in the Wetland
Water Budget Tool (WWBT):
\itemize{
\item F (flood up): water applied to fully flood the unit
\item M (maintenance): unit is fully flooded and being actively maintained at full to compensate for evapotranspiration and soil infiltration
\item H (hold): alternative to maintenance mode in which the unit is (or was) fully flooded but is not being actively maintained at full; evapotranspiration and soil infiltration may result in declines in depth
\item D (drawdown): unit is being drained
\item I (irrigation): short-term flooding
\item N (no water supply): no water added to the unit, though water may be present from management in prior months (e.g., drawdown still in progress)
\item C (cropped): no water supply, but actively growing vegetation is removing water from the soil through evapotranspiration
}

Using the output from \code{\link[=estimate_flood_delta]{estimate_flood_delta()}}, the function first
identifies months in which the \code{flood_status} of all observations is
"full", interpreted as M or H depending on the \code{fullmode} provided, or
"dry", interpreted as N. Months in which observations differ in the extent
of flooding are considered transitional, and are further interpreted by
examining the \code{flood_trend}, or the direction and magnitude of change in
the proportion flooded from the previous observation.

A substantial increase in the proportion of a unit flooded from one
observation date to the next is interpreted as new water applied to the
unit, and should normally be interpreted as F or I. The distinction between
F and I is interpreted from the duration of flooding detected, with F
requiring subsequent observation(s) interpreted as M or H. Exceptions
include: (1) increases that represent (sometimes substantial) fluctuations
in the extent of flooding during extended periods of M or H (which are
instead interpreted as continued M or H), or (2) the previous observation
was already interpreted as F. Only one month in each water year should
normally be interpreted as F, even if flood up is slow and the extent of
flooding continues to increase in the following month. However, it is
important to note that floodup may begin at the end of the previous water
year (e.g., in September). There is no limit to the number of months that
can be interpreted as I, but multiple irrigation events will only be
detected if there are gaps in flooding between them.

A substantial decrease in the proportion of a unit flooded from one
observation to the next is interpreted as D, provided the previous
observation(s) were interpreted as M or H and not I or D. Only one month in
each water year should normally be designated as D, even if drawdown is
slow and there is still surface water present in the following month. If a
previous observation was already designated as D and the extent of flooding
continues to decline, it will be interpreted as N.

Relatively small fluctuations in the extent of flooding are ignored and
assumed to reflect noise in the remote sensing data. In addition,
WaterTracker data are not yet capable of automatically detecting cropped
status. Values for \code{N} may be changed manually to \code{C} as needed.
}
\examples{
df = format_watertracker(sampledat) |> estimate_flood_extent() |> estimate_flood_delta()
estimate_wetland_mode(df)
}
