% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_obsdate.R
\name{estimate_obsdate}
\alias{estimate_obsdate}
\title{Estimate observation date of satellite imagery}
\usage{
estimate_obsdate(df)
}
\arguments{
\item{df}{Input data frame from water tracker with added field "dup" from
\code{\link[=find_duplicates]{find_duplicates()}}}
}
\value{
tibble with added fields "overlap_days" and "obsdate".
}
\description{
Estimate observation date of satellite imagery
}
\details{
Internal to \code{\link[=format_watertracker]{format_watertracker()}}. Not meant to be called
separately.

Function first find the number of days of overlap period between the end
date of each observation's mosaic date range and start of the next
observation's date range. If the next row is marked as a duplicate, the
observation date of the image is estimated as the midpoint of this overlap
period. Otherwise, the observation date is estimated as the midpoint of the
original mosaic start and end date range.
}
