% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_flood_delta.R
\name{estimate_flood_delta}
\alias{estimate_flood_delta}
\title{Estimate change in flooding}
\usage{
estimate_flood_delta(df, delta = 0.2)
}
\arguments{
\item{df}{Input tibble from \code{\link[=estimate_flood_extent]{estimate_flood_extent()}}.}

\item{delta}{Numeric proportion change representing significant increase or
decrease in flooding.}
}
\value{
tibble with added fields: \code{flood_delta} and \code{flood_trend}
}
\description{
Interprets sequence of Water Tracker data in each unit to estimate whether
the change in the extent of flooding from the previous observation represents
a substantial increase or decrease.
}
\details{
For each unit, the proportion change in flooded area from the
previous observation date is calculated (\code{flood_delta}) and the direction
and magnitude of change is categorized (\code{flood_trend}) based on the input
value for \code{delta} provided, as:
\itemize{
\item \code{INCREASE}:  \code{flood_delta} >= \code{delta}
\item \code{up}: \code{delta} > \code{flood_delta} > 0
\item \code{0}: \code{flood_delta} = 0
\item \code{down}: 0 > \code{flood_delta} > -\code{delta}
\item \code{DECREASE}: -\code{delta} >= \code{flood_delta}
}
}
\examples{
df = format_watertracker(sampledat) |> estimate_flood_extent()
estimate_flood_delta(df)
}
