# Contrasting responses of forest phenological guilds to complex floodplain change

[https://doi.org/10.5061/dryad.1vhhmgr2c](https://doi.org/10.5061/dryad.1vhhmgr2c)

In total, we collected 28 explanatory variables that are assumed to have a significant effect on the abundance and richness of the herbaceous layer in floodplain forests and divided them into the categories of climatic, hydrological, and soil conditions, and forest canopy structure. Most of the factors were represented by the differences in their values between the current and historical samples (hereafter referred to as Δ). Changes in climatic conditions and hydrological regimes were calculated using the summary statistic (mean) of the year of sampling and the ten-year values (eleven years in total) of the variable before sampling to remove potential bias from a season of unusual conditions. Most variables therefore provide information on absolute changes in environmental conditions between these two periods. Differences were not calculated for most of the soil characteristics that were only measured in the current sampling period. Climatic and hydrological changes were calculated for spring (March-May), summer (June-August), autumn (September-November), and winter (December-February) in order to distinguish between different effects of seasonal changes on plant phenological guilds. Climatic variables included data on changes in temperature and the Standardised Precipitation-Evapotranspiration Index (SPEI). They were used to describe changes in the length of the growing season and the balance between drought and humidity. SPEI was calculated from monthly potential evapotranspiration (PE) using the Thornthwaite equation (Thornthwaite 1948). SPEI expresses the climatic water balance in each month as precipitation minus potential evapotranspiration (Vicente-Serrano et al. 2010, Beguería et al. 2014). The hydrological regime was represented by variables describing changes in the flood regime of the river. Flooding was characterised by the difference between the daily discharge (m^3/s) and the flood reached or exceeded once a year on the long-term average (i.e., *Q1* according to the Czech Hydrological Institute). We also calculated the relative elevation (m) of each sample plot above/below the flood level reached or exceeded once every five years, using a digital terrain model (DMR 4G, total standard error of elevation 0.3 m) and maps showing areas covered by 5-year floods. Soil conditions were represented by values of soil pH and plant bioavailable nutrients (Ca, K, Mg, P), which indicate the level of nutrient availability to plants (mg/kg). The proportions of soil particle-size fractions (*clay* < 0.001 mm, *clay* *and fine silt* < 0.01 mm, *coarse silt* 0.01–0.05 mm, *fine sand* 0.05–0.25 mm, *coarse sand* 0.25–2 mm) indicated sedimentation processes in river alluvium with increasing proportions of coarse sand particles, lower water and nutrient availability for plants. Soil acidity (pH-H2O) was the only soil characteristic measured during the historical data collection and its changes could indicate potential site acidification. Canopy structure was characterised by changes in canopy cover, expressed as the sum of the percent cover of all species present in the tree layer, and tree species diversity, expressed as species richness in the tree layer. Canopy cover of *Quercus robur* (%) represents the occurrence of key species in hard-wood riparian forests in Europe. Bray-Curtis dissimilarity was calculated using non-transformed species cover values between the tree species composition recorded during the current and historical sampling. Changes in tree litter quality were estimated using an ordinal scale (1-5) following Maes et al. (2019), with increasing values indicating higher litter quality. These variables characterise canopy succession and are thought to influence herbaceous plant development through changes in light and soil nutrient availability and microclimate.

**References**

Beguería, S., Vicente‐Serrano, S. M., Reig, F., & Latorre, B. (2014). Standardized precipitation evapotranspiration index (SPEI) revisited: parameter fitting, evapotranspiration models, tools, datasets and drought monitoring. *International Journal of Climatology*, 34(10), 3001–3023.

Maes, S. L., Blondeel, H., Perring, M. P., Depauw, L., Brūmelis, G., Brunet, J., Decocq, G., den Ouden, J., Härdtle, W., Hédl, R., Heinken, T., Heinrichs, S., Jaroszewicz, B., Kirby, K. J., Kopecký, M., Máliš, F., Wulf, M., & Verheyen, K. (2019). Litter quality, land-use history, and nitrogen deposition effects on topsoil conditions across European temperate deciduous forests. *Forest Ecology and Management*, 433, 405–418.

Thornthwaite, C. W. (1948). An approach toward a rational classification of climate. *Geographical Review*, 38(1), 55–94.

Vicente-Serrano, S. M., Beguería, S., & López-Moreno, J. I. (2010). A multiscalar drought index sensitive to global warming: the standardized precipitation evapotranspiration index. *Journal of Climate*, 23(7), 1696–1718.

## Description of the data and file structure

Data contains a table with all the variables (in columns) needed to test the effects of environmental variables on temporal changes in species diversity and abundance of plant species in floodplain forests. Below is an explanation of each variable in the table.

*   *SampleID*: Identification number of the resurveyed plot
*   *Plant_phenological_guild*: Corresponds to month (i.e. 3-10 means March to October) when given plant phenological guild is flowering.
*   *Species_coverDIFF*: Difference between current and original total herbaceous plant cover in plot (%)
*   *Species_richnessDIFF*: Difference between current and original plant herbaceous species richness in plot
*   *Management*:  Mature forest was the forest stand that had not been harvested since the historical sampling. Clear-cut forest had been cut and replanted (Mature or Clear-cut)
*   *YearDIFF*: The time between the original and current samples
*   *YearOriginal*: Year of original sampling
*   *YearCurrent*: Year of current re-sampling
*   *Latitude* and *Longitude*: WGS coordinates
*   *Soil_PS_001*: Proportion (%) of soil particle size *clay* < 0.001 mm
*   *Soil_PS_01*: Proportion (%) of soil particle size *clay* *and fine silt* < 0.01 mm
*   *Soil_PS_01_05*: Proportion (%) of soil particle size *coarse silt* 0.01–0.05 mm
*   *Soil_PS_05*: Proportion (%) of soil particle size *fine sand* 0.05–0.25 mm
*   *Soil_PS_05_25*: Proportion (%) of soil particle size *coarse sand* 0.25–2 mm
*   *pHDIFF*: Difference between current and original sampling in pH
*   *pH_Orig*: Soil reaction in original sampling
*   *Ca*: plant-available calcium (mg/kg)
*   *K*: plant-available potassium (mg/kg)
*   *Mg*: plant-available magnesium (mg/kg)
*   *P*: plant-available phosphorus (mg/kg)
*   *Relative_elevation*: The relative elevation (m) of each sample plot above/below the flood level reached or exceeded once every five years
*   *Tree_richnessDIFF*: Difference between current and original sampling in species richness in the tree layer
*   *QuercusDIFF*: Difference between current and original sampling in canopy cover of *Quercus robur* (%)
*   TreeCoverDIFF: Difference between current and original sampling in tree canopy cover (%), expressed as the sum of the percent cover of all species present in the tree layer
*   *Litter_CWMDIFF*: Difference between current and original sampling in tree litter quality estimated using an ordinal scale (1-5) and calculated as a community weighted mean (CWM) of all tree species present
*   *Tree_richness_Orig*: Species richness in the tree layer in the original sampling
*   *Quercus_Orig*: Canopy cover of *Quercus robur* (%) in original sampling
*   *TreeCover_Orig*: Tree canopy cover (%) in original sampling, expressed as the sum of the percent cover of all species present in the tree layer
*   *Litter_CWM_Orig*: Tree litter quality in original sampling was estimated using an ordinal scale (1-5) and calculated as a community-weighted mean (CWM) of all tree species present
*   *Species_cover_Orig*: Total herbaceous plant cover (%) in original sampling
*   *TreeDiss*: Bray-Curtis dissimilarity was calculated using non-transformed species cover values between the tree species composition recorded during the current and original sampling
*   *Species_richness_Orig*: Plant herbaceous species richness in original sampling
*   *Temp_WinterDIFF*: Difference between current and original sampling in mean winter temperature (December-February)
*   *Temp_SpringDIFF*: Difference between current and original sampling in mean spring temperature (March-May)
*   *Temp_SummerDIFF*: Difference between current and original sampling in mean summer temperature (June-August)
*   *Temp_AutumnDIFF*: Difference between current and original sampling in mean autumn temperature (September-November)
*   *Aridity_WinterDIFF*: Difference between current and original sampling in winter (December-February) Standardised Precipitation-Evapotranspiration Index (SPEI)
*   *Aridity_SpringDIFF*: Difference between current and original sampling in spring (March-May) Standardised Precipitation-Evapotranspiration Index (SPEI)
*   *Aridity_SummerDIFF*: Difference between current and original sampling in summer (June-August) Standardised Precipitation-Evapotranspiration Index (SPEI)
*   *Aridity_AutumnDIFF*: Difference between current and original sampling in autumn (September-November) Standardised Precipitation-Evapotranspiration Index (SPEI)
*   *Temp_Winter_Orig*: Mean winter temperature (December-February) in original sampling
*   *Temp_Spring_Orig*: Mean spring temperature (March-May) in original sampling
*   *Temp_Summer_Orig*: Mean summer temperature (June-August) in the original sampling
*   *Temp_Autumn_Orig*: Mean autumn temperature (September-November) in original sampling
*   *Aridity_Winter_Orig*: Winter (December-February) Standardised Precipitation-Evapotranspiration Index (SPEI) in original sampling
*   *Aridity_Spring_Orig*: Spring (March-May) Standardised Precipitation-Evapotranspiration Index (SPEI) in original sampling
*   *Aridity_Summer_Orig*: Summer (June-August) Standardised Precipitation-Evapotranspiration Index (SPEI) in original sampling
*   *Aridity_Autumn_Orig*: The autumn (September-November) Standardised Precipitation-Evapotranspiration Index (SPEI) in the original sampling
*   *Flooding_WinterDIFF*: Difference between current and original sampling in winter flooding (December-February), i.e. mean daily discharge (m3/s) minus value the flood reached or exceeded once a year on the long-term average (= *Q1* according to the Czech Hydrological Institute)
*   *Flooding_SpringDIFF*: Difference between current and original sampling in spring flooding (March-May), i.e. mean daily discharge (m3/s) minus value the flood reached or exceeded once a year on the long-term average (= *Q1* according to the Czech Hydrological Institute)
*   *Flooding_SummerDIFF*: Difference between current and original sampling in summer flooding (June-August), i.e. mean daily discharge (m3/s) minus value the flood reached or exceeded once a year on the long-term average (= *Q1* according to the Czech Hydrological Institute)
*   *Flooding_AutumnDIFF*: Difference between current and original sampling in autumn flooding (September-November), i.e. mean daily discharge (m3/s) minus value the flood reached or exceeded once a year on the long-term average (= *Q1* according to the Czech Hydrological Institute)
*   *Flooding_Winter_Orig*: Winter flooding (December-February), i.e. mean daily discharge (m3/s) minus the value the flood reached or exceeded once a year on the long-term average (= *Q1* according to the Czech Hydrological Institute).
*   *Flooding_Spring_Orig*: Spring flooding (March-May), i.e. mean daily discharge (m3/s) minus the value the flood reached or exceeded once a year on the long-term average (= *Q1* according to the Czech Hydrological Institute).
*   *Flooding_Summer_Orig*: Summer flooding (June-August), i.e. mean daily discharge (m3/s) minus the value the flood reached or exceeded once a year on the long-term average (= *Q1* according to the Czech Hydrological Institute).
*   *Flooding_Autumn_Orig*: Autumn flooding (September-November), i.e. mean daily discharge (m3/s) minus the value the flood reached or exceeded once a year on the long-term average (= *Q1* according to the Czech Hydrological Institute).

## Sharing/Access information

NA

## Code/Software

NA