import React, { Fragment } from 'react';
import { docs } from '../../../doc.json';
import { MiniRepl } from '../../../tutorial/MiniRepl';

const visible = window.location.href.includes('?api=true');

function ApiDoc() {
  if (!visible) {
    return (
      <p>
        There remaining function documentation is a work in progress, but you can preview it by clicking{' '}
        <a href="?api=true#everything-else">here</a>. Beware that everything is not properly ordered from this point.
      </p>
    );
  }
  // console.log('docJson', docs);
  return (
    <div>
      <p>
        The following Chapter is autogenerated from the jsdoc comments in the source files.{' '}
        <a href="?#everything-else">hide</a>. Beware that everything is not properly ordered from this point.
      </p>
      {docs
        .filter((item) => !item.name?.startsWith('_') && item.kind !== 'package')
        .map((item, i) => (
          <Fragment key={i}>
            {' '}
            <h2 id={`${item.memberof ? `${item.memberof}-` : ''}${item.name}`}>
              {item.memberof && item.memberof !== item.name ? `${item.memberof}.` : ''}
              {item.name}
            </h2>
            <div
              dangerouslySetInnerHTML={{
                __html: item.description.replaceAll(/\{\@link ([a-zA-Z]+)?\#?([a-zA-Z]*)\}/g, (_, a, b) => {
                  // console.log(_, 'a', a, 'b', b);
                  return `<a href="#${a}${b ? `-${b}` : ''}">${a}${b ? `#${b}` : ''}</a>`;
                }),
              }}
            />
            {!!item.params?.length && <h3>Parameters</h3>}
            <ul>
              {item.params?.map((param, i) => (
                <li key={i}>
                  {param.name} ({param.type?.names?.join('|')}): {param.description?.replace(/(<([^>]+)>)/gi, '')}
                </li>
              ))}
            </ul>
            {item.examples?.length && <h3>Examples</h3>}
            <div className="space-y-2">
              {item.examples?.map((example, k) => (
                <MiniRepl key={k} tune={example} />
              ))}
            </div>
          </Fragment>
        ))}
    </div>
  );
}

export default ApiDoc;
