#Author: Francisco Pereira Lobo (franciscolobo@gmail.com) - 2024
#Description: plots the stitched tree together with NCT data

library(ape)
library(ggplot2)
library(geiger)
library(phytools)
library(ggtree)
library(RColorBrewer)

rm(list=ls())

#this path should point to the directory produced when you uncompressed file
#reproducibility.tgz
setwd("~/projects/evolution_of_complexity/docs/biorx_evolution_of_complexity/version1/dataFiles/reproductibility_raw_data/reproducibility/")

#loads stitched tree
tree <- read.tree("data/trees/final_tree_branches_corrected.nwk")
tree$node.label <- paste0("t", c(1:tree$Nnode))

#loads metadata
info <- read.table("data/metadata/metadata_spp.txt", header=TRUE, sep="\t")
tmp <- gsub("\\(Vertebrata\\)", "", info$Popular_group_name)
tmp <- gsub("\\(Invertebrata\\)", "", tmp)
tmp <- gsub("\\(Angiosperm\\)", "", tmp)
tmp <- gsub("\\(Chlorophyta\\)", "", tmp)
info$Popular_group_name <- as.factor(tmp)
col_order <- c("GenomeID", "Spp", "Popular_group_name", "Scientific_name", "short_name", "NonRedundantProteomeSize", "Average_cell_types")
info <- info[,col_order]
colnames(info) <- c("GenomeID", "Spp", "Group", "Scientific_name", "Short_name", "NonRedundantProteomeSize", "Average_cell_types")

cairo_pdf("results/figures/Figure_1_B_tree.pdf", width=6, height=8)

p <- ggtree(tree, aes(color=Group, size=8), show.legend = FALSE) %<+% info + xlim(NA, 300)
p2 <- p +
      theme_tree2() +
      geom_tippoint(aes(x=x+30, size = Average_cell_types, color = Group), position="identity", show.legend = TRUE) +
      theme(legend.position = c(0.2,0.8)) +
      scale_size_continuous(range=c(0.2, 4)) +
      geom_tiplab(aes(label=Short_name, family ="Courier New", size=130), offset = 0, hjust=-0.4, align=TRUE, show.legend = FALSE) +
      scale_color_manual(values=c("#E41A1C", "#377EB8", "#4DAF4A", "#FF7F00"))
  
p2 <- revts(p2)

plot(p2)

dev.off()
