import os, sys, re
import numpy as np
import pandas as pd


rnn0 = 1.23681571
Rs = rnn0 + np.arange (1.5, -0.301, -0.1)
Rs = np.insert(Rs, 15, Rs[14]-0.05)

result = []
pattern = r'Number of determinants in trial wavefunction: (\d+)'
tols = [0.05, 0.01, 0.005, 0.001]
for tol in tols: 
    out = "qmc_las_{0}.out".format(tol)
    with open(out, 'r') as f:
        match = re.search(pattern, f.read())
        if match:
            num_SDs_las = int(match.group(1))

    out = "qmc_cas_{0}.out".format(tol)
    with open(out, 'r') as f:
        match = re.search(pattern, f.read())
        if match:
            num_SDs_cas = int(match.group(1))
            
    result.append([tol, num_SDs_las, num_SDs_cas])
    
columns = ['epsilon', 'LAS', 'CAS']
df = pd.DataFrame(result, columns=columns)
df.to_csv('num_SDs.csv', index=False)