import sys, os
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import subprocess

delete_nblocks_left = 2000
delete_nblocks_right = 25000

def get_energy_and_error(filename):
    os.system("head -n {0} {1} > qmc_tmp.s000.scalar.dat".format(delete_nblocks_right+1, filename))
    cmd = ["/opt/tiger/quchem/qmcpack-3.14.0/nexus/bin/qmca", "-q", "el", "--sac", "-e", str(delete_nblocks_left), 'qmc_tmp.s000.scalar.dat']
    result = subprocess.run(cmd, capture_output=True, text=True).stdout
    os.system("rm qmc_tmp.s000.scalar.dat")
    # Splitting by "EnergyEstim__nume_real=" and taking the second part
    parts = result.split("EnergyEstim__nume_real=")
    if len(parts) > 1:
        # Splitting by "+/-" to separate the value and error bar
        segments = parts[1].split("+/-")
        value = segments[0].split()[0]  # Taking the first segment before whitespace
        error_bar = segments[1].split()[0] if len(segments) > 1 else None  # Taking the first segment after "+/-"

        # Converting them to float and returning
        print(f"Extracting value and error bar for file: {filename} E = {float(value)} +- {float(error_bar)}")
        return float(value), float(error_bar) if error_bar else None
    else:
        print(f"Error extracting value and error bar for file: {filename}")
        return None, None

# Lists to store average energies and their error bars
avg_energies = []

# Loop through all given files
tols = [0.05, 0.01, 0.005, 0.001]
for tol in tols: 
    tmp = [tol]
    for method in ['las', 'cas']:
        filename = 'qmc_{0}_{1}.s000.scalar.dat'.format(method, tol)
        # Read in the data file
        # Get the average energy and error:
        avg_energy, error_bar = get_energy_and_error(filename)
        tmp.append(avg_energy)
        tmp.append(error_bar)
    avg_energies.append(tmp)
            
energy = np.asarray(avg_energies)   
df = pd.DataFrame()
df['epsilon'] = energy[:,0]
df['LAS'] = energy[:,1]
df['LAS error'] = energy[:,2]
df['CAS'] = energy[:,3]
df['CAS error'] = energy[:,4]
df.to_csv('energy_afqmc.csv', encoding='utf-8', index=False, header=True)

