%% Figure: Publications over the years

% import paper from BibTeX file
bibdata = readBibTeX('../rp.bib');

% all labels
labels = fieldnames(bibdata);


% count papers per year
paperPerYear = dictionary('1987', 0);

minYear = 1987;

for i = 1:length(labels)
   paper = bibdata.(labels{i});
   
   % skip if paper is software or related
   if strcmpi(paper.annote, 'software') | strcmpi(paper.annote, 'related')
      continue
   end
   
   year_ = '0';
   if isfield(paper,'year')
      year_ = paper.year;
      if str2num(year_) < minYear, continue, end % skip if publication is before minYear
      %if strcmpi(year_, 'in press'), continue, end % skip if publication is in press
      if strcmpi(year_, 'in press'), year_ = '2024'; end
      if isKey(paperPerYear,year_)
         paperPerYear(year_) = paperPerYear(year_) + 1; % increment value of key year_
      else
         paperPerYear = insert(paperPerYear, year_, 1); % add value 1 for key year_
      end
      
   end
end


% sort keys
years = sort(keys(paperPerYear))
paperPerYear(years)


% plot
set(gcf, 'Pos', [731 316 528 276])
bar(years, paperPerYear(years), 'edgecolor', 'none', 'facecolor', [0.89 0.45 0.13])
xlim([categorical(1987) categorical(2023)])
xlabel('Publication year'), ylabel('Number of publications')
box off

%plot(str2double(years), paperPerYear(years), 'color', [0.89 0.45 0.13])
%semilogy(str2double(years), paperPerYear(years), 'color', [0.89 0.45 0.13])



% exponential growth

% fit exponential growth model to the data for 3 intervals
yearsIntervals = {string([1987, 1989:2008]);
                  string([2008:2019]);
                  string([2019:2023])};

for i = 1:length(yearsIntervals)
    p(i,:) = polyfit(str2double(yearsIntervals{i})', log(paperPerYear(yearsIntervals{i})'), 1);
end


% plot
clf

for i = 1:length(yearsIntervals)
    h(i) = semilogy(str2double(yearsIntervals{i}), exp(polyval(p(i,:), str2double(yearsIntervals{i}))), 'LineWidth', 3, 'Color', [0.89 0.45 0.13])
    hold on
    text(mean(str2double(yearsIntervals{i})), exp(polyval(p(i,:), mean(str2double(yearsIntervals{i})))), sprintf('~e^{%1.3f t}',p(i,1)))
end

semilogy(str2double(years), (paperPerYear(years)), '.', 'Color', [0. 0.62 0.85], 'MarkerSize', 15)

xlabel('Publication year'), ylabel('Number of publications')
set(gca, 'XTickLabelRotation', 90, 'Xlim', [1987 2023], 'XTick', [1987:2023])

grid on
box off





