%% Figure: Davies Bouldin index for increasing number of clusters

% load Davies Bouldin index
dbi = load('../Data/cluster_DBindex.txt');
num_clusters = 22;


% plot Davies Bouldin index
clf
set(gcf, 'Pos', [731 100 528 276])
h = plotyy(1:length(dbi), dbi(:,1), 1:length(dbi), dbi(:,2));
set(h(1).Children, 'LineWidth', 2, 'Color', [0. 0.62 0.85])
set(h(2).Children, 'LineWidth', 2, 'Color', [0.89 0.45 0.13])
xlabel('Number clusters'), ylabel(h(1), 'Davies-Bouldin index'), ylabel(h(2), 'Calinski-Harabasz index')
yl = [5 13];
line([num_clusters num_clusters], yl, 'LineWidth', 2, 'LineStyle', '--', 'Color', [.5 .5 .5])
grid on
set(h(1), 'ylim', [5 13], 'ytick', 5:13)
set(h(2), 'ylim', [5 21], 'ytick', 5:2:21)





%% Figure: Subjects of papers evolving over the years

% prepare colormap
c = [
    0 0.4470 0.7410;
    0.8500 0.3250 0.0980;
    0.9290 0.6940 0.1250;
    0.6 0.5 0.5;
    0.4940 0.1840 0.5560;
    0.4660 0.6740 0.1880;
    0.3010 0.7450 0.9330;
    0.6350 0.0780 0.1840;
    0.7 0.7 0.7
];
cm = [c; 1*fliplr(c); 1.1*c]; cm(cm>1) = 1;


% load cluster statistics
clustersPerYear = load('../Data/cluster_stat.txt');

% time interval
years = 1987:2024;

% plot cluster distribution
clf
set(gcf, 'Pos', [731 100 528 670])
h = bar(years, clustersPerYear, 1, 'stacked', 'EdgeColor', 'none');
for i = 1:length(h)
   set(h(i), 'FaceColor', cm(i,:))
end
xlabel('Year'), ylabel('Fraction')

% add text (cluster ID)
clustersPerYearCumsum = cumsum(clustersPerYear(:,end));
for i = 1:size(clustersPerYear,1)
   text(2025, clustersPerYearCumsum(i)-clustersPerYear(i,end)/2, sprintf('Cluster %d', i), 'color', cm(i,:))
end
axis([1987 2024 0 1])
pos = get(gca, 'Pos');
set(gca, 'Pos', [pos(1) pos(2) .9*pos(3) pos(4)]) % make axes object a bit smaller to show text at the right border
 
