%% Figure on data base updates

% import paper from BibTeX file
data = readtable('../Data/rp_time.dat');

% convert the first column to a datetime variable
data.Time = datetime(data.Time, 'InputFormat', 'yyyy-MM');

% median entries per month
m = median(diff(data.NumberEntries))

% plot
clf
set(gcf, 'Pos', [731 100 528 276])
bar(data.Time(2:end), diff(data.NumberEntries), 'edgecolor', 'none', 'facecolor', [0. 0.62 0.85])
line(data.Time([2 end]), [m m], 'Color', [0.89 0.45 0.13], 'LineWidth', 2)
set(gca, 'XTickLabelRotation', 90)
set(gca,'XTick', data.Time(2:2:end))
xlabel('Update time'), ylabel('New papers')
box off


%% Basic numbers of RP bibliography

minYear = 1987;

% import paper from BibTeX file
bibdata = readBibTeX('../rp.bib');

% all labels
labels = fieldnames(bibdata);

type = dictionary('article', 0, 'book', 0, 'inproceedings', 0, 'incollection', 0, 'thesis', 0, 'techreport', 0);

for i = 1:length(labels)
   paper = bibdata.(labels{i});
   year = paper.year;
   if strcmpi(year, 'in press'), year = '2024'; end
   
    % skip if paper is software or related
    if strcmpi(paper.annote, 'software') | strcmpi(paper.annote, 'related') | str2num(year) < minYear
       continue
    end
   
   paperType = paper.type;
   if strcmpi(paperType, 'Diploma Thesis') | strcmpi(paperType, 'Bachelor Thesis') | strcmpi(paperType, 'Masters Thesis') | strcmpi(paperType, 'PhD Thesis') | strcmpi(paperType, 'Habilitation Thesis')
       paperType = 'thesis';
   end
   if strcmpi(paperType, 'inbook')
       paperType = 'incollection';
   end
   type(paperType) = type(paperType) + 1;
end
