%% Table: Institutes citations
minYear = 1018;
topN = 10;

% import paper from BibTeX file
bibdata = readBibTeX('../rp.bib');
% all labels
labels = fieldnames(bibdata);

% import citation file
citationData = jsondecode(fileread('../Data/citations.json'));

% import affiliation file
affiliationsData = jsondecode(fileread('../Data/affiliations.json'));


%% correct some affiliations
replaceNames = [{"Leibniz-Gemeinschaft","Potsdam Institut fur Klimafolgenforschung"};
      {"Rush Medical College", "Rush University"};
      {"Rush University Medical Center", "Rush University"};
      {"Loyola University Stritch School of Medicine", "Loyola University Chicago"};
      {"Loyola University Medical Center", "Loyola University Chicago"}];

labelsAff = fieldnames(affiliationsData);
for i = 1:length(labelsAff) % go through each paper
    for j = 1:length(affiliationsData.(labelsAff{i})) % go through each author
        aff = affiliationsData.(labelsAff{i})(j).author_affiliations;
        for k = 1:length(aff)
            author_affiliations = aff(k).affiliation_name;
            for l = 1:length(replaceNames)
                author_affiliations_old = author_affiliations;
                author_affiliations = strrep(author_affiliations, replaceNames{l,1}, replaceNames{l,2});
                
%                 if ~strcmpi(author_affiliations_old, author_affiliations)
%                    disp(sprintf('changed %s to %s', author_affiliations_old, author_affiliations))
%                 end
            end
            affiliationsData.(labelsAff{i})(j).author_affiliations(k).affiliation_name = author_affiliations;
        end
    end
    
end




%% Figure: Institutes publications

% find publishing institute
affiliationPublications = dictionary("Universität Potsdam", 0);
for i = 1:length(labels)

    paper = bibdata.(labels{i});
    year = bibdata.(labels{i}).year;
    if strcmpi(year, 'in press')
        year = '2024';
    end

    % skip if paper is software or related
    if strcmpi(paper.annote, 'software') | strcmpi(paper.annote, 'related') | str2num(year) < minYear
       continue
    end
    
    if ~isfield(affiliationsData, labels{i})
       continue
    end
    
    paper = affiliationsData.(labels{i});
    aff = []; % list of affiliations
    for k = 1:length(paper) % each author
        author = paper(k).author_affiliations;
        for l = 1:length(author) % each affiliation of author
           aff = [aff; string(author(l).affiliation_name)];
        end
    end

    aff = unique(aff);

    for k = 1:length(aff)
        if ~isKey(affiliationPublications,aff(k))
            affiliationPublications = insert(affiliationPublications, aff(k), 1); % set value 1 for key aff
        else
            affiliationPublications(aff(k)) = affiliationPublications(aff(k)) + 1; % add value 1 for key aff
        end
    end
end

length(values(affiliationPublications)) % number of affiliations






%% Table: Institutes citations

% find cited institute
affiliationCitations = dictionary("Universität Potsdam", 0);
for i = 1:length(labels)

    paper = bibdata.(labels{i});
    
    % skip if paper is software or related
    if strcmpi(paper.annote, 'software') | strcmpi(paper.annote, 'related')
       continue
    end
    
    if ~isfield(citationData, labels{i})
       continue
    end
    citedWorks = citationData.(labels{i});
    if length(citedWorks)
        for j = 1:length(citedWorks)
        
            year = bibdata.(citedWorks{j}).year;
            if strcmpi(year, 'in press')
                year = '2024';
            end

            if ~isfield(bibdata, citedWorks{j}) | strcmpi(bibdata.(citedWorks{j}).annote, 'software') | strcmpi(bibdata.(citedWorks{j}).annote, 'related') | str2num(year) < minYear
                continue
            end
            if ~isfield(affiliationsData, citedWorks{j})
                continue
            end
            citedPaper = affiliationsData.(citedWorks{j});
            aff = []; % list of affiliations
            for k = 1:length(citedPaper) % each author
                author = citedPaper(k).author_affiliations;
                for l = 1:length(author) % each affiliation of author
                   aff = [aff; string(author(l).affiliation_name)];
                end
            end
            
            aff = unique(aff);
            
            for k = 1:length(aff)
                if ~isKey(affiliationCitations,aff(k))
                    affiliationCitations = insert(affiliationCitations, aff(k), 1); % set value 1 for key aff
                else
                    affiliationCitations(aff(k)) = affiliationCitations(aff(k)) + 1; % add value 1 for key aff
                end
            end
        end
    end
end



% sort affiliation by number of citations
topN = 30;
[j idx] = sort(values(affiliationCitations),'desc');
k = keys(affiliationCitations);
affiliationCitations(k(idx));

% show list for manuscript
rank = 1;
for i = 1:topN
    if i > 1 & affiliationCitations(k(idx(i-1))) ~= affiliationCitations(k(idx(i)))
        rank = rank + 1;
    end
    disp(sprintf('%d\t&%s\t&%d\t&%1.2f\\\\',rank,k{idx(i)}, affiliationCitations(k(idx(i))), 100*affiliationCitations(k(idx(i)))/sum(values(affiliationCitations)) ))
end



% save ranking list
f = fopen('aff_cit.txt', 'w');
fprintf(f, 'Rank\tInsititute\tNumber citations\tPercentage citations\n',rank,k{idx(i)}, affiliationCitations(k(idx(i))), 100*affiliationCitations(k(idx(i)))/sum(values(affiliationCitations)) );
rank = 1;
oldNum = 0;
for i = 1:length(k)
    if isKey(affiliationCitations, k(idx(i)))
        if i > 1 & oldNum ~= affiliationCitations(k(idx(i)))
            rank = rank + 1;
        end
        fprintf(f, '%d\t%s\t%d\t%1.2f\n',rank,k{idx(i)}, affiliationCitations(k(idx(i))), 100*affiliationCitations(k(idx(i)))/sum(values(affiliationCitations)) );
        oldNum = affiliationCitations(k(idx(i)));
    end
end
fclose(f);






%% average number of citations

affiliationAvgCitations = dictionary("Universität Potsdam", 0);

%for i = 1:length(k)
for i = 1:topN
    if isKey(affiliationCitations, k{idx(i)}) & isKey(affiliationPublications, k{idx(i)})
       affiliationAvgCitations = insert(affiliationAvgCitations, k{idx(i)},  affiliationCitations(k{idx(i)}) / affiliationPublications(k{idx(i)}));
       %disp(sprintf('%s:  citations: %i - publications: %i - avg: %f', k{idx(i)}, affiliationCitations(k{idx(i)}), affiliationPublications(k{idx(i)}), affiliationAvgCitations(k{idx(i)})))
    end
end



% sort affiliation by number of publications
topN = 10;
[j idx] = sort(values(affiliationPublications),'desc');
k = keys(affiliationPublications);
affiliationPublications(k(idx));

% show list for manuscript
rank = 1;
oldNum = 0;
for i = 1:length(k)
    if isKey(affiliationAvgCitations, k(idx(i)))
        if i > 1 & oldNum ~= affiliationAvgCitations(k(idx(i)))
            rank = rank + 1;
        end
        if i <= topN | affiliationAvgCitations(k{idx(i)}) >= 500 | affiliationPublications(k{idx(i)}) >= 40
            disp(sprintf('%d\t&%s\t&%.0f\t&%.0f\t&%1.2f\\\\',rank, k{idx(i)}, affiliationPublications(k{idx(i)}), affiliationCitations(k{idx(i)}), affiliationAvgCitations(k{idx(i)}) ))
        end
        oldNum = affiliationAvgCitations(k(idx(i)));
    end
end
