# Accompanying data for the paper "Wedge indentation of elastoplastic solids - from single indentation to interaction between indenters"

<br>

## Links

- isCitedBy *publication-article* [https://doi.org/10.46298/jtcam.8945](https://doi.org/10.46298/jtcam.8945)

## Authors

- **Yvan Marthouret**, CEA, DES, ISEC, DE2D, SEAD, Laboratoire d’Étanchéité Maestral, Univ. Montpellier, Marcoule, France;Mines Saint-Étienne, CNRS UMR 5307 LGF, Centre SMS, Saint-Étienne F42023, France, ORCID: [0000-0002-1181-1568](https://orcid.org/0000-0002-1181-1568)
- **Tony Zaouter**, CEA, DES, ISEC, DE2D, SEAD, Laboratoire d’Étanchéité Maestral, Univ. Montpellier, Marcoule, France, ORCID: [0000-0003-1330-9130](https://orcid.org/0000-0003-1330-9130)
- **Florent Ledrappier**, TECHNETICS Group France, Laboratoire d’Étanchéité Maestral CEA–Technetics, Pierrelatte, France
- **Guillaume Kermouche**, Mines Saint-Étienne, CNRS UMR 5307 LGF, Centre SMS, Saint-Étienne F42023, France, ORCID: [0000-0001-6224-245X](https://orcid.org/0000-0001-6224-245X)

## Language

- English

## License

- Creative Commons Attribution 4.0

Contributions
-------------

* Yvan MARTHOURET did contribute to data creation and curation
* Tony ZAOUTER  did contribute to data curation
* Florent LEDRAPPIER and Guillaume KERMOUCHE did contribute to validation

Data collection: period and details
-----------------------------------

* Data used in the article are provided in the file `BDD_article_finale.hdf5`.
It was written with h5py python library whom documentation is available at:
https://docs.h5py.org/en/stable/quick.html. A Jupyter notebook `view_results.ipynb` includes a typical python code to view the stored results.

* `multi_indentation.inp` describes a double indentation with periodic conditions on the sides.

For any question regarding this supplementary material, please contact the corresponding author Yvan MARTHOURET at:
y.marthouret@laposte.net

Funding sources
---------------

* The authors are grateful to the CEA and Technetics Group France for funding this research through the
joint Maestral sealing laboratory.

Data structure and information
------------------------------

Extracted data contained in the `BDD_article_finale.hdf5` are the force of the indenter (`force_indenter`), the opening of the ridge (`free_volume`) and 
the contact area provided by the associated Abaqus feature **carea** (`contact_area`).

The stored data were obtained through Abaqus simulations.
The file is organized with an arborescence specifying geometric and material characteristics of each corresponding simulation:

```
angle[°]/bulk_height[mm]/indenter_distance[mm]/hardening_coefficient/elastic_limit[MPa]
```

Four geometries were used in the study, listed below in the format `DI_angle_indenterDistance[µm]\bulkHeight[mm]` ('03' standing for '0.3').

- `DI_80_100_1`
- `DI_85_350_1`
- `DI_85_100_1`
- `DI_80_50_1`
- `DI_80_100_03`

A typical input Abaqus file (`multi_indentation.inp`) for the first geometry is provided.

The file has a material section which is easily modified to adapt them to material characteristics.

Please note that **"diamond"** material corresponds to the indenter which also has a rigid condition attached.
Therefore its material law is not actually used during simulation.

