Contributions
-------------

* Yvan MARTHOURET did contribute to data creation and curation
* Tony ZAOUTER  did contribute to data curation
* Florent LEDRAPPIER and Guillaume KERMOUCHE did contribute to validation

Data collection: period and details
-----------------------------------

* Data used in the article are provided in the file `BDD_article_finale.hdf5`.
It was written with h5py python library whom documentation is available at:
https://docs.h5py.org/en/stable/quick.html. A Jupyter notebook `view_results.ipynb` includes a typical python code to view the stored results.

* `multi_indentation.inp` describes a double indentation with periodic conditions on the sides.

For any question regarding this supplementary material, please contact the corresponding author Yvan MARTHOURET at:
y.marthouret@laposte.net

Funding sources
---------------

* The authors are grateful to the CEA and Technetics Group France for funding this research through the
joint Maestral sealing laboratory.

Data structure and information
------------------------------

Extracted data contained in the `BDD_article_finale.hdf5` are the force of the indenter (`force_indenter`), the opening of the ridge (`free_volume`) and 
the contact area provided by the associated Abaqus feature **carea** (`contact_area`).

The stored data were obtained through Abaqus simulations.
The file is organized with an arborescence specifying geometric and material characteristics of each corresponding simulation:

```
angle[°]/bulk_height[mm]/indenter_distance[mm]/hardening_coefficient/elastic_limit[MPa]
```

Four geometries were used in the study, listed below in the format `DI_angle_indenterDistance[µm]\bulkHeight[mm]` ('03' standing for '0.3').

- `DI_80_100_1`
- `DI_85_350_1`
- `DI_85_100_1`
- `DI_80_50_1`
- `DI_80_100_03`

A typical input Abaqus file (`multi_indentation.inp`) for the first geometry is provided.

The file has a material section which is easily modified to adapt them to material characteristics.

Please note that **"diamond"** material corresponds to the indenter which also has a rigid condition attached.
Therefore its material law is not actually used during simulation.

