clc
clear
close
%case 1
Half_thickness_a=0.05;Half_thickness_b=0.05;
C11_dry_Pwave_modulus_a=47.66;C44_dry_Pwave_modulus_a=17.75;
C11_dry_Pwave_modulus_b=47.66;C44_dry_Pwave_modulus_b=17.75;
C13_a=6.66;C33_a=37.67;
C66_a=19.81;
C13_b=6.66;C33_b=37.67;
C66_b=19.81;
%% case 2
% Half_thickness_a=0.05;Half_thickness_b=0.05;
% C11_dry_Pwave_modulus_a=52.95;C44_dry_Pwave_modulus_a=19.41;
% C11_dry_Pwave_modulus_b=52.95;C44_dry_Pwave_modulus_b=19.41;
% C13_a=8.16;C33_a=43.63;
% C66_a=21.22;
% C13_b=8.16;C33_b=43.63;
% C66_b=21.22;
%% case3
% Half_thickness_a=0.05;Half_thickness_b=0.05;
% C11_dry_Pwave_modulus_a=54.95;C44_dry_Pwave_modulus_a=20.37;
% C11_dry_Pwave_modulus_b=54.95;C44_dry_Pwave_modulus_b=20.37;
% C13_a=9.52;C33_a=47.2;
% C66_a=22.02;
% C13_b=9.52;C33_b=47.2;
% C66_b=22.02;
%% case4
% Half_thickness_a=0.05;Half_thickness_b=0.05;
% C11_dry_Pwave_modulus_a=56.57;C44_dry_Pwave_modulus_a=21.11;
% C11_dry_Pwave_modulus_b=56.57;C44_dry_Pwave_modulus_b=21.11;
% C13_a=10.42;C33_a=50.05;
% C66_a=22.67;
% C13_b=10.42;C33_b=50.05;
% C66_b=22.67;
%% 
Permeability_a=9.87*10^(-16);Permeability_b=9.87*10^(-16);
Porosity_a=0.067;Porosity_b=0.067;
Ks_Grain_bulk_modulus=38;
grain_density=2.65;
%a层流体相关参数?
Kfluid_a=0.0096;
viscosity_a=0.015*10^(-12);
fluid_density_a=0;
%b层流体相关参数?
Kfluid_b=2.5;
viscosity_b=0.001*10^(-9);
fluid_density_b=1;
%%
L=Half_thickness_a+Half_thickness_b;
%%
f1=Half_thickness_a./(Half_thickness_a+Half_thickness_b);
f2=Half_thickness_b./(Half_thickness_a+Half_thickness_b);
C44=1./(f1./C44_dry_Pwave_modulus_a+f2./C44_dry_Pwave_modulus_b);          %%average
C66=f1*C44_dry_Pwave_modulus_a+f2*C44_dry_Pwave_modulus_b;
%%
%stiffness C
C12_a=C11_dry_Pwave_modulus_a-2*C66_a;%%TI浠嬭川%%鍚勫悜鍚屾??
C12_b=C11_dry_Pwave_modulus_b-2*C66_b;


%%%鍋氱畝鍖?
alpha_a1=1-(C11_dry_Pwave_modulus_a+C12_a+C13_a)/(3*Ks_Grain_bulk_modulus);
alpha_b1=1-(C11_dry_Pwave_modulus_b+C12_b+C13_b)/(3*Ks_Grain_bulk_modulus);
alpha_a3=1-(2*C13_a+C33_a)/(3*Ks_Grain_bulk_modulus);
alpha_b3=1-(2*C13_b+C33_b)/(3*Ks_Grain_bulk_modulus);
Ma=Ks_Grain_bulk_modulus./(1-Porosity_a.*(1-Ks_Grain_bulk_modulus./Kfluid_a)-...
    (2*C11_dry_Pwave_modulus_a+2*C12_a+4*C13_a+C33_a)/(9*Ks_Grain_bulk_modulus));
Mb=Ks_Grain_bulk_modulus./(1-Porosity_b.*(1-Ks_Grain_bulk_modulus./Kfluid_b)-...
    (2*C11_dry_Pwave_modulus_b+2*C12_b+4*C13_b+C33_b)/(9*Ks_Grain_bulk_modulus));

C33_sat_a=C33_a+alpha_a3.*alpha_a3.*Ma;
C33_sat_b=C33_b+alpha_b3.*alpha_b3.*Mb;
%%%%D
D_a=(Permeability_a.*Ma.*C33_a)./(viscosity_a.*C33_sat_a);
D_b=(Permeability_b.*Mb.*C33_b)./(viscosity_b.*C33_sat_b);
%%%%lamda
f=0.1:0.1:10^5;
w=2*pi*f;
lamda_a=sqrt((1i.*w)./D_a);
lamda_b=sqrt((1i.*w)./D_b);
%%%%gama
gama_a=(alpha_a3.*Ma)./C33_sat_a;
gama_b=(alpha_b3.*Mb)./C33_sat_b;

%%%%C33
C33_hf=1./(f1./C33_sat_a+f2./C33_sat_b);
A=(viscosity_a./(lamda_a*Permeability_a)).*coth(lamda_a.*Half_thickness_a);
B=(viscosity_b./(lamda_b*Permeability_b)).*coth(lamda_b.*Half_thickness_b);
gama2=power(gama_a-gama_b,2);
C33_vara=C33_hf.*power((C33_hf.*gama2)./(1i.*w.*L.*(A+B))+1,-1);
%%%%%
% C12_a=C11_dry_Pwave_modulus_a-2*C44_dry_Pwave_modulus_a;                  %鍗曠嫭鐨勫眰涓哄悇鍚戝悓鎬т粙璐?
% C12_b=C11_dry_Pwave_modulus_b-2*C44_dry_Pwave_modulus_b;


%%%%%%C13
C1=C13_a*gama_a-C13_b*gama_b-(gama_a*C33_a*alpha_a1)/alpha_a3+(gama_b*C33_b*alpha_b1)/alpha_b3;
C2=f1*(gama_a*((C13_a*alpha_a3)/C33_a-alpha_a1)-C13_a/C33_a)...
    +f2*(gama_b*((C13_b*alpha_b3)/C33_b-alpha_b1)-C13_b/C33_b);
C13_var1=((gama_a-gama_b)*C1)./(1i.*w.*L.*(A+B))-C2;
C13_var2=f1./C33_sat_a+f2./C33_sat_b+gama2./(1i.*w.*L.*(A+B));
C13_vara=C13_var1./C13_var2;

%%
% %C11
x_a=(Ma.*(alpha_a1*C33_a-alpha_a3*C13_a))./C33_sat_a;
x_b=(Mb.*(alpha_b1*C33_b-alpha_b3*C13_b))./C33_sat_b;
D1=f1*(C11_dry_Pwave_modulus_a*C33_a-C13_a^2)/(C33_a)+...
    f2*(C11_dry_Pwave_modulus_b*C33_b-C13_b^2)/(C33_b);
D2=((alpha_a3*C13_a-alpha_a1*C33_a)/C33_a).*((C33_a*x_a/(alpha_a1*C33_a-alpha_a3*C13_a)).*(x_a-x_b)./(1i.*w.*L.*(A+B))-x_a*f1)-...
    ((alpha_b3*C13_b-alpha_b1*C33_b)/C33_b).*((C33_b*x_b/(alpha_b1*C33_b-alpha_b3*C13_b)).*(x_a-x_b)./(1i.*w.*L.*(A+B))+x_b*f2);
C11_vara=D1+D2+(C13_vara.*C13_vara)./C33_vara;

%%
%High frequency parameters
C33_hf=1./(f1./C33_sat_a+f2./C33_sat_b);
C13_hf_1=f1.*(gama_a*((C13_a*alpha_a3)/C33_a-alpha_a1)-C13_a/C33_a)+...
    f2.*(gama_b*((C13_b*alpha_b3)/C33_b-alpha_b1)-C13_b/C33_b);
C13_hf_2=-(f1./C33_sat_a+f2./C33_sat_b);
C13_hf=C13_hf_1./C13_hf_2;
% C11_hf_1=f1.*((C44.*(C11_sat_a-C44))./C11_sat_a)+f2.*((C44.*(C11_sat_b-C44))./C11_sat_b);
D2_1=(((alpha_a3*C13_a-alpha_a1*C33_a)/C33_a).*x_a)*f1+...
    ((alpha_b3*C13_b-alpha_b1*C33_b)/C33_b).*(x_b*f2);%%
C11_hf=D1-D2_1+(C13_hf.*C13_hf)./C33_hf;

%Low frequency parameters
ope_low=(viscosity_a.*D_a)./(Permeability_a.*Half_thickness_a)+...
        (viscosity_b.*D_b)./(Permeability_b.*Half_thickness_b);
C33_lf=C33_hf.*power((C33_hf.*gama2)./(L.*ope_low)+1,-1);
C13_lf1=((gama_a-gama_b)*C1)./(L*ope_low)-C2;
C13_lf2=f1./C33_sat_a+f2./C33_sat_b+gama2./(L*ope_low);
C13_lf=C13_lf1./C13_lf2;

%D2_2=((alpha_a3*C13_a-alpha_a1*C33_a)/C33_a).*((C33_a*x_a/(alpha_a1*C33_a-alpha_a3*C13_a)).*(x_a-x_b)./(L.*ope_low)-x_a*f1)-...
%     ((alpha_b3*C13_b-alpha_b1*C33_b)/C33_b).*((C33_b*x_b/(alpha_b1*C33_b-alpha_b3*C13_b)).*(x_a-x_b)./(L.*ope_low)+x_b*f2);
X2=power(x_a-x_b,2);
C11_lf=D1-D2_1-X2/(L.*ope_low)+(C13_lf.*C13_lf)./C33_lf;
%%
%Comparison with the single relaxation function approximation
R=(C33_hf-C33_vara)./(C33_hf-C33_lf);                                      %relaxation function
C13_w=C13_hf-(C13_hf-C13_lf).*R;
C33_w=C33_hf-(C33_hf-C33_lf).*R;
C11_w=C11_hf-(C11_hf-C11_lf).*R;
epsilon=(C11_w-C33_w)./(2.*C33_w);
delta=(power(C13_w+C44,2)-power(C33_w-C44,2))./(2.*C33_w.*(C33_w-C44));%
A1=imag(epsilon);A2=imag(delta);
B1=real(epsilon);B2=real(delta);
figure(1);
semilogx(f,real(C13_vara), 'LineWidth', 2);
hold on;

% 密集分布的区间（0.1-1）
x_dense = logspace(-1, 0,5);
y_dense = interp1(f,real(C13_w), x_dense, 'linear');
semilogx(x_dense, y_dense, '*',  'LineWidth', 1,'MarkerSize', 7,'color','r');

x_dense = logspace(0,1,10);
y_dense = interp1(f, real(C13_w), x_dense, 'linear');
semilogx(x_dense, y_dense, '*',  'LineWidth', 1,'MarkerSize', 7,'color','r');

x_dense2 = logspace(1,2,6);
y_dense2 = interp1(f,real(C13_w), x_dense2, 'linear');
semilogx(x_dense2, y_dense2, '*', 'LineWidth', 1, 'MarkerSize', 7,'color','r');

x_dense2 = logspace(2,5,10);
y_dense2 = interp1(f,real(C13_w), x_dense2, 'linear');
semilogx(x_dense2, y_dense2, '*', 'LineWidth', 1, 'MarkerSize', 7,'color','r');

hold off;
xlabel('Frequency(Hz)','FontWeight','bold');ylabel('Real part of {\itC}_{13}(GPa)','FontWeight','bold');
legend('Analytical solution','Approximation','FontWeight','bold');
legend('boxoff');
%%
figure(2);
semilogx(f,imag(C13_vara), 'LineWidth', 2);
hold on;

% 密集分布的区间（0.1-1）
x_dense = logspace(-1, 0,5);
y_dense = interp1(f,imag(C13_w), x_dense, 'linear');
semilogx(x_dense, y_dense, '*',  'LineWidth', 1,'MarkerSize', 7,'color','r');

x_dense = logspace(0,1,10);
y_dense = interp1(f, imag(C13_w), x_dense, 'linear');
semilogx(x_dense, y_dense, '*',  'LineWidth', 1,'MarkerSize', 7,'color','r');

x_dense2 = logspace(1,2,6);
y_dense2 = interp1(f,imag(C13_w), x_dense2, 'linear');
semilogx(x_dense2, y_dense2, '*', 'LineWidth', 1, 'MarkerSize', 7,'color','r');

x_dense2 = logspace(2,5,10);
y_dense2 = interp1(f,imag(C13_w), x_dense2, 'linear');
semilogx(x_dense2, y_dense2, '*', 'LineWidth', 1, 'MarkerSize', 7,'color','r');

hold off;
xlabel('Frequency(Hz)','FontWeight','bold');ylabel('Imaginary part of {\itC}_{13}(GPa)','FontWeight','bold');
legend('Analytical solution','Approximation','FontWeight','bold');
legend('boxoff');
%%
figure(3);
semilogx(f,real(C11_vara), 'LineWidth', 2);
hold on;

% 密集分布的区间（0.1-1）
x_dense = logspace(-1, 0,5);
y_dense = interp1(f,real(C11_w), x_dense, 'linear');
semilogx(x_dense, y_dense, '*',  'LineWidth', 1,'MarkerSize', 7,'color','r');

x_dense = logspace(0,1,10);
y_dense = interp1(f, real(C11_w), x_dense, 'linear');
semilogx(x_dense, y_dense, '*',  'LineWidth', 1,'MarkerSize', 7,'color','r');

x_dense2 = logspace(1,2,6);
y_dense2 = interp1(f,real(C11_w), x_dense2, 'linear');
semilogx(x_dense2, y_dense2, '*', 'LineWidth', 1, 'MarkerSize', 7,'color','r');

x_dense2 = logspace(2,5,10);
y_dense2 = interp1(f,real(C11_w), x_dense2, 'linear');
semilogx(x_dense2, y_dense2, '*', 'LineWidth', 1, 'MarkerSize', 7,'color','r');

hold off;
xlabel('Frequency(Hz)','FontWeight','bold');ylabel('Real part of {\itC}_{11}(GPa)','FontWeight','bold');
legend('Analytical solution','Approximation','FontWeight','bold');
legend('boxoff');
%%
figure(4);
semilogx(f,imag(C11_vara), 'LineWidth', 2);
hold on;

% 密集分布的区间（0.1-1）
x_dense = logspace(-1, 0,5);
y_dense = interp1(f,imag(C11_w), x_dense, 'linear');
semilogx(x_dense, y_dense, '*',  'LineWidth', 1,'MarkerSize', 7,'color','r');

x_dense = logspace(0,1,10);
y_dense = interp1(f, imag(C11_w), x_dense, 'linear');
semilogx(x_dense, y_dense, '*',  'LineWidth', 1,'MarkerSize', 7,'color','r');

x_dense2 = logspace(1,2,6);
y_dense2 = interp1(f,imag(C11_w), x_dense2, 'linear');
semilogx(x_dense2, y_dense2, '*', 'LineWidth', 1, 'MarkerSize', 7,'color','r');

x_dense2 = logspace(2,5,10);
y_dense2 = interp1(f,imag(C11_w), x_dense2, 'linear');
semilogx(x_dense2, y_dense2, '*', 'LineWidth', 1, 'MarkerSize', 7,'color','r');

hold off;
xlabel('Frequency(Hz)','FontWeight','bold');ylabel('Imaginary part of {\itC}_{11}(GPa)','FontWeight','bold');
legend('Analytical solution','Approximation','FontWeight','bold');
legend('boxoff');
