function [A1,A2,B1,B2]=Velocity_Att_case4(C11_dry_Pwave_modulus_a,C44_dry_Pwave_modulus_a,...
    C11_dry_Pwave_modulus_b,C44_dry_Pwave_modulus_b,C12_a,C12_b,C13_a,C13_b,C33_a,C33_b,Permeability_a,Permeability_b,...
    Porosity_a,Porosity_b,Half_thickness_a,Half_thickness_b)
L=Half_thickness_a+Half_thickness_b;
f1=Half_thickness_a./(Half_thickness_a+Half_thickness_b);
f2=Half_thickness_b./(Half_thickness_a+Half_thickness_b);
%% 
%skeleton parameters
Ks_Grain_bulk_modulus=38;
grain_density=2.65;
%layer A Water
% Kfluid_a=2.5;
% viscosity_a=0.001*10^(-9);
% fluid_density_a=1;
Kfluid_a=0.0096;
viscosity_a=0.015*10^(-12);
fluid_density_a=0;
% Layer B Gas
Kfluid_b=2.5;
viscosity_b=0.001*10^(-9);
fluid_density_b=1;
% Kfluid_b=0.0096;
% viscosity_b=0.015*10^(-12);
% fluid_density_b=0;
%%
Density=f1*(fluid_density_a*Porosity_a+(1-Porosity_a)*grain_density)...
    +f2*(fluid_density_b*Porosity_b+(1-Porosity_b)*grain_density);
%%
C44=1./(f1./C44_dry_Pwave_modulus_a+f2./C44_dry_Pwave_modulus_b);          %%average
C66=f1*C44_dry_Pwave_modulus_a+f2*C44_dry_Pwave_modulus_b;
%%%parameters
alpha_a1=1-(C11_dry_Pwave_modulus_a+C12_a+C13_a)/(3*Ks_Grain_bulk_modulus);
alpha_b1=1-(C11_dry_Pwave_modulus_b+C12_b+C13_b)/(3*Ks_Grain_bulk_modulus);
alpha_a3=1-(2*C13_a+C33_a)/(3*Ks_Grain_bulk_modulus);
alpha_b3=1-(2*C13_b+C33_b)/(3*Ks_Grain_bulk_modulus);
Ma=Ks_Grain_bulk_modulus./(1-Porosity_a.*(1-Ks_Grain_bulk_modulus./Kfluid_a)-...
    (2*C11_dry_Pwave_modulus_a+2*C12_a+4*C13_a+C33_a)/(9*Ks_Grain_bulk_modulus));
Mb=Ks_Grain_bulk_modulus./(1-Porosity_b.*(1-Ks_Grain_bulk_modulus./Kfluid_b)-...
    (2*C11_dry_Pwave_modulus_b+2*C12_b+4*C13_b+C33_b)/(9*Ks_Grain_bulk_modulus));

C33_sat_a=C33_a+alpha_a3.*alpha_a3.*Ma;
C33_sat_b=C33_b+alpha_b3.*alpha_b3.*Mb;
%%%%D
D_a=(Permeability_a.*Ma.*C33_a)./(viscosity_a.*C33_sat_a);
D_b=(Permeability_b.*Mb.*C33_b)./(viscosity_b.*C33_sat_b);
%%%%lamda
% you sholud chose the sample interval and same in function(Velocity_Att_case4)
%f=0.01:0.1:10^8;
%The sampling interval is small and the running time is long
% f=0.01:0.1:10^5;
%f=10^5:100:10^8;
%Sampling in two intervals
w=2*pi*f;
lamda_a=sqrt((1i.*w)./D_a);
lamda_b=sqrt((1i.*w)./D_b);
%%%%gama
gama_a=(alpha_a3.*Ma)./C33_sat_a;
gama_b=(alpha_b3.*Mb)./C33_sat_b;
%%%%C33
C33_hf=1./(f1./C33_sat_a+f2./C33_sat_b);
A=(viscosity_a./(lamda_a*Permeability_a)).*coth(lamda_a.*Half_thickness_a);
B=(viscosity_b./(lamda_b*Permeability_b)).*coth(lamda_b.*Half_thickness_b);
gama2=power(gama_a-gama_b,2);
C33_vara=C33_hf.*power((C33_hf.*gama2)./(1i.*w.*L.*(A+B))+1,-1);
%%%%%
% C12_a=C11_dry_Pwave_modulus_a-2*C44_dry_Pwave_modulus_a;                  %鍗曠嫭鐨勫眰涓哄悇鍚戝悓鎬т粙璐?
% C12_b=C11_dry_Pwave_modulus_b-2*C44_dry_Pwave_modulus_b;
%%%%%%C13
C1=C13_a*gama_a-C13_b*gama_b-(gama_a*C33_a*alpha_a1)/alpha_a3+(gama_b*C33_b*alpha_b1)/alpha_b3;
C2=f1*(gama_a*((C13_a*alpha_a3)/C33_a-alpha_a1)-C13_a/C33_a)...
    +f2*(gama_b*((C13_b*alpha_b3)/C33_b-alpha_b1)-C13_b/C33_b);
C13_var1=((gama_a-gama_b)*C1)./(1i.*w.*L.*(A+B))-C2;
C13_var2=f1./C33_sat_a+f2./C33_sat_b+gama2./(1i.*w.*L.*(A+B));
C13_vara=C13_var1./C13_var2;
%%
%C11
x_a=(Ma.*(alpha_a1*C33_a-alpha_a3*C13_a))./C33_sat_a;
x_b=(Mb.*(alpha_b1*C33_b-alpha_b3*C13_b))./C33_sat_b;
D1=f1*(C11_dry_Pwave_modulus_a*C33_a-C13_a^2)/(C33_a)+...
    f2*(C11_dry_Pwave_modulus_b*C33_b-C13_b^2)/(C33_b);
D2=((alpha_a3*C13_a-alpha_a1*C33_a)/C33_a).*((C33_a*x_a/(alpha_a1*C33_a-alpha_a3*C13_a)).*(x_a-x_b)./(1i.*w.*L.*(A+B))-x_a*f1)-...
    ((alpha_b3*C13_b-alpha_b1*C33_b)/C33_b).*((C33_b*x_b/(alpha_b1*C33_b-alpha_b3*C13_b)).*(x_a-x_b)./(1i.*w.*L.*(A+B))+x_b*f2);
C11_vara=D1+D2+(C13_vara.*C13_vara)./C33_vara;

%% Seismic dispersion, attenuation, and frequency-dependent anisotropy
% epsilon=(C11_vara-C33_vara)./(2*C33_vara);
% delta=(power(C13_vara+C44,2)-power(C33_vara-C44,2))./(2.*C33_vara.*(C33_vara-C44));%鏈夐棶棰?
% A1=imag(epsilon);A2=imag(delta);
% AA1=real(epsilon);AA2=real(delta);
% semilogx(f,real((C11_vara-C33_vara)/(2.*C33_vara)));
%% 计算P波和Sv波速度
    ope_sin=0;
    ope_cos=1;
    ope=0;
    N_1=zeros(1,length(f));
    N=zeros(1,length(f));
    N_1(1,:)=(C11_vara-C44).*ope_sin-(C33_vara-C44).*ope_cos;
    N(1,:)=N_1.*N_1+power(C13_vara+C44,2).*ope;
% %     Data_N(jj,:)= N(1,:);                                                  %%灏嗘瘡娆＄殑杩愮畻缁撴灉淇濆瓨杩涚煩闃?
    V_p=power(C11_vara.*ope_sin+C33_vara.*ope_cos+C44+sqrt(N),0.5).*power(2*Density,-0.5);
    Vp=power(real(1./V_p),-1);
    Qp_1=imag(V_p.^2)./real(V_p.^2);  
    
    ope_sin_sv=0.5;
    ope_cos_sv=0.5;
    ope_sv=1;
    N_1=zeros(1,length(f));
    N=zeros(1,length(f));
    N_1(1,:)=(C11_vara-C44).*ope_sin_sv-(C33_vara-C44).*ope_cos_sv;
    N(1,:)=N_1.*N_1+power(C13_vara+C44,2).*ope_sv;
% %     Data_N(jj,:)= N(1,:);                                                  %%灏嗘瘡娆＄殑杩愮畻缁撴灉淇濆瓨杩涚煩闃?
    V_sv=power(C11_vara.*ope_sin_sv+C33_vara.*ope_cos_sv+C44-sqrt(N),0.5).*power(2*Density,-0.5);
    Vsv=power(real(1./V_sv),-1);
    Qsv_1=imag(V_sv.*V_sv)./real(V_sv.*V_sv);
%% Seismic dispersion, attenuation, and frequency-dependent anisotropy
epsilon=(C11_vara-C33_vara)./(2.*C33_vara);
delta=(power(C13_vara+C44,2)-power(C33_vara-C44,2))./(2.*C33_vara.*(C33_vara-C44));%鏈夐棶棰?
A1=-imag(epsilon);A2=-imag(delta);
B1=real(epsilon);B2=real(delta);
end
 

