# Annotation Guidelines (after iteration 1 , used for annotation with other annotators)

## General problems

|Issue| Sub-Issue | Problem description | Example | Decision |
|--|--|--|--|--|
|**Annotation scope**| | What should be annotated? || <ul> <li>**only annotate things that may be relevant to the "Leistung"**</li><li>**Read the whole process description in advance and try to understand the process**</li><li>**Take Absatz only as hint(Annotate all)**</li><li>**ignore for annotation when something with the formatting is wrong**</li></ul> 
|**Fundamentals** | | |  | | 
| | Stringmatcher | Do we accept stringmatcher suggestions that are right but not important to the Leistung | | we only accept suggestions of the Leistung|
|**Ellipsis**| Ellipsis without - | Sometimes there are Ellipsis that are not marked by a hyphen. In those cases it is hard to recognize, what is left out | Art und die Zahl der für den Eingriff vorgesehenen Tiere | |
|**Long-/short span annotation**|How to handle categories, that contain other categories| | [Prüfung, aktion , short] der [Sachkunde, dokument, short] |**if a longspan would contain other categories, don't annotate the long span, but make two short spans instead** |
| | how to handle generic long-span-additions? | z.B. unterschiedliche Präparate | **Only annotate additions that specify the short-span** |
|| Mixed cases of long span and prefix/sufix |zu-und abgang sowie kennzeichung von tieren *weitere Beispiele: 99110002001000 sentence 11*|**Not possible to link the addition to more than one entity ->only link it with the closer one** |
|**Overlap**| At this point overlap isn't allowed by the tool. Should we allow it? |||**Decision: no overlap -> per priority , the bigger entity wins**|

## Category-specific problems

|Category| Problem description | Example | Decision | 
|--|--|--|--|
Signalwort| Signalwort and full verb are not always mentioned next to each other | können .... bestellt werden (99110013061000_c) | *Signalwort* **does no longer have to be together with a full verb** | 
| | Should Modalverbs only be annotated, when they are accompanied by other signal words? | können nur, braucht nicht (9110002001000_c) | **No, but the additional words should be marked via longspan**| 
| |Is *sein* realy a *signalwort* |  | **Only annotate** *sein*, **when it comes with** *zu-Infinitiv* |
||List of modal verbs is not good||**List of Modal verbs has to be completed**|
Aktion | Sometimes parts of the verbs are somewhere else in the text and can't be represented by the BIO-Format  | sicher stellen: Das Bundesamt stellt bis 5 Tage nach Einreichung des Antrags sicher, dass... |**Only full verb (in this case stellen) should be annotated**| 
|| Is annotating zu in zu-Infinitiv necessary?| zu sammeln | **Don't annotate 'zu', if it is not integrated in the Verb (anzuzeigen)**
| | How to annotate things that are not documents but are "gegenstand der aktion" | <ul><li>ressource - Frequenzen (zugeteilt) 99109065058000</li> <li>Eingriff (anzuzeigen ), in 99110002001000</li></ul> | Annotate subject of Aktion as long-span |
Bedingung | Do we make a difference between Bedingung (determines the process) and Voraussetzung (is checked beforehand) | Bedingung: das Amt kann Ausnahmen zulassen, wenn <Bedingung erfüllt ist> Voraussetzung: falls ein Abschluss vorhanden ist... | **No difference between Bedingung and Vorraussetzung: Both are annotated as Bedingung** 
|Handlungsgrundlage| |||
|Frist| How to annotate Fristen, that consist of more than one word? | bis zu vier Wochen verlängert (99110002001000_c) | ***Frist* consists of the whole phrase *bis zu vier Wochen*** |
| | There are more than the two of our initial Fristen-categories (Abgabe, Entscheidung). Should we make it one generic category? |-"mindestens fünf Jahre lang aufzubewahren" describes an "Aufbewahrungsfrist" (99110013061000_c) | **One generic category *Frist***|
| | Does "Fristverlängerung" count as *Dokument* or *Frist*? ||***Fristverlängerung* counts as *Frist*** |
|Dokument|How to annotate things that are not documents but are subject of the action? Do we need an extra category | |**no do not annotate them**
| Ergebnisempfänger | Should relative clauses and relative pronouns be annotated as Ergebnisempfänger? | derjenige, der .... wer,..... (99110002001000) | **Don't annotate those constructions** |

## Addition category definition interview Schröder:

- Hauptakteur/Ergebnisempfänger: Nicht konkrete Person sondern Rolle
- Mitwirkender: nicht nur Behörde , auch andere Rollen : wie Betreuer
- Signalwort ist alt und irreführend. Stattdessen: wie optional ist eine Aktion
- Handlungsgrundlage: nicht nur etwas das Paragraph zeichen beinhaltet

## Curation Guidelines additions

|Issue| Sub-Issue | Problem description | Example | Decision |
|--|--|--|--|--|
|**Fundamentals** | | |  | | 
| | | Gesetz Titel annotieren |Gesetz über das Bundesamt für Sicherheit in der Informationstechnik |Titeln werden nicht annotiert|
|**Signalwort** | | |  | | 
| | | |hat zu entscheiden |Das Verb sein und haben wird nur in Kombination mit einem anderen Verb im zu-Infinitiv als Signalwort annotiert|
| | | |  | | 
| | |braucht nicht, können nur |hat zu entscheiden |Wörter, die Signalwörter näher bestimmen wie sollen per Longspan dem Signalwort zugeordnet werden|
|**Dokument** | | |  | | 
| | | | Auskunft und Unterlagen |sollen auch als Dokument annotiert werden.|
|**Aktion** | | |  | | 
| | | | Das Bundesamt stellt bis 5 Tage nach Einreichung des Antrags sicher, dass...|soll nur der flektierbare Teil des Verbs, wie in diesem Fall stellen annotiert werden|
|**Ergebnisempfänger** | | |  | | 
| | | | Derjenige, der einen Eingriff nach Absatz 1 Satz2 Nummer 4 durchführen will, hat..|Demonstrativpronomen (derjenige) und Relativpronomen (wer) sollten nicht annotiert werden|
|**Bedingung** | | |  | | 
| | | | Das Amt kann Ausnahmen zulassen, <wenn zu erfüllende Bedingung> Beispiel Voraussetzung: Falls ein Abschluss vorhanden ist, ...oder nur Personen mit abgeschlossenem Studium..|Es wird auch kein Unterschied zwischen einer Bedingung, die im Prozess entscheidend ist, und einer Voraussetzung, die vorher erfüllt sein muss,gemacht. Beides wird mit dem Label Bedingungannotiert.Beispiel Bedingung|

# Annotation Guidelines (after iteration 0 , used for iteration 1)

## General problems

|Issue| Sub-Issue | Problem description | Example | Decision |
|--|--|--|--|--|
|**Annotation scope**| | What should be annotated? || <ul> <li>**only annotate things that may be relevant to the "Leistung"**</li><li>**Read everything in advance**</li><li>**Take Absatz as hint**</li><li>**ignore for annotation when something with the formatting is wrong**</li></ul> 
| | Should all occurences of the same word be annotated? | | |**Basically yes but not when they are out of our annotation scope**
|**Fundamentals** | should plural forms be annotated?| | "Antrag" vs. "Anträge"? | **Yes** | 
| | Noun + article (Determinative) |should articles be included| "der, die, das" | **annotate without article**  
|| words with hyphens | annotated as two or one word? | "schwarz-weiß"| **annotate as one word**
|| Spelling mistakes || "Haupt akteur" | **Don't annotate misspelled word**
|| Abbreviations || "BMI" | **Annotate abbreviations as entities**
|| Words from other languages ||| **Annotate accordingly**
|**Ellipsis**| How to handle multiple elliptic terms with conjunctions? Several possible solutions: <ul><li>One big term</li><li>Fragment relations (see [Christina Lohr])</li></ul>   |"Sicherheits- oder Personnenzertifizierung" |  |<ul><li>**Should be treated as two instances**</li><li>**Exclude the connecting term ("oder", "und", etc.)**</li><li>**The NER-Annotation-Layer is enriched with the attributes "Suffix" and "Präfix"**</li><li>**In elliptical cases the fitting attribute has to be added manually**</li><li>**Example annotation: [Sicherheits; label:Ressource; Suffix:zertifizierung]- oder [Personenzertifizierung; label:Ressource]** </li></ul>  |
**Long-/short span annotation**| Nouns + adjectives| How to handle nouns with adjectives?|  "Medizinisch-technischer Laboratoriumsassitent" or "Laboratoriumsassitent"| <ul><li>**"Laboratoriumsassistent" should be annotated on short-span-layer**</li><li>**"Medizinisch-technischer" should be annotated on the long-span-layer**</li><li>**Both instance should be connected via relation-layer**</li></ul>|
| |Noun + Noun | what belongs to genitive Constructions | "Erteilung eines Zertifikats" | <ul><li>**"Erteilung" as Short-span**</li><li>**"eines Zertifikats" as Long-span**</li></ul>
|| Noun + Noun ||"Agentur für Arbeit"| **[Agentur; label: Hauptakteur]_short <-->[für Arbei;label: Hauptakteur]_long**
| |noun + verb | What is part of the Action scope?|"Führerschein beantragen"  | **[Führerschein; label:Aktion]_long<->[beantrgen; label:Aktion]_short**
| | Aktion-specific | <ul><li>passive voice</li><li>other time-forms</li></ul> | <ul><li>"beantragt werden"</li><li>"hat beantragt"</li></ul>| <ul><li>**annotate only the verb e.g., "beantragt"**</li></ul>
| | Aktion-specific | "zu-infinitive"| <ul><li>"zu beantragen"</li><li>"einzufügen"</li></ul>| <ul><li>**[einzufügen; label:Aktion]_short-Span-layer**</li><li>**[zu;label:Aktion]_long-span-layer<-->[beantragen;label:Aktion]_short-span-layer**</li></ul>
|**Overlap**| At this point overlap isn't allowed by the tool. Should we allow it? |||**Decision: no overlap -> per priority , the bigger entity wins**|

<!--|  |Conjunctions| How to handle multiple terms with conjunctions ("oder", "und")? Should it be one big term or two without the conjunction?| "Medizinisch-technische Laboratoriumsassistentin oder Medizinisch-technischer Laboratoriumsassitent"| Two terms without the conjunction|-->

## Category-specific problems

|Category| Problem description | Example | Decision | 
|--|--|--|--|
Signalwort|Category definition is fuzzy. |  | **Definition: Angabe zur Verbindlichkeit einer Aktion. Ausgedrückt durch Modalverben oder andere Ausdrückem die beschreiben, wie optional eine Aktion ist (z.b. bei Bedarf, erforderlich, zweckgebunden, auf Verlangen.etc.).**
Signalwort| Signalwort often overlaps with action | "Vertrag soll abgeschlossen werden" -> "soll" is part of the Verb form and signalling the modality at the same time | <ul><li>**Annotate words, that describe modality and are not part of the verb form like "bei Bedarf" (open set)**</li><li>**For verbs there is a defined closed set namely [sein, müssen, sollen, können, dürfen]. Those should be only annotate if they are mentioned together with a full verb e.g. [soll;label:Signalwort][beantragt;label:Aktion]_short <--> [werden; label:Aktion]_long**</li></ul> 
Aktion | <ul><li>Category is fuzzy</li><li> annotate "Aktion" only from "Verwaltungssicht" or also things that come from "Antragsteller"</li></ul> | | **Definition:Handlung der Verwaltung oder der anderen Akteure, z.B. Antragssteller, extern Mitwirkender etc. (Was ist prozessrelevant? Was wird getan?)** 
Aktion | Actions which are nouns are hard to recognize/should they be recognized at all? Very heterogenous category | "Beantragung des Führerscheins"-> Beantragung as action | **Annotate nouns as Action aswell**
Aktion | Fine grained or coarse grained classification? (Verwaltungssicht/Antragsstellersicht) | | **Coarse grained classification** |
Bedingung   | Category is fuzzy; Overlaps and Boundaries should be defined || <ul><li>**Definition: Voraussetzung für die Aktion, z. B. zeitlicher Auslöser**</li><li>**Gewisse Wörter "wie wenn, soweit, sofern" aber auch jegliche Verben wie in "sind blablabla" oder "verstirbt ein x"..., können Hinweis auf Bedingungen sein**</li><li>**als Bedingung soll jeweils der ganze [konditionale Nebensatz](https://mein-deutschbuch.de/konditionalsaetze.html) annotiert werden (bis zum Punkt oder Komma), Punkt oder Komma muss nicht annotiert werden.**</li></ul>
Bedingung | mehrere Nebensätze als eine Bedingung? | <ul><li>"Verstirbt eine natürliche Person, ohne dass ein Erbe die Frequenzen weiter nutzen will"</li><li>Bedingungslisten als ganzes?("wenn 1. [...] , 2. [...]")</li></ul> | **Annotate as one Bedingung and include everything**  | 
|Handlungsgrundlage| do we annotate the whole sentence also with "und" e.g., absatz 1 und 2 ? Do we annotate the whole sentence also with book name ? e.g., BGB absatz 1  ||**Decision: Annotate all**|

<!---## Formating 
- weird formatting, sometimes . not recognised as end of sentence /Segmentation errors in the data lead to bad annotations ./fragment relations for long spans
no space enumeration: see page 11 in 99109065058000.txtconv, annotation function is influenced at the end of line
	- Find out: Mistake with Source file? (probably coming from the html)Import? Does it influence our annotation? (yes)
	- Solution Clara writes simple script
- sometimes Handlungsgrundlagen are wrongly identified as end of sentence
	- Clara looks after formatting
	- **Ignore for annotation when Something is wrong**
	
## Remarks about Tool
- The time in the up-right corner shows time until automatic logout --->

## Decided for Additional Categories
	
- **deadlines** or **Frist**, Example: "innerhalb von sechs wochen" because it is shown in the process, is important infomation, 

- **Datenfeld** as new Category (Example: 99110002001000 seite 11)

## Class Definitions

|Category| Definition Handbuch Normenanalyse| Definition spezial| Example | 
|--|--|--|--|
|Hauptakteur|[No definition found] Wer?|Aus Verwaltungssicht die Person oder Behörde, die für die Leistungserbringung verantwortlich ist.||
|Ergebnisempfänger|[No definition found] Für wen? |Die Person oder Unternehmen, das die Verwaltungsleistung in Anspruch nehmen möchte.||
|Mitwirkender|[No definition found] Mit wem?|Externe Behörde, die bei der Verwaltungsleistung mit einbezogen wird.||
|Aktion|Handlung der Verwaltung (Was?)|Handlung der Verwaltung oder der anderen Akteure, z.B. Antragssteller, extern Mitwirkender etc. (Was ist prozessrelevant? Was wird getan?)||
|Signalwort|Angabe zur Verbindlichkeit der Aktion: MUSS, SOLL, KANN (Welche Verbindlichkeit?)|Angabe zur Verbindlichkeit einer Aktion. Ausgedrückt durch Modalverben oder andere Ausdrückem die beschreiben, wie optional eine Aktion ist (z.b. bei Bedarf, erforderlich, zweckgebunden, auf Verlangen.etc.).||
|Dokument|Objekt, womit die Aktion durchgeführt wird oder das Gegenstand der Aktion ist (Womit?)| Dokumente die zwischen Behörde/Ergebnisempfänger/Mitwirkender ausgetauscht werden (e.g., von Behörde verlangt)||
|Bedingung|Voraussetzung für die Aktion, z. B. zeitlicher Auslöser (Welche Voraussetzung?)|<ul><li>Gewisse Wörter "wie wenn, soweit, sofern" aber auch jegliche Verben wie in "sind blablabla" oder "verstirbt ein x"..., können Hinweis auf Bedingungen sein</li><li>als Bedingung soll jeweils der ganze [konditionale Nebensatz](https://mein-deutschbuch.de/konditionalsaetze.html) annotiert werden (bis zum Punkt oder Komma)</li></ul>||
|Entscheidungsfrist|[new category]|Fristen oder Zeitlimits, die für den Prozess relevant sind| "die bundesagentur entscheidet über vollstädige anträge [innerhalb von sechs wochen]"|
|Abgabefrist|[new category]|Fristen oder Zeitlimits, sich auf einen Dokument beziehen| "eingriff spätestens [zwei Wcohen vor beginn] der zuständigen behörde anzuzeigen"|
|Datenfeld|[new category]|Bei expliziter Nennung von Elementen, die mit in einen Antrag müssen, kann das als Datenfeld notiert werden|<ul><li>[Beispiel S.92](https://cloud.uni-jena.de/apps/files/?dir=/OZG/05_Bibliothek/01_Schulungsunterlagen/03_FIM-Methodenexperte/Schulungsunterlagen_ME&openfile=49752878)</li><li>Example: 99110002001000 seite 11</li></ul>|
Handlungsgrundlage | [new category] | Verweise auf eine andere Gesetzesnorm | "Artikel 2 §1" 


