# Guidelines (after iteration 0 , used for iteration 1)

## General problems

|Issue| Sub-Issue | Problem description | Example | Decision |
|--|--|--|--|--|
|**Annotation scope**| | What should be annotated? || <ul> <li>**only annotate things that may be relevant to the "Leistung"**</li><li>**Read everything in advance**</li><li>**Take Absatz as hint**</li><li>**ignore for annotation when something with the formatting is wrong**</li></ul> 
| | Should all occurences of the same word be annotated? | | |**Basically yes but not when they are out of our annotation scope**
|**Fundamentals** | should plural forms be annotated?| | "Antrag" vs. "Anträge"? | **Yes** | 
| | Noun + article (Determinative) |should articles be included| "der, die, das" | **annotate without article**  
|| words with hyphens | annotated as two or one word? | "schwarz-weiß"| **annotate as one word**
|| Spelling mistakes || "Haupt akteur" | **Don't annotate misspelled word**
|| Abbreviations || "BMI" | **Annotate abbreviations as entities**
|| Words from other languages ||| **Annotate accordingly**
|**Ellipsis**| How to handle multiple elliptic terms with conjunctions? Several possible solutions: <ul><li>One big term</li><li>Fragment relations (see [Christina Lohr])</li></ul>   |"Sicherheits- oder Personnenzertifizierung" |  |<ul><li>**Should be treated as two instances**</li><li>**Exclude the connecting term ("oder", "und", etc.)**</li><li>**The NER-Annotation-Layer is enriched with the attributes "Suffix" and "Präfix"**</li><li>**In elliptical cases the fitting attribute has to be added manually**</li><li>**Example annotation: [Sicherheits; label:Ressource; Suffix:zertifizierung]- oder [Personenzertifizierung; label:Ressource]** </li></ul>  |
**Long-/short span annotation**| Nouns + adjectives| How to handle nouns with adjectives?|  "Medizinisch-technischer Laboratoriumsassitent" or "Laboratoriumsassitent"| <ul><li>**"Laboratoriumsassistent" should be annotated on short-span-layer**</li><li>**"Medizinisch-technischer" should be annotated on the long-span-layer**</li><li>**Both instance should be connected via relation-layer**</li></ul>|
| |Noun + Noun | what belongs to genitive Constructions | "Erteilung eines Zertifikats" | <ul><li>**"Erteilung" as Short-span**</li><li>**"eines Zertifikats" as Long-span**</li></ul>
|| Noun + Noun ||"Agentur für Arbeit"| **[Agentur; label: Hauptakteur]_short <-->[für Arbei;label: Hauptakteur]_long**
| |noun + verb | What is part of the Action scope?|"Führerschein beantragen"  | **[Führerschein; label:Aktion]_long<->[beantrgen; label:Aktion]_short**
| | Aktion-specific | <ul><li>passive voice</li><li>other time-forms</li></ul> | <ul><li>"beantragt werden"</li><li>"hat beantragt"</li></ul>| <ul><li>**annotate only the verb e.g., "beantragt"**</li></ul>
| | Aktion-specific | "zu-infinitive"| <ul><li>"zu beantragen"</li><li>"einzufügen"</li></ul>| <ul><li>**[einzufügen; label:Aktion]_short-Span-layer**</li><li>**[zu;label:Aktion]_long-span-layer<-->[beantragen;label:Aktion]_short-span-layer**</li></ul>
|**Overlap**| At this point overlap isn't allowed by the tool. Should we allow it? |||**Decision: no overlap -> per priority , the bigger entity wins**|

<!--|  |Conjunctions| How to handle multiple terms with conjunctions ("oder", "und")? Should it be one big term or two without the conjunction?| "Medizinisch-technische Laboratoriumsassistentin oder Medizinisch-technischer Laboratoriumsassitent"| Two terms without the conjunction|-->

## Category-specific problems

|Category| Problem description | Example | Decision | 
|--|--|--|--|
Signalwort|Category definition is fuzzy. |  | **Definition: Angabe zur Verbindlichkeit einer Aktion. Ausgedrückt durch Modalverben oder andere Ausdrückem die beschreiben, wie optional eine Aktion ist (z.b. bei Bedarf, erforderlich, zweckgebunden, auf Verlangen.etc.).**
Signalwort| Signalwort often overlaps with action | "Vertrag soll abgeschlossen werden" -> "soll" is part of the Verb form and signalling the modality at the same time | <ul><li>**Annotate words, that describe modality and are not part of the verb form like "bei Bedarf" (open set)**</li><li>**For verbs there is a defined closed set namely [sein, müssen, sollen, können, dürfen]. Those should be only annotate if they are mentioned together with a full verb e.g. [soll;label:Signalwort][beantragt;label:Aktion]_short <--> [werden; label:Aktion]_long**</li></ul> 
Aktion | <ul><li>Category is fuzzy</li><li> annotate "Aktion" only from "Verwaltungssicht" or also things that come from "Antragsteller"</li></ul> | | **Definition:Handlung der Verwaltung oder der anderen Akteure, z.B. Antragssteller, extern Mitwirkender etc. (Was ist prozessrelevant? Was wird getan?)** 
Aktion | Actions which are nouns are hard to recognize/should they be recognized at all? Very heterogenous category | "Beantragung des Führerscheins"-> Beantragung as action | **Annotate nouns as Action aswell**
Aktion | Fine grained or coarse grained classification? (Verwaltungssicht/Antragsstellersicht) | | **Coarse grained classification** |
Bedingung   | Category is fuzzy; Overlaps and Boundaries should be defined || <ul><li>**Definition: Voraussetzung für die Aktion, z. B. zeitlicher Auslöser**</li><li>**Gewisse Wörter "wie wenn, soweit, sofern" aber auch jegliche Verben wie in "sind blablabla" oder "verstirbt ein x"..., können Hinweis auf Bedingungen sein**</li><li>**als Bedingung soll jeweils der ganze [konditionale Nebensatz](https://mein-deutschbuch.de/konditionalsaetze.html) annotiert werden (bis zum Punkt oder Komma), Punkt oder Komma muss nicht annotiert werden.**</li></ul>
Bedingung | mehrere Nebensätze als eine Bedingung? | <ul><li>"Verstirbt eine natürliche Person, ohne dass ein Erbe die Frequenzen weiter nutzen will"</li><li>Bedingungslisten als ganzes?("wenn 1. [...] , 2. [...]")</li></ul> | **Annotate as one Bedingung and include everything**  | 
|Handlungsgrundlage| do we annotate the whole sentence also with "und" e.g., absatz 1 und 2 ? Do we annotate the whole sentence also with book name ? e.g., BGB absatz 1  ||**Decision: Annotate all**|

<!---## Formating 
- weird formatting, sometimes . not recognised as end of sentence /Segmentation errors in the data lead to bad annotations ./fragment relations for long spans
no space enumeration: see page 11 in 99109065058000.txtconv, annotation function is influenced at the end of line
	- Find out: Mistake with Source file? (probably coming from the html)Import? Does it influence our annotation? (yes)
	- Solution Clara writes simple script
- sometimes Handlungsgrundlagen are wrongly identified as end of sentence
	- Clara looks after formatting
	- **Ignore for annotation when Something is wrong**
	
## Remarks about Tool
- The time in the up-right corner shows time until automatic logout --->

## Decided for Additional Categories
	
- **deadlines** or **Frist**, Example: "innerhalb von sechs wochen" because it is shown in the process, is important infomation, 

- **Datenfeld** as new Category (Example: 99110002001000 seite 11)

## Class Definitions

|Category| Definition Handbuch Normenanalyse| Definition spezial| Example | 
|--|--|--|--|
|Hauptakteur|[No definition found] Wer?|Aus Verwaltungssicht die Person oder Behörde, die für die Leistungserbringung verantwortlich ist.||
|Ergebnisempfänger|[No definition found] Für wen? |Die Person oder Unternehmen, das die Verwaltungsleistung in Anspruch nehmen möchte.||
|Mitwirkender|[No definition found] Mit wem?|Externe Behörde, die bei der Verwaltungsleistung mit einbezogen wird.||
|Aktion|Handlung der Verwaltung (Was?)|Handlung der Verwaltung oder der anderen Akteure, z.B. Antragssteller, extern Mitwirkender etc. (Was ist prozessrelevant? Was wird getan?)||
|Signalwort|Angabe zur Verbindlichkeit der Aktion: MUSS, SOLL, KANN (Welche Verbindlichkeit?)|Angabe zur Verbindlichkeit einer Aktion. Ausgedrückt durch Modalverben oder andere Ausdrückem die beschreiben, wie optional eine Aktion ist (z.b. bei Bedarf, erforderlich, zweckgebunden, auf Verlangen.etc.).||
|Dokument|Objekt, womit die Aktion durchgeführt wird oder das Gegenstand der Aktion ist (Womit?)|||
|Bedingung|Voraussetzung für die Aktion, z. B. zeitlicher Auslöser (Welche Voraussetzung?)|<ul><li>Gewisse Wörter "wie wenn, soweit, sofern" aber auch jegliche Verben wie in "sind blablabla" oder "verstirbt ein x"..., können Hinweis auf Bedingungen sein</li><li>als Bedingung soll jeweils der ganze [konditionale Nebensatz](https://mein-deutschbuch.de/konditionalsaetze.html) annotiert werden (bis zum Punkt oder Komma)</li></ul>||
|Entscheidungsfrist|[new category]|Fristen oder Zeitlimits, die für den Prozess relevant sind| "die bundesagentur entscheidet über vollstädige anträge [innerhalb von sechs wochen]"|
|Abgabefrist|[new category]|Fristen oder Zeitlimits, sich auf einen Dokument beziehen| "eingriff spätestens [zwei Wcohen vor beginn] der zuständigen behörde anzuzeigen"|
|Datenfeld|[new category]|Bei expliziter Nennung von Elementen, die mit in einen Antrag müssen, kann das als Datenfeld notiert werden|<ul><li>[Beispiel S.92](https://cloud.uni-jena.de/apps/files/?dir=/OZG/05_Bibliothek/01_Schulungsunterlagen/03_FIM-Methodenexperte/Schulungsunterlagen_ME&openfile=49752878)</li><li>Example: 99110002001000 seite 11</li></ul>|
Handlungsgrundlage | [new category] | Verweise auf eine andere Gesetzesnorm | "Artikel 2 §1"
