---
layout: default-cylinter
title: Workflow
nav_order: 4
has_children: true
---

# Workflow

| Input Directory Structure (see [Input File Structure]({{ site.baseurl }}/structure/index) for details) | Output Directory Structure
| :-- | :-- |
| <code>INPUT_DIR<br>├── config.yml<br>├── csv/<br>├── markers.csv<br>├── mask/<br>├── seg/<br>└── tif/<br></code> | <code>OUTPUT_DIR<br>├── area/<br>├── checkpoints/<br>├── clustering/<br>├── contrast/<br>├── cycles/<br>├── gating/<br>├── intensity/<br>├── metaQC/<br>├── PCA/<br>├── pruning/<br>└──  ROIs/<br></code>

<table>
  <tr>
    <td style="width: 70%;"> <img src="{{ site.baseurl }}/assets/images/ExtFig5.jpg" alt="CyLinter"/></td>
    <td style="line-height: 1.1;"><font size="2.7"><b>Identifying and Removing Noisy Single-cell Data Points with CyLinter.</b> | <b>a-d</b>: CyLinter input: <b>a</b>, Multiplex microscopy file <b>b</b>, Cell segmentation outlines <b>c</b>, Cell ID mask <b>d</b>, Single-cell feature table. <b>e</b>, ROI selection module: multi-channel images are viewed to identify and gate on regions of tissue affected by microscopy artifacts (in the default negative selection mode). <b>f-i</b>, Demonstration of automated artifact detection in CyLinter. <b>f</b>, CyLinter’s selectROIs module showing artifacts in the CDKN1A (green) channel of EMIT TMA core 18 (mesothelioma). <b>g</b>, Transformed version of the original CDKN1A image such that artifacts appear as large, bright regions relative to channel intensity variations associated with true signal of immunoreactive cells which are suppressed. <b>h</b>, Local intensity maxima are identified in the transformed image and a flood fill algorithm is used to create a pixel-level binary mask indicating regions of tissue affected by artifacts. In this example, the method identifies three artifacts in the image: one fluorescence aberration at the top of the core, and two tissue folds at the bottom of the core. <b>i</b>, CyLinter’s selectROIs module showing the binary artifact mask (translucent gray shapes) and their corresponding local maxima (red dots) defining each of the three artifacts. <b>j</b>, DNA intensity filter: histogram sliders are used to define lower and upper bounds on nuclear counterstain single intensity. Cells between cutoffs are visualized as scatter points at their spatial coordinates in the corresponding tissue for gate confirmation or refinement. <b>k</b>, Cell segmentation area filter: histogram sliders are used to define lower and upper bounds on cell segmentation area (pixel counts). Cells between cutoffs are visualized as scatter points at their spatial coordinates in the corresponding tissue for gate confirmation or refinement. <b>l</b>, Cross-cycle correlation filter: applicable to multi-cycle experiments. Histogram sliders are used to define lower and upper bounds on the log-transformed ratio of DNA signals between the first and last imaging cycles. Cells between cutoffs are visualized as scatter points at their spatial coordinates in their corresponding tissues for gate confirmation or refinement. <b>m</b>, Channel outlier filter: the distribution of cells according to antibody signal intensity is viewed for all sample as a facet grid of scatter plots (or hexbin plots) against cell area (y-axes). Lower and upper percentile cutoffs are applied to remove outliers. Outliers are visualized as scatter points at their spatial coordinates in their corresponding tissues for gate confirmation or refinement. <b>n</b>, MetaQC module: unsupervised clustering methods (UMAP or TSNE followed by HDBSCAN clustering) are used to correct for gating bias in prior data filtration modules by thresholding on the percent of each cluster composed of clean (maintained) or noisy (redacted) cells. <b>o</b>, Unsupervised cluster methods (UMAP or TSNE followed by HDBSCAN) are used to identify unique cell states in a given cohort of tissues. <b>p</b>, Image contrast adjustment: channel contrast settings are optimized for visualization on reference tissue which are applied to all tissues in the cohort. <b>q</b>, Evaluate cluster membership: cluster quality is checked by visualizing galleries of example cells drawn at random from each cluster identified in the clustering module.</font></td>
  </tr>
</table>
