---
layout: default-cylinter
title: Tutorials
nav_order: 8
has_children: true
---

# Tutorials

## Overview Video

{% include youtube.html id="fnxBvgJQmtY" autoplay=false mute=false controls=true loop=false related=false %}

A general introduction [video](https://www.youtube.com/watch?v=fnxBvgJQmtY) that provides a high-level overview of the pipeline.

---

<div class="basic-grid">

<div markdown="1">
## Visual Guide
This detailed [visual guide](pipeline-visual-guide.html) takes you through the steps performed by the MCMICRO pipeline as it processes [exemplar-002]({{ site.baseurl }}/datasets.html). The guide was developed using the open source [Minerva software](https://www.cycif.org/software/minerva), developed by the Laboratory of Systems Pharmacology.

[![]({{ site.baseurl }}/images/tutorials/vizguide.png)](pipeline-visual-guide.html)
{: .mt-6 .mr-10}
</div>

<div markdown="1">
## Installing Nextflow and MCMICRO Video
This [tutorial video](https://youtu.be/tLWMe_uJY9A) walks you through installing Nextflow and MCMICRO, downloading exemplar images, and executing the pipeline on the Google Cloud Platform.

[![](https://img.youtube.com/vi/tLWMe_uJY9A/0.jpg)](https://youtu.be/tLWMe_uJY9A)
{: .mt-6 .mr-10}
</div>

</div><!-- end grid -->

---

This [written guide](basics.html) provides an overview of basic concepts in tissue imaging, including how the data is collected and represented, image format standards, and the mandatory set of initial steps in image processing.
