---
layout: default-cylinter
title: Input File Structure
nav_order: 5
has_children: false
---

{: .no_toc }

<details open markdown="block">
  <summary>
    Table of contents
  </summary>
  {: .text-delta }
1. TOC
{:toc}
</details>

# Input directory structure

CyLinter can analyze any multiplex imaging data so long as they conform to the expected file formats and folder structure. In the below example, `<sample#>` corresponds to the name of a particular tissue sample.

``` bash
<INPUT DIR>
├── config.yml
├── csv/
│   ├── <sample1>.csv
│   └── <sample2>.csv
├── markers.csv
├── mask/
│   ├── <sample1>.ome.tif (or .tif)
│   └── <sample2>.ome.tif (or .tif)
├── seg/
│   ├── <sample1>.ome.tif (or .tif)
│   └── <sample2>.ome.tif (or .tif)
└── tif/
    ├── <sample1>.ome.tif (or .tif)
    └── <sample2>.ome.tif (or .tif)
```

## Note for MCMICRO users
CyLinter can parse **whole slide image (WSI)** and **tissue microarray (TMA)** multiplex imaging data generated by the [MCMICRO](https://mcmicro.org) image-processing pipeline in their native file structure. In these cases, the [MCMICRO output directory](https://mcmicro.org/io.html#directory-structure) serves as the CyLinter input directory. 


# YAML configuration file

`config.yml` is the YAML configuration file passed to the `cylinter` command on program execution. It specifies general program configurations and module-specific parameters for a given analysis and should be stored in the top level CyLinter [input directory](#input-directory-structure). The `config.yml` file downloaded with the program is pre-configured for use with [Example Data]({{ site.baseurl }}/exemplar) used to demonstrate CyLinter. On MacOS, this file is located here: `/Users/<user>/miniconda3/envs/cylinter/lib/python3.10/site-packages/cylinter/config.yml`.

## General configurations

| Parameter | Default | Description |
| --- | --- | --- |
| `inDir` | /Users/user/Desktop/cylinter_demo | CyLinter input directory; contains multi-channel image files (TIFF/OME-TIFF), segmentation outline files (TIFF/OME-TIFF), cell ID masks (TIFF/OME-TIFF), single-cell spatial feature tables (CSV), `config.yml`, and `markers.csv` organized according to the [input directory structure](#input-directory-structure) or as native [MCMICRO output structure](https://mcmicro.org/io.html#directory-structure). |
| `outDir` | /Users/user/Desktop/cylinter_demo/output | CyLinter output directory path; created on program execution. |
| `sampleMetadata` | "Filename": <br />  ["15", "Glioblastoma", "GBM", "CANCER-TRUE", 1] | Sample metadata dictionary: keys = Filenames (str); values = list of strings. First elements: sample names (str, may differ from Filename). Second elements: descriptive text of experimental condition (str). Third elements: abbreviation of experimental condition (str). Fourth elements: comma-delimited string of arbitrary binary declarations for computing t-statistics between two groups of samples (str). Fifth elements: replicate number specifying biological or technical replicates (int). |
| `samplesToExclude` | [ ] | (list of strs) Sample names (i.e., first elements in `sampleMetadata` values) to exclude from analysis. |
| `markersToExclude` | [ ] | (list of strs) Markers to exclude from analysis (not including nuclear dyes). |

## Module configurations
For module-specific configuration settings, see [Modules]({{ site.baseurl }}/modules)


# Markers.csv
`markers.csv` is a standard input file into the MCMICRO image-processing pipeline also used by CyLinter to index marker channels in a batch multiplex images labeled with the same markers. The file takes the following format and must be included in the top level CyLinter [input directory](#input-directory-structure):

```
channel_number,cycle_number,marker_name
1,1,<DNA1>
2,1,<abx1>
3,1,<abx2>
4,1,<abx3>
5,2,<DNA2>
6,2,<abx4>
7,2,<abx5>
8,2,<abx6>
.
.
.
```
* Additional metadata columns may be present in the file, but are not currently read by CyLinter.
