---
layout: default-cylinter
title: clustering
nav_order: 12
parent: Modules
---

12\. `clustering`: this module performs density-based hierarchical clustering with [HDBSCAN](https://hdbscan.readthedocs.io/en/latest/api.html) on [UMAP](https://umap-learn.readthedocs.io/en/latest/) (or [t-SNE](https://scikit-learn.org/stable/modules/generated/sklearn.manifold.TSNE.html)) embeddings of cells in the identification of biologically relevant cell states and/or residual dataset noise. Users are presented with UMAP (or t-SNE) embeddings of cells colored by **1)** HDBSCAN cluster, **2)** gate-based cell type classification, and **3)** sample, after selecting a `Min Cluster Size (MCS)` value and clicking the `Cluster and Plot` button in the `Plot Single MCS` widget at the top right of the Napari viewer. Clustering is optimized by testing different minimum cluster sizes (`min_cluster_size`, an HDBSCAN parameter that significantly effects the clustering result). To aid in identifying a stable clustering solution, a range of `min_cluster_size` values may be entered into the `Sweep MCS Range` widget at the right of the Napari viwer and the number of clusters associated with each `min_cluster_size` will be printed to the terminal window. After each clustering, a new window showing a [silhouette analysis](https://www.sciencedirect.com/science/article/pii/0377042787901257) beside its corresponding clustering solution. Cells with positive silhouette coefficients are considered properly clustered, while those with increasingly negative coefficients are considered under-clustered. Cells in the HDBSCAN plot in the Napari viewer may be lassoed by pressing and holding the mouse (or track pad) button and drawing around cells of interest, then typing the name of a sample of interest in the `Sample Name` field and clicking the `View Lassoed Points` button. Selected cells will then appear as scatter points in their corresponding image. Clicking the `Save` button at the bottom right of the Napari viewer causes the program to append the current cluster labels to the single-cell dataframe and proceed to the next module.

### YAML configurations

| Parameter | Default | Description |
| --- | --- | --- |
| `embeddingAlgorithm` | "UMAP" | (str) Embedding algorithm to use for clustering (options: "TSNE" or "UMAP"). |
| `channelExclusionsClustering` | [ ] | (list of strs) Immunomarkers to exclude from clustering. |
| `samplesToRemoveClustering` | [ ] | (list of strs) Samples to exclude from clustering. |
| `normalizeTissueCounts` | True | (bool) Make the number of cells per tissue for clustering more similar through sample-weighted random sampling. |
| `fracForEmbedding` | 1.0 | (float) Fraction of cells to be embedded (range: 0.0-1.0). Limits amount of data passed to downstream modules. |
| `dimensionEmbedding` | 2 | (int) Dimension of the embedding (options: 2 or 3). |
| `topMarkers` | "channels" | (str) Normalization axis ("channels" or "clusters") used to define highest expressed markers per cluster. |
| `colormapAnnotationClustering` | "Sample" | (str) Metadata annotation to colormap the embedding: Sample or Condition. |
| `metric` | "euclidean" | (str) Distance metric for computing embedding. Choose from valid metrics used by scipy.spatial.distance.pdist: "braycurtis", "canberra", "chebyshev", "cityblock", "correlation", "cosine", "dice", "euclidean", "hamming", "jaccard", "jensenshannon", "kulsinski", "mahalanobis", "matching", "minkowski", "rogerstanimoto", "russellrao", "seuclidean", "sokalmichener", "sokalsneath", "sqeuclidean", "yule". |
| `perplexity` | 50.0 | (float) This is a [tSNE-specific configuration](https://scikit-learn.org/stable/modules/generated/sklearn.manifold.TSNE.html) related to the number of nearest neighbors used in other manifold learning algorithms. Larger datasets usually require larger perplexity. Different values can result in significantly different results. |
| `earlyExaggeration` | 12.0 | (float) This is a [tSNE-specific configuration](https://scikit-learn.org/stable/modules/generated/sklearn.manifold.TSNE.html). For larger values, the space between natural clusters will be larger in the embedded space. |
| `learningRateTSNE` | 200.0 | (float) This is a [tSNE-specific configuration](https://scikit-learn.org/stable/modules/generated/sklearn.manifold.TSNE.html). tSNE learning rate (typically between 10.0 and 1000.0). |
| `randomStateTSNE` | 5 | (int) This is a [tSNE-specific configuration](https://scikit-learn.org/stable/modules/generated/sklearn.manifold.TSNE.html). It determines the random number generator for reproducible results across multiple function calls. |
| `nNeighbors` | 5 | (int) This is a [UMAP-specific configuration](https://umap-learn.readthedocs.io/en/latest/api.html). It determines the size of local neighborhood (in terms of number of neighboring sample points) used for manifold approximation. Larger values result in more global views of the manifold, while smaller values result in more local data being preserved. In general values should be in the range 2 to 100. |
| `learningRateUMAP` | 1.0 | (float) This is a [UMAP-specific configuration](https://umap-learn.readthedocs.io/en/latest/api.html). It Determines the initial learning rate for the embedding optimization. |
| `minDist` | 0.1 | (float) This is a [UMAP-specific configuration](https://umap-learn.readthedocs.io/en/latest/api.html). Determines the effective minimum distance between embedded points. Smaller values will result in a more clustered/clumped embedding where nearby points on the manifold are drawn closer together, while larger values will result on a more even dispersal of points. The value should be set relative to the spread value, which determines the scale at which embedded points will be spread out. |
| `repulsionStrength` | 5.0 | (float) This is a [UMAP-specific configuration](https://umap-learn.readthedocs.io/en/latest/api.html). Determines the weighting applied to negative samples in low dimensional embedding optimization. Values higher than one will result in greater weight being given to negative samples. |
| `randomStateUMAP` | 5 | (int) This is a [UMAP-specific configuration](https://umap-learn.readthedocs.io/en/latest/api.html). It determines the random number generator for reproducible results across multiple function calls. |
