#include<iostream>
#include<fstream>
#include<cmath>
#include<string>
#include<iomanip>
#include<stdlib.h>
using namespace std;
#define lines 244638314
#define R 6371.
#define pi 4*atan(1.)
#define nport 3630

double rad(double degree){/*Degree to radians*/
  return degree*pi/180.;}

double haversine (double deglat1, double deglon1, double deglat2, double deglon2){
  double radlat1,radlat2,a,dlat,dlon;
  radlat1=deglat1*pi/180.;
  radlat2=deglat2*pi/180.;
  dlat=radlat2-radlat1;
  dlon=(deglon2-deglon1)*pi/180.;
  double sdlat=sin(dlat/2.);
  double sdlon=sin(dlon/2.);
  a=sdlat*sdlat+cos(radlat1)*cos(radlat2)*sdlon*sdlon;
  a=2*asin(sqrt(a));
  return a*R;}

int main(){
  int i,j,k,l;
  string str,fname;
  ifstream datain("trajectories_fishing_ais.dat");
  ofstream dataout("anomaliesdata.dat");
  int id[2];
  double lat[2],lon[2],datat[2],speed[2],la0,lo0;
  double deltat;
  int cx,cy,cell[2];
  double d;
  cout<<"Beginning"<<endl;
  //Read ports
  ifstream datain3("wpi_coords.dat");
  bool cellport[2*2*360*180];
  for(i=0;i<2*2*360*180;i++)cellport[i]=0;
  getline(datain3,str);
  for(i=0;i<nport;i++){
    datain3>>d>>la0>>lo0;
    cx=(int)(2.*(lo0+180.));
    cy=(int)(2.*(la0+90.));
    j=cx+2*360*cy;
    cellport[j]=1;}
  cout<<"Finished reading ports"<<endl;
  dataout<<"MMSI"<<"\t"<<"Lat"<<"\t"<<"Lon"<<"\t"<<"Lat1"<<"\t"<<"Lon1"<<"\t"<<"Deltat"<<"\t"<<"Type"<<"\t"<<"Port before"<<"\t"<<"Port after"<<endl;
  int accanom,portbef[10000],typeanom[10000];
  double latanom[10000],lonanom[10000];
  double latanom1[10000],lonanom1[10000],tanom[10000];
  //For the ports, include the port cell
  int anomaly;
  int lastport=-1;

  getline(datain,str);
  datain>>j>>id[1]>>lat[1]>>lon[1]>>datat[1]>>speed[1];
  cx = (int)(2.*(lon[1]+180.));
  cy = (int)(2.*(lat[1]+90.));
  cell[1] = cx+2*360*cy;
  if(cellport[cell[1]]==1){
    lastport=cell[1];}
  else{
    lastport = -1;}
  accanom = 0;
  cout<<"Starting loop"<<endl;
  for(i=1;i<lines-1;i++){
    id[0]=id[1];
    lat[0]=lat[1];
    lon[0]=lon[1];
    datat[0]=datat[1];
    speed[0]=speed[1];
    cell[0]=cell[1];
    datain>>j>>id[1]>>lat[1]>>lon[1]>>datat[1]>>speed[1];
    cx=(int)(2.*(lon[1]+180.));
    cy=(int)(2.*(lat[1]+90.));
    cell[1]=cx+2*360*cy;
    j=cell[1];
    if(cellport[j]==1){//We do not consider anomalies in port cells
      if(id[1] == id[0]){//If same id, arriving to port and write everything
	for(k=0;k<accanom;k++){
	  dataout<<id[1]<<"\t"<<latanom[k]<<"\t"<<lonanom[k]<<"\t"<<latanom1[k]<<"\t"<<lonanom1[k]<<"\t"<<tanom[k]<<"\t"<<typeanom[k]<<"\t"<<lastport<<"\t"<<j<<endl;}
	lastport=j;
	accanom=0;}
      else{//Different ID, write the data up to now
	for(k=0;k<accanom;k++){
	  dataout<<id[0]<<"\t"<<latanom[k]<<"\t"<<lonanom[k]<<"\t"<<latanom1[k]<<"\t"<<lonanom1[k]<<"\t"<<tanom[k]<<"\t"<<typeanom[k]<<"\t"<<lastport<<"\t"<<"-1"<<endl;}
	lastport=j;
	accanom=0;}}
    else if(id[1] == id[0]){//Look for anomalies in non-port cells
      if(cellport[cell[0]]==0){//We already checked that cell[1] is not a port, have to check if cell[0] is or not a port
	d=haversine(lat[0],lon[0],lat[1],lon[1]);
	deltat=datat[1]-datat[0];
	if((deltat>1.)||(d/deltat>2000.)){//Anomaly
	  //1: anomaly only in deltat
	  if((deltat>1.)&&(d/deltat<=2000.)){
	    anomaly=0;}
	  //2: anomaly only in velocity
	  else if((deltat<=1.)&&(d/deltat>2000.)){
	    anomaly=1;}
	  //3: anomaly in both
	  else{
	    anomaly=2;}
	  latanom[accanom] = lat[0];
	  lonanom[accanom]= lon[0];
	  latanom1[accanom] = lat[1];
	  lonanom1[accanom] = lon[1];
	  typeanom[accanom] = anomaly;
	  tanom[accanom] = deltat;
	  accanom++;}}}
    else{//No port cell, new ID (the port after is considered -1)
      for(k=0;k<accanom;k++){
	dataout<<std::setprecision(8)<<id[0]<<"\t"<<latanom[k]<<"\t"<<lonanom[k]<<"\t"<<latanom1[k]<<"\t"<<lonanom1[k]<<"\t"<<tanom[k]<<"\t"<<typeanom[k]<<"\t"<<lastport<<"\t"<<"-1"<<endl;}
      accanom=0;
      lastport=-1;}}
  return 0;}
