package org.vcell.pathway.sbo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This file automatically generates the SBOListEx.java by parsing the SBO ontology file
 * downloaded from the SBO site in xml format
 * You should update this file from time to time as new SBO terms are added to it and then
 * run this program to update SBOListEx.java
 */
public class SBOBuilder {
	private final static Logger lg = LogManager.getLogger(SBOBuilder.class);

static final private String newLine = "\n";			// String to add after every line. i.e. \r\n or just \n.
static final private String fileName = "C:\\dan\\projects\\VCell_trunk\\src\\org\\vcell\\pathway\\sbo\\SBOListEx.java";


public static void main(String argv[]) {
	try {
		File file = new File(fileName);
		
		BufferedWriter writer = new BufferedWriter(new FileWriter(file));
		writer.write("package org.vcell.pathway.sbo;");
		writer.write(newLine);
		writer.write(newLine);
		
		writer.write("import java.util.HashMap;");
		writer.write(newLine);
		writer.write("import java.util.Map;");
		writer.write(newLine);
		writer.write(newLine);

		writer.write("/*");
		writer.write(newLine);
		writer.write(" * WARNING: automatically generated by SBOBuilder. Do not edit this file!");
		writer.write(newLine);
		writer.write(" */");
		writer.write(newLine);
		
		writer.write("public class SBOListEx {");
		writer.write(newLine);
		writer.write(newLine);

		writer.write("public static final String NO_SYMBOL = \"?\";");
		writer.write(newLine);
		writer.write("public static Map<String, SBOTerm> sboMap = new HashMap<String, SBOTerm>();");
		writer.write(newLine);
		writer.write(newLine);
		
		File fXmlFile = new File("c:\\dan\\SBO_XML.xml");
		DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
		Document doc = dBuilder.parse(fXmlFile);
		doc.getDocumentElement().normalize();
		System.out.println("Root element :" + doc.getDocumentElement().getNodeName());
		NodeList nList = doc.getElementsByTagName("Term");
		System.out.println("-----------------------");
		String s = "";
		for (int temp = 0; temp < nList.getLength(); temp++) {
			Node nNode = nList.item(temp);
			if (nNode.getNodeType() == Node.ELEMENT_NODE) {
				Element eElement = (Element) nNode;
				
				System.out.println("id : " + getTagValue("id", eElement));
				String id = getTagValue("id", eElement);
				
				String termName = id.substring(id.indexOf("SBO:")+4);
				s = "public static final SBOTerm x_" + termName + " = ";
				writer.write(s);
				writer.write(newLine);
				
				System.out.println("symbol : " + getTagValue("synonym_text", eElement));
				String symbol = getTagValue("synonym_text", eElement);
				if(symbol.isEmpty()) {
					symbol = "?";
				}
				
				System.out.println("name : " + getTagValue("name", eElement));
				String name = getTagValue("name", eElement);

				
				String defstr = getTagValue("defstr", eElement);
				defstr = defstr.replaceAll("[\\r\\n]", " ");
				defstr = defstr.replaceAll(" {2}", " ");
				defstr = defstr.replaceAll("\"", "");
				System.out.println("defstr : " + defstr);

				String isA = getTagValues("is_a", eElement);
				
				s = "\t\t" + "SBOUtil.createTerm(\"" + id  + "\", ";
				writer.write(s);

				s = "\"" + symbol + "\"" + ", ";
				writer.write(s);
				
				s = "\"" + name + "\"" + ", ";
				writer.write(s);
				writer.write(newLine);
				
				s = "\t\t\t\"" + defstr + "\"" + ", ";
				writer.write(s);
				writer.write(newLine);
				
				s = "\t\t\t\"" + isA + "\"" + ");";
				writer.write(s);
				writer.write(newLine);
			}
		}
		writer.write(newLine);
		writer.write("}");

		writer.close();

	} catch (Exception e) {
		lg.error(e.getMessage(), e);
	}
}

// assumes each tag has an unique value (non repetitive tags)
private static String getTagValue(String sTag, Element eElement) {
	NodeList nL1 = eElement.getElementsByTagName(sTag);
	if(nL1.getLength() == 0) {
		return "";
	}
	
	NodeList nL2 = nL1.item(0).getChildNodes();
	if(nL2.getLength() == 0) {
		return "";
	}
	
	Node nValue = (Node) nL2.item(0);
		return nValue.getNodeValue();
}

// used only for the is_a property, there may be 2 properties with the same tag
// returns an empty string (for the root element) 
// returns a (comma separated) string with the SBO id of the ancestor(s)
// for example  "SBO:0000016,SBO:0000153"
private static String getTagValues(String sTag, Element eElement) {
	NodeList nL1 = eElement.getElementsByTagName(sTag);
	String s = "";
	if(nL1.getLength() == 0) {
		return s;
	}
	
	NodeList nL2 = nL1.item(0).getChildNodes();
	if(nL2.getLength() == 0) {
		return s;
	}
	
	Node nValue = (Node) nL2.item(0);
	s = nValue.getNodeValue();
		
	if(nL1.getLength() == 2) {
		nL2 = nL1.item(1).getChildNodes();
		nValue = (Node) nL2.item(0);
		s += "," + nValue.getNodeValue();
	}
		
	return s;
}


}
