/* Generated By:JJTree: Do not edit this line. ASTCompartment.java */

package org.vcell.model.bngl;

public class ASTCompartment extends SimpleNode {
	
	String name = null;
	int dimension = 3;		// 3 for compartments, 2 for membranes
	String volume = "1";
	
	public ASTCompartment(int id) {
		super(id);
	}
	public ASTCompartment(BNGLParser p, int id) {
		super(p, id);
	}

	/** Accept the visitor. **/
	public Object jjtAccept(BNGLParserVisitor visitor, Object data) {
		return visitor.visit(this, data);
	}

	public void setName(String image) {
		this.name = image;
	}
	public String getName() {
		return name;
	}

	@Override
	public String toBNGL() {
		return jjtGetChild(0).toBNGL();
	}

	public void setDimension(String image) {
		if(image == null || image.length() == 0) {
			return;
		}
		try {
			int num = Integer.parseInt(image);
			if(num == 2 || num == 3) {
				this.dimension = num;
			} else {
				System.out.println("BnglParser: Compartment dimension must be 2 or 3.");
			}
		} catch (NumberFormatException e) {
			System.out.println("BnglParser: Couldn't parse compartment dimension.");
		}	
	}
	public int getDimension() {
		return dimension;
	}

	public void setVolume(String image) {
		if (image.startsWith("{") && image.endsWith("}")) {
			image = image.substring(1, image.length()-1);
		}
		this.volume = image;
	}
	public String getVolume() {
		return volume;
	}
}
