/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.simdata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.vcell.solver.nfsim.NFSimMolecularConfigurations;
import org.vcell.util.DataAccessException;
import org.vcell.util.PermissionException;
import org.vcell.util.document.User;
import org.vcell.util.document.VCDataIdentifier;
import org.vcell.vis.io.ChomboFiles;
import org.vcell.vis.io.ComsolSimFiles;
import org.vcell.vis.io.MovingBoundarySimFiles;
import org.vcell.vis.io.VCellSimFiles;
import org.vcell.vis.io.VtuFileContainer;
import org.vcell.vis.io.VtuVarInfo;

import cbit.rmi.event.ExportEvent;
import cbit.vcell.export.server.ExportServiceImpl;
import cbit.vcell.field.io.FieldDataFileOperationResults;
import cbit.vcell.field.io.FieldDataFileOperationSpec;
import cbit.vcell.solver.AnnotatedFunction;
import cbit.vcell.solvers.CartesianMesh;

/**
 * This interface was generated by a SmartGuide.
 * 
 */
public class DataServerImpl {
	public static final Logger lg = LogManager.getLogger(DataServerImpl.class);

	private DataSetControllerImpl dataSetControllerImpl = null;
	private ExportServiceImpl exportServiceImpl = null;

/**
 * This method was created by a SmartGuide.
 */
public DataServerImpl (DataSetControllerImpl dsControllerImpl, ExportServiceImpl esl) {
	super();
	this.dataSetControllerImpl = dsControllerImpl;
	exportServiceImpl = esl;
}


/**
 * Insert the method's description here.
 * Creation date: (8/5/2001 10:29:59 PM)
 * @param simInfo cbit.vcell.solver.SimulationInfo
 */
private void checkReadAccess(User user, VCDataIdentifier vcdID) throws PermissionException {
//	//
//	// throw PermissionException if current user doesn't own Simulation and it isn't public.
//	//
//	if (!simInfo.getVersion().getOwner().compareEqual(getUser()) &&
//		!simInfo.getVersion().getGroupAccess().isMember(getUser())){
//		throw new PermissionException("PermissionException: simulation="+simInfo.toString());
//	}

	//
	// DON'T PROHIBIT ACCESS AT THIS LEVEL FOR READ-ONLY 
	// (access is by reachability, the Simulation.Version doesn't have enough information).
	//
}


/**
 * Insert the method's description here.
 * Creation date: (8/5/2001 10:29:59 PM)
 * @param simInfo cbit.vcell.solver.SimulationInfo
 */
private void checkWriteAccess(User user, VCDataIdentifier vcdID) throws PermissionException {
	//
	// throw PermissionException if current user doesn't own Simulation.
	//
	if (!vcdID.getOwner().compareEqual(user)){
		throw new PermissionException("PermissionException: VCData="+vcdID.getID());
	}
}


public FieldDataFileOperationResults fieldDataFileOperation(User user,FieldDataFileOperationSpec fieldDataOpearationSpec) throws DataAccessException {
	//checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.fieldDataFileOperation(fieldDataOpearationSpec);
	}catch (DataAccessException e){
		lg.error(e.getMessage(), e);
		throw e;
	}catch (Exception e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException("Error FieldDataFileOperation",e);
	}
}



/**
 * This method was created by a SmartGuide.
 * @return java.lang.String[]
 */
public DataIdentifier[] getDataIdentifiers(OutputContext outputContext, User user, VCDataIdentifier vcdID) throws DataAccessException {
	checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.getDataIdentifiers(outputContext, vcdID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage(),e);
	}
}


/**
 * This method was created by a SmartGuide.
 * @return double[]
 */
public double[] getDataSetTimes(User user, VCDataIdentifier vcdID) throws DataAccessException {
	if (lg.isTraceEnabled()) lg.trace("DataServerImpl.getDataSetTimes()");
	checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.getDataSetTimes(vcdID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


/**
 * Insert the method's description here.
 * Creation date: (10/11/00 1:11:04 PM)
 * @param function cbit.vcell.math.Function
 * @exception org.vcell.util.DataAccessException The exception description.
 * @exception java.rmi.RemoteException The exception description.
 */
public AnnotatedFunction[] getFunctions(OutputContext outputContext,User user, VCDataIdentifier vcdID) throws DataAccessException {
	if (lg.isTraceEnabled()) lg.trace("DataServerImpl.getFunctions()");
	checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.getFunctions(outputContext,vcdID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return cbit.plot.PlotData
 * @param variable java.lang.String
 * @param time double
 * @param spatialSelection cbit.vcell.simdata.gui.SpatialSelection
 * @exception java.rmi.RemoteException The exception description.
 */
public cbit.plot.PlotData getLineScan(OutputContext outputContext, User user, VCDataIdentifier vcdID, java.lang.String varName, double time, SpatialSelection spatialSelection) throws DataAccessException {
	checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.getLineScan(outputContext,vcdID,varName,time,spatialSelection);
	} catch (DataAccessException e) {
		lg.error(e.getMessage(), e);
		throw e;
	} catch (Throwable e) {
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


/**
 * This method was created in VisualAge.
 * @return CartesianMesh
 */
public CartesianMesh getMesh(User user, VCDataIdentifier vcdID) throws DataAccessException {
	checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.getMesh(vcdID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


/**
 * Insert the method's description here.
 * Creation date: (1/14/00 11:20:51 AM)
 * @return cbit.vcell.export.data.ODESimData
 * @exception org.vcell.util.DataAccessException The exception description.
 * @exception java.rmi.RemoteException The exception description.
 */
public cbit.vcell.solver.ode.ODESimData getODEData(User user, VCDataIdentifier vcdID) throws DataAccessException {
	checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.getODEDataBlock(vcdID).getODESimData();
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.server.DataSet
 * @param time double
 */
public ParticleDataBlock getParticleDataBlock(User user, VCDataIdentifier vcdID, double time) throws DataAccessException {
	checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.getParticleDataBlock(vcdID, time);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.server.DataSet
 * @param time double
 */
public DataOperationResults doDataOperation(User user, DataOperation dataOperation) throws DataAccessException {
	checkReadAccess(user, dataOperation.getVCDataIdentifier());
	try {
		return dataSetControllerImpl.doDataOperation(dataOperation);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


/**
 * This method was created in VisualAge.
 * @return boolean
 */
public boolean getParticleDataExists(User user, VCDataIdentifier vcdID) throws DataAccessException {
	checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.getParticleDataExists(vcdID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.server.DataSet
 * @param time double
 */
public SimDataBlock getSimDataBlock(OutputContext outputContext, User user, VCDataIdentifier vcdID, String var, double time) throws DataAccessException {
	checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.getSimDataBlock(outputContext,vcdID,var,time);
	}catch (DataAccessException e){
		lg.error(e.getMessage(), e);
		throw (DataAccessException)e;
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return double[]
 * @param varName java.lang.String
 * @param x int
 * @param y int
 * @param z int
 */
public org.vcell.util.document.TimeSeriesJobResults getTimeSeriesValues(OutputContext outputContext, User user, VCDataIdentifier vcdID, org.vcell.util.document.TimeSeriesJobSpec timeSeriesJobSpec) throws DataAccessException {
	checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.getTimeSeriesValues(outputContext,vcdID,timeSeriesJobSpec);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


/**
 * Insert the method's description here.
 * Creation date: (3/30/2001 11:11:52 AM)
 * @param exportSpecs cbit.vcell.export.server.ExportSpecs
 * @exception org.vcell.util.DataAccessException The exception description.
 */
public ExportEvent makeRemoteFile(OutputContext outputContext,User user, cbit.vcell.export.server.ExportSpecs exportSpecs) throws org.vcell.util.DataAccessException {
	if (lg.isTraceEnabled()) lg.trace("DataServerImpl.makeRemoteFile(" + exportSpecs.getVCDataIdentifier() + ")");
	try {
		ExportEvent exportEvent = exportServiceImpl.makeRemoteFile(outputContext,user, this, exportSpecs);
		return exportEvent;
	} catch (Throwable e) {
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


public DataSetMetadata getDataSetMetadata(User user, VCDataIdentifier vcdataID) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		return dataSetControllerImpl.getDataSetMetadata(vcdataID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}

public DataSetTimeSeries getDataSetTimeSeries(User user, VCDataIdentifier vcdataID, String[] variableNames) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		return dataSetControllerImpl.getDataSetTimeSeries(vcdataID, variableNames);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


public boolean isChombo(User user, VCDataIdentifier vcdataID) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		return dataSetControllerImpl.getIsChombo(vcdataID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage(),e);
	}
}


public boolean isMovingBoundary(User user, VCDataIdentifier vcdataID) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		return dataSetControllerImpl.getIsMovingBoundary(vcdataID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}

public boolean isComsol(User user, VCDataIdentifier vcdataID) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		return dataSetControllerImpl.getIsComsol(vcdataID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}

public ChomboFiles getChomboFiles(User user, VCDataIdentifier vcdataID) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		return dataSetControllerImpl.getChomboFiles(vcdataID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


public VCellSimFiles getVCellSimFiles(User user, VCDataIdentifier vcdataID) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		return dataSetControllerImpl.getVCellSimFiles(vcdataID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}

public ComsolSimFiles getComsolSimFiles(User user, VCDataIdentifier vcdataID) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		return dataSetControllerImpl.getComsolSimFiles(vcdataID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}

public MovingBoundarySimFiles getMovingBoundarySimFiles(User user, VCDataIdentifier vcdataID) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		return dataSetControllerImpl.getMovingBoundarySimFiles(vcdataID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}

/**
 * This method was created by a SmartGuide.
 * @return double[]
 */
public double[] getVtuTimes(User user, VCDataIdentifier vcdID) throws DataAccessException {
	if (lg.isTraceEnabled()) lg.trace("DataServerImpl.getVtuTimes()");
	checkReadAccess(user, vcdID);
	try {
		if (isComsol(user,vcdID)){
			ComsolSimFiles comsolFiles = getComsolSimFiles(user, vcdID);
			return dataSetControllerImpl.getVtuTimes(comsolFiles, vcdID);
		}else{
			return dataSetControllerImpl.getDataSetTimes(vcdID);
		}
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}



public double[] getVtuMeshData(User user, OutputContext outputContext, VCDataIdentifier vcdataID, VtuVarInfo var, double time) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		if (isComsol(user, vcdataID)){
			ComsolSimFiles comsolFiles = getComsolSimFiles(user, vcdataID);
			return dataSetControllerImpl.getVtuMeshData(comsolFiles, outputContext, vcdataID, var, time);
		}else if (isChombo(user, vcdataID)){
			ChomboFiles chomboFiles = getChomboFiles(user, vcdataID);
			return dataSetControllerImpl.getVtuMeshData(chomboFiles, outputContext, vcdataID, var, time);
		}else if (isMovingBoundary(user, vcdataID)){
			MovingBoundarySimFiles movingBoundarySimFiles = getMovingBoundarySimFiles(user, vcdataID);
			return dataSetControllerImpl.getVtuMeshData(movingBoundarySimFiles, outputContext, vcdataID, var, time);
		}else{
			VCellSimFiles vcellFiles = getVCellSimFiles(user, vcdataID);
			return dataSetControllerImpl.getVtuMeshData(vcellFiles, outputContext, vcdataID, var, time);
		}
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}

public VtuFileContainer getEmptyVtuMeshFiles(User user, VCDataIdentifier vcdataID, int timeIndex) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		if (isComsol(user, vcdataID)){
			ComsolSimFiles comsolSimFiles = getComsolSimFiles(user, vcdataID);
			return dataSetControllerImpl.getEmptyVtuMeshFiles(comsolSimFiles, vcdataID, timeIndex);
		}else if (isChombo(user, vcdataID)){
			ChomboFiles chomboFiles = getChomboFiles(user, vcdataID);
			return dataSetControllerImpl.getEmptyVtuMeshFiles(chomboFiles, vcdataID, timeIndex);
		}else if (isMovingBoundary(user, vcdataID)){
			MovingBoundarySimFiles movingBoundaryFiles = getMovingBoundarySimFiles(user, vcdataID);
			return dataSetControllerImpl.getEmptyVtuMeshFiles(movingBoundaryFiles, vcdataID, timeIndex);
		}else{
			VCellSimFiles vcellFiles = getVCellSimFiles(user, vcdataID);
			return dataSetControllerImpl.getEmptyVtuMeshFiles(vcellFiles, vcdataID, timeIndex);
		}
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}


public VtuVarInfo[] getVtuVarInfos(User user, OutputContext outputContext, VCDataIdentifier vcdataID) throws DataAccessException {
	checkReadAccess(user, vcdataID);
	try {
		if (isComsol(user, vcdataID)){
			ComsolSimFiles comsolFiles = getComsolSimFiles(user, vcdataID);
			return dataSetControllerImpl.getVtuVarInfos(comsolFiles, outputContext, vcdataID);
		}else if (isChombo(user, vcdataID)){
			ChomboFiles chomboFiles = getChomboFiles(user, vcdataID);
			return dataSetControllerImpl.getVtuVarInfos(chomboFiles, outputContext, vcdataID);
		}else if (isMovingBoundary(user, vcdataID)){
			MovingBoundarySimFiles mbSimFiles = getMovingBoundarySimFiles(user, vcdataID);
			return dataSetControllerImpl.getVtuVarInfos(mbSimFiles, outputContext, vcdataID);
		}else{
			VCellSimFiles vcellFiles = getVCellSimFiles(user, vcdataID);
			return dataSetControllerImpl.getVtuVarInfos(vcellFiles, outputContext, vcdataID);
		}
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage(),e);
	}
}

public NFSimMolecularConfigurations getNFSimMolecularConfigurations(User user, VCDataIdentifier vcdID) throws DataAccessException {
	if (lg.isTraceEnabled()) lg.trace("DataServerImpl.getNFSimMolecularConfigurations()");
	checkReadAccess(user, vcdID);
	try {
		return dataSetControllerImpl.getNFSimMolecularConfigurations(vcdID);
	}catch (Throwable e){
		lg.error(e.getMessage(), e);
		throw new DataAccessException(e.getMessage());
	}
}

}
