/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.server;

import java.io.IOException;
import java.io.Serializable;

import org.vcell.util.DataAccessException;
import org.vcell.util.document.UserLoginInfo;

import cbit.rmi.event.MessageEvent;
import cbit.rmi.event.PerformanceMonitorEvent;
import cbit.vcell.message.server.bootstrap.client.RemoteProxyVCellConnectionFactory.RemoteProxyException;
/**
 * This interface was generated by a SmartGuide.
 * 
 */
public interface VCellConnection {
	/**
	 * provide extra context to email. Implement as separate class to make
	 * extension easier in the future
	 */
	@SuppressWarnings("serial")
	public static class ExtraContext implements Serializable {
		final String threadName;

		/**
		 * explicitly set thread name
		 * @param threadName
		 */
		public ExtraContext(String threadName) {
			this.threadName = threadName;
		}
		
		/**
		 * set thread name to current thread
		 */
		public ExtraContext() {
			threadName = Thread.currentThread().getName();
		}

		@Override
		public String toString() {
			return "ExtraContext [threadName=" + threadName + "]";
		}
	}
/**
 * Insert the method's description here.
 * Creation date: (6/8/2001 1:17:05 AM)
 * @return cbit.vcell.server.DataSetController
 * @exception org.vcell.util.DataAccessException The exception description.
 * @exception java.rmi.RemoteException The exception description.
 */
DataSetController getDataSetController() throws DataAccessException, RemoteProxyException;
/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.solvers.MathController
 * @param simulationInfo cbit.vcell.solver.SimulationInfo
 * @param simulation cbit.vcell.solver.Simulation
 * @exception java.rmi.RemoteException The exception description.
 */
public SimulationController getSimulationController() throws RemoteProxyException;

public UserLoginInfo getUserLoginInfo() throws RemoteProxyException;
/**
 * This method was created by a SmartGuide.
 * @return DBManager
 * @param userid java.lang.String
 * @exception java.rmi.RemoteException The exception description.
 */
public UserMetaDbServer getUserMetaDbServer() throws RemoteProxyException, DataAccessException;
void sendErrorReport(Throwable exception) throws RemoteProxyException;
void sendErrorReport(Throwable exception, ExtraContext extra) throws RemoteProxyException;

MessageEvent[] getMessageEvents() throws RemoteProxyException, IOException;
//void reportPerformanceMonitorEvent(PerformanceMonitorEvent performanceMonitorEvent) throws RemoteProxyException;
}
