/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.server;
import org.vcell.util.DataAccessException;
import org.vcell.util.document.KeyValue;
import org.vcell.util.document.User;

import cbit.vcell.solver.VCSimulationIdentifier;
/**
 * This interface was generated by a SmartGuide.
 * 
 */
public interface SimulationService {
/**
 * This method was created by a SmartGuide.
 * @exception java.rmi.RemoteException The exception description.
 */
public SimulationStatus startSimulation(User user, VCSimulationIdentifier vcSimulationIdentifier, int numSimulationScanJobs) throws DataAccessException;


/**
 * This method was created by a SmartGuide.
 * @exception java.rmi.RemoteException The exception description.
 */
public SimulationStatus stopSimulation(User user, VCSimulationIdentifier vcSimulationIdentifier) throws DataAccessException;


public SimulationStatus[] getSimulationStatus(User user, KeyValue[] simKeys) throws DataAccessException;


public SimulationStatus getSimulationStatus(User user, KeyValue simulationKey) throws DataAccessException;

public SimpleJobStatus[] getSimpleJobStatus(User user, SimpleJobStatusQuerySpec simJobStatusQuerySpec) throws DataAccessException;
}
