/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.message.server.bootstrap.client;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.vcell.solver.nfsim.NFSimMolecularConfigurations;
import org.vcell.util.DataAccessException;
import org.vcell.util.document.UserLoginInfo;
import org.vcell.util.document.VCDataIdentifier;
import org.vcell.vis.io.VtuFileContainer;
import org.vcell.vis.io.VtuVarInfo;

import cbit.plot.PlotData;
import cbit.rmi.event.ExportEvent;
import cbit.vcell.export.server.ExportSpecs;
import cbit.vcell.field.io.FieldDataFileOperationResults;
import cbit.vcell.field.io.FieldDataFileOperationSpec;
import cbit.vcell.message.server.bootstrap.client.RemoteProxyVCellConnectionFactory.RemoteProxyException;
import cbit.vcell.server.DataSetController;
import cbit.vcell.simdata.DataIdentifier;
import cbit.vcell.simdata.DataOperation;
import cbit.vcell.simdata.DataOperationResults;
import cbit.vcell.simdata.DataSetMetadata;
import cbit.vcell.simdata.DataSetTimeSeries;
import cbit.vcell.simdata.OutputContext;
import cbit.vcell.simdata.ParticleDataBlock;
import cbit.vcell.simdata.SimDataBlock;
import cbit.vcell.simdata.SpatialSelection;
import cbit.vcell.solvers.CartesianMesh;

/**
 * This interface was generated by a SmartGuide.
 * 
 */
public class LocalDataSetControllerMessaging implements DataSetController {
    private RpcDataServerProxy dataServerProxy = null;
    private static Logger lg = LogManager.getLogger(LocalDataSetControllerMessaging.class);

/**
 * This method was created by a SmartGuide.
 */
public LocalDataSetControllerMessaging (UserLoginInfo userLoginInfo, RpcSender rpcSender) {
	this.dataServerProxy = new RpcDataServerProxy(userLoginInfo, rpcSender);
}



public FieldDataFileOperationResults fieldDataFileOperation(FieldDataFileOperationSpec fieldDataFileOperationSpec) throws DataAccessException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.fieldDataFileOperationSpec(...)");
	try {
		return dataServerProxy.fieldDataFileOperation(fieldDataFileOperationSpec);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String[]
 * @throws RemoteProxyException 
 */
public DataIdentifier[] getDataIdentifiers(OutputContext outputContext,VCDataIdentifier vcdID) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getDataIdentifiers(vcdID=" + vcdID + ")");
	try {
		return dataServerProxy.getDataIdentifiers(outputContext,vcdID);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}

/**
 * This method was created by a SmartGuide.
 * @return double[]
 * @throws RemoteProxyException 
 */
public double[] getDataSetTimes(VCDataIdentifier vcdID) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getDataSetTimes(vcdID=" + vcdID + ")");
	try {
		return dataServerProxy.getDataSetTimes(vcdID);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


/**
 * Insert the method's description here.
 * Creation date: (2/26/2004 1:05:01 PM)
 * @param function cbit.vcell.math.Function
 * @exception org.vcell.util.DataAccessException The exception description.
 * @exception RemoteProxyException The exception description.
 */

public cbit.vcell.solver.AnnotatedFunction[] getFunctions(OutputContext outputContext,org.vcell.util.document.VCDataIdentifier vcdataID) throws org.vcell.util.DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getFunctions(vcdataID=" + vcdataID + ")");
	try {
		return dataServerProxy.getFunctions(outputContext,vcdataID);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return cbit.plot.PlotData
 * @param varName java.lang.String
 * @param spatialSelection cbit.vcell.simdata.gui.SpatialSelection
 * @throws RemoteProxyException 
 */
public PlotData getLineScan(OutputContext outputContext,VCDataIdentifier vcdID, String varName, double time, SpatialSelection spatialSelection) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getLineScan(vcdID=" + vcdID + ", " + varName + ", " + time + ", at " + spatialSelection+")");
	try {
		return dataServerProxy.getLineScan(outputContext,vcdID, varName, time, spatialSelection);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return int[]
 * @throws RemoteProxyException 
 */
public CartesianMesh getMesh(VCDataIdentifier vcdID) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getMesh(vcdID=" + vcdID + ")");
	try {
		return dataServerProxy.getMesh(vcdID);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


/**
 * Insert the method's description here.
 * Creation date: (1/14/00 11:20:51 AM)
 * @return cbit.vcell.export.data.ODESimData
 * @exception org.vcell.util.DataAccessException The exception description.
 * @exception RemoteProxyException The exception description.
 */
public cbit.vcell.solver.ode.ODESimData getODEData(VCDataIdentifier vcdID) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getODEData(vcdID=" + vcdID + ")");
	try {
		return dataServerProxy.getODEData(vcdID);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return double[]
 * @param varName java.lang.String
 * @param time double
 * @throws RemoteProxyException 
 */
public ParticleDataBlock getParticleDataBlock(VCDataIdentifier vcdID, double time) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getParticleDataBlock(vcdID=" + vcdID + ",time=" + time + ")");
	try {
		return dataServerProxy.getParticleDataBlock(vcdID,time);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return boolean
 * @throws RemoteProxyException 
 */
public boolean getParticleDataExists(VCDataIdentifier vcdID) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getParticleDataExists(vcdID=" + vcdID + ")");
	try {
		return dataServerProxy.getParticleDataExists(vcdID);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return double[]
 * @param varName java.lang.String
 * @param time double
 * @throws RemoteProxyException 
 */
public SimDataBlock getSimDataBlock(OutputContext outputContext,VCDataIdentifier vcdID, String varName, double time) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getSimDataBlock(vcdID=" + vcdID + ", varName=" + varName + ", time=" + time + ")");
	try {
		return dataServerProxy.getSimDataBlock(outputContext,vcdID,varName,time);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


/**
 * This method was created by a SmartGuide.
 * @return double[]
 * @param varName java.lang.String
 * @param index int
 * @throws RemoteProxyException 
 */
public org.vcell.util.document.TimeSeriesJobResults getTimeSeriesValues(OutputContext outputContext,VCDataIdentifier vcdID,org.vcell.util.document.TimeSeriesJobSpec timeSeriesJobSpec) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getTimeSeriesValues(vcdID=" + vcdID + ", " + timeSeriesJobSpec + ")");
	try {
		return dataServerProxy.getTimeSeriesValues(outputContext,vcdID,timeSeriesJobSpec);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


/**
 * This method was created in VisualAge.
 * @param simInfo cbit.vcell.solver.SimulationInfo
 * @exception org.vcell.util.DataAccessException The exception description.
 * @throws RemoteProxyException 
 */
public ExportEvent makeRemoteFile(OutputContext outputContext,ExportSpecs exportSpecs) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.makeRemoteFile(vcdID=" + exportSpecs.getVCDataIdentifier() + ")");
	try {
		return dataServerProxy.makeRemoteFile(outputContext,exportSpecs);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}



public DataOperationResults doDataOperation(DataOperation dataOperation) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.doDataOperation(...)");
	try {
		return dataServerProxy.doDataOperation(dataOperation);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


@Override
public DataSetMetadata getDataSetMetadata(VCDataIdentifier vcdataID) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getDataSetMetadata(vcdataID=" + vcdataID + ")");
	try {
		return dataServerProxy.getDataSetMetadata(vcdataID);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}



@Override
public DataSetTimeSeries getDataSetTimeSeries(VCDataIdentifier vcdataID, String[] variableNames) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getDataSetMetadata(vcdataID=" + vcdataID + ")");
	try {
		return dataServerProxy.getDataSetTimeSeries(vcdataID, variableNames);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}

@Override
public VtuFileContainer getEmptyVtuMeshFiles(VCDataIdentifier vcdataID, int timeIndex)	throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getEmptyVtuMeshFiles(vcdataID=" + vcdataID + ")");
	try {
		return dataServerProxy.getEmptyVtuMeshFiles(vcdataID, timeIndex);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}


@Override
public double[] getVtuMeshData(OutputContext outputContext, VCDataIdentifier vcdataID, VtuVarInfo var, double time)	throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getVtuMeshData(vcdataID=" + vcdataID + ", var=" + var.name + ", time=" + time + ")");
	try {
		return dataServerProxy.getVtuMeshData(outputContext, vcdataID, var, time);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}



@Override
public VtuVarInfo[] getVtuVarInfos(OutputContext outputContext, VCDataIdentifier vcdataID) throws DataAccessException, RemoteProxyException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getVtuMeshFiles(vcdataID=" + vcdataID + ")");
	try {
		return dataServerProxy.getVtuVarInfos(outputContext, vcdataID);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}



@Override
public double[] getVtuTimes(VCDataIdentifier vcdataID) throws RemoteProxyException, DataAccessException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getVtuTimes(vcdataID=" + vcdataID + ")");
	try {
		return dataServerProxy.getVtuTimes(vcdataID);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}

@Override
public NFSimMolecularConfigurations getNFSimMolecularConfigurations(VCDataIdentifier vcdataID) throws RemoteProxyException, DataAccessException {
	if (lg.isTraceEnabled()) lg.trace("LocalDataSetControllerMessaging.getNFSimMolecularConfigurations(vcdataID=" + vcdataID + ")");
	try {
		return dataServerProxy.getNFSimMolecularConfigurations(vcdataID);
	} catch (DataAccessException e){
		lg.error(e.getMessage(),e);
		throw e;
	} catch (Throwable e){
		lg.error(e.getMessage(),e);
		throw new RuntimeException(e.getMessage());
	}
}

}
